/*
 * Decompiled with CFR 0.152.
 */
package org.globalqss.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MCashPlan;
import org.compiere.model.MCashPlanLine;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class GeneratePeriodicCashPlanLines
extends SvrProcess {
    private int p_C_Project_ID = 0;
    private int p_C_Activity_ID = 0;
    private String p_Name = null;
    private int p_M_Product_ID = 0;
    private int p_C_Charge_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_Periodicity = null;
    private int p_Repetitions = 0;
    private BigDecimal p_Amount = null;
    private Timestamp p_DateFrom = null;
    private BigDecimal p_Probability = null;
    private int p_C_CashPlan_ID = 0;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_Activity_ID")) {
                this.p_C_Activity_ID = para[i2].getParameterAsInt();
            } else if (name.equals("Name")) {
                this.p_Name = (String)para[i2].getParameter();
            } else if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_Charge_ID")) {
                this.p_C_Charge_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
            } else if (name.equals("Periodicity")) {
                this.p_Periodicity = (String)para[i2].getParameter();
            } else if (name.equals("Repetitions")) {
                this.p_Repetitions = para[i2].getParameterAsInt();
            } else if (name.equals("Amount")) {
                this.p_Amount = (BigDecimal)para[i2].getParameter();
            } else if (name.equals("DateFrom")) {
                this.p_DateFrom = (Timestamp)para[i2].getParameter();
            } else if (name.equals("Probability")) {
                this.p_Probability = (BigDecimal)para[i2].getParameter();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
            }
            ++i2;
        }
        this.p_C_CashPlan_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        boolean usecharge;
        boolean usename = this.p_Name != null && this.p_Name.trim().length() > 0;
        boolean useproduct = this.p_M_Product_ID > 0;
        boolean bl = usecharge = this.p_C_Charge_ID > 0;
        if (!(usename || useproduct || usecharge)) {
            throw new IllegalArgumentException("Required at least one of the fields Name, Product, Charge");
        }
        if (useproduct && usecharge) {
            throw new IllegalArgumentException("Product and charge are exclusive, you can use just one of them");
        }
        if (this.p_Amount.signum() == 0) {
            throw new IllegalArgumentException("Amount must be different than zero");
        }
        if (this.p_Repetitions <= 0) {
            return "@Inserted@=0";
        }
        if (this.p_Probability == null) {
            this.p_Probability = Env.ONEHUNDRED;
        }
        int days = 0;
        int months = 0;
        int years = 0;
        if ("001_D".equals(this.p_Periodicity)) {
            days = 1;
        } else if ("007_W".equals(this.p_Periodicity)) {
            days = 7;
        } else if ("014_F".equals(this.p_Periodicity)) {
            days = 14;
        } else if ("015_B".equals(this.p_Periodicity)) {
            days = 15;
        } else if ("030_M".equals(this.p_Periodicity)) {
            months = 1;
        } else if ("060_2".equals(this.p_Periodicity)) {
            months = 2;
        } else if ("090_Q".equals(this.p_Periodicity)) {
            months = 3;
        } else if ("180_S".equals(this.p_Periodicity)) {
            months = 6;
        } else if ("365_Y".equals(this.p_Periodicity)) {
            years = 1;
        } else {
            throw new IllegalArgumentException("Wrong periodicity " + this.p_Periodicity);
        }
        MCashPlan cp = new MCashPlan(this.getCtx(), this.p_C_CashPlan_ID, this.get_TrxName());
        if (cp.get_ID() <= 0) {
            throw new IllegalArgumentException("Cash Plan does not exist");
        }
        int insertNo = 0;
        int lineNo = DB.getSQLValue(this.get_TrxName(), "SELECT NVL(MAX(Line),0)+10 FROM C_CashPlanLine WHERE C_CashPlan_ID=?", this.p_C_CashPlan_ID);
        int cnt = 0;
        while (cnt < this.p_Repetitions) {
            MCashPlanLine cpl = new MCashPlanLine(this.getCtx(), 0, this.get_TrxName());
            cpl.setC_CashPlan_ID(cp.getC_CashPlan_ID());
            cpl.setAD_Org_ID(cp.getAD_Org_ID());
            cpl.setProcessed(false);
            cpl.setIsActive(true);
            cpl.setQtyEntered(Env.ONE);
            cpl.setAD_OrgTrx_ID(cp.getAD_OrgTrx_ID());
            cpl.setC_Campaign_ID(cp.getC_Campaign_ID());
            cpl.setUser1_ID(cp.getUser1_ID());
            cpl.setUser2_ID(cp.getUser2_ID());
            cpl.setC_Activity_ID(this.p_C_Activity_ID);
            cpl.setC_Project_ID(this.p_C_Project_ID);
            cpl.setC_Charge_ID(this.p_C_Charge_ID);
            cpl.setM_Product_ID(this.p_M_Product_ID);
            cpl.setName(this.p_Name);
            cpl.setLineTotalAmt(this.p_Amount);
            cpl.setC_BPartner_ID(this.p_C_BPartner_ID);
            cpl.setProbability(this.p_Probability);
            cpl.setLine(lineNo);
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.p_DateFrom);
            if (days == 15) {
                int bwmonths = cnt / 2;
                cal.add(2, bwmonths);
                if (cnt % 2 != 0) {
                    cal.add(5, days);
                }
            } else {
                cal.add(5, days * cnt);
                cal.add(2, months * cnt);
                cal.add(1, years * cnt);
            }
            Timestamp datetrx = new Timestamp(cal.getTimeInMillis());
            cpl.setDateTrx(datetrx);
            lineNo += 10;
            if (!cpl.save()) {
                throw new AdempiereSystemError("Error saving cash plan line");
            }
            ++insertNo;
            ++cnt;
        }
        return "@Inserted@=" + insertNo;
    }
}

