/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.trekglobal.idempiere.rest.api.model.MAuthToken;
import com.trekglobal.idempiere.rest.api.model.MRefreshToken;
import java.util.ArrayList;
import java.util.Arrays;
import org.adempiere.base.event.AbstractEventHandler;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.osgi.service.event.Event;

public class RESTEventHandler
extends AbstractEventHandler {
    private static CLogger log = CLogger.getCLogger(RESTEventHandler.class);

    protected void initialize() {
        log.info("");
        this.registerTableEvent("adempiere/po/afterChange", "AD_User");
        this.registerTableEvent("adempiere/po/afterChange", "AD_Role");
        this.registerTableEvent("adempiere/po/afterChange", "AD_Client");
    }

    protected void doHandleEvent(Event event) {
        MClient client;
        String type = event.getTopic();
        PO po = this.getPO(event);
        log.info(String.valueOf(po) + " Type: " + type);
        if (po instanceof MUser && type.equals("adempiere/po/afterChange")) {
            MUser user;
            if (po.is_ValueChanged("Password")) {
                MUser user2 = (MUser)po;
                this.expireTokens(user2, "P");
            } else if (po.is_ValueChanged("IsActive") && !(user = (MUser)po).isActive()) {
                MAuthToken.deactivateTokens(user.getAD_User_ID(), -1, -1, user.get_TrxName());
                this.expireTokens(user, "M");
            }
        } else if (po instanceof MRole && type.equals("adempiere/po/afterChange")) {
            MRole role;
            if (po.is_ValueChanged("IsActive") && !(role = (MRole)po).isActive()) {
                MAuthToken.deactivateTokens(-1, role.getAD_Role_ID(), -1, role.get_TrxName());
            }
        } else if (po instanceof MClient && type.equals("adempiere/po/afterChange") && po.is_ValueChanged("IsActive") && !(client = (MClient)po).isActive()) {
            MAuthToken.deactivateTokens(-1, -1, client.getAD_Client_ID(), client.get_TrxName());
            MRefreshToken.expireTokens("AD_Client_ID=?", "M", new ArrayList<Object>(Arrays.asList(client.getAD_Client_ID())));
        }
    }

    public void expireTokens(MUser user, String cause) {
        log.info("");
        MRefreshToken.expireTokens("CreatedBy=?", cause, new ArrayList<Object>(Arrays.asList(user.getAD_User_ID())));
    }
}

