/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;

public class ODataUtils {
    public static final String EQUALS = "eq";
    public static final String IN = "in";
    public static final String NOT_EQUALS = "neq";
    public static final String GREATER_THAN = "gt";
    public static final String GREATER_THAN_OR_EQUAL = "ge";
    public static final String LESS_THAN = "lt";
    public static final String LESS_THAN_OR_EQUAL = "le";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String NOT = "not";
    public static final String CONTAINS = "contains";
    public static final String STARTSWITH = "startswith";
    public static final String ENDSWITH = "endswith";
    public static final String LOWER = "tolower";
    public static final String UPPER = "toupper";
    private static final List<String> SUPPORTED_PARAM_METHODS = Collections.unmodifiableList(Arrays.asList("contains", "startswith", "endswith"));
    private static final List<String> SUPPORTED_METHODS = Collections.unmodifiableList(Arrays.asList("tolower", "toupper"));
    private static final Map<String, String> OPERATORS = new HashMap<String, String>(){
        private static final long serialVersionUID = 8733161114590577691L;
        {
            this.put(ODataUtils.AND, "AND");
            this.put(ODataUtils.EQUALS, "=");
            this.put(ODataUtils.IN, " IN ");
            this.put(ODataUtils.GREATER_THAN_OR_EQUAL, ">=");
            this.put(ODataUtils.GREATER_THAN, ">");
            this.put(ODataUtils.LESS_THAN_OR_EQUAL, "<=");
            this.put(ODataUtils.LESS_THAN, "<");
            this.put(ODataUtils.NOT_EQUALS, "<>");
            this.put(ODataUtils.OR, "OR");
        }
    };

    public static String getOperator(String operator) {
        return OPERATORS.get(operator);
    }

    public static boolean isMethodCall(String operator) {
        if (!operator.trim().startsWith("(") && operator.trim().endsWith(")")) {
            String methodName = ODataUtils.getMethodCallName(operator);
            if (SUPPORTED_METHODS.contains(methodName) || SUPPORTED_PARAM_METHODS.contains(methodName)) {
                return true;
            }
            throw new AdempiereException("Method call '" + methodName + "' not implemented");
        }
        return false;
    }

    public static String getMethodCall(String operator) {
        return ODataUtils.isMethodCall(operator) ? ODataUtils.getMethodCallName(operator) : null;
    }

    public static boolean isMethodWithParameters(String methodName) {
        return SUPPORTED_PARAM_METHODS.contains(methodName);
    }

    private static String getMethodCallName(String expression) {
        return expression.indexOf("(") > 0 ? expression.substring(0, expression.indexOf("(")) : "";
    }

    public static String getFirstParameter(String methodName, String expression) {
        return ODataUtils.isMethodWithParameters(methodName) ? expression.substring(expression.indexOf("(") + 1, expression.indexOf(",")) : expression.substring(expression.indexOf("(") + 1, expression.indexOf(")"));
    }

    public static String getSecondParameter(String methodName, String expression) {
        return ODataUtils.isMethodWithParameters(methodName) ? expression.substring(expression.indexOf(",") + 1, expression.lastIndexOf(")")) : null;
    }

    public static String getSQLMethodOperator(String methodName, boolean isNot) {
        String sql = isNot ? " NOT " : "";
        switch (methodName) {
            case "startswith": 
            case "contains": 
            case "endswith": {
                return sql + " LIKE ";
            }
        }
        throw new AdempiereException("Method call " + methodName + " not implemented");
    }

    public static String getSQLFunction(String methodName, String columnName, boolean isNot) {
        String sql = isNot ? " NOT " : "";
        switch (methodName) {
            case "startswith": 
            case "contains": 
            case "endswith": {
                return sql + " LIKE ?";
            }
            case "tolower": {
                return "lower(" + columnName + ")";
            }
            case "toupper": {
                return "upper(" + columnName + ")";
            }
        }
        throw new AdempiereException("Method call " + methodName + " not implemented");
    }
}

