/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.compiere.model.Query;
import org.compiere.model.X_AD_UserDef_Theme;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MUserDefTheme
extends X_AD_UserDef_Theme {
    private static final long serialVersionUID = 6771338140208128930L;
    private static final Map<Integer, List<MUserDefTheme>> m_fullMap = new ConcurrentHashMap<Integer, List<MUserDefTheme>>();
    private static CCache<String, MUserDefTheme> s_cache = new CCache("AD_UserDef_Theme", 3);

    public MUserDefTheme(Properties ctx, String X_AD_UserDef_Theme_UU, String trxName) {
        super(ctx, X_AD_UserDef_Theme_UU, trxName);
    }

    public MUserDefTheme(Properties ctx, int X_AD_UserDef_Theme_ID, String trxName) {
        super(ctx, X_AD_UserDef_Theme_ID, trxName);
    }

    public MUserDefTheme(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private static MUserDefTheme[] getAll(Properties ctx, String themeName) {
        List<MUserDefTheme> fullList = null;
        fullList = m_fullMap.get(Env.getAD_Client_ID(ctx));
        if (fullList == null) {
            fullList = new Query(ctx, "AD_UserDef_Theme", null, null).setOnlyActiveRecords(true).setClient_ID().list();
            m_fullMap.put(Env.getAD_Client_ID(ctx), fullList);
        }
        if (fullList.size() == 0) {
            return null;
        }
        ArrayList<MUserDefTheme> list = new ArrayList<MUserDefTheme>();
        for (MUserDefTheme udw : fullList) {
            if (udw.getAD_Client_ID() != Env.getAD_Client_ID(ctx) || !udw.getTheme().equals(themeName)) continue;
            list.add(udw);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new MUserDefTheme[list.size()]);
    }

    public static MUserDefTheme getBestMatch(Properties ctx, String themeName) {
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        int AD_Role_ID = Env.getAD_Role_ID(ctx);
        int AD_User_ID = Env.getAD_User_ID(ctx);
        String key = themeName + "_" + Env.getAD_Client_ID(ctx) + "_" + AD_Org_ID + "_" + AD_Role_ID + "_" + AD_User_ID;
        if (s_cache.containsKey(key)) {
            return s_cache.get(key);
        }
        MUserDefTheme[] candidates = MUserDefTheme.getAll(ctx, themeName);
        if (candidates == null) {
            s_cache.put(key, null);
            return null;
        }
        int size = candidates.length;
        int[] weight = new int[size];
        int i = 0;
        while (i < size) {
            weight[i] = 0;
            if (candidates[i].getAD_User_ID() > 0) {
                weight[i] = candidates[i].getAD_User_ID() == AD_User_ID ? weight[i] + 4 : -1;
            }
            if (weight[i] > -1 && candidates[i].getAD_Role_ID() > 0) {
                weight[i] = candidates[i].getAD_Role_ID() == AD_Role_ID ? weight[i] + 2 : -1;
            }
            if (weight[i] > -1 && candidates[i].getAD_Org_ID() > 0) {
                weight[i] = candidates[i].getAD_Org_ID() == AD_Org_ID ? weight[i] + 1 : -1;
            }
            ++i;
        }
        int maximum = weight[0];
        int maxindex = 0;
        int j = 0;
        while (j < weight.length) {
            if (weight[j] > maximum) {
                maximum = weight[j];
                maxindex = j;
            }
            ++j;
        }
        if (weight[maxindex] > -1) {
            MUserDefTheme retValue = null;
            retValue = candidates[maxindex];
            s_cache.put(key, retValue);
            return retValue;
        }
        s_cache.put(key, null);
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        m_fullMap.remove(this.getAD_Client_ID());
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        m_fullMap.remove(this.getAD_Client_ID());
        return true;
    }
}

