/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.util.DisplayType;

public class NumericTypeConverter
implements ITypeConverter<Number> {
    @Override
    public Object toJsonValue(MColumn column, Number value) {
        return this.toJsonValue(column.getAD_Reference_ID(), value);
    }

    @Override
    public Object toJsonValue(GridField field, Number value) {
        return this.toJsonValue(field.getDisplayType(), value);
    }

    @Override
    public Object fromJsonValue(MColumn column, JsonElement value) {
        return this.fromJsonValue(column.getAD_Reference_ID(), value);
    }

    @Override
    public Object fromJsonValue(GridField field, JsonElement value) {
        return this.fromJsonValue(field.getDisplayType(), value);
    }

    private Object toJsonValue(int displayType, Number value) {
        if (!DisplayType.isNumeric((int)displayType) && displayType != 28 && displayType != 200202 && displayType != 13) {
            return null;
        }
        if (displayType == 11 || displayType == 200202 || displayType == 13) {
            return value.intValue();
        }
        return value;
    }

    private Object fromJsonValue(int displayType, JsonElement value) {
        if (!DisplayType.isNumeric((int)displayType) && displayType != 28 && displayType != 200202 && displayType != 13) {
            return null;
        }
        JsonPrimitive primitive = (JsonPrimitive)value;
        if (displayType == 11 || displayType == 200202 || displayType == 13) {
            if (primitive.isString()) {
                return Integer.parseInt(primitive.getAsString());
            }
            return primitive.getAsInt();
        }
        return primitive.getAsBigDecimal();
    }
}

