/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public class ReadFileCallable
implements Callable<byte[]>,
Serializable {
    private static final long serialVersionUID = -1423690018599866128L;
    private String parentFolderName;
    private String fileName;
    private int blockSize;
    private int blockNo;
    private static final CLogger log = CLogger.getCLogger(ReadFileCallable.class);

    public ReadFileCallable(String parentFolderName, String fileName, int blockSize, int blockNo) {
        this.parentFolderName = parentFolderName;
        this.fileName = fileName;
        this.blockSize = blockSize;
        this.blockNo = blockNo;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] call() throws Exception {
        File file;
        File parentFolder = null;
        if ("java.io.tmpdir".equals(this.parentFolderName)) {
            parentFolder = new File(System.getProperty("java.io.tmpdir"));
        } else if (!Util.isEmpty((String)this.parentFolderName, (boolean)true)) {
            parentFolder = new File(this.parentFolderName);
        }
        File file2 = file = parentFolder != null ? new File(parentFolder, this.fileName) : new File(this.fileName);
        if (file.length() == 0L) {
            return new byte[0];
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                byte[] byArray;
                FileChannel channel;
                RandomAccessFile raf;
                block25: {
                    block24: {
                        raf = new RandomAccessFile(file, "r");
                        channel = raf.getChannel();
                        if (this.blockNo > 0 && this.blockSize > 0) {
                            channel.position(this.blockNo * this.blockSize);
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(1024);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                        int bytesRead = 0;
                        int totalRead = 0;
                        while ((bytesRead = channel.read(buffer)) > 0) {
                            if (this.blockSize > 0 && (totalRead += bytesRead) > this.blockSize) {
                                int diff = totalRead - this.blockSize;
                                bytesRead -= diff;
                                totalRead = this.blockSize;
                            }
                            baos.write(buffer.array(), 0, bytesRead);
                            buffer.clear();
                            if (totalRead == this.blockSize) break;
                        }
                        byArray = baos.toByteArray();
                        if (channel == null) break block24;
                        channel.close();
                    }
                    if (raf == null) break block25;
                    raf.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (channel != null) {
                                channel.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (raf != null) {
                                raf.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "stream" + String.valueOf(ex));
            return null;
        }
    }
}

