/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.trekglobal.idempiere.rest.api.json.DateTypeConverter;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class YAMLSchema {
    private static final List<String> readonlyColumns = Arrays.asList("ad_client_id", "created", "createdby", "updated", "updatedby");

    private YAMLSchema() {
    }

    public static void addServers(StringBuilder builder) {
        builder.append("servers:\n");
        builder.append(" ".repeat(2)).append("- url: '{base_url}'\n");
        builder.append(" ".repeat(4)).append("variables:\n");
        builder.append(" ".repeat(6)).append("base_url:\n");
        builder.append(" ".repeat(8)).append("enum:\n");
        builder.append(" ".repeat(10)).append("- 'http://localhost:8080/api/v1'\n");
        builder.append(" ".repeat(8)).append("default: 'http://localhost:8080/api/v1'\n");
    }

    public static void addSecuritySchema(StringBuilder builder) {
        builder.append(" ".repeat(2)).append("securitySchemes:\n");
        builder.append(" ".repeat(4)).append("bearerAuth:\n");
        builder.append(" ".repeat(6)).append("type: http\n");
        builder.append(" ".repeat(6)).append("scheme: bearer\n");
        builder.append(" ".repeat(6)).append("bearerFormat: JWT\n");
    }

    public static void addPredefinedParameters(StringBuilder builder) {
        builder.append(" ".repeat(2)).append("parameters:\n");
        builder.append(" ".repeat(4)).append("expand:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $expand\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: string\n");
        builder.append(" ".repeat(6)).append("description: expand of parent or child entities\n");
        builder.append(" ".repeat(4)).append("filter:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $filter\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: string\n");
        builder.append(" ".repeat(6)).append("description: query filter\n");
        builder.append(" ".repeat(4)).append("orderby:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $orderby\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: string\n");
        builder.append(" ".repeat(6)).append("description: ordering of query result\n");
        builder.append(" ".repeat(4)).append("select:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $select\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: string\n");
        builder.append(" ".repeat(6)).append("description: comma separated list of properties to be included in the json result object\n");
        builder.append(" ".repeat(4)).append("top:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $top\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: string\n");
        builder.append(" ".repeat(6)).append("description: first n items to return from query result\n");
        builder.append(" ".repeat(4)).append("skip:\n");
        builder.append(" ".repeat(6)).append("in: query\n");
        builder.append(" ".repeat(6)).append("name: $skip\n");
        builder.append(" ".repeat(6)).append("required: false\n");
        builder.append(" ".repeat(6)).append("schema:\n");
        builder.append(" ".repeat(8)).append("type: integer\n");
        builder.append(" ".repeat(8)).append("minimum: 0\n");
        builder.append(" ".repeat(6)).append("description: first n items to skip\n");
    }

    public static void addSecurityHeader(StringBuilder builder) {
        builder.append("security:\n");
        builder.append(" ".repeat(2)).append("- bearerAuth: [] # use the same name as above\n");
    }

    public static void addViewProperties(MRestView view, StringBuilder builder, int offset) {
        MRestViewRelated[] relatedViews;
        MRestViewColumn[] viewColumns;
        MTable table = MTable.get((int)view.getAD_Table_ID());
        String uidColumn = PO.getUUIDColumnName((String)table.getTableName());
        MRestViewColumn[] mRestViewColumnArray = viewColumns = view.getColumns();
        int n = viewColumns.length;
        int n2 = 0;
        while (n2 < n) {
            MRestViewColumn viewColumn = mRestViewColumnArray[n2];
            MColumn column = MColumn.get((int)viewColumn.getAD_Column_ID());
            if (!column.isKey() && !column.getColumnName().equals(uidColumn) && column.getAD_Reference_ID() != 28 && column.getAD_Reference_ID() != 53370) {
                builder.append(" ".repeat(offset)).append(viewColumn.getName()).append(":");
                if (column.getAD_Reference_ID() == 32) {
                    builder.append(" { $ref: '#/components/schemas/Image' }\n");
                } else if (column.getAD_Reference_ID() == 21 && viewColumn.getREST_ReferenceView_ID() == 0) {
                    builder.append(" { $ref: '#/components/schemas/Location' }\n");
                } else {
                    builder.append("\n");
                    String columnDescription = column.get_Translation("Description");
                    if (column.getAD_Reference_ID() == 21 && viewColumn.getREST_ReferenceView_ID() > 0) {
                        MRestView locationView = MRestView.get(viewColumn.getREST_ReferenceView_ID());
                        builder.append(" ".repeat(offset + 2)).append("type: object\n");
                        builder.append(" ".repeat(offset + 2)).append("properties:\n");
                        builder.append(" ".repeat(offset + 4)).append("id:\n");
                        builder.append(" ".repeat(offset + 6)).append("type: integer\n");
                        builder.append(" ".repeat(offset + 6)).append("description: record id\n");
                        builder.append(" ".repeat(offset + 4)).append("identifier:\n");
                        builder.append(" ".repeat(offset + 6)).append("type: string\n");
                        builder.append(" ".repeat(offset + 6)).append("description: record identifier\n");
                        builder.append(" ".repeat(offset + 4)).append("model-name:\n");
                        builder.append(" ".repeat(offset + 6)).append("type: string\n");
                        builder.append(" ".repeat(offset + 6)).append("readOnly: true\n");
                        builder.append(" ".repeat(offset + 6)).append("enum:\n");
                        builder.append(" ".repeat(offset + 8)).append(" - '").append("c_location").append("'\n");
                        builder.append(" ".repeat(offset + 4)).append("view-name:\n");
                        builder.append(" ".repeat(offset + 6)).append("type: string\n");
                        builder.append(" ".repeat(offset + 6)).append("readOnly: true\n");
                        builder.append(" ".repeat(offset + 6)).append("enum:\n");
                        builder.append(" ".repeat(offset + 8)).append(" - '").append(locationView.getName()).append("'\n");
                        YAMLSchema.addViewProperties(locationView, builder, offset + 4);
                    } else if (DisplayType.isList((int)column.getAD_Reference_ID())) {
                        YAMLSchema.addListProperty(builder, column, offset + 2);
                    } else if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                        YAMLSchema.addLookupProperty(builder, column, offset + 2);
                    } else if (column.getAD_Reference_ID() == 23) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: byte\n");
                        builder.append(" ".repeat(offset + 2)).append("description: base64 encoded binary content\n");
                    } else if (column.getAD_Reference_ID() == 20) {
                        builder.append(" ".repeat(offset + 2)).append("type: boolean\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (column.getAD_Reference_ID() == 11) {
                        builder.append(" ".repeat(offset + 2)).append("type: integer\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                        builder.append(" ".repeat(offset + 2)).append("type: number\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (column.getAD_Reference_ID() == 15) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: date\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(15, new Date())).append("\n");
                    } else if (column.getAD_Reference_ID() == 24) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: time\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(24, new Date())).append("\n");
                    } else if (column.getAD_Reference_ID() == 16 || column.getAD_Reference_ID() == 200133) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: date-time\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(16, new Date())).append("\n");
                    } else {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    }
                    if (readonlyColumns.contains(column.getColumnName().toLowerCase())) {
                        builder.append(" ".repeat(offset + 2)).append("readOnly: true\n");
                    }
                }
            }
            ++n2;
        }
        MRestViewRelated[] mRestViewRelatedArray = relatedViews = view.getRelatedViews();
        int n3 = relatedViews.length;
        n = 0;
        while (n < n3) {
            MRestViewRelated relatedView = mRestViewRelatedArray[n];
            if (relatedView.isRestAutoExpand()) {
                builder.append(" ".repeat(offset)).append(relatedView.getName()).append(":\n");
                builder.append(" ".repeat(offset + 2)).append("type: array\n");
                builder.append(" ".repeat(offset + 2)).append("items:\n");
                builder.append(" ".repeat(offset + 4)).append("$ref: '#/components/schemas/").append(MRestView.get(relatedView.getREST_RelatedRestView_ID()).getName()).append("'\n");
            }
            ++n;
        }
    }

    public static void addImageReference(StringBuilder builder) {
        builder.append(" ".repeat(4)).append("Image").append(":\n");
        builder.append(" ".repeat(6)).append("type: object\n");
        builder.append(" ".repeat(6)).append("properties:\n");
        builder.append(" ".repeat(8)).append("id:\n");
        builder.append(" ".repeat(10)).append("type: integer\n");
        builder.append(" ".repeat(10)).append("description: image id\n");
        builder.append(" ".repeat(8)).append("uid:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("description: image uuid\n");
        builder.append(" ".repeat(8)).append("file_name:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("description: image file name\n");
        builder.append(" ".repeat(8)).append("data:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("format: byte\n");
        builder.append(" ".repeat(10)).append("description: base64 encoded image content\n");
    }

    public static void addLocationReference(StringBuilder builder, int offset) {
        String label = Msg.getElement((Properties)Env.getCtx(), (String)"C_Location_ID");
        builder.append(" ".repeat(offset)).append("Location").append(":\n");
        builder.append(" ".repeat(offset + 2)).append("type: object\n");
        builder.append(" ".repeat(offset + 2)).append("properties:\n");
        builder.append(" ".repeat(offset + 4)).append("propertyLabel: \n");
        builder.append(" ".repeat(offset + 6)).append("type: string\n");
        builder.append(" ".repeat(offset + 6)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 6)).append("enum:\n");
        builder.append(" ".repeat(offset + 8)).append(" - '").append(label).append("'\n");
        builder.append(" ".repeat(offset + 4)).append("id:\n");
        builder.append(" ".repeat(offset + 6)).append("type: integer\n");
        builder.append(" ".repeat(offset + 6)).append("description: record id\n");
        builder.append(" ".repeat(offset + 4)).append("identifier:\n");
        builder.append(" ".repeat(offset + 6)).append("type: string\n");
        builder.append(" ".repeat(offset + 6)).append("description: record identifier\n");
        builder.append(" ".repeat(offset + 4)).append("model-name:\n");
        builder.append(" ".repeat(offset + 6)).append("type: string\n");
        builder.append(" ".repeat(offset + 6)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 6)).append("enum:\n");
        builder.append(" ".repeat(offset + 8)).append(" - '").append("c_location").append("'\n");
        MTable locationTable = MTable.get((int)162);
        StringBuilder locationYaml = new StringBuilder();
        YAMLSchema.addTableProperties(locationTable, locationYaml, offset + 4);
        builder.append(locationYaml.toString());
    }

    public static void addErrorResponseReference(StringBuilder builder) {
        builder.append(" ".repeat(4)).append("errorResponse").append(":\n");
        builder.append(" ".repeat(6)).append("type: object\n");
        builder.append(" ".repeat(6)).append("properties:\n");
        builder.append(" ".repeat(8)).append("title:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("description: error summary text\n");
        builder.append(" ".repeat(8)).append("status:\n");
        builder.append(" ".repeat(10)).append("type: integer\n");
        builder.append(" ".repeat(10)).append("description: http status\n");
        builder.append(" ".repeat(8)).append("detail:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("description: error detail text\n");
    }

    public static void addLookupProperty(StringBuilder builder, MColumn column, int offset) {
        String label = Msg.getElement((Properties)Env.getCtx(), (String)column.getColumnName());
        builder.append(" ".repeat(offset)).append("type: object\n");
        builder.append(" ".repeat(offset)).append("properties:\n");
        builder.append(" ".repeat(offset + 2)).append("propertyLabel: \n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 4)).append("enum:\n");
        builder.append(" ".repeat(offset + 6)).append(" - '").append(label).append("'\n");
        builder.append(" ".repeat(offset + 2)).append("id:\n");
        builder.append(" ".repeat(offset + 4)).append("type: integer\n");
        builder.append(" ".repeat(offset + 4)).append("description: record id\n");
        builder.append(" ".repeat(offset + 2)).append("identifier:\n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("description: record identifier\n");
        builder.append(" ".repeat(offset + 2)).append("model-name:\n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 4)).append("enum:\n");
        builder.append(" ".repeat(offset + 6)).append(" - '").append(column.getReferenceTableName().toLowerCase()).append("'\n");
    }

    public static void addListProperty(StringBuilder builder, MColumn column, int offset) {
        ValueNamePair pair;
        int n;
        int n2;
        ValueNamePair[] valueNamePairArray;
        String label = Msg.getElement((Properties)Env.getCtx(), (String)column.getColumnName());
        ValueNamePair[] referenceList = MRefList.getList((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (boolean)false);
        builder.append(" ".repeat(offset)).append("type: object\n");
        builder.append(" ".repeat(offset)).append("properties:\n");
        builder.append(" ".repeat(offset + 2)).append("propertyLabel: \n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 4)).append("enum:\n");
        builder.append(" ".repeat(offset + 6)).append(" - '").append(label).append("'\n");
        builder.append(" ".repeat(offset + 2)).append("id:\n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("description: list item id\n");
        if (referenceList.length > 0) {
            builder.append(" ".repeat(offset + 4)).append("enum:\n");
            valueNamePairArray = referenceList;
            n2 = referenceList.length;
            n = 0;
            while (n < n2) {
                pair = valueNamePairArray[n];
                builder.append(" ".repeat(offset + 6)).append("- ").append("'").append(pair.getValue()).append("'\n");
                ++n;
            }
        }
        builder.append(" ".repeat(offset + 2)).append("identifier:\n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("description: list item identifier\n");
        if (referenceList.length > 0) {
            builder.append(" ".repeat(offset + 4)).append("enum:\n");
            valueNamePairArray = referenceList;
            n2 = referenceList.length;
            n = 0;
            while (n < n2) {
                pair = valueNamePairArray[n];
                builder.append(" ".repeat(offset + 6)).append("- ").append("'").append(pair.getName()).append("'\n");
                ++n;
            }
        }
        builder.append(" ".repeat(offset + 2)).append("model-name:\n");
        builder.append(" ".repeat(offset + 4)).append("type: string\n");
        builder.append(" ".repeat(offset + 4)).append("readOnly: true\n");
        builder.append(" ".repeat(offset + 4)).append("enum:\n");
        builder.append(" ".repeat(offset + 6)).append(" - '").append("ad_ref_list").append("'\n");
    }

    public static void addTableProperties(MTable table, StringBuilder builder, int offset) {
        MColumn[] columns;
        String uidColumn = PO.getUUIDColumnName((String)table.getTableName());
        MColumn[] mColumnArray = columns = table.getColumns(false);
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (!column.isKey() && !column.getColumnName().equals(uidColumn) && column.getAD_Reference_ID() != 28 && column.getAD_Reference_ID() != 53370) {
                builder.append(" ".repeat(offset)).append(column.getColumnName()).append(":");
                if (column.getAD_Reference_ID() == 32) {
                    builder.append(" { $ref: '#/components/schemas/Image' }\n");
                } else if (column.getAD_Reference_ID() == 21) {
                    builder.append(" { $ref: '#/components/schemas/Location' }\n");
                } else {
                    builder.append("\n");
                    String columnDescription = column.get_Translation("Description");
                    if (DisplayType.isList((int)column.getAD_Reference_ID())) {
                        YAMLSchema.addListProperty(builder, column, offset + 2);
                    } else if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                        YAMLSchema.addLookupProperty(builder, column, offset + 2);
                    } else if (column.getAD_Reference_ID() == 23) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: byte\n");
                        builder.append(" ".repeat(offset + 2)).append("description: base64 encoded binary content\n");
                    } else if (column.getAD_Reference_ID() == 20) {
                        builder.append(" ".repeat(offset + 2)).append("type: boolean\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (column.getAD_Reference_ID() == 11) {
                        builder.append(" ".repeat(offset + 2)).append("type: integer\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                        builder.append(" ".repeat(offset + 2)).append("type: number\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    } else if (column.getAD_Reference_ID() == 15) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: date\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(15, new Date())).append("\n");
                    } else if (column.getAD_Reference_ID() == 24) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(24, new Date())).append("\n");
                    } else if (column.getAD_Reference_ID() == 16 || column.getAD_Reference_ID() == 200133) {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        builder.append(" ".repeat(offset + 2)).append("format: date-time\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                        builder.append(" ".repeat(offset + 2)).append("example: ").append(new DateTypeConverter().toJsonValue(16, new Date())).append("\n");
                    } else {
                        builder.append(" ".repeat(offset + 2)).append("type: string\n");
                        if (!Util.isEmpty((String)columnDescription)) {
                            builder.append(" ".repeat(offset + 2)).append("description: ").append(columnDescription).append("\n");
                        }
                    }
                    if (readonlyColumns.contains(column.getColumnName().toLowerCase())) {
                        builder.append(" ".repeat(offset + 2)).append("readOnly: true\n");
                    }
                }
            }
            ++n2;
        }
    }

    private static void addQueryRequest(String name, boolean view, StringBuilder builder) {
        builder.append(" ".repeat(2)).append(view ? "/views/" : "/models/").append(name).append(":\n");
        builder.append(" ".repeat(4)).append("get:\n");
        builder.append(" ".repeat(6)).append("parameters:\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/expand'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/select'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/filter'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/orderby'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/top'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/skip'\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("page-count:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: number of page\n");
        builder.append(" ".repeat(18)).append("records-size:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: number of records per page\n");
        builder.append(" ".repeat(18)).append("skip-records:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(18)).append("row-count:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: total number of records\n");
        builder.append(" ".repeat(18)).append("array-count:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(18)).append("records:\n");
        builder.append(" ".repeat(20)).append("type: array\n");
        builder.append(" ".repeat(20)).append("items: { $ref: '#/components/schemas/").append(name).append("' }\n");
    }

    public static void addModelRequest(String name, boolean view, StringBuilder builder) {
        builder.append(" ".repeat(2)).append(view ? "/views/" : "/models/").append(name).append("/{id}:\n");
        builder.append(" ".repeat(4)).append("get:\n");
        builder.append(" ".repeat(6)).append("parameters:\n");
        builder.append(" ".repeat(8)).append("- name: id\n");
        builder.append(" ".repeat(10)).append("in: path\n");
        builder.append(" ".repeat(10)).append("schema:\n");
        builder.append(" ".repeat(12)).append("oneOf: \n");
        builder.append(" ".repeat(14)).append("- type: string\n");
        builder.append(" ".repeat(14)).append("- type: integer\n");
        builder.append(" ".repeat(10)).append("required: true\n");
        builder.append(" ".repeat(10)).append("description: integer record id or string record uuid\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/expand'\n");
        builder.append(" ".repeat(8)).append("- $ref: '#/components/parameters/select'\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/").append(name).append("' }\n");
        builder.append(" ".repeat(8)).append("'404':\n");
        builder.append(" ".repeat(10)).append("description: Not found response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
        builder.append(" ".repeat(4)).append("put:\n");
        builder.append(" ".repeat(6)).append("requestBody:\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/").append(name).append("' }\n");
        builder.append(" ".repeat(6)).append("parameters:\n");
        builder.append(" ".repeat(8)).append("- name: id\n");
        builder.append(" ".repeat(10)).append("in: path\n");
        builder.append(" ".repeat(10)).append("schema:\n");
        builder.append(" ".repeat(12)).append("oneOf: \n");
        builder.append(" ".repeat(14)).append("- type: string\n");
        builder.append(" ".repeat(14)).append("- type: integer\n");
        builder.append(" ".repeat(10)).append("required: true\n");
        builder.append(" ".repeat(10)).append("description: integer record id or string record uuid\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/").append(name).append("' }\n");
        builder.append(" ".repeat(8)).append("'404':\n");
        builder.append(" ".repeat(10)).append("description: Not found response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
        builder.append(" ".repeat(8)).append("'500':\n");
        builder.append(" ".repeat(10)).append("description: Error response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
        builder.append(" ".repeat(4)).append("delete:\n");
        builder.append(" ".repeat(6)).append("parameters:\n");
        builder.append(" ".repeat(8)).append("- name: id\n");
        builder.append(" ".repeat(10)).append("in: path\n");
        builder.append(" ".repeat(10)).append("schema:\n");
        builder.append(" ".repeat(12)).append("oneOf: \n");
        builder.append(" ".repeat(14)).append("- type: string\n");
        builder.append(" ".repeat(14)).append("- type: integer\n");
        builder.append(" ".repeat(10)).append("required: true\n");
        builder.append(" ".repeat(10)).append("description: integer record id or string record uuid\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("msg:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: info or error message\n");
        builder.append(" ".repeat(20)).append("example: 'Deleted'\n");
        builder.append(" ".repeat(8)).append("'404':\n");
        builder.append(" ".repeat(10)).append("description: Not found response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
        builder.append(" ".repeat(8)).append("'500':\n");
        builder.append(" ".repeat(10)).append("description: Error response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
        YAMLSchema.addQueryRequest(name, view, builder);
        builder.append(" ".repeat(4)).append("post:\n");
        builder.append(" ".repeat(6)).append("requestBody:\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/").append(name).append("' }\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'201':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/").append(name).append("' }\n");
        builder.append(" ".repeat(8)).append("'500':\n");
        builder.append(" ".repeat(10)).append("description: Error response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema: { $ref: '#/components/schemas/errorResponse' }\n");
    }

    public static void addAuthRequest(StringBuilder builder) {
        builder.append(" ".repeat(2)).append("/auth/tokens:\n");
        builder.append(" ".repeat(4)).append("post:\n");
        builder.append(" ".repeat(6)).append("summary: Login for authorization token\n");
        builder.append(" ".repeat(6)).append("requestBody:\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("userName:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Username for authentication\n");
        builder.append(" ".repeat(18)).append("password:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Password for authentication\n");
        builder.append(" ".repeat(18)).append("parameters:\n");
        builder.append(" ".repeat(20)).append("type: object\n");
        builder.append(" ".repeat(20)).append("properties:\n");
        builder.append(" ".repeat(22)).append("clientId:\n");
        builder.append(" ".repeat(24)).append("oneOf:\n");
        builder.append(" ".repeat(26)).append("- type: integer\n");
        builder.append(" ".repeat(26)).append("- type: string\n");
        builder.append(" ".repeat(24)).append("description: Tenant integer id or tenant search key\n");
        builder.append(" ".repeat(24)).append("example: 1000000\n");
        builder.append(" ".repeat(22)).append("roleId:\n");
        builder.append(" ".repeat(24)).append("oneOf:\n");
        builder.append(" ".repeat(26)).append("- type: integer\n");
        builder.append(" ".repeat(26)).append("- type: string\n");
        builder.append(" ".repeat(24)).append("description: Role integer id or role name\n");
        builder.append(" ".repeat(24)).append("example: 1000000\n");
        builder.append(" ".repeat(22)).append("organizationId:\n");
        builder.append(" ".repeat(24)).append("oneOf:\n");
        builder.append(" ".repeat(26)).append("- type: integer\n");
        builder.append(" ".repeat(26)).append("- type: string\n");
        builder.append(" ".repeat(24)).append("description: Organization integer id or organization name\n");
        builder.append(" ".repeat(24)).append("example: 1000000\n");
        builder.append(" ".repeat(22)).append("warehouseId:\n");
        builder.append(" ".repeat(24)).append("oneOf:\n");
        builder.append(" ".repeat(26)).append("- type: integer\n");
        builder.append(" ".repeat(26)).append("- type: string\n");
        builder.append(" ".repeat(24)).append("description: Warehouse integer id or warehouse name\n");
        builder.append(" ".repeat(24)).append("example: 1000000\n");
        builder.append(" ".repeat(22)).append("language:\n");
        builder.append(" ".repeat(24)).append("type: string\n");
        builder.append(" ".repeat(24)).append("description: Language code\n");
        builder.append(" ".repeat(24)).append("example: en_US\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("userId:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: User identifier\n");
        builder.append(" ".repeat(18)).append("language:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Language code\n");
        builder.append(" ".repeat(20)).append("example: en_US\n");
        builder.append(" ".repeat(18)).append("menuTreeId:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: Menu tree identifier\n");
        builder.append(" ".repeat(18)).append("token:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Authentication token (JWT)\n");
        builder.append(" ".repeat(18)).append("refresh_token:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Authentication token (JWT)\n");
        builder.append(" ".repeat(2)).append("/auth/refresh:\n");
        builder.append(" ".repeat(4)).append("post:\n");
        builder.append(" ".repeat(6)).append("summary: Refresh authorization token\n");
        builder.append(" ".repeat(6)).append("requestBody:\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("refresh_token:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Authentication token (JWT)\n");
        builder.append(" ".repeat(18)).append("clientId:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: clientId from the source /auth/tokens or /auth/refresh call\n");
        builder.append(" ".repeat(18)).append("userId:\n");
        builder.append(" ".repeat(20)).append("type: integer\n");
        builder.append(" ".repeat(20)).append("description: userId from the /auth/tokens response\n");
        builder.append(" ".repeat(6)).append("responses:\n");
        builder.append(" ".repeat(8)).append("'200':\n");
        builder.append(" ".repeat(10)).append("description: Successful response\n");
        builder.append(" ".repeat(10)).append("content:\n");
        builder.append(" ".repeat(12)).append("application/json:\n");
        builder.append(" ".repeat(14)).append("schema:\n");
        builder.append(" ".repeat(16)).append("type: object\n");
        builder.append(" ".repeat(16)).append("properties:\n");
        builder.append(" ".repeat(18)).append("token:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Authentication token (JWT)\n");
        builder.append(" ".repeat(18)).append("refresh_token:\n");
        builder.append(" ".repeat(20)).append("type: string\n");
        builder.append(" ".repeat(20)).append("description: Authentication token (JWT)\n");
    }
}

