/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.InfoResource;
import com.trekglobal.idempiere.rest.api.v1.resource.info.InfoWindow;
import com.trekglobal.idempiere.rest.api.v1.resource.info.QueryResponse;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.adempiere.model.MInfoProcess;
import org.adempiere.model.MInfoRelated;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class InfoResourceImpl
implements InfoResource {
    private static final CLogger log = CLogger.getCLogger(InfoResourceImpl.class);
    private static final int DEFAULT_QUERY_TIMEOUT = 120;
    private static final int DEFAULT_PAGE_SIZE = 100;

    @Override
    public Response getInfoWindows(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_InfoWindow", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "AD_InfoWindow", convertedStatement.getWhereClause(), null);
            query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            query.setQueryTimeout(120);
            query.setParameters(convertedStatement.getParameters());
            List infoWindows = query.setOrderBy("AD_InfoWindow.Name").list();
            JsonArray array = new JsonArray();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_InfoWindow", MInfoWindow.class);
            for (MInfoWindow infoWindow : infoWindows) {
                if (!this.hasAccess(infoWindow)) continue;
                JsonObject json = serializer.toJson((PO)infoWindow);
                json.addProperty("slug", TypeConverterUtils.slugify(infoWindow.getName()));
                array.add((JsonElement)json);
            }
            JsonObject json = new JsonObject();
            json.add("infowindows", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get InfoWindows with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    private boolean hasAccess(MInfoWindow infoWindow) {
        MRole role = MRole.getDefault();
        return role.getInfoAccess(infoWindow.getAD_InfoWindow_ID()) != null;
    }

    @Override
    public Response getInfoWindowRecords(String infoSlug, String parameters, String whereClause, String orderBy, int pageNo) {
        Query query = new Query(Env.getCtx(), "AD_InfoWindow", "slugify(name)=?", null);
        query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
        MInfoWindow infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
        if (infoWindowModel == null) {
            query.setApplyAccessFilter(false);
            infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
            if (infoWindowModel != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid info window name").append("No match found for info window name: ").append(infoSlug).build().toString()).build();
        }
        if (!this.hasAccess(infoWindowModel)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
        }
        HashMap<String, JsonElement> paraMap = new HashMap<String, JsonElement>();
        if (!Util.isEmpty((String)parameters)) {
            Gson gson = new GsonBuilder().create();
            JsonObject jso = (JsonObject)gson.fromJson(parameters, JsonObject.class);
            for (String key : jso.keySet()) {
                JsonElement element = jso.get(key);
                if (element == null) continue;
                paraMap.put(key, element);
            }
        }
        InfoWindow infoWindow = new InfoWindow(infoWindowModel, whereClause, orderBy, true);
        infoWindow.setQueryParameters(paraMap);
        QueryResponse queryResponse = infoWindow.executeQuery(100, pageNo, 120);
        JsonArray array = queryResponse.getRecords();
        JsonObject json = new JsonObject();
        json.add("infowindow-records", (JsonElement)array);
        Response.ResponseBuilder response = Response.ok((Object)json.toString());
        if (array.size() > 0) {
            pageNo = queryResponse.getPageNo();
            response.header("X-Page", (Object)pageNo);
            response.header("X-Per-Page", (Object)100);
            if (queryResponse.isHasNextPage()) {
                response.header("X-Next-Page", (Object)(pageNo + 1));
            }
            if (pageNo > 1) {
                response.header("X-Prev-Page: 1", (Object)(pageNo - 1));
            }
        }
        return response.build();
    }

    @Override
    public Response getInfoWindowColumns(String infoSlug) {
        Query query = new Query(Env.getCtx(), "AD_InfoWindow", "slugify(name)=?", null);
        query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
        MInfoWindow infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
        if (infoWindowModel == null) {
            query.setApplyAccessFilter(false);
            infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
            if (infoWindowModel != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid info window name").append("No match found for info window name: ").append(infoSlug).build().toString()).build();
        }
        if (!this.hasAccess(infoWindowModel)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
        }
        MInfoColumn[] infoColumns = infoWindowModel.getInfoColumns();
        JsonArray array = new JsonArray();
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_InfoColumn", MInfoColumn.class);
        MInfoColumn[] mInfoColumnArray = infoColumns;
        int n = infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn infoColumn = mInfoColumnArray[n2];
            JsonObject json = serializer.toJson((PO)infoColumn);
            array.add((JsonElement)json);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("infowindowcolumns", (JsonElement)array);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getInfoWindowProcesses(String infoSlug) {
        Query query = new Query(Env.getCtx(), "AD_InfoWindow", "slugify(name)=?", null);
        query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
        MInfoWindow infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
        if (infoWindowModel == null) {
            query.setApplyAccessFilter(false);
            infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
            if (infoWindowModel != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid info window name").append("No match found for info window name: ").append(infoSlug).build().toString()).build();
        }
        if (!this.hasAccess(infoWindowModel)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
        }
        MInfoProcess[] infoProcesses = infoWindowModel.getInfoProcess(false);
        JsonArray array = new JsonArray();
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_InfoProcess", MInfoProcess.class);
        MInfoProcess[] mInfoProcessArray = infoProcesses;
        int n = infoProcesses.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoProcess infoProcess = mInfoProcessArray[n2];
            JsonObject json = serializer.toJson((PO)infoProcess);
            String slug = TypeConverterUtils.slugify(infoProcess.getAD_Process().getValue());
            json.addProperty("slug", slug);
            array.add((JsonElement)json);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("infowindowprocesses", (JsonElement)array);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getInfoWindowRelateds(String infoSlug) {
        Query query = new Query(Env.getCtx(), "AD_InfoWindow", "slugify(name)=?", null);
        query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
        MInfoWindow infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
        if (infoWindowModel == null) {
            query.setApplyAccessFilter(false);
            infoWindowModel = (MInfoWindow)query.setParameters(new Object[]{infoSlug}).first();
            if (infoWindowModel != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid info window name").append("No match found for info window name: ").append(infoSlug).build().toString()).build();
        }
        if (!this.hasAccess(infoWindowModel)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for info window: ").append(infoSlug).build().toString()).build();
        }
        MInfoRelated[] infoRelateds = infoWindowModel.getInfoRelated(false);
        JsonArray array = new JsonArray();
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_InfoRelated", MInfoRelated.class);
        MInfoRelated[] mInfoRelatedArray = infoRelateds;
        int n = infoRelateds.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoRelated infoRelated = mInfoRelatedArray[n2];
            JsonObject json = serializer.toJson((PO)infoRelated);
            String slug = TypeConverterUtils.slugify(infoRelated.getRelatedInfo().getName());
            json.addProperty("slug", slug);
            array.add((JsonElement)json);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("infowindowrelateds", (JsonElement)array);
        return Response.ok((Object)json.toString()).build();
    }
}

