/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.auth.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.model.MAuthToken;
import com.trekglobal.idempiere.rest.api.model.MOIDCService;
import com.trekglobal.idempiere.rest.api.model.MRefreshToken;
import com.trekglobal.idempiere.rest.api.model.MRestResourceAccess;
import com.trekglobal.idempiere.rest.api.v1.jwt.LoginClaims;
import com.trekglobal.idempiere.rest.api.v1.jwt.TokenUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.adempiere.util.ServerContext;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MUser;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Provider
@Priority(value=2000)
public class RequestFilter
implements ContainerRequestFilter {
    public static final String LOGIN_NAME = "#LoginName";
    public static final String LOGIN_CLIENTS = "#LoginClients";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Properties ctx = new Properties();
        ServerContext.setCurrentInstance((Properties)ctx);
        if ("OPTIONS".equals(requestContext.getMethod()) || "POST".equals(requestContext.getMethod()) && requestContext.getUriInfo().getPath().endsWith("v1/auth/tokens") || "GET".equals(requestContext.getMethod()) && requestContext.getUriInfo().getPath().endsWith("v1/auth/jwk") || "POST".equals(requestContext.getMethod()) && requestContext.getUriInfo().getPath().endsWith("v1/auth/refresh") || "POST".equals(requestContext.getMethod()) && requestContext.getUriInfo().getPath().endsWith("v1/auth/logout")) {
            return;
        }
        String authHeaderVal = requestContext.getHeaderString("Authorization");
        if (authHeaderVal != null && authHeaderVal.startsWith("Bearer")) {
            try {
                String[] authHeaderValues = authHeaderVal.split(" ");
                if (authHeaderValues.length < 2) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
                this.validate(authHeaderValues[1], requestContext);
                if ((Util.isEmpty((String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_ID")) || Util.isEmpty((String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Role_ID"))) && !requestContext.getUriInfo().getPath().startsWith("v1/auth/")) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
                if (MRestResourceAccess.isResourceAccessByRole() && !requestContext.getUriInfo().getPath().startsWith("v1/auth/") && !MRestResourceAccess.hasAccess(requestContext.getUriInfo().getPath(true), requestContext.getMethod())) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
            }
            catch (JWTVerificationException ex) {
                ex.printStackTrace();
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                requestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
        } else {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private void validate(String token, ContainerRequestContext requestContext) throws IllegalArgumentException, UnsupportedEncodingException {
        if (MAuthToken.isBlocked(token)) {
            throw new JWTVerificationException("Token is blocked");
        }
        if (MRefreshToken.isRevoked(token)) {
            throw new JWTVerificationException("Token is revoked");
        }
        MOIDCService service = MOIDCService.findMatchingOIDCService(token);
        if (service != null) {
            service.validateAccessToken(token, requestContext);
            return;
        }
        Algorithm algorithm = Algorithm.HMAC512((String)TokenUtils.getTokenSecret());
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(TokenUtils.getTokenIssuer()).build();
        DecodedJWT jwt = verifier.verify(token);
        String userName = jwt.getSubject();
        ServerContext.setCurrentInstance((Properties)new Properties());
        Env.setContext((Properties)Env.getCtx(), (String)LOGIN_NAME, (String)userName);
        Claim claim = jwt.getClaim(LoginClaims.Clients.name());
        if (!claim.isNull() && !claim.isMissing()) {
            String clients = claim.asString();
            Env.setContext((Properties)Env.getCtx(), (String)LOGIN_CLIENTS, (String)clients);
        }
        claim = jwt.getClaim(LoginClaims.AD_Client_ID.name());
        int AD_Client_ID = 0;
        if (!claim.isNull() && !claim.isMissing()) {
            AD_Client_ID = claim.asInt();
            MClient client = MClient.get((int)AD_Client_ID);
            if (client == null) {
                throw new JWTVerificationException("Invalid client claim");
            }
            if (!client.isActive()) {
                throw new JWTVerificationException("Client is inactive");
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)AD_Client_ID);
        }
        if (!(claim = jwt.getClaim(LoginClaims.AD_User_ID.name())).isNull() && !claim.isMissing()) {
            MUser user = MUser.get((int)claim.asInt());
            if (user == null) {
                throw new JWTVerificationException("Invalid user claim");
            }
            if (!user.isActive()) {
                throw new JWTVerificationException("User is inactive");
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)claim.asInt());
        }
        claim = jwt.getClaim(LoginClaims.AD_Role_ID.name());
        int AD_Role_ID = 0;
        if (!claim.isNull() && !claim.isMissing()) {
            AD_Role_ID = claim.asInt();
            MRole role = MRole.get((Properties)Env.getCtx(), (int)AD_Role_ID);
            if (role == null) {
                throw new JWTVerificationException("Invalid role claim");
            }
            if (!role.isActive()) {
                throw new JWTVerificationException("Role is inactive");
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)AD_Role_ID);
        }
        claim = jwt.getClaim(LoginClaims.AD_Org_ID.name());
        int AD_Org_ID = 0;
        if (!claim.isNull() && !claim.isMissing()) {
            AD_Org_ID = claim.asInt();
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Org_ID", (int)AD_Org_ID);
        }
        if (!(claim = jwt.getClaim(LoginClaims.M_Warehouse_ID.name())).isNull() && !claim.isMissing()) {
            Env.setContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID", (int)claim.asInt());
        }
        if (!(claim = jwt.getClaim(LoginClaims.AD_Language.name())).isNull() && !claim.isMissing()) {
            String AD_Language = claim.asString();
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Language", (String)AD_Language);
        }
        claim = jwt.getClaim(LoginClaims.AD_Session_ID.name());
        int AD_Session_ID = 0;
        if (!claim.isNull() && !claim.isMissing()) {
            AD_Session_ID = claim.asInt();
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)AD_Session_ID);
            MSession session = MSession.get((Properties)Env.getCtx());
            if (session.isProcessed()) {
                MAuthToken authToken = MAuthToken.get(Env.getCtx(), token);
                if (authToken != null || MRefreshToken.existsAuthToken(token)) {
                    DB.executeUpdateEx((String)"UPDATE AD_Session SET Processed='N', UpdatedBy=CreatedBy, Updated=getDate() WHERE AD_Session_ID=?", (Object[])new Object[]{AD_Session_ID}, null);
                    session.load(session.get_TrxName(), new String[0]);
                } else {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
            }
        }
        RestUtils.setSessionContextVariables(Env.getCtx());
    }
}

