/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import javax.ws.rs.core.Response;
import org.compiere.model.PO;

public class POParser {
    private static final String ACCESS_DENIED_TITLE = "Access denied";
    private static final String ACCESS_DENIED_MESSAGE = "Access denied for record with id: ";
    private static final String NOT_FOUND_TITLE = "Record not found";
    private static final String NOT_FOUND_MESSAGE = "No record found matching id: ";
    private PO po;
    private String tableName;
    private String recordID;
    private Response responseError;

    public POParser(String tableName, String recordID, boolean fullyQualifiedWhere, boolean isReadWrite) {
        this.tableName = tableName;
        this.recordID = recordID;
        if (this.isValidTable(isReadWrite)) {
            this.po = RestUtils.getPO(tableName, recordID, fullyQualifiedWhere, isReadWrite);
        }
    }

    public POParser(String tableName, String recordID, PO po) {
        this.tableName = tableName;
        this.recordID = recordID;
        if (this.isValidTable(false)) {
            this.po = po;
        }
    }

    private boolean isValidTable(boolean isReadWrite) {
        try {
            RestUtils.getTableAndCheckAccess(this.tableName, isReadWrite);
        }
        catch (Exception ex) {
            this.responseError = ResponseUtils.getResponseErrorFromException(ex, "");
            return false;
        }
        return true;
    }

    public boolean isValidPO() {
        return this.po != null;
    }

    public PO getPO() {
        return this.po;
    }

    public Response getResponseError() {
        if (this.responseError != null) {
            return this.responseError;
        }
        try {
            this.po = RestUtils.getPO(this.tableName, this.recordID, false, false);
        }
        catch (Exception e) {
            return ResponseUtils.getResponseErrorFromException(e, "Exception reading " + this.recordID);
        }
        if (this.po != null) {
            return ResponseUtils.getResponseError(Response.Status.FORBIDDEN, ACCESS_DENIED_TITLE, ACCESS_DENIED_MESSAGE, this.recordID);
        }
        return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, NOT_FOUND_TITLE, NOT_FOUND_MESSAGE, this.recordID);
    }
}

