/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;

public class DBReadReplica {
    private static String m_user = null;
    private static String m_pass = null;
    private static final String sqlValidateSync = "SELECT lastupdate FROM dbreplicasyncverifier";
    private static final String sqlUpdateSync = "UPDATE dbreplicasyncverifier SET lastupdate=getDate()";
    private static final String sqlValidateDBAddress = "SELECT DBAddress FROM AD_System";
    private static volatile int shift = 0;
    private static CLogger log = CLogger.getCLogger(DBReadReplica.class);

    public static PreparedStatement prepareNormalReadReplicaStatement(String sql, int resultSetType, int resultSetConcurrency, String trxName) {
        Connection conn = DBReadReplica.getConnectionRO();
        PreparedStatement statementToReturn = null;
        if (conn != null) {
            try {
                sql = DB.getDatabase().convertStatement(sql);
                statementToReturn = conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            catch (SQLException e) {
                log.warning("Error preparing statement in replica -> SQL = " + sql);
                statementToReturn = null;
                throw new AdempiereException(e);
            }
        }
        return statementToReturn;
    }

    private static Timestamp getReplicaVerificationTimestamp(Connection conn) {
        Timestamp replicaTs;
        block6: {
            PreparedStatement stVerifySync = null;
            ResultSet rsVerifySync = null;
            replicaTs = null;
            try {
                try {
                    stVerifySync = conn.prepareStatement(sqlValidateSync);
                    rsVerifySync = stVerifySync.executeQuery();
                    if (rsVerifySync.next()) {
                        replicaTs = rsVerifySync.getTimestamp("lastupdate");
                    }
                }
                catch (SQLException sQLException) {
                    replicaTs = null;
                    DB.close(rsVerifySync, stVerifySync);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsVerifySync, stVerifySync);
                throw throwable;
            }
            DB.close(rsVerifySync, stVerifySync);
        }
        return replicaTs;
    }

    private static String getReplicaDBAddress(Connection conn) {
        String dbAddr;
        block6: {
            PreparedStatement stVerifyAddr = null;
            ResultSet rsVerifyAddr = null;
            dbAddr = null;
            try {
                try {
                    stVerifyAddr = conn.prepareStatement(sqlValidateDBAddress);
                    rsVerifyAddr = stVerifyAddr.executeQuery();
                    if (rsVerifyAddr.next()) {
                        dbAddr = rsVerifyAddr.getString("DBAddress");
                    }
                }
                catch (SQLException sQLException) {
                    dbAddr = null;
                    DB.close(rsVerifyAddr, stVerifyAddr);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsVerifyAddr, stVerifyAddr);
                throw throwable;
            }
            DB.close(rsVerifyAddr, stVerifyAddr);
        }
        return dbAddr;
    }

    private static Connection tryConnect(String replicaURL) {
        Connection conn = null;
        try {
            conn = DB.getDatabase(replicaURL).getDriverConnection(replicaURL, m_user, m_pass);
            conn.setReadOnly(true);
        }
        catch (SQLException e) {
            log.warning("Could not get a connection to " + replicaURL + ", cause = " + e.getLocalizedMessage());
            conn = null;
        }
        return conn;
    }

    private static Timestamp setMasterVerificationTimestamp() {
        Timestamp lastTs = null;
        try {
            DB.executeUpdateEx(sqlUpdateSync, null);
            lastTs = DB.getSQLValueTSEx(null, sqlValidateSync, new Object[0]);
        }
        catch (DBException e1) {
            log.warning("Could not sync dbreplicasyncverifier, cause = " + e1.getLocalizedMessage());
            lastTs = null;
        }
        return lastTs;
    }

    public static void closeReadReplicaStatement(Statement st) {
        try {
            st.getConnection().close();
        }
        catch (SQLException e) {
            log.warning("Error closing the read replica statement, cause = " + e.getLocalizedMessage());
        }
    }

    private static void setUserPass() {
        if (m_user != null || m_pass != null) {
            return;
        }
        String attributes = Ini.getProperty("Connection");
        try {
            String[] pairs;
            attributes = attributes.substring(attributes.indexOf("[") + 1, attributes.length() - 1);
            String[] stringArray = pairs = attributes.split("[,]");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String pair = stringArray[n2];
                String[] pairComponents = pair.split("[=]");
                String key = pairComponents[0];
                String string = value = pairComponents.length == 2 ? DBReadReplica.unescape(pairComponents[1]) : "";
                if ("UID".equalsIgnoreCase(key)) {
                    m_user = value;
                } else if ("PWD".equalsIgnoreCase(key)) {
                    m_pass = value;
                }
                ++n2;
            }
            if (m_pass == null && MSystem.isSecureProps()) {
                m_pass = Ini.getVar("ADEMPIERE_DB_PASSWORD");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, attributes + " - " + e.toString(), e);
        }
    }

    private static String unescape(String value) {
        value = value.replace("&eq;", "=");
        value = value.replace("&comma;", ",");
        return value;
    }

    public static Connection getConnectionRO() {
        String replicaURLsConfig = MSysConfig.getValue("DB_READ_REPLICA_URLS");
        if (Util.isEmpty(replicaURLsConfig, true)) {
            return null;
        }
        int DB_READ_REPLICA_NORMAL_TIMEOUT_IN_MILLISECONDS = MSysConfig.getIntValue("DB_READ_REPLICA_NORMAL_TIMEOUT_IN_MILLISECONDS", 5000);
        int DB_READ_REPLICA_NORMAL_MAX_ITERATIONS = MSysConfig.getIntValue("DB_READ_REPLICA_NORMAL_MAX_ITERATIONS", 3);
        DBReadReplica.setUserPass();
        Timestamp lastTs = DBReadReplica.setMasterVerificationTimestamp();
        String masterDBAddress = MSystem.get(Env.getCtx()).getDBAddress();
        ArrayList<URLReplicaConnection> urlConnList = new ArrayList<URLReplicaConnection>();
        String[] replicaURLs = replicaURLsConfig.split("\\|");
        int index = 0;
        int length = replicaURLs.length;
        int i2 = 0;
        while (i2 < length) {
            String replicaURL = replicaURLs[i2].trim();
            index = (i2 + shift) % length;
            URLReplicaConnection urc = new URLReplicaConnection(replicaURL, index);
            urlConnList.add(urc);
            ++i2;
        }
        if (++shift >= length) {
            shift = 0;
        }
        Collections.sort(urlConnList);
        String usedReplicaURL = null;
        Connection retConn = null;
        int i3 = 0;
        while (i3 < DB_READ_REPLICA_NORMAL_MAX_ITERATIONS) {
            for (URLReplicaConnection urlConn : urlConnList) {
                if (!urlConn.isUsable()) continue;
                String replicaURL = urlConn.getReplicaURL();
                Connection conn = urlConn.getConnection();
                if (conn == null && urlConn.isUsable()) {
                    conn = DBReadReplica.tryConnect(replicaURL);
                }
                if (conn == null) {
                    urlConn.setUsable(false);
                    continue;
                }
                urlConn.setConnection(conn);
                String replicaDBAddress = DBReadReplica.getReplicaDBAddress(conn);
                if (!masterDBAddress.equals(replicaDBAddress)) {
                    log.warning("Replica DB Address doesn't match with master DB Address -> " + (String)replicaURL);
                    urlConn.setUsable(false);
                    continue;
                }
                Timestamp replicaTs = DBReadReplica.getReplicaVerificationTimestamp(conn);
                if (replicaTs == null) {
                    log.warning("Could not get replica verification timestamp -> " + (String)replicaURL);
                    urlConn.setUsable(false);
                    continue;
                }
                if (replicaTs.before(lastTs) || conn == null) continue;
                retConn = conn;
                usedReplicaURL = urlConn.getReplicaURL();
                break;
            }
            if (retConn != null) break;
            boolean noMoreUsables = true;
            for (URLReplicaConnection urlConn : urlConnList) {
                if (!urlConn.isUsable()) continue;
                noMoreUsables = false;
                break;
            }
            if (noMoreUsables) break;
            if (i3 < DB_READ_REPLICA_NORMAL_MAX_ITERATIONS - 1) {
                try {
                    log.warning("Waiting " + DB_READ_REPLICA_NORMAL_TIMEOUT_IN_MILLISECONDS + " milliseconds for replication to sync");
                    Thread.sleep(DB_READ_REPLICA_NORMAL_TIMEOUT_IN_MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i3;
        }
        if (retConn == null) {
            log.warning("Abandoning replicas: none usable or max wait reached without sync");
        }
        for (URLReplicaConnection urlConn : urlConnList) {
            Connection conn = urlConn.getConnection();
            if (conn == null || retConn != null && retConn == conn) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.warning("Could not close connection statement on replica, URL = " + urlConn.getReplicaURL() + ", cause = " + e.getLocalizedMessage());
            }
        }
        if (retConn != null) {
            log.warning("Using replica for connection, URL = " + usedReplicaURL);
        }
        return retConn;
    }

    private static class URLReplicaConnection
    implements Comparable<URLReplicaConnection> {
        private String replicaURL;
        private int index;
        private boolean usable = true;
        private Connection conn = null;

        public URLReplicaConnection(String replicaURL, int index) {
            this.replicaURL = replicaURL;
            this.index = index;
        }

        public String getReplicaURL() {
            return this.replicaURL;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void setUsable(boolean usable) {
            this.usable = usable;
        }

        public Connection getConnection() {
            return this.conn;
        }

        public void setConnection(Connection conn) {
            this.conn = conn;
        }

        @Override
        public int compareTo(URLReplicaConnection o) {
            if (this.index > o.index) {
                return 1;
            }
            if (this.index < o.index) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "replicaURL=" + this.replicaURL + " index=" + this.index + " usable=" + this.usable + " connection=" + String.valueOf(this.conn);
        }
    }
}

