/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.X_C_RfQResponseLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class MRfQResponseLine
extends X_C_RfQResponseLine {
    private static final long serialVersionUID = 3388579962604552288L;
    private MRfQLine m_rfqLine = null;
    private MRfQResponseLineQty[] m_qtys = null;

    public MRfQResponseLine(Properties ctx, String C_RfQResponseLine_UU, String trxName) {
        super(ctx, C_RfQResponseLine_UU, trxName);
    }

    public MRfQResponseLine(Properties ctx, int C_RfQResponseLine_ID, String trxName) {
        super(ctx, C_RfQResponseLine_ID, trxName);
    }

    public MRfQResponseLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQResponseLine(MRfQResponse response, MRfQLine line) {
        super(response.getCtx(), 0, response.get_TrxName());
        this.setClientOrg(response);
        this.setC_RfQResponse_ID(response.getC_RfQResponse_ID());
        this.setC_RfQLine_ID(line.getC_RfQLine_ID());
        this.setIsSelectedWinner(false);
        this.setIsSelfService(false);
        MRfQLineQty[] qtys = line.getQtys();
        int i = 0;
        while (i < qtys.length) {
            if (qtys[i].isActive() && qtys[i].isRfQQty()) {
                if (this.get_ID() == 0) {
                    this.saveEx();
                }
                MRfQResponseLineQty qty = new MRfQResponseLineQty(this, qtys[i]);
                qty.saveEx();
            }
            ++i;
        }
    }

    public MRfQResponseLineQty[] getQtys() {
        return this.getQtys(false);
    }

    public MRfQResponseLineQty[] getQtys(boolean requery) {
        ArrayList<MRfQResponseLineQty> list;
        block7: {
            if (this.m_qtys != null && !requery) {
                return this.m_qtys;
            }
            list = new ArrayList<MRfQResponseLineQty>();
            String sql = "SELECT * FROM C_RfQResponseLineQty WHERE C_RfQResponseLine_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_RfQResponseLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRfQResponseLineQty(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_qtys = new MRfQResponseLineQty[list.size()];
        list.toArray(this.m_qtys);
        return this.m_qtys;
    }

    public MRfQLine getRfQLine() {
        if (this.m_rfqLine == null) {
            this.m_rfqLine = MRfQLine.get(this.getCtx(), this.getC_RfQLine_ID(), this.get_TrxName());
        }
        return this.m_rfqLine;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRfQResponseLine[");
        sb.append(this.get_ID()).append(",Winner=").append(this.isSelectedWinner()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays(this.getDateWorkStart(), this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween(this.getDateWorkStart(), this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays(this.getDateWorkComplete(), this.getDeliveryDays() * -1));
        }
        if (!this.isActive()) {
            this.setIsSelectedWinner(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!this.isActive()) {
            this.getQtys(false);
            int i = 0;
            while (i < this.m_qtys.length) {
                MRfQResponseLineQty qty = this.m_qtys[i];
                if (qty.isActive()) {
                    qty.setIsActive(false);
                    qty.saveEx();
                }
                ++i;
            }
        }
        return success;
    }
}

