/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.X_M_DiscountSchema;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MDiscountSchema
extends X_M_DiscountSchema
implements ImmutablePOSupport {
    private static final long serialVersionUID = 4916780751688051566L;
    private static ImmutableIntPOCache<Integer, MDiscountSchema> s_cache = new ImmutableIntPOCache("M_DiscountSchema", 20);
    private MDiscountSchemaBreak[] m_breaks = null;
    private MDiscountSchemaLine[] m_lines = null;

    public static MDiscountSchema get(int M_DiscountSchema_ID) {
        return MDiscountSchema.get(Env.getCtx(), M_DiscountSchema_ID);
    }

    public static MDiscountSchema get(Properties ctx, int M_DiscountSchema_ID) {
        Integer key = M_DiscountSchema_ID;
        MDiscountSchema retValue = s_cache.get(ctx, key, e -> new MDiscountSchema(ctx, (MDiscountSchema)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDiscountSchema(ctx, M_DiscountSchema_ID, null);
        if (retValue.get_ID() == M_DiscountSchema_ID) {
            s_cache.put(key, retValue, e -> new MDiscountSchema(Env.getCtx(), (MDiscountSchema)e));
            return retValue;
        }
        return null;
    }

    public MDiscountSchema(Properties ctx, String M_DiscountSchema_UU, String trxName) {
        super(ctx, M_DiscountSchema_UU, trxName);
        if (Util.isEmpty(M_DiscountSchema_UU)) {
            this.setInitialDefaults();
        }
    }

    public MDiscountSchema(Properties ctx, int M_DiscountSchema_ID, String trxName) {
        super(ctx, M_DiscountSchema_ID, trxName);
        if (M_DiscountSchema_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDiscountType("F");
        this.setFlatDiscount(Env.ZERO);
        this.setIsBPartnerFlatDiscount(false);
        this.setIsQuantityBased(true);
        this.setCumulativeLevel("L");
    }

    public MDiscountSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDiscountSchema(MDiscountSchema copy) {
        this(Env.getCtx(), copy);
    }

    public MDiscountSchema(Properties ctx, MDiscountSchema copy) {
        this(ctx, copy, null);
    }

    public MDiscountSchema(Properties ctx, MDiscountSchema copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_breaks = copy.m_breaks != null ? (MDiscountSchemaBreak[])Arrays.stream(copy.m_breaks).map(e -> new MDiscountSchemaBreak(ctx, (MDiscountSchemaBreak)e, trxName)).toArray(MDiscountSchemaBreak[]::new) : null;
        this.m_lines = copy.m_lines != null ? (MDiscountSchemaLine[])Arrays.stream(copy.m_lines).map(e -> new MDiscountSchemaLine(ctx, (MDiscountSchemaLine)e, trxName)).toArray(MDiscountSchemaLine[]::new) : null;
    }

    public MDiscountSchemaBreak[] getBreaks(boolean reload) {
        ArrayList<MDiscountSchemaBreak> list;
        block8: {
            if (this.m_breaks != null && !reload) {
                return this.m_breaks;
            }
            String sql = "SELECT * FROM M_DiscountSchemaBreak WHERE M_DiscountSchema_ID=? ORDER BY SeqNo";
            list = new ArrayList<MDiscountSchemaBreak>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_DiscountSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MDiscountSchemaBreak dsb = new MDiscountSchemaBreak(this.getCtx(), rs, this.get_TrxName());
                        if (this.is_Immutable()) {
                            dsb.markImmutable();
                        }
                        list.add(dsb);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_breaks = new MDiscountSchemaBreak[list.size()];
        list.toArray(this.m_breaks);
        return this.m_breaks;
    }

    public MDiscountSchemaLine[] getLines(boolean reload) {
        ArrayList<MDiscountSchemaLine> list;
        block8: {
            if (this.m_lines != null && !reload) {
                MDiscountSchema.set_TrxName(this.m_lines, this.get_TrxName());
                return this.m_lines;
            }
            String sql = "SELECT * FROM M_DiscountSchemaLine WHERE M_DiscountSchema_ID=? ORDER BY SeqNo,M_DiscountSchemaLine_ID";
            list = new ArrayList<MDiscountSchemaLine>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_DiscountSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MDiscountSchemaLine dsl = new MDiscountSchemaLine(this.getCtx(), rs, this.get_TrxName());
                        if (this.is_Immutable()) {
                            dsl.markImmutable();
                        }
                        list.add(dsl);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MDiscountSchemaLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public BigDecimal calculatePrice(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Price=" + String.valueOf(Price) + ",Qty=" + String.valueOf(Qty));
        }
        if (Price == null || Env.ZERO.compareTo(Price) == 0) {
            return Price;
        }
        BigDecimal discount = this.calculateDiscount(Qty, Price, M_Product_ID, M_Product_Category_ID, BPartnerFlatDiscount);
        if (discount == null || discount.signum() == 0) {
            BigDecimal fixedPrice = this.calculateFixedPrice(Qty, Price, M_Product_ID, M_Product_Category_ID);
            if (fixedPrice != null) {
                return fixedPrice;
            }
            return Price;
        }
        BigDecimal newPrice = MDiscountSchema.calculateDiscountedPrice(Price, discount);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("=>" + String.valueOf(newPrice));
        }
        return newPrice;
    }

    public static BigDecimal calculateDiscountedPrice(BigDecimal price, BigDecimal discount) {
        BigDecimal onehundred = Env.ONEHUNDRED;
        BigDecimal multiplier = onehundred.subtract(discount);
        multiplier = multiplier.divide(onehundred, 6, RoundingMode.HALF_UP);
        BigDecimal newPrice = price.multiply(multiplier);
        return newPrice;
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal calculateDiscount(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        if (BPartnerFlatDiscount == null) {
            BPartnerFlatDiscount = Env.ZERO;
        }
        if ("F".equals(this.getDiscountType())) {
            if (this.isBPartnerFlatDiscount()) {
                return BPartnerFlatDiscount;
            }
            return this.getFlatDiscount();
        }
        if ("S".equals(this.getDiscountType()) || "P".equals(this.getDiscountType())) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Not supported (yet) DiscountType=" + this.getDiscountType());
            }
            return Env.ZERO;
        }
        this.getBreaks(false);
        Amt = Price.multiply(Qty);
        if (this.isQuantityBased()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Qty=" + String.valueOf(Qty) + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
            }
        } else if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Amt=" + String.valueOf(Amt) + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
        }
        i = 0;
        while (i < this.m_breaks.length) {
            block17: {
                block18: {
                    block19: {
                        br = this.m_breaks[i];
                        if (!br.isActive()) break block17;
                        if (!this.isQuantityBased()) break block18;
                        if (br.applies(Qty, M_Product_ID, M_Product_Category_ID)) break block19;
                        if (this.log.isLoggable(Level.FINER)) {
                            this.log.finer("No: " + String.valueOf(br));
                        }
                        break block17;
                    }
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Yes: " + String.valueOf(br));
                    }
                    ** GOTO lbl40
                }
                if (!br.applies(Amt, M_Product_ID, M_Product_Category_ID)) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("No: " + String.valueOf(br));
                    }
                } else {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Yes: " + String.valueOf(br));
                    }
lbl40:
                    // 4 sources

                    discount = null;
                    discount = br.isBPartnerFlatDiscount() != false ? BPartnerFlatDiscount : br.getBreakDiscount();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Discount=>" + String.valueOf(discount));
                    }
                    return discount;
                }
            }
            ++i;
        }
        return Env.ZERO;
    }

    private BigDecimal calculateFixedPrice(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID) {
        if ("F".equals(this.getDiscountType()) || "S".equals(this.getDiscountType()) || "P".equals(this.getDiscountType())) {
            return null;
        }
        this.getBreaks(false);
        BigDecimal Amt = Price.multiply(Qty);
        int i = 0;
        while (i < this.m_breaks.length) {
            MDiscountSchemaBreak br = this.m_breaks[i];
            if (br.isActive() && !(!this.isQuantityBased() ? !br.applies(Amt, M_Product_ID, M_Product_Category_ID) : !br.applies(Qty, M_Product_ID, M_Product_Category_ID))) {
                if (!br.isBPartnerFlatDiscount() && br.getFixedPrice() != null && br.getFixedPrice().signum() > 0) {
                    return br.getFixedPrice();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        return true;
    }

    public int reSeq() {
        int count = 0;
        MDiscountSchemaLine[] lines = this.getLines(true);
        int i = 0;
        while (i < lines.length) {
            int line = (i + 1) * 10;
            if (line != lines[i].getSeqNo()) {
                lines[i].setSeqNo(line);
                if (lines[i].save()) {
                    ++count;
                }
            }
            ++i;
        }
        this.m_lines = null;
        MDiscountSchemaBreak[] breaks = this.getBreaks(true);
        int i2 = 0;
        while (i2 < breaks.length) {
            int line = (i2 + 1) * 10;
            if (line != breaks[i2].getSeqNo()) {
                breaks[i2].setSeqNo(line);
                if (breaks[i2].save()) {
                    ++count;
                }
            }
            ++i2;
        }
        this.m_breaks = null;
        return count;
    }

    @Override
    public MDiscountSchema markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_lines != null) {
            Arrays.stream(this.m_lines).forEach(e -> e.markImmutable());
        }
        if (this.m_breaks != null) {
            Arrays.stream(this.m_breaks).forEach(e -> e.markImmutable());
        }
        return this;
    }
}

