/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.awt.Color;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ExtendedColor
extends Color {
    private static final long serialVersionUID = 2722660170712380080L;
    public static final int TYPE_RGB = 0;
    public static final int TYPE_GRAY = 1;
    public static final int TYPE_CMYK = 2;
    public static final int TYPE_SEPARATION = 3;
    public static final int TYPE_PATTERN = 4;
    public static final int TYPE_SHADING = 5;
    public static final int MAX_COLOR_VALUE = 255;
    public static final float MAX_INT_COLOR_VALUE = 255.0f;
    public static final float MAX_FLOAT_COLOR_VALUE = 1.0f;
    protected int type;

    public ExtendedColor(int type) {
        super(0, 0, 0);
        this.type = type;
    }

    public ExtendedColor(int type, float red, float green, float blue) {
        this(type, ExtendedColor.normalize(red), ExtendedColor.normalize(green), ExtendedColor.normalize(blue), 1.0f);
    }

    public ExtendedColor(int type, float red, float green, float blue, float alpha) {
        super(ExtendedColor.normalize(red), ExtendedColor.normalize(green), ExtendedColor.normalize(blue), ExtendedColor.normalize(alpha));
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static int getType(Color color) {
        if (color instanceof ExtendedColor) {
            return ((ExtendedColor)color).getType();
        }
        return 0;
    }

    static final float normalize(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    static final int normalize(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }
}

