/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IReservationTracer;
import org.adempiere.util.IReservationTracerFactory;
import org.compiere.model.MBPGroup;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MatchPOAutoMatch;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_M_InOutLine;
import org.compiere.model.X_M_MatchPO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class MMatchPO
extends X_M_MatchPO {
    private static final long serialVersionUID = 487498668807522050L;
    protected MMatchInv m_matchInv;
    private static CLogger s_log = CLogger.getCLogger(MMatchPO.class);
    protected boolean m_isInvoiceLineChange = false;
    protected boolean m_isInOutLineChange = false;
    protected MOrderLine m_oLine = null;
    protected MInvoiceLine m_iLine = null;

    public static MMatchPO[] get(Properties ctx, int C_OrderLine_ID, int C_InvoiceLine_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_OrderLine_ID == 0 || C_InvoiceLine_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=? AND C_InvoiceLine_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_OrderLine_ID);
                    pstmt.setInt(2, C_InvoiceLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] get(Properties ctx, int M_InOutLine_ID, String trxName) {
        if (M_InOutLine_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE M_InOutLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, M_InOutLine_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MMatchPO(ctx, rs, trxName));
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (M_InOut_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO m INNER JOIN M_InOutLine l ON (m.M_InOutLine_ID=l.M_InOutLine_ID) WHERE l.M_InOut_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_Invoice_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO mi INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) WHERE il.C_Invoice_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_OrderLine_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_OrderLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO create(MInvoiceLine iLine, MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        String trxName = null;
        Properties ctx = null;
        int C_OrderLine_ID = 0;
        if (iLine != null) {
            trxName = iLine.get_TrxName();
            ctx = iLine.getCtx();
            C_OrderLine_ID = iLine.getC_OrderLine_ID();
        }
        if (sLine != null) {
            trxName = sLine.get_TrxName();
            ctx = sLine.getCtx();
            C_OrderLine_ID = sLine.getC_OrderLine_ID();
        }
        if (C_OrderLine_ID > 0) {
            return MMatchPO.create(ctx, iLine, sLine, C_OrderLine_ID, dateTrx, qty, trxName);
        }
        if (sLine != null && iLine != null) {
            MMatchPO[] matchpos;
            MMatchPO[] mMatchPOArray = matchpos = MMatchPO.get(ctx, sLine.getM_InOutLine_ID(), trxName);
            int n = matchpos.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchPO matchpo = mMatchPOArray[n2];
                C_OrderLine_ID = matchpo.getC_OrderLine_ID();
                MOrderLine orderLine = new MOrderLine(ctx, C_OrderLine_ID, trxName);
                BigDecimal toInvoice = orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced());
                if (toInvoice.signum() > 0) {
                    BigDecimal matchQty = qty;
                    if (matchQty.compareTo(toInvoice) > 0) {
                        matchQty = toInvoice;
                    }
                    if (matchQty.signum() > 0) {
                        MMatchPO newMatchPO = MMatchPO.create(ctx, iLine, sLine, C_OrderLine_ID, dateTrx, matchQty, trxName);
                        if (!newMatchPO.save()) {
                            Object msg = "Failed to update match po.";
                            ValueNamePair error = CLogger.retrieveError();
                            if (error != null) {
                                msg = (String)msg + " " + error.getName();
                            }
                            throw new RuntimeException((String)msg);
                        }
                        if ((qty = qty.subtract(matchQty)).signum() <= 0) {
                            return newMatchPO;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected static MMatchPO create(Properties ctx, MInvoiceLine iLine, MInOutLine sLine, int C_OrderLine_ID, Timestamp dateTrx, BigDecimal qty, String trxName) {
        Object matchInv;
        int cnt;
        int tmpInOutLineId2;
        MMatchPO retValue = null;
        List<MMatchPO> matchPOList = MatchPOAutoMatch.getNotMatchedMatchPOList(ctx, C_OrderLine_ID, trxName);
        if (!matchPOList.isEmpty()) {
            for (MMatchPO mpo : matchPOList) {
                int cnt2;
                if (qty.compareTo(mpo.getQty()) < 0) continue;
                BigDecimal toMatch = qty;
                BigDecimal matchQty = mpo.getQty();
                if (toMatch.compareTo(matchQty) > 0) {
                    toMatch = matchQty;
                }
                if (iLine != null) {
                    if (mpo.getC_InvoiceLine_ID() != 0 && mpo.getC_InvoiceLine_ID() != iLine.getC_InvoiceLine_ID()) continue;
                    if (iLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) continue;
                    }
                }
                if (sLine != null) {
                    if (mpo.getM_InOutLine_ID() != 0 && mpo.getM_InOutLine_ID() != sLine.getM_InOutLine_ID()) continue;
                    if (sLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != sLine.getM_AttributeSetInstance_ID()) continue;
                    }
                    if (iLine == null && mpo.isPosted()) continue;
                }
                if (iLine != null && sLine == null && mpo.getC_InvoiceLine_ID() == 0 && (cnt2 = DB.getSQLValue(iLine.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + mpo.getM_InOutLine_ID() + " AND C_InvoiceLine_ID != " + iLine.getC_InvoiceLine_ID() + " AND Reversal_ID=0")) > 0) continue;
                if (!(iLine == null && mpo.getC_InvoiceLine_ID() <= 0 || sLine == null && mpo.getM_InOutLine_ID() <= 0)) {
                    int M_InOutLine_ID = sLine != null ? sLine.getM_InOutLine_ID() : mpo.getM_InOutLine_ID();
                    int C_InvoiceLine_ID = iLine != null ? iLine.getC_InvoiceLine_ID() : mpo.getC_InvoiceLine_ID();
                    tmpInOutLineId2 = DB.getSQLValue(mpo.get_TrxName(), "SELECT M_InOutLine_ID FROM C_InvoiceLine WHERE C_InvoiceLine_ID=" + C_InvoiceLine_ID);
                    if (tmpInOutLineId2 > 0 && tmpInOutLineId2 != M_InOutLine_ID) continue;
                    cnt = DB.getSQLValue(mpo.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + M_InOutLine_ID + " AND C_InvoiceLine_ID=" + C_InvoiceLine_ID);
                    if (cnt <= 0) {
                        matchInv = MMatchPO.createMatchInv(mpo, C_InvoiceLine_ID, M_InOutLine_ID, mpo.getQty(), dateTrx, trxName);
                        if (matchInv == null) continue;
                        mpo.setMatchInvCreated((MMatchInv)matchInv);
                    }
                }
                if (iLine != null) {
                    mpo.setC_InvoiceLine_ID(iLine);
                }
                if (sLine != null) {
                    mpo.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                    if (!mpo.isPosted()) {
                        mpo.setDateAcct(sLine.getParent().getDateAcct());
                    }
                }
                if (!mpo.save()) {
                    Object msg = "Failed to update match po.";
                    ValueNamePair error = CLogger.retrieveError();
                    if (error != null) {
                        msg = (String)msg + " " + error.getName();
                    }
                    throw new RuntimeException((String)msg);
                }
                if ((qty = qty.subtract(toMatch)).signum() > 0) continue;
                retValue = mpo;
                break;
            }
        }
        if (retValue == null) {
            BigDecimal sLineMatchedQty = null;
            if (sLine != null && iLine != null) {
                sLineMatchedQty = DB.getSQLValueBD(sLine.get_TrxName(), "SELECT Sum(Qty) FROM M_MatchPO WHERE C_OrderLine_ID=" + C_OrderLine_ID + " AND M_InOutLine_ID=?", sLine.getM_InOutLine_ID());
            }
            if (!(sLine == null || sLine.getC_OrderLine_ID() != C_OrderLine_ID && iLine != null || sLineMatchedQty != null && sLineMatchedQty.signum() > 0)) {
                if (qty.signum() != 0) {
                    retValue = new MMatchPO(sLine, dateTrx, qty);
                    retValue.setC_OrderLine_ID(C_OrderLine_ID);
                    X_M_MatchPO otherMatchPO = null;
                    if (iLine == null) {
                        MMatchPO[] matchPOs;
                        MMatchPO[] tmpInOutLineId2 = matchPOs = MMatchPO.getOrderLine(retValue.getCtx(), sLine.getC_OrderLine_ID(), retValue.get_TrxName());
                        int error = matchPOs.length;
                        int msg = 0;
                        while (msg < error) {
                            MMatchPO matchPO = tmpInOutLineId2[msg];
                            if (matchPO.getC_InvoiceLine_ID() > 0 && matchPO.getM_InOutLine_ID() == 0 && matchPO.getReversal_ID() == 0 && matchPO.getQty().compareTo(retValue.getQty()) >= 0 && (cnt = DB.getSQLValueEx(sLine.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + sLine.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + matchPO.getC_InvoiceLine_ID() + " AND Qty != ?", retValue.getQty())) <= 0 && !matchPO.isPosted() && matchPO.getQty().compareTo(retValue.getQty()) >= 0) {
                                otherMatchPO = matchPO;
                                iLine = new MInvoiceLine(retValue.getCtx(), matchPO.getC_InvoiceLine_ID(), retValue.get_TrxName());
                                matchPO.setQty(matchPO.getQty().subtract(retValue.getQty()));
                                matchPO.saveEx();
                                break;
                            }
                            ++msg;
                        }
                    }
                    if (iLine != null) {
                        if (otherMatchPO == null) {
                            retValue.setC_InvoiceLine_ID(iLine);
                        }
                        if (otherMatchPO != null) {
                            int cnt3 = DB.getSQLValue(retValue.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + retValue.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + otherMatchPO.getC_InvoiceLine_ID());
                            if (cnt3 <= 0) {
                                MMatchInv matchInv2 = MMatchPO.createMatchInv(retValue, otherMatchPO.getC_InvoiceLine_ID(), retValue.getM_InOutLine_ID(), retValue.getQty(), dateTrx, trxName);
                                if (matchInv2 == null) {
                                    Object msg = "Failed to create match inv.";
                                    ValueNamePair error = CLogger.retrieveError();
                                    if (error != null) {
                                        msg = (String)msg + " " + error.getName();
                                    }
                                    throw new RuntimeException((String)msg);
                                }
                                retValue.setMatchInvCreated(matchInv2);
                            }
                            if (otherMatchPO.getQty().signum() == 0) {
                                otherMatchPO.deleteEx(true);
                            }
                        }
                    }
                    if (!retValue.save()) {
                        Object msg = "Failed to update match po.";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = (String)msg + " " + error.getName();
                        }
                        throw new RuntimeException((String)msg);
                    }
                }
            } else if (iLine != null && qty.signum() != 0) {
                MMatchPO[] matchPOs;
                retValue = new MMatchPO(iLine, dateTrx, qty);
                retValue.setC_OrderLine_ID(C_OrderLine_ID);
                if (!retValue.save()) {
                    Object msg = "Failed to update match po.";
                    ValueNamePair error = CLogger.retrieveError();
                    if (error != null) {
                        msg = (String)msg + " " + error.getName();
                    }
                    throw new RuntimeException((String)msg);
                }
                HashMap<Integer, BigDecimal[]> noInvoiceLines = new HashMap<Integer, BigDecimal[]>();
                HashMap<Integer, ArrayList<MMatchPO>> invoiceMatched = new HashMap<Integer, ArrayList<MMatchPO>>();
                ArrayList<MMatchPO> noInvoiceList = new ArrayList<MMatchPO>();
                matchInv = matchPOs = MMatchPO.getOrderLine(iLine.getCtx(), C_OrderLine_ID, iLine.get_TrxName());
                cnt = matchPOs.length;
                tmpInOutLineId2 = 0;
                while (tmpInOutLineId2 < cnt) {
                    MMatchPO matchPO = matchInv[tmpInOutLineId2];
                    if (matchPO.getM_MatchPO_ID() != retValue.getM_MatchPO_ID() && matchPO.getM_InOutLine_ID() > 0 && matchPO.getReversal_ID() == 0 && matchPO.getRef_MatchPO_ID() == 0) {
                        if (matchPO.getC_InvoiceLine_ID() == 0) {
                            String docStatus = matchPO.getM_InOutLine().getM_InOut().getDocStatus();
                            if (docStatus.equals("CO") || docStatus.equals("CL")) {
                                noInvoiceLines.put(matchPO.getM_MatchPO_ID(), new BigDecimal[]{matchPO.getQty()});
                                noInvoiceList.add(matchPO);
                            }
                        } else {
                            ArrayList<MMatchPO> invoices = (ArrayList<MMatchPO>)invoiceMatched.get(matchPO.getM_InOutLine_ID());
                            if (invoices == null) {
                                invoices = new ArrayList<MMatchPO>();
                                invoiceMatched.put(matchPO.getM_InOutLine_ID(), invoices);
                            }
                            invoices.add(matchPO);
                        }
                    }
                    ++tmpInOutLineId2;
                }
                Collections.sort(noInvoiceList, new Comparator<MMatchPO>(){

                    @Override
                    public int compare(MMatchPO arg0, MMatchPO arg1) {
                        return arg0.getM_MatchPO_ID() > arg1.getM_MatchPO_ID() ? 1 : (arg0.getM_MatchPO_ID() == arg1.getM_MatchPO_ID() ? 0 : -1);
                    }
                });
                for (MMatchPO matchPO : noInvoiceList) {
                    MMatchInv[] matchInvoices;
                    BigDecimal[] qtyHolder = (BigDecimal[])noInvoiceLines.get(matchPO.getM_MatchPO_ID());
                    List matchedInvoices = (List)invoiceMatched.get(matchPO.getM_InOutLine_ID());
                    MMatchInv[] mMatchInvArray = matchInvoices = MMatchInv.getInOutLine(iLine.getCtx(), matchPO.getM_InOutLine_ID(), iLine.get_TrxName());
                    int n = matchInvoices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MMatchInv matchInv3 = mMatchInvArray[n2];
                        if (matchInv3.getReversal_ID() <= 0) {
                            String docStatus;
                            BigDecimal balance;
                            BigDecimal alreadyMatch = BigDecimal.ZERO;
                            if (matchedInvoices != null) {
                                for (MMatchPO matchedInvoice : matchedInvoices) {
                                    if (matchedInvoice.getC_InvoiceLine_ID() != matchInv3.getC_InvoiceLine_ID()) continue;
                                    alreadyMatch = alreadyMatch.add(matchedInvoice.getQty());
                                }
                            }
                            if ((balance = matchInv3.getQty().subtract(alreadyMatch)).signum() > 0 && ((docStatus = matchInv3.getC_InvoiceLine().getC_Invoice().getDocStatus()).equals("CO") || docStatus.equals("CL"))) {
                                qtyHolder[0] = qtyHolder[0].subtract(balance);
                            }
                        }
                        ++n2;
                    }
                }
                BigDecimal toMatch = retValue.getQty();
                for (MMatchPO matchPO : noInvoiceList) {
                    BigDecimal[] qtyHolder = (BigDecimal[])noInvoiceLines.get(matchPO.getM_MatchPO_ID());
                    if (qtyHolder[0].signum() > 0) {
                        MMatchInv[] matchInvoices;
                        BigDecimal autoMatchQty = null;
                        if (qtyHolder[0].compareTo(toMatch) >= 0) {
                            autoMatchQty = toMatch;
                            toMatch = BigDecimal.ZERO;
                        } else {
                            autoMatchQty = qtyHolder[0];
                            toMatch = toMatch.subtract(autoMatchQty);
                        }
                        if (autoMatchQty != null && autoMatchQty.signum() > 0 && ((matchInvoices = MMatchInv.get(Env.getCtx(), matchPO.getM_InOutLine_ID(), retValue.getC_InvoiceLine_ID(), trxName)) == null || matchInvoices.length == 0)) {
                            MMatchInv matchInv4 = MMatchPO.createMatchInv(retValue, retValue.getC_InvoiceLine_ID(), matchPO.getM_InOutLine_ID(), autoMatchQty, dateTrx, trxName);
                            retValue.setMatchInvCreated(matchInv4);
                            if (matchInv4 == null) break;
                        }
                    }
                    if (toMatch.signum() <= 0) break;
                }
            }
        }
        if (C_OrderLine_ID > 0 && retValue != null) {
            MatchPOAutoMatch.match(ctx, C_OrderLine_ID, retValue, trxName);
        }
        return retValue;
    }

    protected static MMatchInv createMatchInv(MMatchPO mpo, int C_InvoiceLine_ID, int M_InOutLine_ID, BigDecimal qty, Timestamp dateTrx, String trxName) {
        MMatchInv matchInv;
        block18: {
            Savepoint savepoint = null;
            Trx trx = null;
            matchInv = null;
            try {
                try {
                    trx = trxName != null ? Trx.get(trxName, false) : null;
                    savepoint = trx != null ? trx.getConnection().setSavepoint() : null;
                    matchInv = new MMatchInv(mpo.getCtx(), 0, mpo.get_TrxName());
                    matchInv.setC_InvoiceLine_ID(C_InvoiceLine_ID);
                    matchInv.setM_Product_ID(mpo.getM_Product_ID());
                    matchInv.setM_InOutLine_ID(M_InOutLine_ID);
                    matchInv.setAD_Client_ID(mpo.getAD_Client_ID());
                    matchInv.setAD_Org_ID(mpo.getAD_Org_ID());
                    matchInv.setM_AttributeSetInstance_ID(mpo.getM_AttributeSetInstance_ID());
                    matchInv.setQty(qty);
                    matchInv.setDateTrx(dateTrx);
                    matchInv.setProcessed(true);
                    if (!matchInv.save()) {
                        if (savepoint != null) {
                            trx.getConnection().rollback(savepoint);
                            savepoint = null;
                        } else {
                            matchInv.delete(true);
                        }
                        Object msg = "Failed to auto match invoice.";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = (String)msg + " " + error.getName();
                        }
                        s_log.severe((String)msg);
                        matchInv = null;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "Failed to auto match Invoice.", e);
                    matchInv = null;
                    if (savepoint != null) {
                        try {
                            trx.getConnection().releaseSavepoint(savepoint);
                        }
                        catch (Exception exception) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (savepoint != null) {
                    try {
                        trx.getConnection().releaseSavepoint(savepoint);
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (savepoint != null) {
                try {
                    trx.getConnection().releaseSavepoint(savepoint);
                }
                catch (Exception exception) {}
            }
        }
        return matchInv;
    }

    protected void setMatchInvCreated(MMatchInv matchInv) {
        this.m_matchInv = matchInv;
    }

    public MMatchInv getMatchInvCreated() {
        MMatchInv tmp = this.m_matchInv;
        this.m_matchInv = null;
        return tmp;
    }

    public MMatchPO(Properties ctx, String M_MatchPO_UU, String trxName) {
        super(ctx, M_MatchPO_UU, trxName);
        if (Util.isEmpty(M_MatchPO_UU)) {
            this.setInitialDefaults();
        }
    }

    public MMatchPO(Properties ctx, int M_MatchPO_ID, String trxName) {
        super(ctx, M_MatchPO_ID, trxName);
        if (M_MatchPO_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setM_AttributeSetInstance_ID(0);
        this.setPosted(false);
        this.setProcessed(false);
        this.setProcessing(false);
    }

    public MMatchPO(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchPO(MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        this(sLine.getCtx(), 0, sLine.get_TrxName());
        this.setClientOrg(sLine);
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(sLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public MMatchPO(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine);
        if (iLine.getC_OrderLine_ID() != 0) {
            this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        }
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public void setC_InvoiceLine_ID(MInvoiceLine line) {
        this.m_iLine = line;
        if (line == null) {
            this.setC_InvoiceLine_ID(0);
        } else {
            this.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        }
    }

    @Override
    public void setC_InvoiceLine_ID(int C_InvoiceLine_ID) {
        int old = this.getC_InvoiceLine_ID();
        if (old != C_InvoiceLine_ID) {
            super.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            this.m_isInvoiceLineChange = true;
        }
    }

    public MInvoiceLine getInvoiceLine() {
        if (this.m_iLine == null && this.getC_InvoiceLine_ID() != 0) {
            this.m_iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        }
        return this.m_iLine;
    }

    @Override
    public void setM_InOutLine_ID(int M_InOutLine_ID) {
        int old = this.getM_InOutLine_ID();
        if (old != M_InOutLine_ID) {
            super.setM_InOutLine_ID(M_InOutLine_ID);
            this.m_isInOutLineChange = true;
        }
    }

    public void setC_OrderLine_ID(MOrderLine line) {
        this.m_oLine = line;
        if (line == null) {
            this.setC_OrderLine_ID(0);
        } else {
            this.setC_OrderLine_ID(line.getC_OrderLine_ID());
        }
    }

    public MOrderLine getOrderLine() {
        if (this.m_oLine == null && this.getC_OrderLine_ID() != 0 || this.getC_OrderLine_ID() != this.m_oLine.getC_OrderLine_ID()) {
            this.m_oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        }
        return this.m_oLine;
    }

    public BigDecimal getInvoicePriceActual() {
        int orderCurrency_ID;
        MInvoiceLine iLine = this.getInvoiceLine();
        MInvoice invoice = iLine.getParent();
        MOrder order = this.getOrderLine().getParent();
        BigDecimal priceActual = iLine.getPriceActual();
        int invoiceCurrency_ID = invoice.getC_Currency_ID();
        if (invoiceCurrency_ID != (orderCurrency_ID = order.getC_Currency_ID()) && (priceActual = MConversionRate.convert(this.getCtx(), priceActual, invoiceCurrency_ID, orderCurrency_ID, invoice.getDateInvoiced(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID())) == null) {
            throw new AdempiereException(MConversionRateUtil.getErrorMessage(this.getCtx(), "ErrorConvertingCurrencyToBaseCurrency", invoiceCurrency_ID, orderCurrency_ID, invoice.getC_ConversionType_ID(), invoice.getDateInvoiced(), this.get_TrxName()));
        }
        return priceActual;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        if (newRecord && this.getC_InvoiceLine_ID() == 0 && this.getReversal_ID() == 0) {
            MMatchInv[] mpi = MMatchInv.getInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            int i = 0;
            while (i < mpi.length) {
                int cnt;
                if (mpi[i].getC_InvoiceLine_ID() != 0 && mpi[i].getM_AttributeSetInstance_ID() == this.getM_AttributeSetInstance_ID() && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT Count(*) FROM M_MatchPO WHERE M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + mpi[i].getC_InvoiceLine_ID())) <= 0) {
                    if (mpi[i].getQty().compareTo(this.getQty()) == 0) {
                        this.setC_InvoiceLine_ID(mpi[i].getC_InvoiceLine_ID());
                        break;
                    }
                    MInvoiceLine il = new MInvoiceLine(this.getCtx(), mpi[i].getC_InvoiceLine_ID(), this.get_TrxName());
                    MMatchPO match = new MMatchPO(il, this.getDateTrx(), mpi[i].getQty());
                    match.setC_OrderLine_ID(this.getC_OrderLine_ID());
                    if (!match.save()) {
                        Object msg = "Failed to create match po";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = (String)msg + " " + error.getName();
                        }
                        throw new RuntimeException((String)msg);
                    }
                }
                ++i;
            }
        }
        if (this.getC_OrderLine_ID() == 0) {
            MInOutLine iol;
            MInvoiceLine il = null;
            if (this.getC_InvoiceLine_ID() != 0 && (il = this.getInvoiceLine()).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(il.getC_OrderLine_ID());
            }
            if (this.getC_OrderLine_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                if (il != null) {
                    il.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                    il.saveEx();
                }
            }
        }
        if (this.getC_OrderLine_ID() != 0 && this.getC_InvoiceLine_ID() != 0 && (newRecord || this.is_ValueChanged("C_OrderLine_ID") || this.is_ValueChanged("C_InvoiceLine_ID"))) {
            int cnt;
            BigDecimal invPrice;
            BigDecimal poPrice = this.getOrderLine().getPriceActual();
            BigDecimal difference = poPrice.subtract(invPrice = this.getInvoicePriceActual());
            if (difference.signum() != 0) {
                difference = difference.multiply(this.getQty());
                this.setPriceMatchDifference(difference);
                MBPGroup group = MBPGroup.getOfBPartner(this.getCtx(), this.getOrderLine().getC_BPartner_ID());
                BigDecimal mt = group.getPriceMatchTolerance();
                if (mt != null && mt.signum() != 0) {
                    boolean ok;
                    BigDecimal poAmt = poPrice.multiply(this.getQty());
                    BigDecimal maxTolerance = poAmt.multiply(mt);
                    maxTolerance = maxTolerance.abs().divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
                    boolean bl = ok = (difference = difference.abs()).compareTo(maxTolerance) <= 0;
                    if (this.log.isLoggable(Level.CONFIG)) {
                        this.log.config("Difference=" + String.valueOf(this.getPriceMatchDifference()) + ", Max=" + String.valueOf(maxTolerance) + " => " + ok);
                    }
                    this.setIsApproved(ok);
                }
            } else {
                this.setPriceMatchDifference(difference);
                this.setIsApproved(true);
            }
            if (this.getM_InOutLine_ID() > 0 && this.getC_InvoiceLine_ID() > 0 && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + this.getC_InvoiceLine_ID())) <= 0) {
                MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
                MInOutLine inoutLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                throw new IllegalStateException("[MatchPO] Missing corresponding invoice matching record for invoice line " + String.valueOf(invoiceLine) + " and receipt line " + String.valueOf(inoutLine));
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            boolean validateOrderedQty;
            BigDecimal matchedQty;
            PO line;
            if (this.getM_InOutLine_ID() > 0) {
                line = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE M_InOutLine_ID=?", this.getM_InOutLine_ID());
                if (((X_M_InOutLine)line).getMovementQty().signum() > 0 && matchedQty != null && matchedQty.compareTo(((X_M_InOutLine)line).getMovementQty()) > 0) {
                    throw new IllegalStateException("Total matched qty > movement qty. MatchedQty=" + String.valueOf(matchedQty) + ", MovementQty=" + String.valueOf(((X_M_InOutLine)line).getMovementQty()) + ", Line=" + String.valueOf(line));
                }
            }
            if (this.getC_InvoiceLine_ID() > 0) {
                line = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
                matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID=?  AND Reversal_ID IS NULL ", this.getC_InvoiceLine_ID());
                if (matchedQty != null && matchedQty.compareTo(((X_C_InvoiceLine)line).getQtyInvoiced()) > 0) {
                    throw new IllegalStateException("Total matched qty > invoiced qty. MatchedQty=" + String.valueOf(matchedQty) + ", InvoicedQty=" + String.valueOf(((X_C_InvoiceLine)line).getQtyInvoiced()) + ", Line=" + String.valueOf(line));
                }
            }
            if (this.getC_OrderLine_ID() > 0 && (validateOrderedQty = MSysConfig.getBooleanValue("VALIDATE_MATCHING_TO_ORDERED_QTY", true, Env.getAD_Client_ID(Env.getCtx())))) {
                MOrderLine line2 = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
                BigDecimal qtyOrdered = line2.getQtyOrdered();
                BigDecimal invoicedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID());
                if (invoicedQty != null && (qtyOrdered.signum() > 0 && invoicedQty.compareTo(qtyOrdered) > 0 || qtyOrdered.signum() < 0 && invoicedQty.compareTo(qtyOrdered) < 0)) {
                    throw new IllegalStateException("Total matched invoiced qty > ordered qty. MatchedInvoicedQty=" + String.valueOf(invoicedQty) + ", OrderedQty=" + String.valueOf(qtyOrdered) + ", Line=" + String.valueOf(line2));
                }
                BigDecimal deliveredQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE M_InOutLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID());
                if (deliveredQty != null && (qtyOrdered.signum() > 0 && deliveredQty.compareTo(qtyOrdered) > 0 || qtyOrdered.signum() < 0 && deliveredQty.compareTo(qtyOrdered) < 0)) {
                    throw new IllegalStateException("Total matched delivered qty > ordered qty. MatchedDeliveredQty=" + String.valueOf(deliveredQty) + ", OrderedQty=" + String.valueOf(qtyOrdered) + ", Line=" + String.valueOf(line2));
                }
            }
        }
        if (success && this.getC_OrderLine_ID() != 0) {
            MInOutLine iol;
            BigDecimal oldQty;
            MOrderLine orderLine = this.getOrderLine();
            if (this.m_isInOutLineChange && (newRecord || this.getM_InOutLine_ID() != this.get_ValueOldAsInt("M_InOutLine_ID"))) {
                if (this.getM_InOutLine_ID() != 0) {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().add(this.getQty()));
                } else if (!newRecord) {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
                }
                orderLine.setDateDelivered(this.getDateTrx());
            } else if (!newRecord && this.getM_InOutLine_ID() > 0 && this.is_ValueChanged("Qty")) {
                oldQty = (BigDecimal)this.get_ValueOld("Qty");
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(oldQty.subtract(this.getQty())));
            }
            if (this.m_isInvoiceLineChange && (newRecord || this.getC_InvoiceLine_ID() != this.get_ValueOldAsInt("C_InvoiceLine_ID"))) {
                if (this.getC_InvoiceLine_ID() != 0) {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().add(this.getQty()));
                } else if (!newRecord) {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
                }
                orderLine.setDateInvoiced(this.getDateTrx());
            } else if (!newRecord && this.getC_InvoiceLine_ID() > 0 && this.is_ValueChanged("Qty")) {
                oldQty = (BigDecimal)this.get_ValueOld("Qty");
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(oldQty.subtract(this.getQty())));
            }
            if (orderLine.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getMovementQty().compareTo(orderLine.getQtyOrdered()) == 0) {
                orderLine.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            }
            return orderLine.save();
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql;
        Timestamp invoiceDate = null;
        Timestamp shipDate = null;
        if (this.getC_InvoiceLine_ID() != 0) {
            sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
            invoiceDate = DB.getSQLValueTS(null, sql, this.getC_InvoiceLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
            shipDate = DB.getSQLValueTS(null, sql, this.getM_InOutLine_ID());
        }
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXP", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(473, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success && this.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            if (this.getM_InOutLine_ID() != 0) {
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
            }
            if (this.getC_InvoiceLine_ID() != 0) {
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
            }
            return orderLine.save(this.get_TrxName());
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMatchPO[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID()).append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID()).append(",Processed=").append(this.isProcessed()).append(",Posted=").append(this.isPosted()).append("]");
        return sb.toString();
    }

    public boolean reverse(Timestamp reversalDate) {
        return this.reverse(reversalDate, false);
    }

    public boolean reverse(Timestamp reversalDate, boolean reverseMatchingOnly) {
        if (this.isProcessed() && this.getReversal_ID() == 0) {
            MMatchPO reversal = new MMatchPO(this.getCtx(), 0, this.get_TrxName());
            reversal.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
            reversal.setM_InOutLine_ID(this.getM_InOutLine_ID());
            if (this.getC_OrderLine_ID() != 0) {
                reversal.setC_OrderLine_ID(this.getC_OrderLine_ID());
            } else {
                reversal.setC_OrderLine_ID(this.getM_InOutLine().getC_OrderLine_ID());
            }
            reversal.setM_Product_ID(this.getM_Product_ID());
            reversal.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
            reversal.setAD_Org_ID(this.getAD_Org_ID());
            reversal.setDescription("(->" + this.getDocumentNo() + ")");
            reversal.setQty(this.getQty().negate());
            reversal.setDateAcct(reversalDate);
            reversal.setDateTrx(reversalDate);
            reversal.set_ValueNoCheck("DocumentNo", null);
            reversal.setPosted(false);
            reversal.setProcessed(true);
            reversal.setRef_MatchPO_ID(this.getRef_MatchPO_ID());
            reversal.setReversal_ID(this.getM_MatchPO_ID());
            reversal.saveEx();
            this.setDescription("(" + reversal.getDocumentNo() + "<-)");
            this.setReversal_ID(reversal.getM_MatchPO_ID());
            this.saveEx();
            if (reverseMatchingOnly && reversal.getM_InOutLine_ID() > 0 && reversal.getC_OrderLine_ID() > 0) {
                MInOutLine sLine = new MInOutLine(Env.getCtx(), reversal.getM_InOutLine_ID(), this.get_TrxName());
                if (sLine.getMovementQty().compareTo(this.getQty()) == 0 && sLine.getC_OrderLine_ID() == reversal.getC_OrderLine_ID()) {
                    sLine.setC_OrderLine_ID(0);
                    sLine.saveEx();
                }
                MOrderLine oLine = new MOrderLine(Env.getCtx(), reversal.getC_OrderLine_ID(), this.get_TrxName());
                BigDecimal storageReservationToUpdate = oLine.getQtyReserved();
                oLine.setQtyReserved(oLine.getQtyReserved().add(this.getQty()));
                BigDecimal reservedAndDelivered = oLine.getQtyDelivered().add(oLine.getQtyReserved());
                if (reservedAndDelivered.compareTo(oLine.getQtyOrdered()) > 0) {
                    oLine.setQtyReserved(oLine.getQtyReserved().subtract(reservedAndDelivered.subtract(oLine.getQtyOrdered())));
                    if (oLine.getQtyReserved().signum() == -1) {
                        oLine.setQtyReserved(Env.ZERO);
                    }
                }
                oLine.saveEx();
                storageReservationToUpdate = storageReservationToUpdate.subtract(oLine.getQtyReserved());
                if (storageReservationToUpdate.signum() != 0) {
                    boolean success;
                    IReservationTracer tracer = null;
                    IReservationTracerFactory factory = Core.getReservationTracerFactory();
                    if (factory != null) {
                        int docTypeId = DB.getSQLValue(null, "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC, C_DocType_ID", this.getAD_Client_ID(), "MXP");
                        tracer = factory.newTracer(docTypeId, reversal.getDocumentNo(), 10, reversal.get_Table_ID(), reversal.get_ID(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getParent().isSOTrx(), this.get_TrxName());
                    }
                    if (!(success = MStorageReservation.add(Env.getCtx(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), storageReservationToUpdate.negate(), oLine.getParent().isSOTrx(), this.get_TrxName(), tracer))) {
                        return false;
                    }
                }
            }
            if (reversal.getC_InvoiceLine_ID() > 0 && reversal.getM_InOutLine_ID() > 0) {
                MMatchPO matchPO;
                MMatchPO[] matchPOs = MMatchPO.getOrderLine(reversal.getCtx(), reversal.getC_OrderLine_ID(), reversal.get_TrxName());
                BigDecimal matchQty = this.getQty();
                MMatchPO[] mMatchPOArray = matchPOs;
                int n = matchPOs.length;
                int n2 = 0;
                while (n2 < n) {
                    matchPO = mMatchPOArray[n2];
                    if (matchPO.getReversal_ID() == 0 && !matchPO.isPosted() && matchPO.getC_InvoiceLine_ID() == reversal.getC_InvoiceLine_ID() && matchPO.getM_InOutLine_ID() == 0) {
                        matchPO.setQty(matchPO.getQty().add(matchQty));
                        matchPO.saveEx();
                        matchQty = BigDecimal.ZERO;
                        break;
                    }
                    ++n2;
                }
                if (matchQty.signum() != 0) {
                    matchPO = new MMatchPO(this.getCtx(), 0, this.get_TrxName());
                    matchPO.setC_OrderLine_ID(this.getC_OrderLine_ID());
                    matchPO.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
                    matchPO.setM_InOutLine_ID(0);
                    matchPO.setAD_Org_ID(this.getAD_Org_ID());
                    matchPO.setQty(this.getQty());
                    matchPO.setDateAcct(this.getDateAcct());
                    matchPO.setDateTrx(this.getDateTrx());
                    matchPO.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
                    matchPO.setM_Product_ID(this.getM_Product_ID());
                    matchPO.setDescription(null);
                    matchPO.setProcessed(true);
                    matchPO.setPosted(false);
                    matchPO.saveEx();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReversal() {
        MMatchPO reversal;
        return this.getReversal_ID() > 0 && (reversal = new MMatchPO(this.getCtx(), this.getReversal_ID(), this.get_TrxName())).getM_MatchPO_ID() < this.getM_MatchPO_ID();
    }

    public static MMatchPO getOrCreate(int C_OrderLine_ID, BigDecimal qty, MInOutLine sLine, String trxName) {
        Query query = new Query(Env.getCtx(), "M_MatchPO", "C_OrderLine_ID=? AND Qty=? AND Posted IN (?,?) AND M_InOutLine_ID IS NULL", trxName);
        MMatchPO matchPO = (MMatchPO)query.setParameters(C_OrderLine_ID, qty, "N", "d").first();
        if (matchPO != null) {
            matchPO.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
            return matchPO;
        }
        return new MMatchPO(sLine, null, qty);
    }
}

