/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.auth.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.model.MRefreshToken;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.auth.AuthService;
import com.trekglobal.idempiere.rest.api.v1.auth.LoginCredential;
import com.trekglobal.idempiere.rest.api.v1.auth.LoginParameters;
import com.trekglobal.idempiere.rest.api.v1.auth.LogoutParameters;
import com.trekglobal.idempiere.rest.api.v1.auth.RefreshParameters;
import com.trekglobal.idempiere.rest.api.v1.jwt.LoginClaims;
import com.trekglobal.idempiere.rest.api.v1.jwt.TokenUtils;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.util.LogAuthFailure;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserOrgAccess;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class AuthServiceImpl
implements AuthService {
    private static LogAuthFailure logAuthFailure = new LogAuthFailure();
    public static final String ROLE_TYPES_WEBSERVICE = "NULL,WS";
    @Context
    private HttpServletRequest request = null;

    @Override
    public Response authenticate(LoginCredential credential) {
        Login login = new Login(Env.getCtx());
        KeyNamePair[] clients = login.getClients(credential.getUserName(), credential.getPassword(), ROLE_TYPES_WEBSERVICE);
        if (clients == null || clients.length == 0) {
            String loginErrMsg = login.getLoginErrMsg();
            return this.unauthorized(loginErrMsg, credential.getUserName());
        }
        JsonArray clientNodes = new JsonArray();
        StringBuilder clientsSB = new StringBuilder();
        KeyNamePair[] keyNamePairArray = clients;
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair client = keyNamePairArray[n2];
            JsonObject node = new JsonObject();
            node.addProperty("id", (Number)client.getKey());
            node.addProperty("name", client.getName());
            clientNodes.add((JsonElement)node);
            if (clientsSB.length() > 0) {
                clientsSB.append(",");
            }
            clientsSB.append(client.getKey());
            ++n2;
        }
        if (credential.getParameters() != null) {
            LoginParameters parameters = credential.getParameters();
            String userName = credential.getUserName();
            Env.setContext((Properties)Env.getCtx(), (String)"#LoginName", (String)userName);
            return this.processLoginParameters(parameters, userName, clientsSB.toString());
        }
        JsonObject responseNode = new JsonObject();
        responseNode.add("clients", (JsonElement)clientNodes);
        JWTCreator.Builder builder = JWT.create().withSubject(credential.getUserName()).withClaim(LoginClaims.Clients.name(), clientsSB.toString());
        boolean setLoginParameters = false;
        if (clients.length == 1) {
            int clientId = clients[0].getKey();
            String userName = credential.getUserName();
            KeyNamePair[] roles = login.getRoles(userName, clients[0], ROLE_TYPES_WEBSERVICE);
            if (roles.length == 1) {
                int roleId = roles[0].getKey();
                MUser user = MUser.get((Properties)Env.getCtx(), (String)userName);
                MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
                int orgId = this.getOrgIdFirstOnly(user, role);
                int warehouseId = 0;
                if (orgId > 0) {
                    warehouseId = MOrgInfo.get((int)orgId).getM_Warehouse_ID();
                }
                Env.setContext((Properties)Env.getCtx(), (String)"#LoginName", (String)userName);
                String errorMessage = this.validateLoginParameters(userName, clientId, roleId, orgId, warehouseId);
                if (Util.isEmpty((String)errorMessage)) {
                    this.addClientIdClaim(builder, clientId);
                    responseNode.addProperty("clientId", (Number)clientId);
                    this.addUserIdClaim(userName, responseNode, builder);
                    builder.withClaim(LoginClaims.AD_Role_ID.name(), Integer.valueOf(roleId));
                    responseNode.addProperty("roleId", (Number)roleId);
                    builder.withClaim(LoginClaims.AD_Org_ID.name(), Integer.valueOf(orgId));
                    responseNode.addProperty("organizationId", (Number)orgId);
                    if (orgId > 0 && warehouseId > 0) {
                        builder.withClaim(LoginClaims.M_Warehouse_ID.name(), Integer.valueOf(warehouseId));
                        responseNode.addProperty("warehouseId", (Number)warehouseId);
                    }
                    String defaultLanguage = this.getPreferenceUserLanguage(user.getAD_User_ID());
                    this.addLanguageClaim(responseNode, builder, defaultLanguage);
                    this.createSession(builder);
                    this.addMenuTreeIdResponse(responseNode);
                    setLoginParameters = true;
                }
            }
        }
        this.addIssuerAndExpiresAt(builder);
        try {
            this.createToken(responseNode, builder, setLoginParameters);
        }
        catch (JWTCreationException | IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)responseNode.toString()).build();
    }

    private int getOrgIdFirstOnly(MUser user, MRole role) {
        int orgId = 0;
        if (!role.isUseUserOrgAccess()) {
            MRoleOrgAccess[] roleOrgAccess = MRoleOrgAccess.getOfRole((Properties)Env.getCtx(), (int)role.getAD_Role_ID());
            if (roleOrgAccess.length == 1) {
                orgId = roleOrgAccess[0].getAD_Org_ID();
            }
        } else {
            MUserOrgAccess[] userOrgAccess = MUserOrgAccess.getOfUser((Properties)Env.getCtx(), (int)user.getAD_User_ID());
            if (userOrgAccess.length == 1) {
                orgId = userOrgAccess[0].getAD_Org_ID();
            }
        }
        return orgId;
    }

    private Response unauthorized(String loginErrMsg, String userName) {
        String x_Forward_IP;
        if (Util.isEmpty((String)loginErrMsg)) {
            loginErrMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"FailedLogin", (boolean)true);
        }
        if ((x_Forward_IP = this.request.getHeader("X-Forwarded-For")) == null) {
            x_Forward_IP = this.request.getRemoteAddr();
        }
        logAuthFailure.log(x_Forward_IP, "/api", userName, loginErrMsg);
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append(loginErrMsg).build().toString()).build();
    }

    @Override
    public Response getRoles(int clientId) {
        try {
            String userName = Env.getContext((Properties)Env.getCtx(), (String)"#LoginName");
            MClient client = MClient.get((Properties)Env.getCtx(), (int)clientId);
            String clients = Env.getContext((Properties)Env.getCtx(), (String)"#LoginClients");
            boolean isValidClient = this.isValidClient(clientId, clients);
            if (!isValidClient) {
                return this.unauthorized("Invalid client", userName);
            }
            KeyNamePair knp = new KeyNamePair(client.getAD_Client_ID(), client.getName());
            Login login = new Login(Env.getCtx());
            KeyNamePair[] roles = login.getRoles(userName, knp, ROLE_TYPES_WEBSERVICE);
            JsonArray array = new JsonArray();
            if (roles != null) {
                KeyNamePair[] keyNamePairArray = roles;
                int n = roles.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair role = keyNamePairArray[n2];
                    JsonObject node = new JsonObject();
                    node.addProperty("id", (Number)role.getKey());
                    node.addProperty("name", role.getName());
                    array.add((JsonElement)node);
                    ++n2;
                }
            }
            JsonObject json = new JsonObject();
            json.add("roles", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response getOrganizations(int clientId, int roleId) {
        try {
            String userName = Env.getContext((Properties)Env.getCtx(), (String)"#LoginName");
            MClient client = MClient.get((Properties)Env.getCtx(), (int)clientId);
            String clients = Env.getContext((Properties)Env.getCtx(), (String)"#LoginClients");
            boolean isValidClient = this.isValidClient(clientId, clients);
            if (!isValidClient) {
                return this.unauthorized("Invalid client", userName);
            }
            KeyNamePair clientKeyNamePair = new KeyNamePair(client.getAD_Client_ID(), client.getName());
            Login login = new Login(Env.getCtx());
            KeyNamePair[] roles = login.getRoles(userName, clientKeyNamePair, ROLE_TYPES_WEBSERVICE);
            boolean isValidRole = this.isValidRole(roleId, roles);
            if (!isValidRole) {
                return this.unauthorized("Invalid role", userName);
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)client.getAD_Client_ID());
            MUser user = MUser.get((Properties)Env.getCtx(), (String)userName);
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
            KeyNamePair knp = new KeyNamePair(role.getAD_Role_ID(), role.getName());
            KeyNamePair[] orgs = login.getOrgs(knp);
            JsonArray array = new JsonArray();
            if (orgs != null) {
                KeyNamePair[] keyNamePairArray = orgs;
                int n = orgs.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair org = keyNamePairArray[n2];
                    JsonObject node = new JsonObject();
                    node.addProperty("id", (Number)org.getKey());
                    node.addProperty("name", org.getName());
                    array.add((JsonElement)node);
                    ++n2;
                }
            }
            JsonObject json = new JsonObject();
            json.add("organizations", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response getWarehouses(int clientId, int roleId, int organizationId) {
        try {
            String userName = Env.getContext((Properties)Env.getCtx(), (String)"#LoginName");
            MClient client = MClient.get((Properties)Env.getCtx(), (int)clientId);
            String clients = Env.getContext((Properties)Env.getCtx(), (String)"#LoginClients");
            boolean isValidClient = this.isValidClient(clientId, clients);
            if (!isValidClient) {
                return this.unauthorized("Invalid client", userName);
            }
            KeyNamePair clientKeyNamePair = new KeyNamePair(client.getAD_Client_ID(), client.getName());
            Login login = new Login(Env.getCtx());
            KeyNamePair[] roles = login.getRoles(userName, clientKeyNamePair, ROLE_TYPES_WEBSERVICE);
            boolean isValidRole = this.isValidRole(roleId, roles);
            if (!isValidRole) {
                return this.unauthorized("Invalid role", userName);
            }
            boolean isValidOrg = this.isValidOrg(organizationId, roleId, login);
            if (!isValidOrg) {
                return this.unauthorized("Invalid organization", userName);
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)client.getAD_Client_ID());
            MUser user = MUser.get((Properties)Env.getCtx(), (String)userName);
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)role.getAD_Role_ID());
            MOrg org = MOrg.get((int)organizationId);
            Env.setPredefinedVariables((Properties)Env.getCtx(), (int)-1, (String)MRole.getDefault().getPredefinedContextVariables());
            KeyNamePair knp = new KeyNamePair(org.getAD_Org_ID(), org.getName());
            KeyNamePair[] warehouses = login.getWarehouses(knp);
            JsonArray array = new JsonArray();
            if (warehouses != null) {
                KeyNamePair[] keyNamePairArray = warehouses;
                int n = warehouses.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair warehouse = keyNamePairArray[n2];
                    JsonObject node = new JsonObject();
                    node.addProperty("id", (Number)warehouse.getKey());
                    node.addProperty("name", warehouse.getName());
                    array.add((JsonElement)node);
                    ++n2;
                }
            }
            JsonObject json = new JsonObject();
            json.add("warehouses", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response getClientLanguage(int clientId) {
        try {
            MClient client = MClient.get((Properties)Env.getCtx(), (int)clientId);
            JsonObject node = new JsonObject();
            node.addProperty("AD_Language", client.getAD_Language());
            return Response.ok((Object)node.toString()).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response changeLoginParameters(LoginParameters parameters) {
        String userName = Env.getContext((Properties)Env.getCtx(), (String)"#LoginName");
        String clients = Env.getContext((Properties)Env.getCtx(), (String)"#LoginClients");
        return this.processLoginParameters(parameters, userName, clients);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response processLoginParameters(LoginParameters parameters, String userName, String clients) {
        String errorMessage;
        int warehouseId;
        int orgId;
        JsonObject responseNode = new JsonObject();
        JWTCreator.Builder builder = JWT.create().withSubject(userName);
        String defaultLanguage = Language.getBaseAD_Language();
        int clientId = this.getClientId(parameters, responseNode);
        if (clientId == -2) {
            return this.unauthorized("Client value not found", userName);
        }
        boolean isValidClient = false;
        if (clientId == -1) {
            if (!Util.isEmpty((String)clients) && clients.indexOf(",") == -1) {
                clientId = Integer.parseInt(clients);
                responseNode.addProperty("clientId", (Number)clientId);
                isValidClient = true;
            }
        } else {
            isValidClient = this.isValidClient(clientId, clients);
        }
        if (!isValidClient) return this.unauthorized("Invalid clientId", userName);
        this.addClientIdClaim(builder, clientId);
        MUser user = this.addUserIdClaim(userName, responseNode, builder);
        defaultLanguage = this.getPreferenceUserLanguage(user.getAD_User_ID());
        int roleId = this.getRoleId(clientId, parameters, responseNode);
        if (roleId == -2) {
            return this.unauthorized("Role name not found", userName);
        }
        if (roleId == -3) {
            return this.unauthorized("Role name not unique", userName);
        }
        if (roleId == -1) {
            Login login = new Login(Env.getCtx());
            KeyNamePair[] roles = login.getRoles(userName, new KeyNamePair(clientId, MClient.get((int)clientId).getName()), ROLE_TYPES_WEBSERVICE);
            if (roles.length != 1) return this.unauthorized("Missing roleId parameter", userName);
            roleId = roles[0].getKey();
            responseNode.addProperty("roleId", (Number)roles[0].getKey());
        }
        if ((orgId = this.getOrganizationId(clientId, parameters, responseNode)) == -2) {
            return this.unauthorized("Organization name not found", userName);
        }
        if (orgId == -3) {
            return this.unauthorized("Organization name not unique", userName);
        }
        if (orgId == -1) {
            orgId = this.getOrgIdFirstOnly(user, MRole.get((Properties)Env.getCtx(), (int)roleId));
            if (orgId == 0) {
                return this.unauthorized("Missing organizationId parameter", userName);
            }
            responseNode.addProperty("organizationId", (Number)orgId);
        }
        if ((warehouseId = this.getWarehouseId(clientId, parameters, responseNode)) == -2) {
            return this.unauthorized("Warehouse name not found", userName);
        }
        if (warehouseId == -1 && orgId > 0 && (warehouseId = MOrgInfo.get((int)orgId).getM_Warehouse_ID()) > 0) {
            responseNode.addProperty("warehouseId", (Number)warehouseId);
        }
        if (!Util.isEmpty((String)(errorMessage = this.validateLoginParameters(userName, clientId, roleId, orgId, warehouseId)))) return this.unauthorized(errorMessage, userName);
        builder.withClaim(LoginClaims.AD_Role_ID.name(), Integer.valueOf(roleId));
        builder.withClaim(LoginClaims.AD_Org_ID.name(), Integer.valueOf(orgId));
        if (orgId > 0 && warehouseId > 0) {
            builder.withClaim(LoginClaims.M_Warehouse_ID.name(), Integer.valueOf(warehouseId));
        }
        if (parameters.getLanguage() != null) {
            for (String langAllowed : Env.getLoginLanguages()) {
                if (!parameters.getLanguage().equals(langAllowed)) continue;
                defaultLanguage = parameters.getLanguage();
                break;
            }
        }
        this.addLanguageClaim(responseNode, builder, defaultLanguage);
        this.createSession(builder);
        this.addMenuTreeIdResponse(responseNode);
        this.addIssuerAndExpiresAt(builder);
        try {
            this.createToken(responseNode, builder, true);
            return Response.ok((Object)responseNode.toString()).build();
        }
        catch (JWTCreationException | IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private int getClientId(LoginParameters parameters, JsonObject responseNode) {
        String s = parameters.getClientId();
        if (Util.isEmpty((String)s)) {
            return -1;
        }
        int clientId = -1;
        if (Pattern.matches("\\d+", s.trim()) && MClient.get((int)(clientId = Integer.parseInt(s.trim()))).get_ID() == clientId) {
            return clientId;
        }
        Query query = new Query(Env.getCtx(), "AD_Client", "IsActive='Y' AND Value=?", null);
        clientId = query.setParameters(new Object[]{s.trim()}).firstId();
        if (clientId == -1) {
            return -2;
        }
        responseNode.addProperty("clientId", (Number)clientId);
        return clientId;
    }

    private int getOrganizationId(int clientId, LoginParameters parameters, JsonObject responseNode) {
        String s = parameters.getOrganizationId();
        if (Util.isEmpty((String)s)) {
            return -1;
        }
        int orgId = -1;
        if (Pattern.matches("\\d+", s.trim()) && MOrg.get((int)(orgId = Integer.parseInt(s.trim()))) != null) {
            return orgId;
        }
        Query query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND IsActive='Y' AND Name=?", null);
        try {
            orgId = query.setParameters(new Object[]{clientId, s.trim()}).firstIdOnly();
        }
        catch (Exception exception) {
            return -3;
        }
        if (orgId == -1) {
            return -2;
        }
        responseNode.addProperty("organizationId", (Number)orgId);
        return orgId;
    }

    private int getRoleId(int clientId, LoginParameters parameters, JsonObject responseNode) {
        String s = parameters.getRoleId();
        if (Util.isEmpty((String)s)) {
            return -1;
        }
        int roleId = -1;
        if (Pattern.matches("\\d+", s.trim())) {
            roleId = Integer.parseInt(s.trim());
            if (MRole.get((Properties)Env.getCtx(), (int)roleId).get_ID() == roleId) {
                return roleId;
            }
        }
        Query query = new Query(Env.getCtx(), "AD_Role", "AD_Client_ID=? AND IsActive='Y' AND Name=?", null);
        try {
            roleId = query.setParameters(new Object[]{clientId, s.trim()}).firstIdOnly();
        }
        catch (Exception exception) {
            return -3;
        }
        if (roleId == -1) {
            return -2;
        }
        responseNode.addProperty("roleId", (Number)roleId);
        return roleId;
    }

    private int getWarehouseId(int clientId, LoginParameters parameters, JsonObject responseNode) {
        String s = parameters.getWarehouseId();
        if (Util.isEmpty((String)s)) {
            return -1;
        }
        int warehouseId = -1;
        if (Pattern.matches("\\d+", s.trim()) && ((warehouseId = Integer.parseInt(s.trim())) == 0 || MWarehouse.get((int)warehouseId) != null)) {
            return warehouseId;
        }
        Query query = new Query(Env.getCtx(), "AD_Org", "AD_Client_ID=? AND IsActive='Y' AND Name=?", null);
        warehouseId = query.setParameters(new Object[]{clientId, s.trim()}).firstId();
        if (warehouseId == -1) {
            return -2;
        }
        responseNode.addProperty("warehouseId", (Number)warehouseId);
        return warehouseId;
    }

    private void createToken(JsonObject responseNode, JWTCreator.Builder builder, boolean createRefreshToken) {
        String token = builder.sign(Algorithm.HMAC512((String)TokenUtils.getTokenSecret()));
        responseNode.addProperty("token", token);
        if (createRefreshToken) {
            Timestamp absoluteExpiresAt = TokenUtils.getTokenAbsoluteExpiresAt();
            responseNode.addProperty("refresh_token", this.generateRefreshToken(token, null, absoluteExpiresAt));
        }
    }

    private void addIssuerAndExpiresAt(JWTCreator.Builder builder) {
        Timestamp expiresAt = TokenUtils.getTokenExpiresAt();
        builder.withIssuer(TokenUtils.getTokenIssuer()).withExpiresAt((Date)expiresAt).withKeyId(TokenUtils.getTokenKeyId());
    }

    private void addMenuTreeIdResponse(JsonObject responseNode) {
        MRole role = MRole.getDefault();
        int menuTreeId = role.getAD_Tree_Menu_ID();
        if (menuTreeId <= 0) {
            menuTreeId = MClientInfo.get().getAD_Tree_Menu_ID();
        }
        responseNode.addProperty("menuTreeId", (Number)menuTreeId);
    }

    private void addLanguageClaim(JsonObject responseNode, JWTCreator.Builder builder, String defaultLanguage) {
        builder.withClaim(LoginClaims.AD_Language.name(), defaultLanguage);
        responseNode.addProperty("language", defaultLanguage);
    }

    private void addClientIdClaim(JWTCreator.Builder builder, int clientId) {
        builder.withClaim(LoginClaims.AD_Client_ID.name(), Integer.valueOf(clientId));
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)clientId);
    }

    private MUser addUserIdClaim(String userName, JsonObject responseNode, JWTCreator.Builder builder) {
        MUser user = MUser.get((Properties)Env.getCtx(), (String)userName);
        builder.withClaim(LoginClaims.AD_User_ID.name(), Integer.valueOf(user.getAD_User_ID()));
        responseNode.addProperty("userId", (Number)user.getAD_User_ID());
        return user;
    }

    private void createSession(JWTCreator.Builder builder) {
        MSession session = MSession.get((Properties)Env.getCtx());
        if (session == null) {
            session = MSession.create((Properties)Env.getCtx());
            session.setWebSession("idempiere-rest");
            session.saveEx();
        }
        builder.withClaim(LoginClaims.AD_Session_ID.name(), Integer.valueOf(session.getAD_Session_ID()));
    }

    private boolean isValidClient(int clientID, String clients) {
        if (clientID >= 0 && !Util.isEmpty((String)clients)) {
            String[] stringArray = clients.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedClient = stringArray[n2];
                if (clientID == Integer.valueOf(allowedClient)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateLoginParameters(String userName, int clientId, int roleId, int orgId, int warehouseId) {
        boolean warehouseValid;
        MClient client = MClient.get((Properties)Env.getCtx(), (int)clientId);
        KeyNamePair clientKeyNamePair = new KeyNamePair(client.getAD_Client_ID(), client.getName());
        Login login = new Login(Env.getCtx());
        KeyNamePair[] roles = login.getRoles(userName, clientKeyNamePair, ROLE_TYPES_WEBSERVICE);
        boolean isValidRole = this.isValidRole(roleId, roles);
        if (!isValidRole) return "Invalid roleId";
        boolean isValidOrg = this.isValidOrg(orgId, roleId, login);
        if (!isValidOrg) return "Invalid organizationId";
        if (orgId <= 0 || warehouseId <= 0 || (warehouseValid = this.isValidWarehouse(orgId, warehouseId, login))) return login.validateLogin(new KeyNamePair(orgId, ""));
        return "Invalid warehouseId";
    }

    private boolean isValidRole(int roleId, KeyNamePair[] roles) {
        if (roleId >= 0 && roles != null) {
            KeyNamePair[] keyNamePairArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair roleAllowed = keyNamePairArray[n2];
                if (roleId == roleAllowed.getKey()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isValidOrg(int orgId, int roleId, Login login) {
        if (orgId >= 0) {
            String userName = Env.getContext((Properties)Env.getCtx(), (String)"#LoginName");
            MUser user = MUser.get((Properties)Env.getCtx(), (String)userName);
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            MRole role = MRole.get((Properties)Env.getCtx(), (int)roleId);
            KeyNamePair rolesKeyNamePair = new KeyNamePair(role.getAD_Role_ID(), role.getName());
            KeyNamePair[] orgs = login.getOrgs(rolesKeyNamePair);
            if (orgs != null) {
                KeyNamePair[] keyNamePairArray = orgs;
                int n = orgs.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair orgAllowed = keyNamePairArray[n2];
                    if (orgId == orgAllowed.getKey()) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean isValidWarehouse(int orgId, int warehouseId, Login login) {
        MOrg org = MOrg.get((int)orgId);
        KeyNamePair orgKeyNamePair = new KeyNamePair(org.getAD_Org_ID(), org.getName());
        KeyNamePair[] warehouses = login.getWarehouses(orgKeyNamePair);
        if (warehouses != null) {
            KeyNamePair[] keyNamePairArray = warehouses;
            int n = warehouses.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair allowedWarehouse = keyNamePairArray[n2];
                if (warehouseId == allowedWarehouse.getKey()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String getPreferenceUserLanguage(int AD_User_ID) {
        Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), " Attribute=? AND AD_User_ID=? AND PreferenceFor = 'W'", null);
        MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setParameters(new Object[]{"Language", AD_User_ID}).first();
        return preference != null ? Language.getAD_Language((String)preference.getValue()) : MClient.get((Properties)Env.getCtx()).getAD_Language();
    }

    @Override
    public Response getJWK() {
        JsonObject jwks = new JsonObject();
        if (MSysConfig.getBooleanValue((String)"IDEMPIERE_REST_EXPOSE_JWK", (boolean)false)) {
            JsonArray keys = new JsonArray();
            JsonObject key = new JsonObject();
            try {
                key.addProperty("alg", Algorithm.HMAC512((String)TokenUtils.getTokenSecret()).getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            key.addProperty("k", DatatypeConverter.printBase64Binary((byte[])TokenUtils.getTokenSecret().getBytes()));
            key.addProperty("kid", TokenUtils.getTokenKeyId());
            key.addProperty("kty", "oct");
            keys.add((JsonElement)key);
            jwks.add("keys", (JsonElement)keys);
        }
        return Response.ok((Object)jwks.toString()).build();
    }

    @Override
    public Response tokenRefresh(RefreshParameters refresh) {
        DecodedJWT jwt;
        String refreshToken = refresh.getRefresh_token();
        Integer refreshClientId = refresh.getClientId();
        if (refreshClientId == null && MSysConfig.getBooleanValue((String)"REST_MANDATORY_CLIENT_ID_ON_REFRESH", (boolean)true)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("No clientId provided").build().toString()).build();
        }
        Integer refreshUserId = refresh.getUserId();
        if (refreshUserId == null && MSysConfig.getBooleanValue((String)"REST_MANDATORY_USER_ID_ON_REFRESH", (boolean)true)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("No userId provided").build().toString()).build();
        }
        if (MRefreshToken.isParent(refreshToken)) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)0);
            MRefreshToken.breachDetected(refreshToken);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("Invalid refresh token").build().toString()).build();
        }
        Algorithm algorithm = Algorithm.HMAC512((String)TokenUtils.getTokenSecret());
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(TokenUtils.getTokenIssuer()).build();
        try {
            verifier.verify(refreshToken);
        }
        catch (JWTVerificationException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append(e.getLocalizedMessage()).build().toString()).build();
        }
        MRefreshToken refreshTokenInDB = MRefreshToken.getValidForRefresh(refreshToken);
        if (refreshTokenInDB == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("Invalid refresh token").build().toString()).build();
        }
        if (refreshClientId != null && refreshTokenInDB.getAD_Client_ID() != refreshClientId.intValue()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("Invalid refresh token").build().toString()).build();
        }
        if (refreshUserId != null && refreshTokenInDB.getCreatedBy() != refreshUserId.intValue()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append("Invalid refresh token").build().toString()).build();
        }
        String authToken = refreshTokenInDB.getToken();
        JWTVerifier decoder = JWT.require((Algorithm)algorithm).withIssuer(TokenUtils.getTokenIssuer()).acceptExpiresAt(Instant.MAX.getEpochSecond()).build();
        try {
            jwt = decoder.verify(authToken);
        }
        catch (JWTVerificationException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append(e.getLocalizedMessage()).build().toString()).build();
        }
        String userName = jwt.getSubject();
        Claim claim = jwt.getClaim(LoginClaims.AD_Client_ID.name());
        int clientId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            clientId = claim.asInt();
        }
        claim = jwt.getClaim(LoginClaims.AD_User_ID.name());
        int userId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            userId = claim.asInt();
        }
        claim = jwt.getClaim(LoginClaims.AD_Role_ID.name());
        int roleId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            roleId = claim.asInt();
        }
        claim = jwt.getClaim(LoginClaims.AD_Org_ID.name());
        int orgId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            orgId = claim.asInt();
        }
        claim = jwt.getClaim(LoginClaims.M_Warehouse_ID.name());
        int warehouseId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            warehouseId = claim.asInt();
        }
        claim = jwt.getClaim(LoginClaims.AD_Language.name());
        String defaultLanguage = null;
        if (!claim.isNull() && !claim.isMissing()) {
            defaultLanguage = claim.asString();
        }
        claim = jwt.getClaim(LoginClaims.AD_Session_ID.name());
        int sessionId = -1;
        if (!claim.isNull() && !claim.isMissing()) {
            sessionId = claim.asInt();
        }
        JsonObject responseNode = new JsonObject();
        JWTCreator.Builder builder = JWT.create().withSubject(userName);
        this.addClientIdClaim(builder, clientId);
        builder.withClaim(LoginClaims.AD_User_ID.name(), Integer.valueOf(userId));
        builder.withClaim(LoginClaims.AD_Role_ID.name(), Integer.valueOf(roleId));
        builder.withClaim(LoginClaims.AD_Org_ID.name(), Integer.valueOf(orgId));
        if (orgId > 0 && warehouseId > 0) {
            builder.withClaim(LoginClaims.M_Warehouse_ID.name(), Integer.valueOf(warehouseId));
        }
        builder.withClaim(LoginClaims.AD_Language.name(), defaultLanguage);
        builder.withClaim(LoginClaims.AD_Session_ID.name(), Integer.valueOf(sessionId));
        this.addIssuerAndExpiresAt(builder);
        try {
            String token = builder.sign(Algorithm.HMAC512((String)TokenUtils.getTokenSecret()));
            responseNode.addProperty("token", token);
            responseNode.addProperty("refresh_token", this.generateRefreshToken(token, refreshToken, null));
        }
        catch (JWTCreationException | IllegalArgumentException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)responseNode.toString()).build();
    }

    private String generateRefreshToken(String token, String previousRefreshToken, Timestamp absoluteExpiresAt) {
        MRefreshToken prt;
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[32];
        secureRandom.nextBytes(randomBytes);
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = randomBytes;
        int n = randomBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hexString.append(String.format("%02x", b));
            ++n2;
        }
        JWTCreator.Builder builder = JWT.create().withJWTId(hexString.toString());
        Timestamp inactiveExpiresAt = TokenUtils.getRefreshTokenExpiresAt();
        builder.withIssuer(TokenUtils.getTokenIssuer()).withKeyId(TokenUtils.getTokenKeyId());
        String refreshToken = builder.sign(Algorithm.HMAC512((String)TokenUtils.getTokenSecret()));
        MRefreshToken refreshTokenInDB = new MRefreshToken(Env.getCtx(), "", null);
        refreshTokenInDB.setToken(token);
        refreshTokenInDB.setRefreshToken(refreshToken);
        refreshTokenInDB.setParentToken(previousRefreshToken);
        refreshTokenInDB.setExpiresAt(inactiveExpiresAt);
        refreshTokenInDB.setAbsoluteExpiresAt(absoluteExpiresAt);
        if (previousRefreshToken != null && absoluteExpiresAt == null && (prt = MRefreshToken.get(previousRefreshToken)) != null) {
            refreshTokenInDB.setAbsoluteExpiresAt(prt.getAbsoluteExpiresAt());
        }
        refreshTokenInDB.save();
        return refreshToken;
    }

    @Override
    public Response tokenLogout(LogoutParameters logout) {
        DecodedJWT jwt;
        String token = logout.getToken();
        Algorithm algorithm = Algorithm.HMAC512((String)TokenUtils.getTokenSecret());
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(TokenUtils.getTokenIssuer()).acceptExpiresAt(Instant.MAX.getEpochSecond()).build();
        try {
            jwt = verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorBuilder().status(Response.Status.UNAUTHORIZED).title("Authenticate error").append(e.getLocalizedMessage()).build().toString()).build();
        }
        Claim claim = jwt.getClaim(LoginClaims.AD_Session_ID.name());
        int sessionId = -1;
        if (claim.isNull() || claim.isMissing()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("AD_Session_ID not found").build().toString()).build();
        }
        sessionId = claim.asInt();
        claim = jwt.getClaim(LoginClaims.AD_User_ID.name());
        if (!claim.isNull() && !claim.isMissing()) {
            int userId = claim.asInt();
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)userId);
        }
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)sessionId);
        MSession session = new MSession(Env.getCtx(), sessionId, null);
        session.logout();
        RestUtils.removeSavedCtx(sessionId);
        MRefreshToken.logout(token);
        JsonObject okResponse = new JsonObject();
        okResponse.addProperty("summary", "OK");
        return Response.ok((Object)okResponse.toString()).build();
    }
}

