/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.ModelHelper;
import com.trekglobal.idempiere.rest.api.json.POParser;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.expand.ExpandParser;
import com.trekglobal.idempiere.rest.api.json.expand.ExpandUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import com.trekglobal.idempiere.rest.api.model.X_REST_View;
import com.trekglobal.idempiere.rest.api.v1.resource.ModelResource;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileStreamingOutput;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.WindowResourceImpl;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.YAMLSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.EventProperty;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.osgi.service.event.Event;

public class ModelResourceImpl
implements ModelResource {
    private static final CLogger log = CLogger.getCLogger(ModelResourceImpl.class);
    public static final String PO_BEFORE_REST_SAVE = "idempiere-rest/po/beforeSave";
    public static final String PO_AFTER_REST_SAVE = "idempiere-rest/po/afterSave";
    private boolean useRestView = false;

    protected ModelResourceImpl restView() {
        this.useRestView = true;
        return this;
    }

    @Override
    public Response getPO(String tableName, String id, String details, String select, String showsql) {
        return this.getPO(tableName, id, details, select, null, showsql);
    }

    private Response getPO(String tableName, String id, String details, String multiProperty, String singleProperty, String showsql) {
        try {
            PO po;
            POParser poParser;
            MRestView view = null;
            if (this.useRestView) {
                view = RestUtils.getView(tableName);
                if (view != null) {
                    tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
                } else {
                    throw new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND);
                }
            }
            RestUtils.getTableAndCheckAccess(tableName, false);
            String[] includes = null;
            if (!Util.isEmpty((String)multiProperty, (boolean)true)) {
                if (view != null) {
                    multiProperty = this.toColumnNames(view, multiProperty);
                }
                includes = RestUtils.getSelectedColumns(tableName, multiProperty);
            } else if (!Util.isEmpty((String)singleProperty, (boolean)true)) {
                MTable table;
                if (view != null) {
                    String original = singleProperty;
                    if (Util.isEmpty((String)(singleProperty = this.toColumnNames(view, singleProperty)), (boolean)true)) {
                        return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Invalid property name", "No match found for table name: ", original);
                    }
                }
                if ((table = MTable.get((Properties)Env.getCtx(), (String)tableName)).getColumnIndex(singleProperty) < 0) {
                    return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Invalid property name", "No match found for column name: ", singleProperty);
                }
                includes = new String[]{singleProperty};
            }
            Query query = RestUtils.getQuery(tableName, id, true, false);
            if (includes != null && includes.length > 0) {
                query.selectColumns(includes);
            }
            if ((poParser = new POParser(tableName, id, po = query.first())).isValidPO()) {
                MRestViewRelated[] relateds;
                IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, po.getClass());
                boolean showData = showsql == null || !"nodata".equals(showsql);
                JsonObject json = showData ? serializer.toJson(po, view, includes, null) : new JsonObject();
                if (showsql != null) {
                    json.addProperty("sql-command", DB.getDatabase().convertStatement(query.getSQL()));
                }
                if (!Util.isEmpty((String)details, (boolean)true)) {
                    this.expandDetailsInJsonObject(po, view, json, json, details, showsql != null, showData);
                } else if (view != null && (relateds = view.getRelatedViews()) != null && relateds.length > 0) {
                    StringBuilder expands = new StringBuilder();
                    MRestViewRelated[] mRestViewRelatedArray = relateds;
                    int n = relateds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MRestViewRelated related = mRestViewRelatedArray[n2];
                        if (related.isRestAutoExpand()) {
                            if (expands.length() > 0) {
                                expands.append(",");
                            }
                            this.autoExpandRelated(expands, related);
                        }
                        ++n2;
                    }
                    if (expands.length() > 0) {
                        this.expandDetailsInJsonObject(po, view, json, json, expands.toString(), showsql != null, showData);
                    }
                }
                return Response.ok((Object)json.toString()).build();
            }
            return poParser.getResponseError();
        }
        catch (Exception ex) {
            return ResponseUtils.getResponseErrorFromException(ex, "GET Error");
        }
    }

    private void autoExpandRelated(StringBuilder expands, MRestViewRelated related) {
        expands.append(related.getName());
        MRestView view = MRestView.get(related.getREST_RelatedRestView_ID());
        if (view.getREST_View_ID() == related.getREST_View_ID()) {
            return;
        }
        MRestViewRelated[] relateds = view.getRelatedViews();
        if (relateds != null && relateds.length > 0) {
            StringBuilder childs = new StringBuilder();
            MRestViewRelated[] mRestViewRelatedArray = relateds;
            int n = relateds.length;
            int n2 = 0;
            while (n2 < n) {
                MRestViewRelated rv = mRestViewRelatedArray[n2];
                if (rv.isRestAutoExpand()) {
                    if (childs.length() > 0) {
                        childs.append(",");
                    }
                    this.autoExpandRelated(childs, rv);
                }
                ++n2;
            }
            if (childs.length() > 0) {
                expands.append("($expand=").append(childs.toString()).append(")");
            }
        }
    }

    private String toColumnNames(MRestView view, String propertyNames) {
        CharSequence[] columns = propertyNames.split("[,]");
        columns = view.toColumnNames((String[])columns, true);
        return String.join((CharSequence)",", columns);
    }

    private void expandDetailsInJsonObject(PO po, MRestView view, JsonObject masterJsonObject, JsonObject detailJsonObject, String expandParameter, boolean showSql, boolean showData) {
        ExpandParser expandParser = new ExpandParser(po, view, expandParameter);
        if (showSql) {
            ExpandUtils.addDetailSQLCommandToJson(expandParser.getTableNameSQLStatementMap(), masterJsonObject);
        }
        if (showData) {
            ExpandUtils.addDetailDataToJson(expandParser.getTableNameChildArrayMap(), detailJsonObject);
        }
    }

    @Override
    public Response getPOProperty(String tableName, String id, String propertyName, String showsql) {
        return this.getPO(tableName, id, null, null, propertyName, showsql);
    }

    @Override
    public Response getModels(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Table", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "AD_Table", convertedStatement.getWhereClause(), null);
            query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            query.setParameters(convertedStatement.getParameters());
            List tables = query.setOrderBy("AD_Table.TableName").list();
            JsonArray array = new JsonArray();
            for (MTable table : tables) {
                if (!RestUtils.hasAccess(table, false)) continue;
                JsonObject json = new JsonObject();
                json.addProperty("id", (Number)table.getAD_Table_ID());
                if (!Util.isEmpty((String)table.getAD_Table_UU())) {
                    json.addProperty("uid", table.getAD_Table_UU());
                }
                json.addProperty("model-name", table.getTableName().toLowerCase());
                json.addProperty("name", table.getName());
                if (!Util.isEmpty((String)table.getDescription())) {
                    json.addProperty("description", table.getDescription());
                }
                array.add((JsonElement)json);
            }
            JsonObject json = new JsonObject();
            json.add("models", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            return ResponseUtils.getResponseErrorFromException(ex, "GET Error");
        }
    }

    @Override
    public Response getPOs(String tableName, String details, String filter, String order, String select, int top, int skip, String validationRuleID, String context, String showsql) {
        try {
            MRestView view = null;
            if (this.useRestView) {
                view = RestUtils.getView(tableName);
                if (view != null) {
                    tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
                } else {
                    throw new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND);
                }
            }
            RestUtils.getTableAndCheckAccess(tableName, false);
            ModelHelper modelHelper = new ModelHelper(tableName, filter, order, top, skip, validationRuleID, context);
            if (view != null && !Util.isEmpty((String)select, (boolean)true)) {
                select = this.toColumnNames(view, select);
            }
            String[] includes = RestUtils.getSelectedColumns(tableName, select);
            if (view != null) {
                modelHelper.setView(view);
            }
            List<PO> list = modelHelper.getPOsFromRequest(includes);
            JsonArray array = new JsonArray();
            if (list != null) {
                IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, MTable.getClass((String)tableName));
                boolean showData = showsql == null || !"nodata".equals(showsql);
                JsonObject json = new JsonObject();
                json.addProperty("page-count", (Number)modelHelper.getPageCount());
                json.addProperty("records-size", (Number)modelHelper.getTop());
                json.addProperty("skip-records", (Number)modelHelper.getSkip());
                json.addProperty("row-count", (Number)modelHelper.getRowCount());
                json.addProperty("array-count", (Number)array.size());
                if (showsql != null) {
                    json.addProperty("sql-command", DB.getDatabase().convertStatement(modelHelper.getSQLStatement()));
                }
                for (PO po : list) {
                    MRestViewRelated[] relateds;
                    JsonObject detailJson = serializer.toJson(po, view, includes, null);
                    if (!Util.isEmpty((String)details, (boolean)true)) {
                        this.expandDetailsInJsonObject(po, view, json, detailJson, details, showsql != null, showData);
                    } else if (view != null && (relateds = view.getRelatedViews()) != null && relateds.length > 0) {
                        StringBuilder expands = new StringBuilder();
                        MRestViewRelated[] mRestViewRelatedArray = relateds;
                        int n = relateds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MRestViewRelated related = mRestViewRelatedArray[n2];
                            if (related.isRestAutoExpand()) {
                                if (expands.length() > 0) {
                                    expands.append(",");
                                }
                                this.autoExpandRelated(expands, related);
                            }
                            ++n2;
                        }
                        if (expands.length() > 0) {
                            this.expandDetailsInJsonObject(po, view, json, detailJson, expands.toString(), showsql != null, showData);
                        }
                    }
                    array.add((JsonElement)detailJson);
                }
                if (showData) {
                    json.add("records", (JsonElement)array);
                }
                return Response.ok((Object)json.toString()).header("X-Page-Count", (Object)modelHelper.getPageCount()).header("X-Records-Size", (Object)modelHelper.getTop()).header("X-Skip-Records", (Object)modelHelper.getSkip()).header("X-Row-Count", (Object)modelHelper.getRowCount()).header("X-Array-Count", (Object)array.size()).build();
            }
            JsonObject json = new JsonObject();
            json.add("records", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            return ResponseUtils.getResponseErrorFromException(ex, "GET Error");
        }
    }

    @Override
    public Response create(String tableName, String jsonText) {
        try (Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            MRestView view = null;
            if (this.useRestView) {
                view = RestUtils.getView(tableName);
                if (view != null) {
                    tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
                } else {
                    throw new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND);
                }
            }
            MTable table = RestUtils.getTableAndCheckAccess(tableName, true);
            trx.start();
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
            IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, MTable.getClass((String)tableName));
            PO po = serializer.fromJson(jsonObject, table, view);
            if (!RestUtils.hasRoleUpdateAccess(po.getAD_Client_ID(), po.getAD_Org_ID(), po.get_Table_ID(), 0, true)) {
                Response response = ResponseUtils.getResponseError(Response.Status.FORBIDDEN, "Update error", "Role does not have access", "");
                return response;
            }
            po.set_TrxName(trx.getTrxName());
            this.fireRestSaveEvent(po, PO_BEFORE_REST_SAVE, true);
            try {
                if (!po.validForeignKeys()) {
                    String msg = CLogger.retrieveErrorString((String)"Foreign key validation error");
                    throw new AdempiereException(msg);
                }
                po.saveEx();
                this.fireRestSaveEvent(po, PO_AFTER_REST_SAVE, true);
            }
            catch (Exception ex) {
                trx.rollback();
                Response response = ResponseUtils.getResponseErrorFromException(ex, "Save error");
                trx.close();
                return response;
            }
            LinkedHashMap<String, JsonArray> detailMap = new LinkedHashMap<String, JsonArray>();
            Set fields = jsonObject.keySet();
            for (String field : fields) {
                String strError = this.createChild(field, jsonObject, po, view, detailMap, trx);
                if (strError == null) continue;
                Response response = ResponseUtils.getResponseError(Response.Status.INTERNAL_SERVER_ERROR, "Save error", "Save error with exception: ", strError);
                return response;
            }
            StringBuilder processMsg = new StringBuilder();
            String processError = this.runDocAction(po, jsonObject, processMsg);
            if (!Util.isEmpty((String)processError, (boolean)true)) {
                trx.rollback();
                log.warning("Encounter exception during execution of document action in REST: " + processError);
                Response response = ResponseUtils.getResponseError(Response.Status.INTERNAL_SERVER_ERROR, Msg.getMsg((Properties)po.getCtx(), (String)"FailedProcessingDocument"), processError, "");
                return response;
            }
            trx.commit(true);
            po.load(trx.getTrxName(), new String[0]);
            jsonObject = serializer.toJson(po, view);
            if (processMsg.length() > 0) {
                jsonObject.addProperty("doc-processmsg", processMsg.toString());
            }
            if (detailMap.size() > 0) {
                for (String childTableName : detailMap.keySet()) {
                    JsonArray childArray = (JsonArray)detailMap.get(childTableName);
                    jsonObject.add(childTableName, (JsonElement)childArray);
                }
            }
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)jsonObject.toString()).build();
            return response;
        }
    }

    private String createChild(String field, JsonObject jsonObject, PO po, MRestView view, Map<String, JsonArray> detailMap, Trx trx) {
        JsonElement fieldElement = jsonObject.get(field);
        if (fieldElement != null && fieldElement.isJsonArray()) {
            MTable childTable;
            String childTableName = field;
            MRestView childView = null;
            if (view != null) {
                MRestViewRelated[] relateds;
                MRestViewRelated[] mRestViewRelatedArray = relateds = view.getRelatedViews();
                int n = relateds.length;
                int n2 = 0;
                while (n2 < n) {
                    MRestViewRelated related = mRestViewRelatedArray[n2];
                    MRestView relatedView = new MRestView(Env.getCtx(), related.getREST_RelatedRestView_ID(), null);
                    String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)relatedView.getAD_Table_ID());
                    if (related.getName().equals(field)) {
                        childTableName = tableName;
                        childView = relatedView;
                        break;
                    }
                    if (tableName.equals(field)) {
                        childView = relatedView;
                        break;
                    }
                    ++n2;
                }
                if (childView == null) {
                    return null;
                }
            }
            if (!RestUtils.isValidDetailTable(childTable = MTable.get((Properties)Env.getCtx(), (String)childTableName), RestUtils.getKeyColumnName(po.get_TableName()))) {
                throw new IDempiereRestException("Wrong detail", "Cannot create detail records for the table because it has no column that links to the parent table: " + childTableName, Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (childTable != null && childTable.getAD_Table_ID() > 0) {
                IPOSerializer childSerializer = IPOSerializer.getPOSerializer(childTableName, MTable.getClass((String)childTableName));
                JsonArray fieldArray = fieldElement.getAsJsonArray();
                JsonArray savedArray = new JsonArray();
                try {
                    MRestView finalChildView = childView;
                    fieldArray.forEach(e -> {
                        if (e.isJsonObject()) {
                            JsonObject childJsonObject = e.getAsJsonObject();
                            PO childPO = childSerializer.fromJson(childJsonObject, childTable, finalChildView);
                            if (!RestUtils.hasRoleUpdateAccess(childPO.getAD_Client_ID(), childPO.getAD_Org_ID(), childPO.get_Table_ID(), 0, true)) {
                                throw new AdempiereException("AccessCannotUpdate");
                            }
                            childPO.set_TrxName(trx.getTrxName());
                            childPO.set_ValueOfColumn(RestUtils.getKeyColumnName(po.get_TableName()), (Object)po.get_ID());
                            this.fireRestSaveEvent(childPO, PO_BEFORE_REST_SAVE, true);
                            if (!childPO.validForeignKeys()) {
                                String msg = CLogger.retrieveErrorString((String)"Foreign key validation error");
                                throw new AdempiereException(msg);
                            }
                            childPO.saveEx();
                            this.fireRestSaveEvent(childPO, PO_AFTER_REST_SAVE, true);
                            childJsonObject = childSerializer.toJson(childPO, finalChildView);
                            JsonObject newChildJsonObject = e.getAsJsonObject();
                            LinkedHashMap<String, JsonArray> childDetailMap = new LinkedHashMap<String, JsonArray>();
                            Set fields = newChildJsonObject.keySet();
                            for (String childField : fields) {
                                String strError = this.createChild(childField, newChildJsonObject, childPO, finalChildView, childDetailMap, trx);
                                if (strError == null) continue;
                                throw new AdempiereException(strError);
                            }
                            if (childDetailMap.size() > 0) {
                                for (String tableName : childDetailMap.keySet()) {
                                    JsonArray childArray = (JsonArray)childDetailMap.get(tableName);
                                    childJsonObject.add(tableName, (JsonElement)childArray);
                                }
                            }
                            savedArray.add((JsonElement)childJsonObject);
                            StringBuilder processMsg = new StringBuilder();
                            String processError = this.runDocAction(childPO, newChildJsonObject, processMsg);
                            if (processError != null) {
                                throw new AdempiereException(processError + " - " + String.valueOf(processMsg) != null ? processMsg.toString() : "");
                            }
                        }
                    });
                    if (savedArray.size() > 0) {
                        detailMap.put(field, savedArray);
                    }
                }
                catch (Exception ex) {
                    trx.rollback();
                    log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
                    return ex.getMessage();
                }
            }
        }
        return null;
    }

    @Override
    public Response update(String name, String id, String jsonText) {
        String tableName;
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(name);
            if (view != null) {
                name = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + name, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if (!(poParser = new POParser(tableName = name, id, true, true)).isValidPO()) {
            return poParser.getResponseError();
        }
        PO po = poParser.getPO();
        if (!RestUtils.hasRoleUpdateAccess(po.getAD_Client_ID(), po.getAD_Org_ID(), po.get_Table_ID(), po.get_ID(), false)) {
            return ResponseUtils.getResponseError(Response.Status.FORBIDDEN, "Update error", "Role does not have access", "");
        }
        try (Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);){
            trx.start();
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
            IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, MTable.getClass((String)tableName));
            po = serializer.fromJson(jsonObject, po, view);
            po.set_TrxName(trx.getTrxName());
            this.fireRestSaveEvent(po, PO_BEFORE_REST_SAVE, false);
            try {
                if (!po.validForeignKeys()) {
                    String msg = CLogger.retrieveErrorString((String)"Foreign key validation error");
                    throw new AdempiereException(msg);
                }
                po.saveEx();
                this.fireRestSaveEvent(po, PO_AFTER_REST_SAVE, false);
            }
            catch (Exception ex) {
                trx.rollback();
                Response response = ResponseUtils.getResponseErrorFromException(ex, "Save error");
                trx.close();
                return response;
            }
            LinkedHashMap<String, JsonArray> detailMap = new LinkedHashMap<String, JsonArray>();
            Set fields = jsonObject.keySet();
            int parentId = po.get_ID();
            for (String field : fields) {
                JsonElement fieldElement = jsonObject.get(field);
                if (fieldElement == null || !fieldElement.isJsonArray()) continue;
                X_REST_View childView = null;
                if (view != null) {
                    MRestViewRelated[] relateds;
                    MRestViewRelated[] mRestViewRelatedArray = relateds = view.getRelatedViews();
                    int n = relateds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MRestViewRelated related = mRestViewRelatedArray[n2];
                        MRestView relatedView = new MRestView(Env.getCtx(), related.getREST_RelatedRestView_ID(), null);
                        String tName = MTable.getTableName((Properties)Env.getCtx(), (int)relatedView.getAD_Table_ID());
                        if (related.getName().equals(field)) {
                            childView = relatedView;
                            break;
                        }
                        if (tName.equals(field)) {
                            childView = relatedView;
                            break;
                        }
                        ++n2;
                    }
                    if (childView == null) continue;
                }
                String childTableName = childView != null ? MTable.getTableName((Properties)Env.getCtx(), (int)childView.getAD_Table_ID()) : field;
                MTable childTable = MTable.get((Properties)Env.getCtx(), (String)childTableName);
                if (!RestUtils.isValidDetailTable(childTable, RestUtils.getKeyColumnName(po.get_TableName()))) {
                    throw new IDempiereRestException("Wrong detail", "Cannot create/update detail records for the table because it has no column that links to the parent table: " + childTableName, Response.Status.INTERNAL_SERVER_ERROR);
                }
                if (childTable == null || childTable.getAD_Table_ID() <= 0) continue;
                IPOSerializer childSerializer = IPOSerializer.getPOSerializer(childTableName, MTable.getClass((String)childTableName));
                JsonArray fieldArray = fieldElement.getAsJsonArray();
                JsonArray savedArray = new JsonArray();
                X_REST_View finalChildView = childView;
                try {
                    fieldArray.forEach(arg_0 -> this.lambda$1(childTableName, childSerializer, childTable, (MRestView)finalChildView, tableName, parentId, trx, serializer, savedArray, arg_0));
                    if (savedArray.size() <= 0) continue;
                    detailMap.put(field, savedArray);
                }
                catch (Exception ex) {
                    trx.rollback();
                    Response response = ResponseUtils.getResponseErrorFromException(ex, "Save error");
                    trx.close();
                    return response;
                }
            }
            StringBuilder processMsg = new StringBuilder();
            String error = this.runDocAction(po, jsonObject, processMsg);
            if (!Util.isEmpty((String)error, (boolean)true)) {
                trx.rollback();
                log.warning("Encounter exception during execution of document action in REST: " + error);
                Response response = ResponseUtils.getResponseError(Response.Status.INTERNAL_SERVER_ERROR, Msg.getMsg((Properties)po.getCtx(), (String)"FailedProcessingDocument"), error, "");
                return response;
            }
            trx.commit(true);
            po.load(trx.getTrxName(), new String[0]);
            jsonObject = serializer.toJson(po, view);
            if (processMsg.length() > 0) {
                jsonObject.addProperty("doc-processmsg", processMsg.toString());
            }
            if (detailMap.size() > 0) {
                for (String field : detailMap.keySet()) {
                    JsonArray child = (JsonArray)detailMap.get(field);
                    jsonObject.add(field, (JsonElement)child);
                }
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)jsonObject.toString()).build();
            return response;
        }
    }

    private void fireRestSaveEvent(PO po, String topic, boolean isNew) {
        Event event = EventManager.newEvent((String)topic, (EventProperty[])new EventProperty[]{new EventProperty("event.data", (Object)po), new EventProperty("tableName", (Object)po.get_TableName()), new EventProperty("isNew", (Object)isNew)});
        EventManager.getInstance().sendEvent(event);
        List errors = (List)event.getProperty("event.errorMessages");
        if (errors != null && !errors.isEmpty()) {
            throw new AdempiereException((String)errors.get(0));
        }
    }

    @Override
    public Response delete(String tableName, String id) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, true)).isValidPO()) {
            PO po = poParser.getPO();
            if (!RestUtils.hasRoleUpdateAccess(po.getAD_Client_ID(), po.getAD_Org_ID(), po.get_Table_ID(), 0, true)) {
                return ResponseUtils.getResponseError(Response.Status.FORBIDDEN, "Delete error", "AccessCannotDelete", "");
            }
            try {
                po.deleteEx(true);
                JsonObject json = new JsonObject();
                json.addProperty("msg", Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted"));
                return Response.ok((Object)json.toString()).build();
            }
            catch (Exception ex) {
                return ResponseUtils.getResponseErrorFromException(ex, "Delete error");
            }
        }
        return poParser.getResponseError();
    }

    @Override
    public Response getAttachments(String tableName, String id) {
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        JsonArray array = new JsonArray();
        POParser poParser = new POParser(tableName, id, true, false);
        if (poParser.isValidPO()) {
            PO po = poParser.getPO();
            MAttachment attachment = po.getAttachment();
            if (attachment != null) {
                MAttachmentEntry[] mAttachmentEntryArray = attachment.getEntries();
                int n = mAttachmentEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MAttachmentEntry entry = mAttachmentEntryArray[n2];
                    JsonObject entryJsonObject = new JsonObject();
                    entryJsonObject.addProperty("name", entry.getName());
                    if (!Util.isEmpty((String)entry.getContentType(), (boolean)true)) {
                        entryJsonObject.addProperty("contentType", entry.getContentType());
                    }
                    array.add((JsonElement)entryJsonObject);
                    ++n2;
                }
            }
            JsonObject json = new JsonObject();
            json.add("attachments", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        return poParser.getResponseError();
    }

    @Override
    public Response getAttachmentsAsZip(String tableName, String id, String asJson) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            MAttachment attachment = po.getAttachment();
            if (attachment != null) {
                try {
                    File zipFile = attachment.saveAsZip();
                    if (zipFile != null) {
                        if (asJson == null) {
                            FileStreamingOutput fso = new FileStreamingOutput(zipFile);
                            return Response.ok((Object)fso).build();
                        }
                        JsonObject json = new JsonObject();
                        byte[] binaryData = Files.readAllBytes(zipFile.toPath());
                        String data = Base64.getEncoder().encodeToString(binaryData);
                        json.addProperty("data", data);
                        return Response.ok((Object)json.toString()).build();
                    }
                }
                catch (IOException ex) {
                    return ResponseUtils.getResponseErrorFromException(ex, "IO error");
                }
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return poParser.getResponseError();
    }

    @Override
    public Response createAttachmentsFromZip(String tableName, String id, String jsonText) {
        POParser poParser;
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        boolean overwrite = false;
        JsonElement jsonElement = jsonObject.get("overwrite");
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            overwrite = jsonElement.getAsBoolean();
        }
        if ((jsonElement = jsonObject.get("data")) == null || !jsonElement.isJsonPrimitive()) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "data property is mandatory", "", "");
        }
        String base64Content = jsonElement.getAsString();
        if (Util.isEmpty((String)base64Content, (boolean)true)) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "data property is mandatory", "", "");
        }
        MRestView view = RestUtils.getView(tableName);
        if (view != null) {
            tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            byte[] data = DatatypeConverter.parseBase64Binary((String)base64Content);
            if (data == null || data.length == 0) {
                return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "Can't parse data", "Can't parse data in Json content, not base64 encoded", "");
            }
            MAttachment attachment = po.getAttachment();
            if (attachment == null) {
                attachment = po.createAttachment();
            }
            try {
                Throwable throwable = null;
                Object var15_17 = null;
                try (ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(data));){
                    ZipEntry entry;
                    while ((entry = stream.getNextEntry()) != null) {
                        int len;
                        String name = entry.getName();
                        int i = 0;
                        while (i < attachment.getEntryCount()) {
                            MAttachmentEntry e = attachment.getEntry(i);
                            if (e.getName().equals(name)) {
                                if (overwrite) {
                                    attachment.deleteEntry(i);
                                    break;
                                }
                                return ResponseUtils.getResponseError(Response.Status.CONFLICT, "Duplicate file name", "Duplicate file name: ", name);
                            }
                            ++i;
                        }
                        byte[] buffer = new byte[2048];
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        while ((len = stream.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                        attachment.addEntry(name, bos.toByteArray());
                    }
                    attachment.saveEx();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                return ResponseUtils.getResponseErrorFromException(ex, "Create attachment error");
            }
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return poParser.getResponseError();
    }

    @Override
    public Response getAttachmentEntry(String tableName, String id, String fileName, String asJson) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            MAttachment attachment = po.getAttachment();
            if (attachment != null) {
                MAttachmentEntry[] mAttachmentEntryArray = attachment.getEntries();
                int n = mAttachmentEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MAttachmentEntry entry = mAttachmentEntryArray[n2];
                    if (entry.getName().equals(fileName)) {
                        try {
                            Path tempPath = Files.createTempDirectory(tableName, new FileAttribute[0]);
                            File tempFolder = tempPath.toFile();
                            File zipFile = new File(tempFolder, fileName);
                            zipFile = entry.getFile(zipFile);
                            if (asJson == null) {
                                FileStreamingOutput fso = new FileStreamingOutput(zipFile);
                                String contentType = MimeType.getMimeType((String)zipFile.getName());
                                return Response.ok((Object)fso).header("Content-Type", (Object)contentType).build();
                            }
                            JsonObject json = new JsonObject();
                            byte[] binaryData = Files.readAllBytes(zipFile.toPath());
                            String data = Base64.getEncoder().encodeToString(binaryData);
                            json.addProperty("data", data);
                            return Response.ok((Object)json.toString()).build();
                        }
                        catch (IOException ex) {
                            return ResponseUtils.getResponseErrorFromException(ex, "IO error");
                        }
                    }
                    ++n2;
                }
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return poParser.getResponseError();
    }

    @Override
    public Response addAttachmentEntry(String tableName, String id, String jsonText) {
        POParser poParser;
        MRestView view;
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        JsonElement jsonElement = jsonObject.get("name");
        if (jsonElement == null || !jsonElement.isJsonPrimitive()) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "name property is mandatory", "", "");
        }
        String fileName = jsonElement.getAsString();
        if (Util.isEmpty((String)fileName, (boolean)true)) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "name property is mandatory", "", "");
        }
        jsonElement = jsonObject.get("data");
        if (jsonElement == null || !jsonElement.isJsonPrimitive()) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "data property is mandatory", "", "");
        }
        String base64Content = jsonElement.getAsString();
        if (Util.isEmpty((String)base64Content, (boolean)true)) {
            return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "data property is mandatory", "", "");
        }
        boolean overwrite = false;
        jsonElement = jsonObject.get("overwrite");
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            overwrite = jsonElement.getAsBoolean();
        }
        if ((view = RestUtils.getView(tableName)) != null) {
            tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            byte[] data = DatatypeConverter.parseBase64Binary((String)base64Content);
            if (data == null || data.length == 0) {
                return ResponseUtils.getResponseError(Response.Status.BAD_REQUEST, "Can't parse data", "Can't parse data in Json content, not base64 encoded", "");
            }
            MAttachment attachment = po.getAttachment();
            if (attachment == null) {
                attachment = po.createAttachment();
            }
            int i = 0;
            while (i < attachment.getEntryCount()) {
                MAttachmentEntry entry = attachment.getEntry(i);
                if (entry.getName().equals(fileName)) {
                    if (overwrite) {
                        attachment.deleteEntry(i);
                        break;
                    }
                    return ResponseUtils.getResponseError(Response.Status.CONFLICT, "Duplicate file name", "Duplicate file name: ", fileName);
                }
                ++i;
            }
            try {
                attachment.addEntry(fileName, data);
                attachment.saveEx();
            }
            catch (Exception ex) {
                return ResponseUtils.getResponseErrorFromException(ex, "Save error");
            }
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return poParser.getResponseError();
    }

    @Override
    public Response deleteAttachments(String tableName, String id) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            MAttachment attachment = po.getAttachment();
            if (attachment != null) {
                try {
                    attachment.deleteEx(true);
                }
                catch (Exception ex) {
                    return ResponseUtils.getResponseErrorFromException(ex, "Delete error");
                }
                JsonObject json = new JsonObject();
                json.addProperty("msg", Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted"));
                return Response.ok((Object)json.toString()).build();
            }
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "No attachments", "No attachment is found for record with id ", id);
        }
        return poParser.getResponseError();
    }

    @Override
    public Response deleteAttachmentEntry(String tableName, String id, String fileName) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            MAttachment attachment = po.getAttachment();
            if (attachment != null) {
                int i = 0;
                MAttachmentEntry[] mAttachmentEntryArray = attachment.getEntries();
                int n = mAttachmentEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MAttachmentEntry entry = mAttachmentEntryArray[n2];
                    if (entry.getName().equals(fileName)) {
                        if (attachment.deleteEntry(i)) {
                            try {
                                attachment.saveEx();
                            }
                            catch (Exception ex) {
                                return ResponseUtils.getResponseErrorFromException(ex, "Delete error");
                            }
                            JsonObject json = new JsonObject();
                            json.addProperty("msg", Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted"));
                            return Response.ok((Object)json.toString()).build();
                        }
                        return ResponseUtils.getResponseError(Response.Status.INTERNAL_SERVER_ERROR, "Fail to remove attachment entry", "", "");
                    }
                    ++i;
                    ++n2;
                }
                return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "No matching attachment entry", "No attachment entry is found for name ", fileName);
            }
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "No attachments", "No attachment is found for record with id ", id);
        }
        return poParser.getResponseError();
    }

    @Override
    public Response printModelRecord(String tableName, String id, String reportType) {
        POParser poParser;
        MRestView view = null;
        if (this.useRestView) {
            view = RestUtils.getView(tableName);
            if (view != null) {
                tableName = MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID());
            } else {
                return ResponseUtils.getResponseErrorFromException((Exception)((Object)new IDempiereRestException("Invalid rest view name", "No match found for rest view name: " + tableName, Response.Status.NOT_FOUND)), "Not found");
            }
        }
        if ((poParser = new POParser(tableName, id, true, false)).isValidPO()) {
            PO po = poParser.getPO();
            try {
                MTable table = RestUtils.getTableAndCheckAccess(tableName, false);
                int windowId = Env.getZoomWindowID((int)table.get_ID(), (int)po.get_ID());
                if (windowId == 0) {
                    return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Window not found", "No valid window found for table name: ", tableName);
                }
                MWindow window = MWindow.get((Properties)Env.getCtx(), (int)windowId);
                String windowSlug = TypeConverterUtils.slugify(window.getName());
                WindowResourceImpl windowResource = new WindowResourceImpl();
                return windowResource.printWindowRecord(windowSlug, po.get_ID(), reportType);
            }
            catch (Exception ex) {
                return ResponseUtils.getResponseErrorFromException(ex, "Print model error");
            }
        }
        return poParser.getResponseError();
    }

    private PO loadPO(String tableName, JsonObject jsonObject) {
        PO po = null;
        String idColumn = RestUtils.getKeyColumnName(tableName);
        String uidColumn = PO.getUUIDColumnName((String)tableName);
        JsonElement idElement = jsonObject.get("id");
        if (idElement != null && idElement.isJsonPrimitive()) {
            Query query = new Query(Env.getCtx(), tableName, idColumn + "=?", null);
            query.setApplyAccessFilter(true, false);
            po = query.setParameters(new Object[]{idElement.getAsInt()}).first();
        } else {
            JsonElement uidElement = jsonObject.get("uid");
            if (uidElement != null && uidElement.isJsonPrimitive()) {
                Query query = new Query(Env.getCtx(), tableName, uidColumn + "=?", null);
                query.setApplyAccessFilter(true, false);
                po = query.setParameters(new Object[]{uidElement.getAsString()}).first();
            }
        }
        return po;
    }

    private String runDocAction(PO po, JsonObject jsonObject, StringBuilder processMsg) {
        JsonElement docActionElement;
        if (po instanceof DocAction && (docActionElement = jsonObject.get("doc-action")) != null) {
            JsonObject docActionJsonObject;
            String docAction = null;
            if (docActionElement.isJsonPrimitive()) {
                docAction = docActionElement.getAsString();
            } else if (docActionElement.isJsonObject() && (docActionElement = (docActionJsonObject = docActionElement.getAsJsonObject()).get("id")) != null && docActionElement.isJsonPrimitive()) {
                docAction = docActionElement.getAsString();
            }
            if (!Util.isEmpty((String)docAction, (boolean)true) && !"--".equals(docAction)) {
                ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow((PO)po, (String)docAction);
                if (processInfo.isError()) {
                    return Msg.parseTranslation((Properties)po.getCtx(), (String)processInfo.getSummary());
                }
                try {
                    po.saveEx();
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
                    return ex.getMessage();
                }
                String pMsg = Msg.parseTranslation((Properties)po.getCtx(), (String)((DocAction)po).getProcessMsg());
                processMsg.append(pMsg);
            }
        }
        return null;
    }

    @Override
    public Response getModelYAML(String tableName) {
        MTable table = RestUtils.getTableAndCheckAccess(tableName, false);
        tableName = table.getTableName();
        StringBuilder header = new StringBuilder();
        header.append("openapi: 3.0.0\n");
        header.append("info:\n");
        header.append(" ".repeat(2)).append("title: models/").append(tableName).append("\n");
        header.append(" ".repeat(2)).append("version: 1.0.0\n");
        YAMLSchema.addServers(header);
        header.append("components:\n");
        YAMLSchema.addSecuritySchema(header);
        YAMLSchema.addPredefinedParameters(header);
        header.append(" ".repeat(2)).append("schemas:\n");
        StringBuilder body = new StringBuilder();
        this.buildYAMLForTable(table, body);
        YAMLSchema.addErrorResponseReference(header);
        if (body.indexOf("#/components/schemas/Image") > 0) {
            YAMLSchema.addImageReference(header);
        }
        if (body.indexOf("#/components/schemas/Location") > 0) {
            YAMLSchema.addLocationReference(header, 4);
        }
        YAMLSchema.addSecurityHeader(body);
        body.append("paths:\n");
        YAMLSchema.addAuthRequest(body);
        YAMLSchema.addModelRequest(tableName, false, body);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)header.append(body.toString()).toString()).build();
    }

    private void buildYAMLForTable(MTable table, StringBuilder builder) {
        builder.append(" ".repeat(4)).append(table.getTableName()).append(":\n");
        builder.append(" ".repeat(6)).append("type: object\n");
        builder.append(" ".repeat(6)).append("properties:\n");
        builder.append(" ".repeat(8)).append("id:\n");
        builder.append(" ".repeat(10)).append("type: integer\n");
        builder.append(" ".repeat(10)).append("readOnly: true\n");
        builder.append(" ".repeat(10)).append("description: record id\n");
        builder.append(" ".repeat(8)).append("uid:\n");
        builder.append(" ".repeat(10)).append("type: string\n");
        builder.append(" ".repeat(10)).append("readOnly: true\n");
        builder.append(" ".repeat(10)).append("description: record uuid\n");
        YAMLSchema.addTableProperties(table, builder, 8);
    }

    private /* synthetic */ void lambda$1(String string, IPOSerializer iPOSerializer, MTable mTable, MRestView mRestView, String string2, int n, Trx trx, IPOSerializer iPOSerializer2, JsonArray jsonArray, JsonElement e) {
        if (e.isJsonObject()) {
            JsonObject childJsonObject = e.getAsJsonObject();
            PO childPO = this.loadPO(string, childJsonObject);
            if (childPO == null) {
                childPO = iPOSerializer.fromJson(childJsonObject, mTable, mRestView);
                childPO.set_ValueOfColumn(RestUtils.getKeyColumnName(string2), (Object)n);
            } else {
                childPO = iPOSerializer.fromJson(childJsonObject, childPO, mRestView);
            }
            childPO.set_TrxName(trx.getTrxName());
            this.fireRestSaveEvent(childPO, PO_BEFORE_REST_SAVE, false);
            if (!childPO.validForeignKeys()) {
                String msg = CLogger.retrieveErrorString((String)"Foreign key validation error");
                throw new AdempiereException(msg);
            }
            childPO.saveEx();
            this.fireRestSaveEvent(childPO, PO_AFTER_REST_SAVE, false);
            childJsonObject = iPOSerializer2.toJson(childPO, mRestView);
            jsonArray.add((JsonElement)childJsonObject);
        }
    }
}

