/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="v1/windows")
public interface WindowResource {
    @GET
    @Produces(value={"application/json"})
    public Response getWindows(@QueryParam(value="$filter") String var1, @QueryParam(value="$expand") String var2, @QueryParam(value="$select") String var3);

    @Path(value="{windowSlug}/tabs")
    @GET
    @Produces(value={"application/json"})
    public Response getTabs(@PathParam(value="windowSlug") String var1);

    @Path(value="{windowSlug}/tabs/{tabSlug}/fields")
    @GET
    @Produces(value={"application/json"})
    public Response getTabFields(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @QueryParam(value="$filter") String var3);

    @Path(value="{windowSlug}")
    @GET
    @Produces(value={"application/json"})
    public Response getWindowRecords(@PathParam(value="windowSlug") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$sort_column") String var3, @QueryParam(value="$page_no") int var4);

    @Path(value="{windowSlug}/{recordId}")
    @GET
    @Produces(value={"application/json"})
    public Response getWindowRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="recordId") int var2, @QueryParam(value="$expand") String var3);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}/{childTabSlug}")
    @GET
    @Produces(value={"application/json"})
    public Response getChildTabRecords(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3, @PathParam(value="childTabSlug") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$sort_column") String var6, @QueryParam(value="$page_no") int var7);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}")
    @GET
    @Produces(value={"application/json"})
    public Response getTabRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3, @QueryParam(value="$expand") String var4);

    @Path(value="{windowSlug}/{recordId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWindowRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="recordId") int var2, String var3);

    @Path(value="{windowSlug}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createWindowRecord(@PathParam(value="windowSlug") String var1, String var2);

    @Path(value="{windowSlug}/{recordId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteWindowRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="recordId") int var2);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTabRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3, String var4);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}/{childTabSlug}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createChildTabRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3, @PathParam(value="childTabSlug") String var4, String var5);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteTabRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3);

    @Path(value="{windowSlug}/{recordId}/print")
    @GET
    @Produces(value={"application/json"})
    public Response printWindowRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="recordId") int var2, @QueryParam(value="$report_type") String var3);

    @Path(value="{windowSlug}/tabs/{tabSlug}/{recordId}/print")
    @GET
    @Produces(value={"application/json"})
    public Response printTabRecord(@PathParam(value="windowSlug") String var1, @PathParam(value="tabSlug") String var2, @PathParam(value="recordId") int var3, @QueryParam(value="$report_type") String var4);
}

