/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.IPOSerializerFactory;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(name="com.trekglobal.idempiere.rest.api.json.DefaultPOSerializer", service={IPOSerializerFactory.class}, property={"service.ranking:Integer=0"}, immediate=true)
public class DefaultPOSerializer
implements IPOSerializer,
IPOSerializerFactory {
    static final List<String> ALLOWED_EXTRA_COLUMNS = new ArrayList<String>(List.of("doc-action", "id", "identifier", "model-name", "tableName", "uid"));

    @Override
    public JsonObject toJson(PO po, String[] includes, String[] excludes) {
        return this.toJson(po, null, includes, excludes);
    }

    @Override
    public JsonObject toJson(PO po, MRestView view, String[] includes, String[] excludes) {
        String uid;
        String uidColumn;
        JsonObject json = new JsonObject();
        String[] keyColumns = po.get_KeyColumns();
        String keyColumn = null;
        if (keyColumns != null && keyColumns.length == 1) {
            json.addProperty("id", (Number)po.get_ID());
            keyColumn = keyColumns[0];
        }
        if (po.get_ColumnIndex(uidColumn = po.getUUIDColumnName()) >= 0 && !Util.isEmpty((String)(uid = po.get_ValueAsString(uidColumn)), (boolean)true)) {
            json.addProperty("uid", uid);
        }
        MRestViewColumn[] viewColumns = view != null ? view.getColumns() : null;
        POInfo poInfo = POInfo.getPOInfo((Properties)Env.getCtx(), (int)po.get_Table_ID());
        int count = view != null ? viewColumns.length : poInfo.getColumnCount();
        int i = 0;
        while (i < count) {
            block18: {
                Object value;
                MRestViewColumn viewColumn;
                MColumn column;
                String columnName;
                block19: {
                    String string = columnName = view != null ? MColumn.getColumnName((Properties)Env.getCtx(), (int)viewColumns[i].getAD_Column_ID()) : poInfo.getColumnName(i);
                    if (keyColumn != null && keyColumn.equalsIgnoreCase(columnName) || uidColumn != null && uidColumn.equalsIgnoreCase(columnName) || !this.include(columnName, includes) || this.exclude(columnName, excludes)) break block18;
                    int columnId = view != null ? viewColumns[i].getAD_Column_ID() : poInfo.getAD_Column_ID(columnName);
                    column = MColumn.get((Properties)Env.getCtx(), (int)columnId);
                    if (column.isSecure() || column.isEncrypted() || !RestUtils.hasRoleColumnAccess(po.get_Table_ID(), column.getAD_Column_ID(), true)) break block18;
                    viewColumn = null;
                    if (viewColumns == null) break block19;
                    Optional<MRestViewColumn> optional = Arrays.stream(viewColumns).filter(e -> e.getAD_Column_ID() == column.getAD_Column_ID()).findFirst();
                    if (!optional.isPresent()) break block18;
                    viewColumn = optional.get();
                }
                if ((value = column.isTranslated() ? po.get_Translation(column.getColumnName()) : po.get_Value(column.getColumnName())) != null) {
                    String propertyName = viewColumn != null ? viewColumn.getName() : (MSysConfig.getBooleanValue((String)"REST_COLUMNNAME_TOLOWERCASE", (boolean)false) ? TypeConverterUtils.toPropertyName(columnName) : columnName);
                    Object jsonValue = TypeConverterUtils.toJsonValue(column, value, viewColumn != null && viewColumn.getREST_ReferenceView_ID() > 0 ? MRestView.get(viewColumn.getREST_ReferenceView_ID()) : null);
                    if (jsonValue != null) {
                        if (jsonValue instanceof Number) {
                            json.addProperty(propertyName, (Number)jsonValue);
                        } else if (jsonValue instanceof Boolean) {
                            json.addProperty(propertyName, (Boolean)jsonValue);
                        } else if (jsonValue instanceof String) {
                            json.addProperty(propertyName, (String)jsonValue);
                        } else if (jsonValue instanceof JsonElement) {
                            json.add(propertyName, (JsonElement)jsonValue);
                        } else {
                            json.addProperty(propertyName, jsonValue.toString());
                        }
                    }
                }
            }
            ++i;
        }
        if (!this.exclude("model-name", excludes)) {
            json.addProperty("model-name", poInfo.getTableName().toLowerCase());
            if (view != null) {
                json.addProperty("view-name", view.getName());
            }
        }
        return json;
    }

    @Override
    public PO fromJson(JsonObject json, MTable table) {
        return this.fromJson(json, table, null);
    }

    @Override
    public PO fromJson(JsonObject json, MTable table, MRestView view) {
        PO po = table.getPO(0, null);
        POInfo poInfo = POInfo.getPOInfo((Properties)Env.getCtx(), (int)table.getAD_Table_ID());
        DefaultPOSerializer.validateJsonFields(json, po, view);
        Set jsonFields = json.keySet();
        MRestViewColumn[] viewColumns = view != null ? view.getColumns() : null;
        int count = view != null ? viewColumns.length : poInfo.getColumnCount();
        int i = 0;
        while (i < count) {
            MRestViewColumn viewColumn = viewColumns != null ? viewColumns[i] : null;
            String columnName = viewColumn != null ? MColumn.getColumnName((Properties)Env.getCtx(), (int)viewColumn.getAD_Column_ID()) : poInfo.getColumnName(i);
            MColumn column = table.getColumn(columnName);
            String propertyName = null;
            propertyName = viewColumns != null ? viewColumns[i].getName() : TypeConverterUtils.toPropertyName(columnName);
            if (!jsonFields.contains(propertyName) && !jsonFields.contains(columnName)) {
                this.setDefaultValue(po, column);
            } else {
                JsonElement field = json.get(propertyName);
                if (field == null) {
                    field = json.get(columnName);
                }
                if (field == null) {
                    this.setDefaultValue(po, column);
                } else {
                    Object value = TypeConverterUtils.fromJsonValue(column, field, viewColumn != null && viewColumn.getREST_ReferenceView_ID() > 0 ? MRestView.get(viewColumn.getREST_ReferenceView_ID()) : null);
                    if (DefaultPOSerializer.isValueUpdated(po.get_ValueOfColumn(column.getAD_Column_ID()), value) && DefaultPOSerializer.isUpdatable(column, false, po)) {
                        if (value != null && value instanceof Integer) {
                            if ((Integer)value < 0 && DisplayType.isID((int)column.getAD_Reference_ID())) {
                                value = null;
                            } else if ((Integer)value == 0 && DisplayType.isLookup((int)column.getAD_Reference_ID()) && !MTable.isZeroIDTable((String)column.getReferenceTableName())) {
                                value = null;
                            }
                        }
                        po.set_ValueOfColumn(column.getAD_Column_ID(), value);
                    }
                }
            }
            ++i;
        }
        return po;
    }

    @Override
    public PO fromJson(JsonObject json, PO po) {
        return this.fromJson(json, po, null);
    }

    @Override
    public PO fromJson(JsonObject json, PO po, MRestView view) {
        MTable table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
        POInfo poInfo = POInfo.getPOInfo((Properties)Env.getCtx(), (int)table.getAD_Table_ID());
        DefaultPOSerializer.validateJsonFields(json, po, view);
        Set jsonFields = json.keySet();
        MRestViewColumn[] viewColumns = view != null ? view.getColumns() : null;
        int count = view != null ? viewColumns.length : poInfo.getColumnCount();
        int i = 0;
        while (i < count) {
            String columnName = viewColumns != null ? MColumn.getColumnName((Properties)Env.getCtx(), (int)viewColumns[i].getAD_Column_ID()) : poInfo.getColumnName(i);
            MColumn column = table.getColumn(columnName);
            String propertyName = null;
            propertyName = viewColumns != null ? viewColumns[i].getName() : TypeConverterUtils.toPropertyName(columnName);
            if (jsonFields.contains(propertyName) || jsonFields.contains(columnName)) {
                JsonElement field = json.get(propertyName);
                if (field == null) {
                    field = json.get(columnName);
                }
                if (field != null) {
                    Object value = TypeConverterUtils.fromJsonValue(column, field);
                    if (DefaultPOSerializer.isValueUpdated(po.get_ValueOfColumn(column.getAD_Column_ID()), value) && DefaultPOSerializer.isUpdatable(column, true, po)) {
                        if (value != null && value instanceof Integer) {
                            if ((Integer)value < 0 && DisplayType.isID((int)column.getAD_Reference_ID())) {
                                value = null;
                            } else if ((Integer)value == 0 && DisplayType.isLookup((int)column.getAD_Reference_ID()) && !MTable.isZeroIDTable((String)column.getReferenceTableName())) {
                                value = null;
                            }
                        }
                        po.set_ValueOfColumn(column.getAD_Column_ID(), value);
                    }
                }
            }
            ++i;
        }
        return po;
    }

    public static boolean isValueUpdated(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue != null && newValue != null) {
            if (oldValue.getClass().equals(newValue.getClass()) && oldValue.equals(newValue)) {
                return false;
            }
            if (oldValue instanceof Integer && newValue instanceof BigDecimal && ((BigDecimal)newValue).intValue() == Integer.valueOf((Integer)oldValue).intValue()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isUpdatable(MColumn column, boolean validateUpdateable, PO po) {
        boolean errorOnNonUpdatable = MSysConfig.getBooleanValue((String)"REST_ERROR_ON_NON_UPDATABLE_COLUMN", (boolean)true);
        if (validateUpdateable && !column.isUpdateable()) {
            if (errorOnNonUpdatable) {
                throw new AdempiereException("Cannot update column " + column.getColumnName());
            }
            return false;
        }
        if (column.isVirtualColumn()) {
            if (errorOnNonUpdatable) {
                throw new AdempiereException("Cannot update virtual column " + column.getColumnName());
            }
            return false;
        }
        boolean allowUpdateSecure = MSysConfig.getBooleanValue((String)"REST_ALLOW_UPDATE_SECURE_COLUMN", (boolean)true);
        if (!allowUpdateSecure && (column.isSecure() || column.isEncrypted())) {
            if (errorOnNonUpdatable) {
                throw new AdempiereException("Cannot update secure/encrypted column " + column.getColumnName());
            }
            return false;
        }
        if (!RestUtils.hasRoleColumnAccess(column.getAD_Table_ID(), column.getAD_Column_ID(), false)) {
            if (errorOnNonUpdatable) {
                throw new AdempiereException("No access to update column " + column.getColumnName());
            }
            return false;
        }
        if (!po.is_new()) {
            if (po.get_ColumnIndex("processed") >= 0 && po.get_ValueAsBoolean("processed") && !column.isAlwaysUpdateable()) {
                if (errorOnNonUpdatable) {
                    throw new AdempiereException("Cannot update " + column.getColumnName() + " on processed record");
                }
                return false;
            }
            if (po.get_ColumnIndex("posted") >= 0 && po.get_ValueAsBoolean("posted") && !column.isAlwaysUpdateable()) {
                if (errorOnNonUpdatable) {
                    throw new AdempiereException("Cannot update " + column.getColumnName() + " on posted record");
                }
                return false;
            }
        }
        return true;
    }

    public static void validateJsonFields(JsonObject json, PO po) {
        DefaultPOSerializer.validateJsonFields(json, po, null);
    }

    public static void validateJsonFields(JsonObject json, PO po, MRestView view) {
        boolean errorOnNonExisting = MSysConfig.getBooleanValue((String)"REST_ERROR_ON_NON_EXISTING_COLUMN", (boolean)true);
        Set jsonFields = json.keySet();
        if (errorOnNonExisting) {
            for (String jsonField : jsonFields) {
                String propertyName;
                JsonElement jsonObj;
                if (ALLOWED_EXTRA_COLUMNS.contains(jsonField) || (jsonObj = json.get(jsonField)) instanceof JsonArray) continue;
                String columnName = jsonField;
                if (view != null && (columnName = view.toColumnName(jsonField)) == null) {
                    Optional<MRestViewColumn> optional = Arrays.stream(view.getColumns()).filter(e -> e.getName().equalsIgnoreCase(jsonField)).findFirst();
                    if (optional.isPresent()) {
                        StringBuilder error = new StringBuilder("Wrong name for column ").append(jsonField).append(", you must use ").append(optional.get().getName());
                        throw new AdempiereException(error.toString());
                    }
                    throw new AdempiereException("Column " + jsonField + " does not exist");
                }
                int colIdx = po.get_ColumnIndex(columnName);
                if (colIdx < 0) {
                    throw new AdempiereException("Column " + jsonField + " does not exist");
                }
                columnName = po.get_ColumnName(colIdx);
                if (view != null || jsonField.equals(propertyName = TypeConverterUtils.toPropertyName(columnName)) || jsonField.equals(columnName)) continue;
                throw new AdempiereException("Wrong name for column " + jsonField + ", you must use " + propertyName + (String)(propertyName.equals(columnName) ? "" : " or " + columnName));
            }
        }
    }

    private boolean exclude(String columnName, String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return false;
        }
        String[] stringArray = excludes;
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (exclude.equals(columnName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean include(String columnName, String[] includes) {
        if (includes == null || includes.length == 0) {
            return true;
        }
        String[] stringArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            if (include.equalsIgnoreCase(columnName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setDefaultValue(PO po, MColumn column) {
        if (!column.isVirtualColumn() && !Util.isEmpty((String)column.getDefaultValue(), (boolean)true)) {
            GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)0, (int)0, (int)0, (int)column.getAD_Column_ID(), (String)column.getColumnName(), (String)column.getName(), (int)(DisplayType.isLookup((int)column.getAD_Reference_ID()) ? (DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) ? 10 : 13) : column.getAD_Reference_ID()), (int)0, (boolean)false, (boolean)false, (String)"");
            vo.DefaultValue = column.getDefaultValue();
            GridField gridField = new GridField(vo);
            Object defaultValue = gridField.getDefault();
            if (defaultValue != null) {
                po.set_ValueOfColumn(column.getAD_Column_ID(), defaultValue);
            }
        }
    }

    @Override
    public IPOSerializer getPOSerializer(String tableName, Class<?> modelClass) {
        if ("*".equals(tableName)) {
            return this;
        }
        return null;
    }
}

