/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MCountry;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUserPreference;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class RestUtils {
    private static final CLogger log = CLogger.getCLogger(RestUtils.class);
    private static final String UUID_REGEX = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final String EXPORT_UU_LOOKUP_SYSCONFIG_NAME = "REST_TABLES_EXPORT_LOOKUP_UU";
    private static CCache<Integer, Properties> ctxSessionCache = new CCache("REST_SessionCtxCache", 100, MSysConfig.getIntValue((String)"REST_TOKEN_EXPIRE_IN_MINUTES", (int)60, (int)Env.getAD_Client_ID((Properties)Env.getCtx())));

    public static boolean isUUID(String value) {
        return value == null ? false : value.matches(UUID_REGEX);
    }

    public static Query getQuery(String tableName, String recordID, boolean fullyQualified, boolean RW) {
        boolean isUUID = RestUtils.isUUID(recordID);
        String keyColumn = RestUtils.getKeyColumn(tableName, isUUID);
        Query query = new Query(Env.getCtx(), tableName, keyColumn + "=?", null);
        if (fullyQualified || RW) {
            query.setApplyAccessFilter(fullyQualified, RW);
        }
        if (isUUID) {
            query.setParameters(new Object[]{recordID});
        } else {
            query.setParameters(new Object[]{Util.isEmpty((String)recordID) ? null : Integer.valueOf(RestUtils.getIntegerValue(recordID))});
        }
        return query;
    }

    public static PO getPO(String tableName, String recordID, boolean fullyQualified, boolean RW) {
        return RestUtils.getQuery(tableName, recordID, fullyQualified, RW).first();
    }

    private static String getKeyColumn(String tableName, boolean isUUID) {
        return isUUID ? PO.getUUIDColumnName((String)tableName) : RestUtils.getKeyColumnName(tableName);
    }

    private static int getIntegerValue(String id) {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IDempiereRestException("Request Error", "Wrong ID " + id + " is not an UU value nor a valid integer ID", Response.Status.BAD_REQUEST);
        }
    }

    public static HashMap<String, ArrayList<String>> getIncludes(String tableName, String select, String details) {
        String[] columnNames;
        if (Util.isEmpty((String)select, (boolean)true) || Util.isEmpty((String)tableName, (boolean)true)) {
            return null;
        }
        HashMap<String, ArrayList<String>> tableSelect = new HashMap<String, ArrayList<String>>();
        boolean hasDetail = !Util.isEmpty((String)details, (boolean)true);
        MTable mTable = MTable.get((Properties)Env.getCtx(), (String)tableName);
        String[] stringArray = columnNames = select.split("[,]");
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            MTable table = mTable;
            if (hasDetail && columnName.contains("/")) {
                String selectTableName = columnName.substring(0, columnName.indexOf("/")).trim();
                if (details.toLowerCase().contains(selectTableName.toLowerCase())) {
                    table = MTable.get((Properties)Env.getCtx(), (String)selectTableName);
                    columnName = columnName.substring(columnName.indexOf("/") + 1, columnName.length());
                } else {
                    throw new IDempiereRestException(selectTableName + " does not make part of the request body.", Response.Status.BAD_REQUEST);
                }
            }
            if (table.getColumnIndex(columnName.trim()) < 0) {
                throw new IDempiereRestException(columnName + " is not a valid column of table " + table.getTableName(), Response.Status.BAD_REQUEST);
            }
            MColumn mColumn = table.getColumn(columnName.trim());
            if (MRole.getDefault().isColumnAccess(table.getAD_Table_ID(), mColumn.getAD_Column_ID(), true)) {
                if (tableSelect.get(table.getTableName()) == null) {
                    tableSelect.put(table.getTableName(), new ArrayList());
                }
                tableSelect.get(table.getTableName()).add(columnName.trim());
            }
            ++n2;
        }
        return tableSelect;
    }

    public static String[] getSelectedColumns(String tableName, String selectClause) {
        String[] columnNames;
        ArrayList<String> selectedColumns = new ArrayList<String>();
        if (Util.isEmpty((String)selectClause, (boolean)true) || Util.isEmpty((String)tableName, (boolean)true)) {
            return new String[0];
        }
        MTable mTable = MTable.get((Properties)Env.getCtx(), (String)tableName);
        String[] stringArray = columnNames = selectClause.split("[,]");
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            MTable table = mTable;
            String columnName = stringArray[n2];
            if (table.getColumnIndex(columnName.trim()) < 0) {
                throw new IDempiereRestException(columnName + " is not a valid column of table " + table.getTableName(), Response.Status.BAD_REQUEST);
            }
            MColumn mColumn = table.getColumn(columnName.trim());
            if (MRole.getDefault().isColumnAccess(table.getAD_Table_ID(), mColumn.getAD_Column_ID(), true)) {
                selectedColumns.add(columnName.trim());
            }
            ++n2;
        }
        return selectedColumns.toArray(new String[selectedColumns.size()]);
    }

    public static Query getQuery(String tableName, String whereClause, List<Object> params) {
        MTable table = RestUtils.getQueryTable(tableName);
        if (table != null && table.isView() && tableName.toLowerCase().endsWith("_v") && table.getTableName().toLowerCase().endsWith("_vt")) {
            if (!Util.isEmpty((String)whereClause)) {
                whereClause = (String)whereClause + " AND ";
            }
            whereClause = (String)whereClause + "AD_Language=?";
            params.add(Env.getAD_Language((Properties)Env.getCtx()));
        }
        Query query = new Query(Env.getCtx(), table, (String)whereClause, null).setApplyAccessFilter(true, false).setParameters(params);
        if (!((String)whereClause).toLowerCase().matches(".*\\bisactive\\b.*")) {
            query.setOnlyActiveRecords(true);
        }
        return query;
    }

    private static MTable getQueryTable(String tableName) {
        MTable trl_view;
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        boolean isBaseLanguage = Language.isBaseLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
        if (!isBaseLanguage && table != null && table.isView() && tableName.toLowerCase().endsWith("_v") && (trl_view = MTable.get((Properties)Env.getCtx(), (String)(tableName + "t"))) != null && trl_view.get_ColumnCount() > 0) {
            return trl_view;
        }
        return table;
    }

    public static MTable getTableAndCheckAccess(String tableName) {
        return RestUtils.getTableAndCheckAccess(tableName, false);
    }

    public static MTable getTableAndCheckAccess(String tableName, boolean isReadWrite) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        if (table == null || table.getAD_Table_ID() == 0) {
            throw new IDempiereRestException("Invalid table name", "No match found for table name: " + tableName, Response.Status.NOT_FOUND);
        }
        if (!RestUtils.hasAccess(table, isReadWrite)) {
            throw new IDempiereRestException("Access denied", "Access denied for table: " + tableName, Response.Status.FORBIDDEN);
        }
        return table;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAccess(MTable table, boolean isReadWrite) {
        boolean bl;
        MRole role = MRole.getDefault();
        if (role == null) {
            return false;
        }
        StringBuilder builder = new StringBuilder("SELECT DISTINCT a.AD_Window_ID FROM AD_Window a JOIN AD_Tab b ON a.AD_Window_ID=b.AD_Window_ID ");
        builder.append("WHERE a.IsActive='Y' AND b.IsActive='Y' AND b.AD_Table_ID=?");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)builder.toString(), null);){
                stmt.setInt(1, table.getAD_Table_ID());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    int windowId = rs.getInt(1);
                    Boolean hasReadWriteAccess = role.getWindowAccess(windowId);
                    if (hasReadWriteAccess == null) continue;
                    if (!isReadWrite) return true;
                    if (!hasReadWriteAccess.booleanValue()) continue;
                    return true;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        int n = table.getAD_Table_ID();
        if (isReadWrite) {
            bl = false;
            return role.isTableAccess(n, bl);
        }
        bl = true;
        return role.isTableAccess(n, bl);
    }

    public static boolean hasRoleUpdateAccess(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, int Record_ID, boolean isNew) {
        return MRole.getDefault((Properties)Env.getCtx(), (boolean)false).canUpdate(AD_Client_ID, AD_Org_ID, AD_Table_ID, Record_ID, isNew);
    }

    public static boolean hasRoleColumnAccess(int AD_Table_ID, int AD_Column_ID, boolean readOnly) {
        return MRole.getDefault((Properties)Env.getCtx(), (boolean)false).isColumnAccess(AD_Table_ID, AD_Column_ID, readOnly);
    }

    public static MRestView getView(String name) {
        MRestView view = MRestView.get(name);
        if (view == null || view.get_ID() == 0) {
            return null;
        }
        return view;
    }

    public static String getLinkKeyColumnName(String parentTable, String childTable) {
        block14: {
            String[] parentKeys;
            MColumn[] cColumns;
            MTable pTable;
            block13: {
                pTable = MTable.get((Properties)Env.getCtx(), (String)parentTable);
                MTable cTable = MTable.get((Properties)Env.getCtx(), (String)childTable);
                if (cTable == null || cTable.getAD_Table_ID() == 0) {
                    throw new IDempiereRestException("Invalid table name", "No match found for table name: " + childTable, Response.Status.NOT_FOUND);
                }
                cColumns = cTable.getColumns(false);
                parentKeys = pTable.getKeyColumns();
                if (pTable.getAD_Table_ID() == cTable.getAD_Table_ID()) {
                    if (cTable.getColumn("Parent_ID") != null) {
                        if (parentKeys.length == 2 && "AD_Tree_ID".equals(parentKeys[0]) && "Node_ID".equals(parentKeys[1])) {
                            return parentKeys[1] + ":Parent_ID";
                        }
                        return parentKeys[0] + ":Parent_ID";
                    }
                    MColumn[] mColumnArray = cColumns;
                    int n = cColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MColumn col = mColumnArray[n2];
                        if (!col.isKey() && col.getColumnName().endsWith("_ID") && parentTable.equalsIgnoreCase(col.getReferenceTableName())) {
                            return parentKeys[0] + ":" + col.getColumnName();
                        }
                        ++n2;
                    }
                    throw new IDempiereRestException("Wrong detail", "Cannot expand to the detail table because it has no column that links to the parent table: " + childTable, Response.Status.INTERNAL_SERVER_ERROR);
                }
                if (parentKeys.length != 1) break block13;
                if (cTable.getColumnIndex(parentKeys[0]) >= 0) {
                    return parentKeys[0];
                }
                MColumn[] mColumnArray = cColumns;
                int n = cColumns.length;
                int n3 = 0;
                while (n3 < n) {
                    MColumn c = mColumnArray[n3];
                    if (c.getColumnName().endsWith("_ID") && parentTable.equalsIgnoreCase(c.getReferenceTableName())) {
                        return parentKeys[0] + ":" + c.getColumnName();
                    }
                    ++n3;
                }
                break block14;
            }
            if (parentKeys.length <= 1) break block14;
            String[] stringArray = parentKeys;
            int n = parentKeys.length;
            int n4 = 0;
            while (n4 < n) {
                String pKey = stringArray[n4];
                String pRefTable = pTable.getColumn(pKey).getReferenceTableName();
                if (pRefTable != null) {
                    MColumn[] mColumnArray = cColumns;
                    int n5 = cColumns.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        MColumn c = mColumnArray[n6];
                        if (c.getColumnName().endsWith("_ID") && pRefTable.equalsIgnoreCase(c.getReferenceTableName())) {
                            return pKey + ":" + c.getColumnName();
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        throw new IDempiereRestException("Wrong detail", "Cannot expand to the detail table because it has no column that links to the parent table: " + childTable, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static String getKeyColumnName(String tableName) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        String[] keyColumns = table.getKeyColumns();
        if (keyColumns.length <= 0 || keyColumns.length > 1) {
            throw new IDempiereRestException("Wrong detail", "Cannot expand to the detail table because it has none or more than one primary key: " + tableName, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return keyColumns[0];
    }

    public static boolean isValidDetailTable(MTable childTable, String parentKeyColumnName) {
        return childTable != null && childTable.getColumnIndex(parentKeyColumnName) > 0;
    }

    public static boolean isReturnUULookup(String tableName) {
        String exportedUUTables = MSysConfig.getValue((String)EXPORT_UU_LOOKUP_SYSCONFIG_NAME, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        return !Util.isEmpty((String)exportedUUTables) && (exportedUUTables.equals("ALL") || RestUtils.isStringInCommaSeparatedList(exportedUUTables, tableName));
    }

    public static boolean isStringInCommaSeparatedList(String commaSeparatedString, String stringToCompare) {
        String[] tableArray;
        String[] stringArray = tableArray = commaSeparatedString.split(",");
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            if (tableName.trim().equalsIgnoreCase(stringToCompare.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setSessionContextVariables(Properties ctx) {
        boolean roleSet;
        int sessionId = Env.getContextAsInt((Properties)ctx, (String)"#AD_Session_ID");
        if (sessionId > 0 && ctxSessionCache.containsKey((Object)sessionId)) {
            Properties savedCtx = (Properties)ctxSessionCache.get((Object)sessionId);
            RestUtils.setCtxFromSavedCtx(ctx, savedCtx);
            return;
        }
        if (Util.isEmpty((String)Env.getContext((Properties)ctx, (String)"#Date"))) {
            Env.setContext((Properties)ctx, (String)"#Date", (Timestamp)new Timestamp(System.currentTimeMillis()));
        }
        boolean bl = roleSet = !Util.isEmpty((String)Env.getContext((Properties)ctx, (String)"#AD_Role_ID"));
        if (roleSet) {
            MRole role = MRole.getDefault();
            Env.setContext((Properties)ctx, (String)"#ShowAcct", (boolean)role.isShowAcct());
            Env.setPredefinedVariables((Properties)ctx, (int)-1, (String)role.getPredefinedContextVariables());
            if (role.isShowAcct()) {
                Env.setContext((Properties)ctx, (String)"#ShowAcct", (String)Ini.getProperty((String)"ShowAcct"));
            } else {
                Env.setContext((Properties)ctx, (String)"#ShowAcct", (String)"N");
            }
            Env.setContext((Properties)ctx, (String)"#ShowAdvanced", (boolean)MRole.getDefault().isAccessAdvanced());
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        int orgId = Env.getAD_Org_ID((Properties)ctx);
        if (clientId > 0) {
            MAcctSchema[] ass;
            int n;
            MClientInfo clientInfo = MClientInfo.get((Properties)ctx, (int)clientId);
            if (clientInfo.getC_AcctSchema1_ID() > 0) {
                MAcctSchemaElement[] els;
                MAcctSchema primary = MAcctSchema.get((Properties)ctx, (int)clientInfo.getC_AcctSchema1_ID());
                Env.setContext((Properties)ctx, (String)"$C_AcctSchema_ID", (int)primary.getC_AcctSchema_ID());
                Env.setContext((Properties)ctx, (String)"$C_Currency_ID", (int)primary.getC_Currency_ID());
                Env.setContext((Properties)ctx, (String)"$HasAlias", (boolean)primary.isHasAlias());
                MAcctSchemaElement[] mAcctSchemaElementArray = els = MAcctSchemaElement.getAcctSchemaElements((MAcctSchema)primary);
                int n2 = els.length;
                n = 0;
                while (n < n2) {
                    MAcctSchemaElement el = mAcctSchemaElementArray[n];
                    Env.setContext((Properties)ctx, (String)("$Element_" + el.getElementType()), (String)"Y");
                    ++n;
                }
            }
            if ((ass = MAcctSchema.getClientAcctSchema((Properties)ctx, (int)clientId)) != null && ass.length > 1) {
                MAcctSchema[] mAcctSchemaArray = ass;
                n = ass.length;
                int n3 = 0;
                while (n3 < n) {
                    MAcctSchema as = mAcctSchemaArray[n3];
                    if (as.getAD_OrgOnly_ID() != 0 && !as.isSkipOrg(orgId)) {
                        MAcctSchemaElement[] els;
                        Env.setContext((Properties)ctx, (String)"$C_AcctSchema_ID", (int)as.getC_AcctSchema_ID());
                        Env.setContext((Properties)ctx, (String)"$C_Currency_ID", (int)as.getC_Currency_ID());
                        Env.setContext((Properties)ctx, (String)"$HasAlias", (boolean)as.isHasAlias());
                        MAcctSchemaElement[] mAcctSchemaElementArray = els = MAcctSchemaElement.getAcctSchemaElements((MAcctSchema)as);
                        int n4 = els.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            MAcctSchemaElement el = mAcctSchemaElementArray[n5];
                            Env.setContext((Properties)ctx, (String)("$Element_" + el.getElementType()), (String)"Y");
                            ++n5;
                        }
                        break;
                    }
                    ++n3;
                }
            }
        }
        Env.setContext((Properties)ctx, (String)"#ShowTrl", (String)Ini.getProperty((String)"ShowTrl"));
        Env.setContext((Properties)ctx, (String)"#DeveloperMode", (String)(Util.isDeveloperMode() ? "Y" : "N"));
        if (Env.getAD_User_ID((Properties)ctx) > 0) {
            MUserPreference userPreference = MUserPreference.getUserPreference((int)Env.getAD_User_ID((Properties)ctx), (int)Env.getAD_Client_ID((Properties)ctx));
            userPreference.fillPreferences();
        }
        Env.setContext((Properties)ctx, (String)"#C_Country_ID", (int)MCountry.getDefault().getC_Country_ID());
        if (sessionId > 0) {
            Properties saveCtx = new Properties();
            saveCtx.putAll((Map<?, ?>)ctx);
            ctxSessionCache.put((Object)sessionId, (Object)saveCtx);
        }
    }

    private static void setCtxFromSavedCtx(Properties ctx, Properties savedCtx) {
        savedCtx.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (value instanceof String) {
                Env.setContext((Properties)ctx, (String)key.toString(), (String)value.toString());
            } else {
                ctx.put(key, value);
            }
        }));
    }

    public static void removeSavedCtx(int sessionId) {
        ctxSessionCache.remove((Object)sessionId);
    }
}

