/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankStatement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MBankStatement
extends X_C_BankStatement
implements DocAction {
    private static final long serialVersionUID = 7420574960104461342L;
    protected MBankStatementLine[] m_lines = null;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public MBankStatement(Properties ctx, String C_BankStatement_UU, String trxName) {
        super(ctx, C_BankStatement_UU, trxName);
        if (Util.isEmpty(C_BankStatement_UU)) {
            this.setInitialDefaults();
        }
    }

    public MBankStatement(Properties ctx, int C_BankStatement_ID, String trxName) {
        super(ctx, C_BankStatement_ID, trxName);
        if (C_BankStatement_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        this.setDocAction("CO");
        this.setDocStatus("DR");
        this.setBeginningBalance(Env.ZERO);
        this.setStatementDifference(Env.ZERO);
        this.setEndingBalance(Env.ZERO);
        this.setIsApproved(false);
        this.setIsManual(true);
        this.setPosted(false);
        super.setProcessed(false);
    }

    public MBankStatement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatement(MBankAccount account, boolean isManual) {
        this(account.getCtx(), 0, account.get_TrxName());
        this.setClientOrg(account);
        this.setC_BankAccount_ID(account.getC_BankAccount_ID());
        this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setBeginningBalance(account.getCurrentBalance());
        this.setName(this.getStatementDate().toString());
        this.setIsManual(isManual);
    }

    public MBankStatement(MBankAccount account) {
        this(account, false);
    }

    public MBankStatementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MBankStatement.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MBankStatementLine> list = new Query(this.getCtx(), "C_BankStatementLine", "C_BankStatement_ID=?", this.get_TrxName()).setParameters(this.getC_BankStatement_ID()).setOrderBy("Line,C_BankStatementLine_ID").list();
        MBankStatementLine[] retValue = new MBankStatementLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE C_BankStatementLine SET Processed='").append(processed ? "Y" : "N").append("' WHERE C_BankStatement_ID=").append(this.getC_BankStatement_ID());
        int noLine = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
        }
    }

    public MBankAccount getBankAccount() {
        return MBankAccount.getCopy(this.getCtx(), this.getC_BankAccount_ID(), null);
    }

    @Override
    public String getDocumentNo() {
        return this.getName();
    }

    @Override
    public String getDocumentInfo() {
        StringBuilder msgreturn = new StringBuilder().append(this.getBankAccount().getName()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() <= 0) {
            this.setC_DocType_ID(MDocType.getDocType("CMB"));
        }
        if (!this.isProcessed() && this.getBeginningBalance().compareTo(Env.ZERO) == 0) {
            MBankAccount ba = this.getBankAccount();
            ba.load(this.get_TrxName(), new String[0]);
            this.setBeginningBalance(ba.getCurrentBalance());
        }
        this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        MBankStatementLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.isActive()) {
                if (!line.isDateConsistentIfUsedForPosting()) {
                    this.m_processMsg = Msg.getMsg(this.getCtx(), "BankStatementLinePeriodNotSameAsHeader", new Object[]{line.getLine()});
                    return "IN";
                }
                total = total.add(line.getStmtAmt());
            }
            ++i;
        }
        this.setStatementDifference(total);
        this.setEndingBalance(this.getBeginningBalance().add(total));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("completeIt - " + this.toString());
        }
        MBankStatementLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                if (payment.isReconciled()) {
                    this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentIsAlreadyReconciled") + String.valueOf(payment);
                    return "IN";
                }
                payment.setIsReconciled(true);
                payment.saveEx(this.get_TrxName());
            } else if (line.getC_DepositBatch_ID() != 0) {
                MDepositBatchLine[] depositBatchLines;
                MDepositBatchLine[] mDepositBatchLineArray = depositBatchLines = line.getC_DepositBatch().getLines();
                int n = depositBatchLines.length;
                int n2 = 0;
                while (n2 < n) {
                    MDepositBatchLine mDepositBatchLine = mDepositBatchLineArray[n2];
                    MPayment payment = new MPayment(this.getCtx(), mDepositBatchLine.getC_Payment_ID(), this.get_TrxName());
                    if (payment.isReconciled()) {
                        this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentIsAlreadyReconciled") + String.valueOf(payment);
                        return "IN";
                    }
                    payment.setIsReconciled(true);
                    payment.saveEx(this.get_TrxName());
                    ++n2;
                }
            }
            ++i;
        }
        MBankAccount ba = this.getBankAccount();
        ba.load(this.get_TrxName(), new String[0]);
        ba.setCurrentBalance(ba.getCurrentBalance().add(this.getStatementDifference()));
        ba.saveEx(this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete() && this.getProcessedOn().signum() == 0) {
            this.setStatementDate(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getStatementDate())) {
                this.setDateAcct(this.getStatementDate());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
                if (MBankStatement.isPostWithDateFromLine(this.getAD_Client_ID())) {
                    MBankStatementLine[] mBankStatementLineArray = this.getLines(false);
                    int n = mBankStatementLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MBankStatementLine bl = mBankStatementLineArray[n2];
                        if (!bl.isDateConsistentIfUsedForPosting(this.getDateAcct())) {
                            throw new AdempiereException(Msg.getMsg(this.getCtx(), "ParentCannotChange", new Object[]{Msg.getElement(this.getCtx(), "DateAcct")}) + " - " + Msg.getMsg(this.getCtx(), "BankStatementLinePeriodNotSameAsHeader", new Object[]{bl.getLine()}));
                        }
                        ++n2;
                    }
                }
            }
        }
        if (dt.isOverwriteSeqOnComplete() && this.getProcessedOn().signum() == 0 && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            MFactAcct.deleteEx(392, this.getC_BankStatement_ID(), this.get_TrxName());
        }
        if (this.isProcessed()) {
            MBankAccount ba = this.getBankAccount();
            ba.load(this.get_TrxName(), new String[0]);
            ba.setCurrentBalance(ba.getCurrentBalance().subtract(this.getStatementDifference()));
            ba.saveEx();
        }
        MBankStatementLine[] lines = this.getLines(true);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.getStmtAmt().compareTo(Env.ZERO) != 0) {
                StringBuilder description = new StringBuilder(Msg.getMsg(this.getCtx(), "Voided")).append(" (").append(Msg.translate(this.getCtx(), "StmtAmt")).append("=").append(line.getStmtAmt());
                if (line.getTrxAmt().compareTo(Env.ZERO) != 0) {
                    description.append(", ").append(Msg.translate(this.getCtx(), "TrxAmt")).append("=").append(line.getTrxAmt());
                }
                if (line.getChargeAmt().compareTo(Env.ZERO) != 0) {
                    description.append(", ").append(Msg.translate(this.getCtx(), "ChargeAmt")).append("=").append(line.getChargeAmt());
                }
                if (line.getInterestAmt().compareTo(Env.ZERO) != 0) {
                    description.append(", ").append(Msg.translate(this.getCtx(), "InterestAmt")).append("=").append(line.getInterestAmt());
                }
                description.append(")");
                line.addDescription(description.toString());
                line.setStmtAmt(Env.ZERO);
                line.setTrxAmt(Env.ZERO);
                line.setChargeAmt(Env.ZERO);
                line.setInterestAmt(Env.ZERO);
                if (line.getC_Payment_ID() != 0) {
                    MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                    payment.setIsReconciled(false);
                    payment.saveEx();
                } else if (line.getC_DepositBatch_ID() != 0) {
                    MDepositBatchLine[] depositBatchLines;
                    MDepositBatchLine[] mDepositBatchLineArray = depositBatchLines = line.getC_DepositBatch().getLines();
                    int n = depositBatchLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MDepositBatchLine mDepositBatchLine = mDepositBatchLineArray[n2];
                        MPayment payment = new MPayment(this.getCtx(), mDepositBatchLine.getC_Payment_ID(), this.get_TrxName());
                        payment.setIsReconciled(false);
                        payment.saveEx();
                        ++n2;
                    }
                }
                line.setC_Payment_ID(0);
                line.saveEx();
            }
            ++i;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setStatementDifference(Env.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "CMB", this.getAD_Org_ID());
        MFactAcct.deleteEx(392, this.getC_BankStatement_ID(), this.get_TrxName());
        this.setPosted(false);
        MBankStatementLine[] lines = this.getLines(true);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            line.setProcessed(false);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                payment.setIsReconciled(false);
                payment.saveEx();
            } else if (line.getC_DepositBatch_ID() != 0) {
                MDepositBatchLine[] depositBatchLines;
                MDepositBatchLine[] mDepositBatchLineArray = depositBatchLines = line.getC_DepositBatch().getLines();
                int n = depositBatchLines.length;
                int n2 = 0;
                while (n2 < n) {
                    MDepositBatchLine mDepositBatchLine = mDepositBatchLineArray[n2];
                    MPayment payment = new MPayment(this.getCtx(), mDepositBatchLine.getC_Payment_ID(), this.get_TrxName());
                    payment.setIsReconciled(false);
                    payment.saveEx(this.get_TrxName());
                    ++n2;
                }
            }
            ++i;
        }
        MBankAccount ba = this.getBankAccount();
        ba.load(this.get_TrxName(), new String[0]);
        ba.setCurrentBalance(ba.getCurrentBalance().subtract(this.getStatementDifference()));
        ba.saveEx();
        this.setDocAction("CO");
        this.setProcessed(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate(this.getCtx(), "StatementDifference")).append("=").append(this.getStatementDifference()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public static boolean isPostWithDateFromLine(int clientID) {
        return MSysConfig.getBooleanValue("BANK_STATEMENT_POST_WITH_DATE_FROM_LINE", false, Env.getAD_Client_ID(Env.getCtx()));
    }
}

