/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.compiere.model.MAttribute;
import org.compiere.model.X_M_AttributeInstance;
import org.compiere.util.DisplayType;
import org.compiere.util.KeyNamePair;

public class MAttributeInstance
extends X_M_AttributeInstance {
    private static final long serialVersionUID = 5697542928282761922L;

    public MAttributeInstance(Properties ctx, String M_AttributeInstance_UU, String trxName) {
        super(ctx, M_AttributeInstance_UU, trxName);
    }

    public MAttributeInstance(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MAttributeInstance(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, String trxName) {
        super(ctx, 0, trxName);
        this.setM_Attribute_ID(M_Attribute_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, String Value, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setValue(Value);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, BigDecimal BDValue, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setValueNumber(BDValue);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, int M_AttributeValue_ID, String Value, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setM_AttributeValue_ID(M_AttributeValue_ID);
        this.setValue(Value);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, int Value, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setValueNumber(BigDecimal.valueOf(Value));
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, Timestamp value, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setValueDate(value);
    }

    public MAttributeInstance(Properties ctx, int M_Attribute_ID, int M_AttributeSetInstance_ID, KeyNamePair value, String trxName) {
        this(ctx, M_Attribute_ID, M_AttributeSetInstance_ID, trxName);
        this.setValueKeyNamePair(value);
    }

    public MAttributeInstance(Properties ctx, int M_AttributeInstance_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_AttributeInstance_ID, trxName, virtualColumns);
    }

    @Override
    public void setValueNumber(BigDecimal ValueNumber) {
        super.setValueNumber(ValueNumber);
        if (ValueNumber == null) {
            this.setValue(null);
            return;
        }
        if (ValueNumber.signum() == 0) {
            this.setValue("0");
            return;
        }
        char[] chars = ValueNumber.toString().toCharArray();
        StringBuilder display = new StringBuilder();
        boolean add = false;
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (add) {
                display.insert(0, c);
            } else if (c != '0') {
                if (c == '.') {
                    add = true;
                } else {
                    display.insert(0, c);
                    add = true;
                }
            }
            --i;
        }
        this.setValue(display.toString());
    }

    @Override
    public void setValueDate(Timestamp valueDate) {
        super.setValueDate(valueDate);
        if (valueDate == null) {
            this.setValue(null);
            return;
        }
        SimpleDateFormat sdf = null;
        MAttribute attribute = MAttribute.get(this.getCtx(), this.getM_Attribute_ID());
        int displayType = attribute.getAD_Reference_ID();
        sdf = "D".equals(attribute.getAttributeValueType()) ? DisplayType.getDateFormat_JDBC() : (displayType == 16 ? DisplayType.getTimestampFormat_Default() : (displayType == 24 ? DisplayType.getTimeFormat_Default() : DisplayType.getDateFormat_JDBC()));
        this.setValue(sdf.format(valueDate));
    }

    public void setValueInt(int valueInt) {
        super.setValueNumber(BigDecimal.valueOf(valueInt));
        String value = String.valueOf(valueInt);
        this.setValue(value);
    }

    public int getValueInt() {
        if (super.getValueNumber() == null) {
            return 0;
        }
        return super.getValueNumber().intValue();
    }

    public void setValueKeyNamePair(KeyNamePair value) {
        super.setValueNumber(BigDecimal.valueOf(value.getKey()));
        this.setValue(value.getName());
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

