/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import com.trekglobal.idempiere.rest.api.model.X_REST_View;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRestView
extends X_REST_View
implements ImmutablePOSupport {
    private static final long serialVersionUID = 7362614368992553892L;
    private static final ImmutablePOCache<String, MRestView> s_cache = new ImmutablePOCache("REST_View", 20);
    private static final ImmutableIntPOCache<Integer, MRestView> s_idCache = new ImmutableIntPOCache("REST_View", 20);
    private MRestViewColumn[] columns = null;
    private MRestViewRelated[] relateds = null;

    public MRestView(Properties ctx, int REST_View_ID, String trxName) {
        super(ctx, REST_View_ID, trxName);
    }

    public MRestView(Properties ctx, int REST_View_ID, String trxName, String ... virtualColumns) {
        super(ctx, REST_View_ID, trxName, virtualColumns);
    }

    public MRestView(Properties ctx, String REST_View_UU, String trxName) {
        super(ctx, REST_View_UU, trxName);
    }

    public MRestView(Properties ctx, String REST_View_UU, String trxName, String ... virtualColumns) {
        super(ctx, REST_View_UU, trxName, virtualColumns);
    }

    public MRestView(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRestView(MRestView copy) {
        this(Env.getCtx(), copy);
    }

    public MRestView(Properties ctx, MRestView copy) {
        this(ctx, copy, null);
    }

    public MRestView(Properties ctx, MRestView copy, String trxName) {
        this(ctx, -1, trxName);
        this.copyPO(copy);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            StackTraceElement[] stackTraces;
            StackTraceElement[] stackTraceElementArray = stackTraces = Thread.currentThread().getStackTrace();
            int n = stackTraces.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTrace = stackTraceElementArray[n2];
                if ("org.adempiere.pipo2.PackIn".equals(stackTrace.getClassName())) {
                    return true;
                }
                ++n2;
            }
            this.copyColumns();
        } else if (success && this.is_ValueChanged("AD_Table_ID")) {
            Query query = new Query(Env.getCtx(), "REST_ViewColumn", "REST_View_ID=?", null);
            List columnList = query.setParameters(new Object[]{this.getREST_View_ID()}).list();
            for (MRestViewColumn column : columnList) {
                column.deleteEx(true, this.get_TrxName());
            }
            this.columns = null;
            this.copyColumns();
            query = new Query(Env.getCtx(), "REST_ViewRelated", "REST_View_ID=?", null);
            List relatedList = query.setParameters(new Object[]{this.getREST_View_ID()}).list();
            for (MRestViewRelated related : relatedList) {
                related.deleteEx(true, this.get_TrxName());
            }
            this.relateds = null;
        }
        return success;
    }

    private void copyColumns() {
        MTable table = MTable.get((int)this.getAD_Table_ID());
        MColumn[] columns = table.getColumns(false);
        String keyColumn = table.getKeyColumns() != null && table.getKeyColumns().length == 1 ? table.getKeyColumns()[0] : "";
        String uidColumn = PO.getUUIDColumnName((String)table.getTableName());
        MColumn[] mColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (!column.getColumnName().equals(keyColumn) && !column.getColumnName().equals(uidColumn)) {
                MRestViewColumn restViewColumn = new MRestViewColumn(Env.getCtx(), 0, this.get_TrxName());
                restViewColumn.setREST_View_ID(this.getREST_View_ID());
                restViewColumn.setAD_Column_ID(column.getAD_Column_ID());
                restViewColumn.setName(TypeConverterUtils.toPropertyName(column.getColumnName()));
                restViewColumn.saveEx();
            }
            ++n2;
        }
    }

    public static MRestView get(String name) {
        MRestView view = (MRestView)s_cache.get(Env.getCtx(), (Object)name, e -> new MRestView(Env.getCtx(), (MRestView)e));
        if (view != null) {
            return view;
        }
        Query query = new Query(Env.getCtx(), "REST_View", "Name=?", null);
        view = (MRestView)query.setParameters(new Object[]{name}).first();
        if (view != null) {
            s_cache.put((Object)name, (PO)view, e -> new MRestView(Env.getCtx(), (MRestView)e));
            if (!s_idCache.containsKey((Object)view.get_ID())) {
                s_idCache.put((Object)view.get_ID(), (PO)view, e -> new MRestView(Env.getCtx(), (MRestView)e));
            }
        }
        return view;
    }

    public static MRestView get(int id) {
        MRestView view = (MRestView)s_idCache.get(Env.getCtx(), (Object)id, e -> new MRestView(Env.getCtx(), (MRestView)e));
        if (view != null) {
            return view;
        }
        Query query = new Query(Env.getCtx(), "REST_View", "REST_View_ID=?", null);
        view = (MRestView)query.setParameters(new Object[]{id}).first();
        if (view != null) {
            s_idCache.put((Object)id, (PO)view, e -> new MRestView(Env.getCtx(), (MRestView)e));
            if (!s_cache.containsKey((Object)view.getName())) {
                s_cache.put((Object)view.getName(), (PO)view, e -> new MRestView(Env.getCtx(), (MRestView)e));
            }
        }
        return view;
    }

    public MRestViewColumn[] getColumns() {
        return this.getColumns(false);
    }

    public MRestViewColumn[] getColumns(boolean refresh) {
        if (this.columns != null && !refresh) {
            return this.columns;
        }
        Query query = new Query(Env.getCtx(), "REST_ViewColumn", "REST_View_ID=?", null);
        List columnList = query.setOnlyActiveRecords(true).setOrderBy("SeqNo, REST_ViewColumn_ID").setParameters(new Object[]{this.getREST_View_ID()}).list();
        this.columns = columnList.toArray(new MRestViewColumn[0]);
        return this.columns;
    }

    public MRestViewRelated[] getRelatedViews() {
        return this.getRelatedViews(false);
    }

    public MRestViewRelated[] getRelatedViews(boolean refresh) {
        if (this.relateds != null && !refresh) {
            return this.relateds;
        }
        Query query = new Query(Env.getCtx(), "REST_ViewRelated", "REST_View_ID=?", null);
        List relatedList = query.setOnlyActiveRecords(true).setParameters(new Object[]{this.getREST_View_ID()}).list();
        this.relateds = relatedList.toArray(new MRestViewRelated[0]);
        return this.relateds;
    }

    public String toColumnName(String name) {
        MRestViewColumn[] columns;
        MRestViewColumn[] mRestViewColumnArray = columns = this.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            MRestViewColumn column = mRestViewColumnArray[n2];
            String columnName = MColumn.getColumnName((Properties)Env.getCtx(), (int)column.getAD_Column_ID());
            if (column.getName().equals(name) || columnName.equalsIgnoreCase(name)) {
                return name;
            }
            ++n2;
        }
        return null;
    }

    public String[] toColumnNames(String[] includes, boolean keepNotViewPropertyName) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            String columnName = this.toColumnName(include);
            if (columnName != null) {
                list.add(columnName);
            } else if (keepNotViewPropertyName) {
                list.add(include);
            }
            ++n2;
        }
        return list.toArray(new String[0]);
    }

    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.columns != null) {
            Arrays.stream(this.columns).forEach(e -> {
                PO pO = e.markImmutable();
            });
        }
        if (this.relateds != null) {
            Arrays.stream(this.relateds).forEach(e -> {
                PO pO = e.markImmutable();
            });
        }
        return this;
    }
}

