/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ModelHelper {
    private static final CLogger log = CLogger.getCLogger(ModelHelper.class);
    private static final int DEFAULT_QUERY_TIMEOUT = 120;
    private static final int MAX_RECORDS_SIZE = MSysConfig.getIntValue((String)"REST_MAX_RECORDS_SIZE", (int)100);
    private static final String CONTEXT_VARIABLES_SEPARATOR = ",";
    private static final String CONTEXT_NAMEVALUE_SEPARATOR = ":";
    private static final AtomicInteger windowNoAtomic = new AtomicInteger();
    private String tableName;
    private String filter;
    private String orderBy;
    private int top;
    private int skip;
    private String validationRuleID;
    private String context;
    private int rowCount = 0;
    private int pageCount = 0;
    private String sqlStatement;
    private MRestView view;

    public ModelHelper(String tableName, String filter, String orderBy, int top, int skip, String validationRuleID, String context) {
        this.tableName = tableName;
        this.filter = filter;
        this.orderBy = orderBy;
        this.top = top;
        this.skip = skip;
        this.validationRuleID = validationRuleID;
        this.context = context;
    }

    public ModelHelper(String tableName, String filter, String orderBy, int top, int skip) {
        this(tableName, filter, orderBy, top, skip, null, null);
    }

    public void setView(MRestView view) {
        this.view = view;
        if (view != null && !MTable.getTableName((Properties)Env.getCtx(), (int)view.getAD_Table_ID()).equalsIgnoreCase(this.tableName)) {
            throw new IllegalArgumentException("Rest view belongs to a different table from what this ModelHelper is using");
        }
    }

    public List<PO> getPOsFromRequest() {
        String whereClause = this.getRequestWhereClause();
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        MTable table = RestUtils.getTableAndCheckAccess(this.tableName);
        ConvertedQuery convertedStatement = converter.convertStatement(this.view, this.tableName, whereClause);
        String convertedWhereClause = this.getFullWhereClause(convertedStatement);
        Query query = RestUtils.getQuery(this.tableName, convertedWhereClause, new ArrayList<Object>(convertedStatement.getParameters()));
        this.addOrderByWhenValid(table, this.orderBy, query);
        query.setQueryTimeout(120);
        this.rowCount = query.count();
        this.pageCount = 1;
        if (MAX_RECORDS_SIZE > 0 && (this.top > MAX_RECORDS_SIZE || this.top <= 0)) {
            this.top = MAX_RECORDS_SIZE;
        }
        if (this.top > 0 && this.rowCount > this.top) {
            this.pageCount = (int)Math.ceil((double)this.rowCount / (double)this.top);
        }
        query.setPageSize(this.top);
        query.setRecordstoSkip(this.skip);
        this.sqlStatement = query.getSQL();
        return query.list();
    }

    private String getRequestWhereClause() {
        return !Util.isEmpty((String)this.filter, (boolean)true) ? this.filter : "";
    }

    private String getFullWhereClause(ConvertedQuery convertedStatement) {
        String convertedWhereClause = convertedStatement.getWhereClause();
        if (log.isLoggable(Level.INFO)) {
            log.info("Where Clause: " + convertedWhereClause);
        }
        if (this.validationRuleID != null) {
            MValRule validationRule = this.getValidationRule(this.validationRuleID);
            if (validationRule == null || validationRule.getAD_Val_Rule_ID() == 0) {
                throw new IDempiereRestException("Invalid validation rule", "No match found for validation with ID: " + this.validationRuleID, Response.Status.NOT_FOUND);
            }
            if (validationRule.getCode() != null) {
                if (!Util.isEmpty((String)convertedWhereClause)) {
                    convertedWhereClause = String.valueOf(convertedWhereClause) + " AND ";
                }
                convertedWhereClause = String.valueOf(convertedWhereClause) + "(" + validationRule.getCode() + ")";
                if (!Util.isEmpty((String)this.context)) {
                    convertedWhereClause = this.parseContext(convertedWhereClause, this.context);
                }
            }
        }
        if (this.view != null && !Util.isEmpty((String)this.view.getWhereClause(), (boolean)true)) {
            String viewWhereClause = this.view.getWhereClause();
            int atIdx = viewWhereClause.indexOf("@");
            if (atIdx >= 0 && viewWhereClause.indexOf("@", atIdx + 1) > atIdx) {
                viewWhereClause = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)viewWhereClause, (boolean)false);
            }
            if (!Util.isEmpty((String)convertedWhereClause)) {
                convertedWhereClause = String.valueOf(convertedWhereClause) + " AND ";
            }
            convertedWhereClause = String.valueOf(convertedWhereClause) + "(" + viewWhereClause + ")";
        }
        return convertedWhereClause;
    }

    private MValRule getValidationRule(String validationRuleID) {
        return (MValRule)RestUtils.getPO("AD_Val_Rule", validationRuleID, false, false);
    }

    private String parseContext(String whereClause, String context) {
        String parsedWhereClause = whereClause;
        int windowNo = windowNoAtomic.getAndIncrement();
        String[] stringArray = context.split(CONTEXT_VARIABLES_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contextNameValue = stringArray[n2];
            String[] namevaluePair = contextNameValue.split(CONTEXT_NAMEVALUE_SEPARATOR);
            String contextName = namevaluePair[0];
            String contextValue = namevaluePair[1];
            if (this.isValidContextValue(contextValue)) {
                Env.setContext((Properties)Env.getCtx(), (int)windowNo, (String)contextName, (String)contextValue);
            }
            ++n2;
        }
        parsedWhereClause = Env.parseContext((Properties)Env.getCtx(), (int)windowNo, (String)parsedWhereClause, (boolean)false, (boolean)true);
        Env.clearWinContext((int)windowNo);
        return parsedWhereClause;
    }

    private boolean isValidContextValue(String value) {
        return Pattern.matches("^[A-Za-z0-9\\s\\-]+$", value);
    }

    private boolean addOrderByWhenValid(MTable table, String orderBy, Query query) {
        if (!Util.isEmpty((String)orderBy, (boolean)true)) {
            String[] columnNames = orderBy.split("[,]");
            ArrayList<String> virtualColumns = new ArrayList<String>();
            String[] stringArray = columnNames;
            int n = columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                MColumn column;
                String columnName = stringArray[n2];
                if ((columnName = columnName.trim()).contains(" ")) {
                    String[] names = columnName.split(" ");
                    columnName = names[0];
                    String orderPreference = names[1];
                    if (names.length > 2 || !"asc".equals(orderPreference.toLowerCase()) && !"desc".equals(orderPreference.toLowerCase())) {
                        log.log(Level.WARNING, "Invalid order by clause.");
                        return false;
                    }
                }
                if ((column = table.getColumn(columnName)) == null) {
                    log.log(Level.WARNING, "Column: " + columnName + " is not a valid column to be ordered by");
                    return false;
                }
                if (!Util.isEmpty((String)column.getColumnSQL())) {
                    virtualColumns.add(columnName);
                }
                ++n2;
            }
            query.setOrderBy(orderBy);
            if (virtualColumns.size() > 0) {
                query.setVirtualColumns(virtualColumns.toArray(new String[virtualColumns.size()]));
            }
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public String getSQLStatement() {
        return this.sqlStatement;
    }

    public int getTop() {
        return this.top;
    }

    public int getSkip() {
        return this.skip;
    }
}

