/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.ReferenceResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.model.MRefTable;
import org.compiere.model.MReference;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class ReferenceResourceImpl
implements ReferenceResource {
    @Override
    public Response getList(String refID) {
        MReference ref = (MReference)RestUtils.getPO("AD_Reference", refID, false, false);
        if (ref == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid reference id").append("No match found for AD_Reference_ID: ").append(refID).build().toString()).build();
        }
        if ("L".equals(ref.getValidationType())) {
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Reference", MTable.getClass((String)"AD_Reference"));
            JsonObject referenceJsonObject = serializer.toJson((PO)ref, new String[]{"AD_Reference_ID", "AD_Reference_UU", "Name", "Description", "Help", "ValidationType", "VFormat"}, null);
            JsonArray refListArray = new JsonArray();
            ValueNamePair[] valueNamePairArray = MRefList.getList((Properties)Env.getCtx(), (int)ref.getAD_Reference_ID(), (boolean)false);
            int n = valueNamePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueNamePair refList = valueNamePairArray[n2];
                JsonObject json = new JsonObject();
                json.addProperty("value", refList.getValue());
                json.addProperty("name", refList.getName());
                refListArray.add((JsonElement)json);
                ++n2;
            }
            referenceJsonObject.add("reflist", (JsonElement)refListArray);
            return Response.ok((Object)referenceJsonObject.toString()).build();
        }
        if ("T".equals(ref.getValidationType())) {
            MRefTable refTable = MRefTable.get((int)ref.getAD_Reference_ID());
            if (refTable == null || refTable.get_ID() == 0) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid reference table id").append("No ref table match found for AD_Reference_ID: ").append(refID).build().toString()).build();
            }
            MTable table = new MTable(Env.getCtx(), refTable.getAD_Table_ID(), null);
            Query query = new Query(Env.getCtx(), table, refTable.getWhereClause(), null);
            List list = query.setApplyAccessFilter(true, false).setOnlyActiveRecords(true).setOrderBy(refTable.getOrderByClause()).list();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Reference", MTable.getClass((String)table.getTableName()));
            JsonArray array = new JsonArray();
            if (list != null && !list.isEmpty()) {
                ArrayList<String> includes = new ArrayList<String>();
                includes.add(MColumn.getColumnName((Properties)Env.getCtx(), (int)refTable.getAD_Key()));
                includes.add(MColumn.getColumnName((Properties)Env.getCtx(), (int)refTable.getAD_Display()));
                if (refTable.isValueDisplayed()) {
                    includes.add("Value");
                }
                for (PO po : list) {
                    JsonObject json = serializer.toJson(po, includes.toArray(new String[includes.size()]), null);
                    array.add((JsonElement)json);
                }
            }
            JsonObject json = new JsonObject();
            json.add("reftable", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)new ErrorBuilder().status(Response.Status.NOT_IMPLEMENTED).title("References with data validation are not implemented.").append("Not implemented AD_Reference_ID: ").append(refID).build().toString()).build();
    }
}

