/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogger;

public class FileAccess {
    private static final String s_dirAccessFileName = "dirAccess.txt";
    private static final CLogger log = CLogger.getCLogger(FileAccess.class);

    private FileAccess() {
    }

    private static List<String> getDirAcessList() {
        ArrayList<String> dirAccessList = new ArrayList<String>();
        CLogFile fileHandler = CLogFile.get((boolean)true, null, (boolean)false);
        File logDir = fileHandler.getLogDirectory();
        dirAccessList.add(logDir.getAbsolutePath());
        File tempFolder = new File(System.getProperty("java.io.tmpdir"));
        dirAccessList.add(tempFolder.getAbsolutePath());
        String dirAccessPathName = String.valueOf(Adempiere.getAdempiereHome()) + File.separator + s_dirAccessFileName;
        File dirAccessFile = new File(dirAccessPathName);
        if (dirAccessFile.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(dirAccessFile));){
                    String pathName;
                    while ((pathName = br.readLine()) != null) {
                        File pathDir = new File(pathName);
                        if (!pathDir.exists() || dirAccessList.contains(pathDir.getAbsolutePath())) continue;
                        dirAccessList.add(pathDir.getAbsolutePath());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, String.valueOf(dirAccessPathName) + " - " + e.toString());
            }
        }
        return dirAccessList;
    }

    public static boolean isAccessible(File file) {
        boolean found = false;
        List<String> dirAccessList = FileAccess.getDirAcessList();
        for (String dir : dirAccessList) {
            if (!file.getAbsolutePath().startsWith(dir)) continue;
            found = true;
            break;
        }
        if (!found) {
            log.warning("Couldn't find file in directories that allowed to access: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }
}

