/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import com.trekglobal.idempiere.rest.api.v1.resource.ViewResource;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.ModelResourceImpl;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ViewResourceImpl
implements ViewResource {
    private static final CLogger log = CLogger.getCLogger(ViewResourceImpl.class);

    private ModelResourceImpl restView() {
        return new ModelResourceImpl().restView();
    }

    @Override
    public Response getPO(String tableName, String id, String details, String select, String showsql) {
        return this.restView().getPO(tableName, id, details, select, showsql);
    }

    @Override
    public Response getPOProperty(String tableName, String id, String propertyName, String showsql) {
        return this.restView().getPOProperty(tableName, id, propertyName, showsql);
    }

    @Override
    public Response getPOs(String tableName, String details, String filter, String order, String select, int top, int skip, String validationRuleID, String context, String showsql) {
        return this.restView().getPOs(tableName, details, filter, order, select, top, skip, validationRuleID, context, showsql);
    }

    @Override
    public Response getModels(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("REST_View", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "REST_View", convertedStatement.getWhereClause(), null);
            query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            query.setParameters(convertedStatement.getParameters());
            List views = query.setOrderBy("REST_View.Name").list();
            JsonArray array = new JsonArray();
            for (MRestView view : views) {
                MRestViewRelated[] relateds;
                int n;
                MRestViewColumn[] columns;
                JsonObject json = new JsonObject();
                json.addProperty("id", (Number)view.getREST_View_ID());
                if (!Util.isEmpty((String)view.getREST_View_UU())) {
                    json.addProperty("uid", view.getREST_View_UU());
                }
                json.addProperty("name", view.getName());
                MTable table = MTable.get((int)view.getAD_Table_ID());
                json.addProperty("tableName", table.getTableName().toLowerCase());
                if (!Util.isEmpty((String)view.getWhereClause())) {
                    json.addProperty("whereClause", view.getWhereClause());
                }
                if ((columns = view.getColumns()).length > 0) {
                    JsonArray columnArray = new JsonArray();
                    MRestViewColumn[] mRestViewColumnArray = columns;
                    n = columns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MRestViewColumn column = mRestViewColumnArray[n2];
                        JsonObject columnJson = new JsonObject();
                        columnJson.addProperty("id", (Number)column.get_ID());
                        if (!Util.isEmpty((String)column.getREST_ViewColumn_UU())) {
                            columnJson.addProperty("uid", column.getREST_ViewColumn_UU());
                        }
                        columnJson.addProperty("name", column.getName());
                        columnJson.addProperty("columnName", MColumn.getColumnName((Properties)Env.getCtx(), (int)column.getAD_Column_ID()));
                        if (column.getREST_ReferenceView_ID() > 0) {
                            MRestView referenceView = MRestView.get(column.getREST_ReferenceView_ID());
                            JsonObject refJson = new JsonObject();
                            refJson.addProperty("id", (Number)referenceView.get_ID());
                            if (!Util.isEmpty((String)referenceView.getREST_View_UU())) {
                                refJson.addProperty("uid", referenceView.getREST_View_UU());
                            }
                            refJson.addProperty("name", referenceView.getName());
                            columnJson.add("referenceView", (JsonElement)refJson);
                        }
                        columnArray.add((JsonElement)columnJson);
                        ++n2;
                    }
                    json.add("columns", (JsonElement)columnArray);
                }
                if ((relateds = view.getRelatedViews()).length > 0) {
                    JsonArray relatedArray = new JsonArray();
                    MRestViewRelated[] mRestViewRelatedArray = relateds;
                    int n3 = relateds.length;
                    n = 0;
                    while (n < n3) {
                        MRestViewRelated related = mRestViewRelatedArray[n];
                        JsonObject relatedJson = new JsonObject();
                        relatedJson.addProperty("id", (Number)related.get_ID());
                        if (!Util.isEmpty((String)related.getREST_ViewRelated_UU())) {
                            relatedJson.addProperty("uid", related.getREST_ViewRelated_UU());
                        }
                        relatedJson.addProperty("name", related.getName());
                        MRestView referenceView = MRestView.get(related.getREST_RelatedRestView_ID());
                        JsonObject refJson = new JsonObject();
                        refJson.addProperty("id", (Number)referenceView.get_ID());
                        if (!Util.isEmpty((String)referenceView.getREST_View_UU())) {
                            refJson.addProperty("uid", referenceView.getREST_View_UU());
                        }
                        refJson.addProperty("name", referenceView.getName());
                        relatedJson.add("view", (JsonElement)refJson);
                        relatedJson.addProperty("autoExpand", Boolean.valueOf(related.isRestAutoExpand()));
                        relatedArray.add((JsonElement)relatedJson);
                        ++n;
                    }
                    json.add("relatedViews", (JsonElement)relatedArray);
                }
                array.add((JsonElement)json);
            }
            JsonObject json = new JsonObject();
            json.add("views", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            return ResponseUtils.getResponseErrorFromException(ex, "GET Error");
        }
    }

    @Override
    public Response create(String tableName, String jsonText) {
        return this.restView().create(tableName, jsonText);
    }

    @Override
    public Response update(String tableName, String id, String jsonText) {
        return this.restView().update(tableName, id, jsonText);
    }

    @Override
    public Response delete(String tableName, String id) {
        return this.restView().delete(tableName, id);
    }

    @Override
    public Response getAttachments(String tableName, String id) {
        return this.restView().getAttachments(tableName, id);
    }

    @Override
    public Response getAttachmentsAsZip(String tableName, String id, String asJson) {
        return this.restView().getAttachmentsAsZip(tableName, id, asJson);
    }

    @Override
    public Response createAttachmentsFromZip(String tableName, String id, String jsonText) {
        return this.restView().createAttachmentsFromZip(tableName, id, jsonText);
    }

    @Override
    public Response getAttachmentEntry(String tableName, String id, String fileName, String asJson) {
        return this.restView().getAttachmentEntry(tableName, id, fileName, asJson);
    }

    @Override
    public Response addAttachmentEntry(String tableName, String id, String jsonText) {
        return this.restView().addAttachmentEntry(tableName, id, jsonText);
    }

    @Override
    public Response deleteAttachments(String tableName, String id) {
        return this.restView().deleteAttachments(tableName, id);
    }

    @Override
    public Response deleteAttachmentEntry(String tableName, String id, String fileName) {
        return this.restView().deleteAttachmentEntry(tableName, id, fileName);
    }

    @Override
    public Response printModelRecord(String tableName, String id, String reportType) {
        return this.restView().printModelRecord(tableName, id, reportType);
    }
}

