/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.trekglobal.idempiere.rest.api.json.DefaultPOSerializer;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import java.util.Properties;
import java.util.Set;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLocation;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class LocationTypeConverter
implements ITypeConverter<Object> {
    @Override
    public Object toJsonValue(MColumn column, Object value) {
        String label = Msg.getElement((Properties)Env.getCtx(), (String)column.getColumnName());
        MLocationLookup lookup = new MLocationLookup(Env.getCtx(), 0);
        return this.toJsonValue(column.getAD_Reference_ID(), label, (Lookup)lookup, column.getReferenceTableName(), value);
    }

    @Override
    public Object toJsonValue(GridField field, Object value) {
        return this.toJsonValue(field.getDisplayType(), field.getHeader(), field.getLookup(), this.getReferenceTableNameFromField(field), value);
    }

    private String getReferenceTableNameFromField(GridField field) {
        String refTableName = null;
        if (field.getVO().isProcess) {
            MProcessPara pp;
            MProcessPara mProcessPara = pp = field.getAD_Column_ID() > 0 ? MProcessPara.get((int)field.getAD_Column_ID()) : null;
            if (pp != null) {
                refTableName = pp.getReferenceTableName();
            }
        } else {
            MColumn column;
            MColumn mColumn = column = field.getAD_Column_ID() > 0 ? MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID()) : null;
            if (column != null) {
                refTableName = column.getReferenceTableName();
            }
        }
        return refTableName;
    }

    private Object toJsonValue(int displayType, String label, Lookup lookup, String refTableName, Object value) {
        if (lookup != null) {
            MLocation loc = MLocation.get((int)((Integer)value));
            JsonObject ref = new JsonObject();
            ref.addProperty("propertyLabel", label);
            if (value instanceof Number) {
                ref.addProperty("id", (Number)((Number)value).intValue());
            } else {
                ref.addProperty("id", value.toString());
            }
            String display = lookup.getDisplay(value);
            if (!Util.isEmpty((String)display, (boolean)true)) {
                ref.addProperty("identifier", display);
            }
            if (!Util.isEmpty((String)refTableName)) {
                ref.addProperty("model-name", refTableName.toLowerCase());
            }
            MColumn[] columns = MTable.get((int)162).getColumns(false);
            String columnName = null;
            Object columnValue = null;
            MColumn[] mColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                MColumn column = mColumnArray[n2];
                if (!column.isKey()) {
                    columnName = column.getColumnName();
                    if (columnName.endsWith("_ID")) {
                        columnValue = loc.get_Value(columnName);
                        if (columnValue != null) {
                            JsonObject refChild = new JsonObject();
                            refChild.addProperty("propertyLabel", Msg.getElement((Properties)Env.getCtx(), (String)columnName));
                            if (value instanceof Number) {
                                refChild.addProperty("id", (Number)((Integer)columnValue));
                            } else {
                                refChild.addProperty("id", value.toString());
                            }
                            String displayValue = this.getColumnLookup(column).getDisplay(columnValue);
                            if (displayValue != null) {
                                refChild.addProperty("identifier", displayValue);
                            }
                            refChild.addProperty("model-name", MTable.get((Properties)Env.getCtx(), (String)columnName.replace("_ID", "")).getTableName().toLowerCase());
                            ref.add(columnName, (JsonElement)refChild);
                        }
                    } else {
                        columnValue = loc.get_Value(columnName);
                        if (columnValue != null) {
                            ref.addProperty(columnName, columnValue.toString());
                        }
                    }
                }
                ++n2;
            }
            return ref;
        }
        return null;
    }

    @Override
    public Object fromJsonValue(GridField field, JsonElement value) {
        return this.fromJson(value);
    }

    @Override
    public Object fromJsonValue(MColumn column, JsonElement value) {
        return this.fromJson(value);
    }

    public Object fromJson(JsonElement element) {
        JsonPrimitive primitive;
        if (element != null && element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            JsonElement idField = json.get("id");
            int C_Location_ID = 0;
            if (idField != null) {
                JsonPrimitive primitive2 = (JsonPrimitive)idField;
                C_Location_ID = primitive2.isNumber() ? primitive2.getAsInt() : 0;
            }
            MLocation po = new MLocation(Env.getCtx(), C_Location_ID, null);
            MTable table = MTable.get((Properties)Env.getCtx(), (int)162);
            POInfo poInfo = POInfo.getPOInfo((Properties)Env.getCtx(), (int)table.getAD_Table_ID());
            DefaultPOSerializer.validateJsonFields(json, (PO)po);
            Set jsonFields = json.keySet();
            int i = 0;
            while (i < poInfo.getColumnCount()) {
                String columnName = poInfo.getColumnName(i);
                String propertyName = TypeConverterUtils.toPropertyName(columnName);
                if (jsonFields.contains(propertyName) || jsonFields.contains(columnName)) {
                    JsonElement field = json.get(propertyName);
                    if (field == null) {
                        field = json.get(columnName);
                    }
                    if (field != null) {
                        MColumn column = table.getColumn(columnName);
                        Object value = TypeConverterUtils.fromJsonValue(column, field);
                        if (DefaultPOSerializer.isValueUpdated(po.get_ValueOfColumn(column.getAD_Column_ID()), value) && DefaultPOSerializer.isUpdatable(column, false, (PO)po)) {
                            if (value != null && value instanceof Integer) {
                                if ((Integer)value < 0 && DisplayType.isID((int)column.getAD_Reference_ID())) {
                                    element = null;
                                } else if ((Integer)value == 0 && DisplayType.isLookup((int)column.getAD_Reference_ID()) && !MTable.isZeroIDTable((String)column.getReferenceTableName())) {
                                    element = null;
                                }
                            }
                            po.set_ValueOfColumn(column.getAD_Column_ID(), value);
                        }
                    }
                }
                ++i;
            }
            po.saveEx();
            return po.get_ID();
        }
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isNumber()) {
            return primitive.getAsInt();
        }
        return null;
    }

    private Lookup getColumnLookup(MColumn column) {
        int WindowNo = 0;
        MLookup lookup = null;
        try {
            String validationCode = null;
            if (column.getAD_Val_Rule_ID() > 0) {
                MValRule rule = MValRule.get((Properties)Env.getCtx(), (int)column.getAD_Val_Rule_ID());
                validationCode = rule.getCode();
            }
            lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), (String)validationCode);
        }
        catch (Exception exception) {
            lookup = null;
        }
        return lookup;
    }
}

