/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.trekglobal.idempiere.rest.api.json.BinaryTypeConverter;
import com.trekglobal.idempiere.rest.api.json.DateTypeConverter;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import com.trekglobal.idempiere.rest.api.json.ImageTypeConverter;
import com.trekglobal.idempiere.rest.api.json.JSONTypeConverter;
import com.trekglobal.idempiere.rest.api.json.LocationTypeConverter;
import com.trekglobal.idempiere.rest.api.json.LookupTypeConverter;
import com.trekglobal.idempiere.rest.api.json.NumericTypeConverter;
import com.trekglobal.idempiere.rest.api.json.YesNoTypeConverter;
import java.text.Normalizer;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.util.DisplayType;

public class TypeConverterUtils {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w_-]");
    private static final Pattern SEPARATORS = Pattern.compile("[\\s\\p{Punct}&&[^-]&&[^_]]");

    private TypeConverterUtils() {
    }

    public static String toPropertyName(String columnName) {
        String propertyName = columnName;
        if (!propertyName.contains("_")) {
            String initial = propertyName.substring(0, 1).toLowerCase();
            propertyName = String.valueOf(initial) + propertyName.substring(1);
        }
        return propertyName;
    }

    public static Object toJsonValue(MColumn column, Object value) {
        ITypeConverter typeConverter = TypeConverterUtils.getTypeConverter(column.getAD_Reference_ID(), value);
        if (typeConverter != null) {
            return typeConverter.toJsonValue(column, value);
        }
        if (value != null && DisplayType.isText((int)column.getAD_Reference_ID())) {
            return value.toString();
        }
        if (value != null && column.getAD_Reference_ID() == 13 && value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public static Object toJsonValue(GridField field, Object value) {
        ITypeConverter typeConverter = TypeConverterUtils.getTypeConverter(field.getDisplayType(), value);
        if (typeConverter != null) {
            return typeConverter.toJsonValue(field, value);
        }
        if (value != null && DisplayType.isText((int)field.getDisplayType())) {
            return value.toString();
        }
        if (value != null && field.getDisplayType() == 13 && value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public static Object fromJsonValue(MColumn column, JsonElement value) {
        ITypeConverter typeConverter = TypeConverterUtils.getTypeConverter(column.getAD_Reference_ID(), value);
        if (typeConverter != null) {
            return typeConverter.fromJsonValue(column, value);
        }
        if (value != null && !(value instanceof JsonNull) && DisplayType.isText((int)column.getAD_Reference_ID())) {
            return value.getAsString();
        }
        return null;
    }

    public static Object fromJsonValue(GridField gridField, JsonElement value) {
        ITypeConverter typeConverter = TypeConverterUtils.getTypeConverter(gridField.getDisplayType(), value);
        if (typeConverter != null) {
            return typeConverter.fromJsonValue(gridField, value);
        }
        if (value != null && !(value instanceof JsonNull) && DisplayType.isText((int)gridField.getDisplayType())) {
            return value.getAsString();
        }
        return null;
    }

    public static String slugify(String input) {
        String noseparators = SEPARATORS.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(noseparators, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH).replaceAll("-{2,}", "-").replaceAll("^-|-$", "");
    }

    private static ITypeConverter getTypeConverter(int displayType, Object value) {
        ITypeConverter typeConverter = null;
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"displayType", (Object)Integer.toString(displayType));
        typeConverter = (ITypeConverter)Service.locator().locate(ITypeConverter.class, query).getService();
        if (typeConverter == null) {
            if ((DisplayType.isNumeric((int)displayType) || displayType == 28 || displayType == 200202 || displayType == 13) && value instanceof Number) {
                typeConverter = new NumericTypeConverter();
            } else if (DisplayType.isDate((int)displayType) && value instanceof Date) {
                typeConverter = new DateTypeConverter();
            } else if (20 == displayType) {
                typeConverter = new YesNoTypeConverter();
            } else {
                if (displayType == 21) {
                    return new LocationTypeConverter();
                }
                if (displayType == 31 || displayType == 25 || displayType == 35 || displayType == 200012 || DisplayType.isLookup((int)displayType)) {
                    return new LookupTypeConverter();
                }
                if (displayType == 23) {
                    return new BinaryTypeConverter();
                }
                if (displayType == 32) {
                    return new ImageTypeConverter();
                }
                if (displayType == 200267) {
                    return new JSONTypeConverter();
                }
            }
        }
        return typeConverter;
    }

    private static ITypeConverter getTypeConverter(int displayType, JsonElement value) {
        ITypeConverter typeConverter = null;
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"displayType", (Object)Integer.toString(displayType));
        typeConverter = (ITypeConverter)Service.locator().locate(ITypeConverter.class, query).getService();
        if (typeConverter == null) {
            if ((DisplayType.isNumeric((int)displayType) || displayType == 28 || displayType == 200202 || displayType == 13) && (TypeConverterUtils.isNumber(value) || TypeConverterUtils.isString(value))) {
                typeConverter = new NumericTypeConverter();
            } else if (DisplayType.isDate((int)displayType) && TypeConverterUtils.isString(value)) {
                typeConverter = new DateTypeConverter();
            } else if (20 == displayType && (TypeConverterUtils.isBoolean(value) || TypeConverterUtils.isString(value))) {
                typeConverter = new YesNoTypeConverter();
            } else {
                if (displayType == 21) {
                    return new LocationTypeConverter();
                }
                if (displayType == 31 || displayType == 25 || displayType == 35 || displayType == 200012 || DisplayType.isLookup((int)displayType)) {
                    return new LookupTypeConverter();
                }
                if (displayType == 23) {
                    return new BinaryTypeConverter();
                }
                if (displayType == 32) {
                    return new ImageTypeConverter();
                }
                if (displayType == 200267) {
                    return new JSONTypeConverter();
                }
            }
        }
        return typeConverter;
    }

    private static boolean isBoolean(JsonElement value) {
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            return primitive.isBoolean();
        }
        return false;
    }

    private static boolean isString(JsonElement value) {
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            return primitive.isString();
        }
        return false;
    }

    private static boolean isNumber(JsonElement value) {
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            return primitive.isNumber();
        }
        return false;
    }
}

