/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.PO;
import org.compiere.model.X_AD_WF_NextCondition;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.idempiere.cache.ImmutablePOSupport;

public class MWFNextCondition
extends X_AD_WF_NextCondition
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3119863973003103716L;
    private boolean m_numeric = true;

    public MWFNextCondition(Properties ctx, String AD_WF_NextCondition_UU, String trxName) {
        super(ctx, AD_WF_NextCondition_UU, trxName);
    }

    public MWFNextCondition(Properties ctx, int id, String trxName) {
        super(ctx, id, trxName);
    }

    public MWFNextCondition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWFNextCondition(MWFNextCondition copy) {
        this(Env.getCtx(), copy);
    }

    public MWFNextCondition(Properties ctx, MWFNextCondition copy) {
        this(ctx, copy, null);
    }

    public MWFNextCondition(Properties ctx, MWFNextCondition copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_numeric = copy.m_numeric;
    }

    public boolean isOr() {
        return "O".equals(this.getAndOr());
    }

    public boolean evaluate(MWFActivity activity) {
        return this.evaluate(activity.getPO());
    }

    protected boolean evaluate(PO po) {
        String value2;
        String value1;
        if (this.getAD_Column_ID() == 0 && Util.isEmpty(this.getSQLStatement(), true)) {
            throw new IllegalStateException("No Column and SQL Statement defined - " + String.valueOf(this));
        }
        if (po == null || po.get_ID() == 0) {
            throw new IllegalStateException("Could not evaluate " + String.valueOf(po) + " - " + String.valueOf(this));
        }
        if (this.getOperation().equals("SQ")) {
            String result;
            String sqlStatement = this.getSQLStatement();
            if (Util.isEmpty(this.getSQLStatement(), true)) {
                return false;
            }
            if (sqlStatement.indexOf("@") >= 0) {
                sqlStatement = Env.parseVariable(sqlStatement, po, po.get_TrxName(), false);
            }
            return "true".equalsIgnoreCase(result = DB.getSQLValueStringEx(po.get_TrxName(), sqlStatement, new Object[0])) || "y".equalsIgnoreCase(result);
        }
        Object valueObj = null;
        if (!Util.isEmpty(this.getSQLStatement(), true)) {
            try {
                valueObj = this.getColumnSQLValue(po);
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not get result from column sql: " + this.getSQLStatement(), e);
            }
        } else {
            valueObj = po.get_ValueOfColumn(this.getAD_Column_ID());
        }
        if (valueObj == null) {
            valueObj = "";
        }
        if ((value1 = this.getDecodedValue(this.getValue(), po)) == null) {
            value1 = "";
        }
        if ((value2 = this.getDecodedValue(this.getValue2(), po)) == null) {
            value2 = "";
        }
        String resultStr = "PO:{" + String.valueOf(valueObj) + "} " + this.getOperation() + " Condition:{" + value1 + "}";
        if (this.getOperation().equals("AB")) {
            resultStr = resultStr + "{" + value2 + "}";
        }
        boolean result = false;
        result = valueObj instanceof Number ? this.compareNumber((Number)valueObj, value1, value2) : (valueObj instanceof Boolean ? this.compareBoolean((Boolean)valueObj, value1, value2) : this.compareString(valueObj, value1, value2));
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(resultStr + " -> " + result + (this.m_numeric ? " (#)" : " ($)"));
        }
        return result;
    }

    protected String getDecodedValue(String sValue, PO po) {
        String sRet = sValue;
        if (sValue != null) {
            if (sValue.startsWith("@COL=")) {
                Object o = po.get_Value(sValue.substring(5));
                if (o != null) {
                    sRet = o.toString();
                }
            } else if (sValue.startsWith("@") && sValue.endsWith("@") && sValue.length() > 1) {
                sRet = Env.parseVariable(sValue, po, null, false);
            }
        }
        return sRet;
    }

    private boolean compareNumber(Number valueObj, String value1, String value2) {
        BigDecimal valueObjB = null;
        BigDecimal value1B = null;
        BigDecimal value2B = null;
        try {
            valueObjB = valueObj instanceof BigDecimal ? (BigDecimal)valueObj : (valueObj instanceof Integer ? new BigDecimal((Integer)valueObj) : new BigDecimal(String.valueOf(valueObj)));
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("compareNumber - valueObj=" + String.valueOf(valueObj) + " - " + e.toString());
            }
            return this.compareString(valueObj, value1, value2);
        }
        try {
            value1B = new BigDecimal(value1);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("compareNumber - value1=" + value1 + " - " + e.toString());
            }
            return this.compareString(valueObj, value1, value2);
        }
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObjB.compareTo(value1B) == 0;
        }
        if (">>".equals(op)) {
            return valueObjB.compareTo(value1B) > 0;
        }
        if (">=".equals(op)) {
            return valueObjB.compareTo(value1B) >= 0;
        }
        if ("<<".equals(op)) {
            return valueObjB.compareTo(value1B) < 0;
        }
        if ("<=".equals(op)) {
            return valueObjB.compareTo(value1B) <= 0;
        }
        if ("~~".equals(op)) {
            return valueObjB.compareTo(value1B) == 0;
        }
        if ("!=".equals(op)) {
            return valueObjB.compareTo(value1B) != 0;
        }
        if ("SQ".equals(op)) {
            throw new IllegalArgumentException("SQL not Implemented");
        }
        if ("AB".equals(op)) {
            if (valueObjB.compareTo(value1B) < 0) {
                return false;
            }
            try {
                value2B = new BigDecimal(String.valueOf(value2));
                return valueObjB.compareTo(value2B) <= 0;
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("compareNumber - value2=" + value2 + " - " + e.toString());
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown Operation=" + op);
    }

    private boolean compareString(Object valueObj, String value1S, String value2S) {
        this.m_numeric = false;
        String valueObjS = String.valueOf(valueObj);
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObjS.compareTo(value1S) == 0;
        }
        if (">>".equals(op)) {
            return valueObjS.compareTo(value1S) > 0;
        }
        if (">=".equals(op)) {
            return valueObjS.compareTo(value1S) >= 0;
        }
        if ("<<".equals(op)) {
            return valueObjS.compareTo(value1S) < 0;
        }
        if ("<=".equals(op)) {
            return valueObjS.compareTo(value1S) <= 0;
        }
        if ("~~".equals(op)) {
            return valueObjS.compareTo(value1S) == 0;
        }
        if ("!=".equals(op)) {
            return valueObjS.compareTo(value1S) != 0;
        }
        if ("SQ".equals(op)) {
            throw new IllegalArgumentException("SQL not Implemented");
        }
        if ("AB".equals(op)) {
            if (valueObjS.compareTo(value1S) < 0) {
                return false;
            }
            return valueObjS.compareTo(value2S) <= 0;
        }
        throw new IllegalArgumentException("Unknown Operation=" + op);
    }

    private boolean compareBoolean(Boolean valueObj, String value1S, String value2S) {
        this.m_numeric = false;
        Boolean value1B = Boolean.valueOf(value1S) != false || "Y".equalsIgnoreCase(value1S);
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObj.equals(value1B);
        }
        if ("!=".equals(op)) {
            return !valueObj.equals(value1B);
        }
        throw new IllegalArgumentException("Not Supported =" + op);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWFNextCondition[");
        sb.append(this.get_ID()).append(",SeqNo=").append(this.getSeqNo()).append("]");
        return sb.toString();
    }

    @Override
    public MWFNextCondition markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    private Object getColumnSQLValue(PO po) throws SQLException {
        String columnSQL = this.getSQLStatement();
        if (columnSQL.indexOf("@") >= 0) {
            columnSQL = Env.parseVariable(columnSQL, po, po.get_TrxName(), false);
        }
        String tableName = po.get_TableName();
        String pkName = po.get_KeyColumns() != null && po.get_KeyColumns().length == 1 ? po.get_KeyColumns()[0] : po.getUUIDColumnName();
        String resultSql = String.format("SELECT (%s) FROM %s WHERE %s = ?", columnSQL, tableName, pkName);
        Throwable throwable = null;
        Object var7_8 = null;
        try (CPreparedStatement pstmt = DB.prepareStatement(resultSql, 1003, 1007, po.get_TrxName());){
            if (pkName.endsWith("_UU")) {
                pstmt.setString(1, po.get_ValueAsString(po.getUUIDColumnName()));
            } else {
                pstmt.setInt(1, po.get_ID());
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                return rs.getObject(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!Util.isEmpty(this.getSQLStatement(), true)) {
            this.setAD_Column_ID(0);
        }
        return true;
    }
}

