/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MElementValue;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class Charge {
    protected int m_WindowNo = 0;
    protected int m_C_Element_ID = 0;
    private int m_C_AcctSchema_ID = 0;
    private int m_C_TaxCategory_ID = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private MAcctSchema m_acctSchema = null;
    protected static final CLogger log = CLogger.getCLogger(Charge.class);
    private String m_trxName;
    protected StringBuffer listCreated;
    protected StringBuffer listRejected;

    public Charge() {
        this.findChargeElementID();
        this.findTaxCategoryID();
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public Vector<Vector<Object>> getData() {
        Vector<Vector<Object>> data;
        block6: {
            data = new Vector<Vector<Object>>();
            String sql = "SELECT C_ElementValue_ID,Value, Name, AccountType FROM C_ElementValue WHERE AccountType IN ('R','E') AND IsSummary='N' AND C_Element_ID=? ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.m_trxName);
                    pstmt.setInt(1, this.m_C_Element_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(4);
                        line.add(Boolean.FALSE);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        line.add(rs.getString(3));
                        boolean isExpenseType = rs.getString(4).equals("E");
                        line.add(isExpenseType);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected void findChargeElementID() {
        block6: {
            this.m_C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID");
            String sql = "SELECT C_Element_ID FROM C_AcctSchema_Element WHERE ElementType='AC' AND C_AcctSchema_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.m_trxName);
                    pstmt.setInt(1, this.m_C_AcctSchema_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_C_Element_ID = rs.getInt(1);
                    }
                }
                catch (SQLException exception) {
                    log.log(Level.SEVERE, sql, (Throwable)exception);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>(4);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Value"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Expense"));
        return columnNames;
    }

    public void setColumnClass(IMiniTable dataTable) {
        dataTable.setColumnClass(0, Boolean.class, false);
        dataTable.setColumnClass(1, String.class, true);
        dataTable.setColumnClass(2, String.class, true);
        dataTable.setColumnClass(3, Boolean.class, true);
        dataTable.autoSize();
    }

    protected void findTaxCategoryID() {
        block6: {
            this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
            String sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE IsDefault='Y' AND AD_Client_ID=?";
            this.m_C_TaxCategory_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.m_trxName);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_C_TaxCategory_ID = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public int createElementValue(String value, String name, boolean isExpenseType) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(name);
        }
        MElementValue ev = new MElementValue(Env.getCtx(), value, name, null, isExpenseType ? "E" : "R", "N", false, false, this.m_trxName);
        ev.setAD_Org_ID(this.m_AD_Org_ID);
        ev.setC_Element_ID(this.m_C_Element_ID);
        try {
            ev.saveEx();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "C_ElementValue_ID not created", (Throwable)e);
            return 0;
        }
        return ev.getC_ElementValue_ID();
    }

    public int createCharge(String name, int elementValueId) {
        this.refreshAccountSchema();
        if (!this.isAccountSchemaValid()) {
            return 0;
        }
        MAccount account = this.getAccount(elementValueId);
        if (account == null) {
            return 0;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(name + " - ");
        }
        MCharge charge = new MCharge(Env.getCtx(), 0, this.m_trxName);
        charge.setName(account.getAccount().getValue() + " " + name);
        charge.setC_TaxCategory_ID(this.m_C_TaxCategory_ID);
        try {
            charge.saveEx();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, name + " not created", (Throwable)e);
            return 0;
        }
        this.updateAccount(charge, account);
        return charge.getC_Charge_ID();
    }

    private void updateAccount(MCharge charge, MAccount account) {
        StringBuffer sql = this.createUpdateAccountSql(charge, account);
        int noAffectedRows = DB.executeUpdate((String)sql.toString(), (String)this.m_trxName);
        if (noAffectedRows != 1) {
            log.log(Level.SEVERE, "Update #" + noAffectedRows + "\n" + sql.toString());
        }
    }

    private boolean isAccountSchemaValid() {
        if (this.m_acctSchema == null) {
            return false;
        }
        return this.m_acctSchema.getC_AcctSchema_ID() != 0;
    }

    private StringBuffer createUpdateAccountSql(MCharge charge, MAccount account) {
        StringBuffer sql = new StringBuffer("UPDATE C_Charge_Acct ");
        sql.append("SET CH_Expense_Acct=").append(account.getC_ValidCombination_ID());
        sql.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
        sql.append(" AND C_AcctSchema_ID=").append(this.m_C_AcctSchema_ID);
        return sql;
    }

    private void refreshAccountSchema() {
        if (this.m_acctSchema == null) {
            this.m_acctSchema = new MAcctSchema(Env.getCtx(), this.m_C_AcctSchema_ID, this.m_trxName);
        }
    }

    private MAccount getAccount(int elementValueId) {
        Properties ctx = Env.getCtx();
        MAccount defaultAccount = MAccount.getDefault((MAcctSchema)this.m_acctSchema, (boolean)true);
        MAccount account = MAccount.get((Properties)ctx, (int)Env.getAD_Client_ID((Properties)ctx), (int)Env.getAD_Org_ID((Properties)ctx), (int)this.m_acctSchema.getC_AcctSchema_ID(), (int)elementValueId, (int)defaultAccount.getC_SubAcct_ID(), (int)defaultAccount.getM_Product_ID(), (int)defaultAccount.getC_BPartner_ID(), (int)defaultAccount.getAD_OrgTrx_ID(), (int)defaultAccount.getC_LocFrom_ID(), (int)defaultAccount.getC_LocTo_ID(), (int)defaultAccount.getC_SalesRegion_ID(), (int)defaultAccount.getC_Project_ID(), (int)defaultAccount.getC_Campaign_ID(), (int)defaultAccount.getC_Activity_ID(), (int)defaultAccount.getUser1_ID(), (int)defaultAccount.getUser2_ID(), (int)defaultAccount.getUserElement1_ID(), (int)defaultAccount.getUserElement2_ID(), (String)this.m_trxName);
        return account;
    }

    public void createAccount(IMiniTable dataTable) {
        log.config("");
        this.listCreated = new StringBuffer();
        this.listRejected = new StringBuffer();
        int rows = dataTable.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)dataTable.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)dataTable.getValueAt(i, 1);
                int C_ElementValue_ID = pp.getKey();
                String name = (String)dataTable.getValueAt(i, 2);
                int C_Charge_ID = this.createCharge(name, C_ElementValue_ID);
                if (C_Charge_ID == 0) {
                    if (this.listRejected.length() > 0) {
                        this.listRejected.append(", ");
                    }
                    this.listRejected.append(name);
                } else {
                    if (this.listCreated.length() > 0) {
                        this.listCreated.append(", ");
                    }
                    this.listCreated.append(name);
                }
                dataTable.setValueAt(Boolean.FALSE, i, 0);
            }
            ++i;
        }
    }

    public String getCreatedAccountNames() {
        return this.listCreated != null ? this.listCreated.toString() : "";
    }

    public String getRejectedAccountNames() {
        return this.listRejected != null ? this.listRejected.toString() : "";
    }

    public static enum EColumn {
        SELECT(0, "Select"),
        VALUE(1, "Value"),
        NAME(2, "Name"),
        EXPENSE(3, "Expense");

        private final int m_index;
        private final String m_title;

        private EColumn(int index, String title) {
            this.m_index = index;
            this.m_title = title;
        }

        public String title() {
            return this.m_title;
        }

        public int index() {
            return this.m_index;
        }
    }
}

