/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.util.ServerContext;
import org.compiere.model.MAuthorizationCredential;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class OAuthCodeCallbackHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 8071951954959980796L;
    public static final String CODE_URL_PARAM_NAME = "code";
    public static final String ERROR_URL_PARAM_NAME = "error";
    public static final String STATE_URL_PARAM_NAME = "state";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String errmsg = null;
        String msg = "";
        String[] error = req.getParameterValues(ERROR_URL_PARAM_NAME);
        if (error != null && error.length > 0) {
            errmsg = error[0];
        }
        String[] code = null;
        if (errmsg == null && ((code = req.getParameterValues(CODE_URL_PARAM_NAME)) == null || code.length == 0)) {
            errmsg = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthCallback_MissingParameter", (Object[])new Object[]{CODE_URL_PARAM_NAME});
        }
        String[] state = null;
        if (errmsg == null && ((state = req.getParameterValues(STATE_URL_PARAM_NAME)) == null || state.length == 0)) {
            errmsg = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthCallback_MissingParameter", (Object[])new Object[]{STATE_URL_PARAM_NAME});
        }
        String msgClose = "";
        try {
            String uuidcol;
            MTable pinstanceTable;
            Properties localctx = new Properties();
            ServerContext.setCurrentInstance((Properties)localctx);
            MPInstance pinstance = null;
            if (errmsg == null && (pinstance = (MPInstance)(pinstanceTable = MTable.get((int)282)).getPO((uuidcol = PO.getUUIDColumnName((String)"AD_PInstance")) + "=?", new Object[]{state[0]}, null)) == null) {
                errmsg = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthCallback_InvalidState");
            }
            MAuthorizationCredential credential = null;
            MPInstancePara paramAnswer = null;
            if (errmsg == null) {
                Env.getCtx().setProperty("#AD_Client_ID", String.valueOf(pinstance.getAD_Client_ID()));
                Env.getCtx().setProperty("#AD_User_ID", String.valueOf(pinstance.getCreatedBy()));
                MPInstancePara[] mPInstanceParaArray = pinstance.getParameters();
                int n = mPInstanceParaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MPInstancePara param = mPInstanceParaArray[n2];
                    if ("AD_AuthorizationCredential_ID".equals(param.getParameterName())) {
                        credential = new MAuthorizationCredential(Env.getCtx(), param.getP_Number().intValue(), null);
                    } else if ("AD_Language".equals(param.getParameterName())) {
                        Env.getCtx().setProperty("#AD_Language", param.getP_String());
                    } else if ("Auth_CallbackAnswer".equals(param.getParameterName())) {
                        paramAnswer = param;
                    }
                    ++n2;
                }
                if (credential == null || credential.get_ID() <= 0) {
                    errmsg = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthCallback_NotFoundState");
                }
                if (paramAnswer == null) {
                    paramAnswer = pinstance.createParameter(50, "Auth_CallbackAnswer", null);
                } else if (paramAnswer.getP_String() != null) {
                    errmsg = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthCallback_AlreadyUsedLink");
                }
            }
            if (errmsg == null) {
                msg = credential.processToken(code[0], pinstance);
                paramAnswer.setP_String(msg);
                paramAnswer.saveEx();
            }
            msgClose = URLEncoder.encode(Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthPopup_Close"), "UTF-8");
        }
        finally {
            ServerContext.dispose();
        }
        String url = null;
        msg = URLEncoder.encode(msg, "UTF-8");
        if (errmsg == null) {
            url = resp.encodeRedirectURL("callback.jsp?msg=" + msg + "&closemsg=" + msgClose);
        } else {
            String msgError = URLEncoder.encode(Msg.getMsg((Properties)Env.getCtx(), (String)"Error"), "UTF-8");
            errmsg = URLEncoder.encode(errmsg, "UTF-8");
            url = resp.encodeRedirectURL("callback.jsp?error=" + errmsg + "&errmsg=" + msgError + "&closemsg=" + msgClose);
        }
        resp.sendRedirect(url);
    }
}

