/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MField;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MTab
extends X_AD_Tab
implements ImmutablePOSupport {
    private static final long serialVersionUID = -8111075325920938135L;
    private static ImmutableIntPOCache<Integer, MTab> s_cache = new ImmutableIntPOCache("AD_Tab", 20);
    private MField[] m_fields = null;
    private static CLogger s_log = CLogger.getCLogger(MTab.class);

    public static MTab get(int AD_Tab_ID) {
        Integer key = AD_Tab_ID;
        MTab retValue = s_cache.get(Env.getCtx(), key, e -> new MTab(Env.getCtx(), (MTab)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTab(Env.getCtx(), AD_Tab_ID, null);
        if (retValue.get_ID() == AD_Tab_ID) {
            s_cache.put(key, retValue);
            return retValue;
        }
        return null;
    }

    public MTab(Properties ctx, String AD_Tab_UU, String trxName) {
        super(ctx, AD_Tab_UU, trxName);
        if (Util.isEmpty(AD_Tab_UU)) {
            this.setInitialDefaults();
        }
    }

    public MTab(Properties ctx, int AD_Tab_ID, String trxName) {
        super(ctx, AD_Tab_ID, trxName);
        if (AD_Tab_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEntityType("U");
        this.setHasTree(false);
        this.setIsReadOnly(false);
        this.setIsSingleRow(false);
        this.setIsSortTab(false);
        this.setIsTranslationTab(false);
        this.setSeqNo(0);
        this.setTabLevel(0);
        this.setIsInsertRecord(true);
        this.setIsAdvancedTab(false);
    }

    public MTab(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTab(MWindow parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MTab(MWindow parent, MTab from) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        MTab.copyValues(from, this);
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MTab(MTab copy) {
        this(Env.getCtx(), copy);
    }

    public MTab(Properties ctx, MTab copy) {
        this(ctx, copy, null);
    }

    public MTab(Properties ctx, MTab copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_fields = copy.m_fields != null ? (MField[])Arrays.stream(copy.m_fields).map(e -> new MField(ctx, (MField)e, trxName)).toArray(MField[]::new) : null;
    }

    public MField[] getFields(boolean reload, String trxName) {
        ArrayList<MField> list;
        block7: {
            if (this.m_fields != null && !reload) {
                return this.m_fields;
            }
            String sql = "SELECT * FROM AD_Field WHERE AD_Tab_ID=? ORDER BY SeqNo";
            list = new ArrayList<MField>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, this.getAD_Tab_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MField(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_fields = new MField[list.size()];
        list.toArray(this.m_fields);
        return this.m_fields;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("AD_Table_ID") && this.getFields(false, this.get_TrxName()).length > 0) {
            this.log.saveError("Error", "Cannot change table if there are related fields");
            return false;
        }
        if (this.isReadOnly() && this.isInsertRecord()) {
            this.setIsInsertRecord(false);
        }
        if (this.is_new() || this.is_ValueChanged("AD_TabType")) {
            this.setIsSortTab("SORT".equals(this.getAD_TabType()));
        }
        if (this.isSortTab() && this.getAD_ColumnSortOrder_ID() == 0) {
            throw new FillMandatoryException(new String[]{"AD_ColumnSortOrder_ID"});
        }
        return true;
    }

    public static int getTab_ID(int AD_Window_ID, String TabName) {
        int retValue;
        block6: {
            retValue = 0;
            String SQL = "SELECT AD_Tab_ID FROM AD_Tab WHERE AD_Window_ID= ?  AND Name = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setInt(1, AD_Window_ID);
                    pstmt.setString(2, TabName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public int getParentTabID() {
        int parentTabID = -1;
        if (this.getTabLevel() == 0) {
            return parentTabID;
        }
        parentTabID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Tab_ID FROM   AD_Tab WHERE  AD_Window_ID = ?        AND SeqNo < ?        AND TabLevel = ?        AND IsActive = 'Y' ORDER  BY SeqNo DESC", this.getAD_Window_ID(), this.getSeqNo(), this.getTabLevel() - 1);
        return parentTabID;
    }

    @Override
    public MTab markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

