/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.util.ClusterUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.distributed.IClusterService;

public class Process {
    private static final CLogger classLog = CLogger.getCLogger(Process.class);

    private Process() {
    }

    public static MPInstance createPInstance(MProcess process, JsonObject jsonObject, boolean runAsJob) {
        MPInstancePara[] iParams;
        MPInstance pInstance = new MPInstance(process, 0, 0, null);
        MPInstancePara[] mPInstanceParaArray = iParams = pInstance.getParameters();
        int n = iParams.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            MPInstancePara iParam = mPInstanceParaArray[n2];
            MProcessPara processPara = process.getParameter(iParam.getParameterName());
            String columnName = processPara.getColumnName();
            String propertyName = TypeConverterUtils.toPropertyName(columnName);
            GridFieldVO gridFieldVO = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)0, (int)0, (int)0, (int)0, (String)columnName, (String)processPara.getName(), (int)processPara.getAD_Reference_ID(), (int)processPara.getAD_Reference_Value_ID(), (boolean)processPara.isMandatory(), (boolean)false, (String)"");
            gridFieldVO.AD_Column_ID = processPara.getAD_Process_Para_ID();
            GridField gridField = new GridField(gridFieldVO);
            JsonElement element = jsonObject.get(propertyName);
            if (element == null) {
                element = jsonObject.get(columnName);
            }
            if (element != null && (value = TypeConverterUtils.fromJsonValue(gridField, element)) != null) {
                if (value instanceof BigDecimal) {
                    iParam.setP_Number((BigDecimal)value);
                } else if (value instanceof Number) {
                    iParam.setP_Number(((Number)value).intValue());
                } else if (value instanceof Timestamp) {
                    iParam.setP_Date((Timestamp)value);
                } else {
                    iParam.setP_String(value.toString());
                }
            }
            if (processPara.isRange()) {
                Object value2;
                String toPropertyName = String.valueOf(propertyName) + "_to";
                element = jsonObject.get(toPropertyName);
                if (element == null) {
                    element = jsonObject.get(String.valueOf(columnName) + "_to");
                }
                if (element != null && (value2 = TypeConverterUtils.fromJsonValue(gridField, element)) != null) {
                    if (value2 instanceof BigDecimal) {
                        iParam.setP_Number_To((BigDecimal)value2);
                    } else if (value2 instanceof Number) {
                        iParam.setP_Number_To(((Number)value2).intValue());
                    } else if (value2 instanceof Timestamp) {
                        iParam.setP_Date_To((Timestamp)value2);
                    } else {
                        iParam.setP_String_To(value2.toString());
                    }
                }
            }
            if (iParam.is_Changed()) {
                iParam.saveEx();
            }
            ++n2;
        }
        if (runAsJob) {
            pInstance.setIsRunAsJob(true);
            pInstance.setIsProcessing(true);
            JsonElement notificationTypeElement = jsonObject.get("notification-type");
            if (notificationTypeElement != null && notificationTypeElement.isJsonPrimitive()) {
                String notificationType = notificationTypeElement.getAsString();
                if (notificationType.equals("E") || notificationType.equals("N") || notificationType.equals("B")) {
                    pInstance.setNotificationType(notificationType);
                } else {
                    pInstance.setNotificationType("B");
                }
            } else {
                pInstance.setNotificationType("B");
            }
        }
        pInstance.saveEx();
        return pInstance;
    }

    public static ProcessInfo createProcessInfo(MProcess process, MPInstance pInstance, JsonObject jsonObject) {
        int Record_ID;
        ProcessInfo processInfo = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        JsonElement recordIdElement = jsonObject.get("record-id");
        if (recordIdElement != null && recordIdElement.isJsonPrimitive() && (Record_ID = recordIdElement.getAsInt()) > 0) {
            MTable table;
            JsonElement tableNameElement;
            processInfo.setRecord_ID(Record_ID);
            JsonElement tableIdElement = jsonObject.get("table-id");
            int AD_Table_ID = 0;
            if (tableIdElement != null && tableIdElement.isJsonPrimitive()) {
                AD_Table_ID = tableIdElement.getAsInt();
            }
            if (AD_Table_ID == 0 && (tableNameElement = jsonObject.get("model-name")) != null && tableNameElement.isJsonPrimitive() && (table = MTable.get((Properties)Env.getCtx(), (String)tableNameElement.getAsString())) != null) {
                AD_Table_ID = table.getAD_Table_ID();
            }
            if (AD_Table_ID > 0) {
                processInfo.setTable_ID(AD_Table_ID);
            }
        }
        if (process.isReport()) {
            JsonElement isSummaryElement;
            JsonElement reportTypeElement = jsonObject.get("report-type");
            if (reportTypeElement != null && reportTypeElement.isJsonPrimitive()) {
                processInfo.setReportType(reportTypeElement.getAsString());
            }
            if ((isSummaryElement = jsonObject.get("is-summary")) != null && isSummaryElement.isJsonPrimitive()) {
                processInfo.setIsSummary(isSummaryElement.getAsBoolean());
            }
        }
        processInfo.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        processInfo.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setAD_Process_UU(process.getAD_Process_UU());
        processInfo.setIsBatch(true);
        processInfo.setPrintPreview(true);
        processInfo.setExport(true);
        JsonElement printFormatIdElement = jsonObject.get("print-format-id");
        if (printFormatIdElement != null && printFormatIdElement.isJsonPrimitive()) {
            int AD_PrintFormat_ID;
            String printFormatStr = printFormatIdElement.getAsString();
            boolean isUUID = Util.isUUID((String)printFormatStr);
            int n = AD_PrintFormat_ID = isUUID ? Process.getPrintFormatId(printFormatStr) : Integer.valueOf(printFormatStr);
            if (AD_PrintFormat_ID > 0) {
                MPrintFormat format = new MPrintFormat(Env.getCtx(), AD_PrintFormat_ID, null);
                processInfo.setSerializableObject((Serializable)format);
            }
        }
        if (!Util.isEmpty((String)process.getJasperReport())) {
            if ("HTML".equals(processInfo.getReportType())) {
                processInfo.setExportFileExtension("html");
            } else if ("CSV".equals(processInfo.getReportType())) {
                processInfo.setExportFileExtension("csv");
            } else if ("XLS".equals(processInfo.getReportType())) {
                processInfo.setExportFileExtension("xls");
            } else {
                processInfo.setExportFileExtension("pdf");
            }
        }
        return processInfo;
    }

    public static JsonObject toJsonObject(ProcessInfo processInfo, String processSlug) {
        IClusterService service;
        File file;
        JsonObject processInfoJson = new JsonObject();
        processInfoJson.addProperty("AD_PInstance_ID", (Number)processInfo.getAD_PInstance_ID());
        processInfoJson.addProperty("process", processSlug);
        processInfoJson.addProperty("summary", processInfo.getSummary());
        String data = processInfo.getJsonData();
        if (data != null && !data.isEmpty()) {
            JsonElement dataElement;
            try {
                dataElement = JsonParser.parseString((String)data);
                processInfoJson.add("data", (JsonElement)dataElement.getAsJsonObject());
            }
            catch (Exception e) {
                dataElement = null;
                classLog.warning(e.getMessage());
            }
        }
        processInfoJson.addProperty("isError", Boolean.valueOf(processInfo.isError()));
        if (processInfo.getPDFReport() != null) {
            file = processInfo.getPDFReport();
            String property = "reportFile";
            Process.addFile(processInfoJson, file, property, "pdf");
        }
        if (processInfo.getExportFile() != null) {
            file = processInfo.getExportFile();
            String extension = processInfo.getExportFileExtension();
            String property = "exportFile";
            Process.addFile(processInfoJson, file, property, extension);
        }
        if ((service = ClusterUtil.getClusterService()) != null && service.getLocalMember() != null) {
            processInfoJson.addProperty("nodeId", service.getLocalMember().getId());
        }
        ProcessInfoUtil.setLogFromDB((ProcessInfo)processInfo);
        ProcessInfoLog[] logs = processInfo.getLogs();
        if (logs != null && logs.length > 0) {
            JsonArray logArray = new JsonArray();
            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)15);
            ProcessInfoLog[] processInfoLogArray = logs;
            int n = logs.length;
            int n2 = 0;
            while (n2 < n) {
                String logData;
                ProcessInfoLog log = processInfoLogArray[n2];
                HashMap<String, Object> logMap = new HashMap<String, Object>();
                if (log.getP_Date() != null) {
                    logMap.put("date", dateFormat.format(log.getP_Date()));
                }
                if (log.getP_Number() != null) {
                    logMap.put("number", log.getP_Number());
                }
                if ((logData = log.getJsonData()) != null && !logData.isEmpty()) {
                    JsonElement dataElement;
                    try {
                        dataElement = JsonParser.parseString((String)logData);
                        logMap.put("data", dataElement.getAsJsonObject());
                    }
                    catch (Exception exception) {
                        dataElement = null;
                    }
                }
                if (log.getP_Msg() != null) {
                    logMap.put("msg", Msg.parseTranslation((Properties)Env.getCtx(), (String)log.getP_Msg()));
                }
                Gson gson = new Gson();
                JsonObject jsonObject = gson.toJsonTree(logMap).getAsJsonObject();
                logArray.add((JsonElement)jsonObject);
                ++n2;
            }
            processInfoJson.add("logs", (JsonElement)logArray);
        }
        return processInfoJson;
    }

    private static void addFile(JsonObject processInfoJson, File file, String property, String extension) {
        JsonPrimitive jsonElement = null;
        try {
            if ("json".equals(extension)) {
                FileReader reader = new FileReader(file.getAbsolutePath());
                JsonReader jsonReader = new JsonReader((Reader)reader);
                jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
            } else {
                ByteArrayOutputStream ba = Process.loadFile(file);
                String base64String = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                jsonElement = new JsonPrimitive(base64String);
            }
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            throw new AdempiereException("Could not create JSON element from file " + file.getAbsolutePath(), e);
        }
        if (jsonElement != null) {
            processInfoJson.add(property, (JsonElement)jsonElement);
        }
        processInfoJson.addProperty(String.valueOf(property) + "Name", file.getName());
        processInfoJson.addProperty(String.valueOf(property) + "Length", (Number)file.length());
    }

    private static ByteArrayOutputStream loadFile(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bos;
    }

    private static int getPrintFormatId(String uuid) {
        String sql = "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_PrintFormat_UU = ?";
        return DB.getSQLValue(null, (String)sql, (String)uuid);
    }
}

