/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.MenuTreeResource;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MMenu;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MenuTreeResourceImpl
implements MenuTreeResource {
    private static final CLogger log = CLogger.getCLogger(MenuTreeResourceImpl.class);

    @Override
    public Response getMenu(String id) {
        try {
            boolean isUUID = RestUtils.isUUID(id);
            int menuTreeId = isUUID ? this.getMenuTreeID(id) : Integer.valueOf(id).intValue();
            JsonObject jsonRoot = new JsonObject();
            MTree mTree = new MTree(Env.getCtx(), menuTreeId, false, true, null);
            MTreeNode rootNode = mTree.getRoot();
            jsonRoot.addProperty("Name", rootNode.getName());
            jsonRoot.addProperty("Description", rootNode.getDescription());
            JsonArray menuEntries = new JsonArray();
            this.generateMenu(menuEntries, rootNode);
            jsonRoot.add("entries", (JsonElement)menuEntries);
            return Response.ok((Object)jsonRoot.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get menu tree with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    private void generateMenu(JsonArray menuEntries, MTreeNode mNode) {
        String[] includedColumns = new String[]{"Name", "Description", "IsSOTrx", "PredefinedContextVariables", "EntityType", "Action", "AD_Window_ID", "AD_Workflow_ID", "AD_Task_ID", "AD_Process_ID", "AD_Form_ID", "AD_InfoWindow_ID"};
        Enumeration nodeEnum = mNode.children();
        while (nodeEnum.hasMoreElements()) {
            IPOSerializer serializer;
            MTreeNode mChildNode = (MTreeNode)nodeEnum.nextElement();
            if (mChildNode.getChildCount() != 0) {
                MMenu menu = MMenu.get((int)mChildNode.getNode_ID());
                serializer = IPOSerializer.getPOSerializer("AD_Menu", MTable.getClass((String)"AD_Menu"));
                JsonObject nodeMenuObject = serializer.toJson((PO)menu, includedColumns, null);
                JsonArray childMenuEntries = new JsonArray();
                this.generateMenu(childMenuEntries, mChildNode);
                nodeMenuObject.add("entries", (JsonElement)childMenuEntries);
                menuEntries.add((JsonElement)nodeMenuObject);
                continue;
            }
            if (mChildNode.getNode_ID() <= 0) continue;
            MMenu entry = MMenu.get((int)mChildNode.getNode_ID());
            serializer = IPOSerializer.getPOSerializer("AD_Menu", MTable.getClass((String)"AD_Menu"));
            JsonObject nodeEntryObject = serializer.toJson((PO)entry, includedColumns, null);
            menuEntries.add((JsonElement)nodeEntryObject);
        }
    }

    private int getMenuTreeID(String uuid) {
        String sql = "SELECT AD_Tree_ID FROM AD_Tree WHERE AD_Tree_UU = ?";
        return DB.getSQLValue(null, (String)sql, (String)uuid);
    }
}

