/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.trekglobal.idempiere.rest.api.model.X_REST_RefreshToken;
import com.trekglobal.idempiere.rest.api.v1.jwt.LoginClaims;
import com.trekglobal.idempiere.rest.api.v1.jwt.TokenUtils;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRefreshToken
extends X_REST_RefreshToken
implements ImmutablePOSupport {
    private static final long serialVersionUID = 728068698206813303L;
    private static ImmutablePOCache<String, MRefreshToken> s_refreshtoken_cache_from_authtoken = new ImmutablePOCache("REST_RefreshToken", 40);

    public MRefreshToken(Properties ctx, String REST_RefreshToken_UUID, String trxName) {
        super(ctx, REST_RefreshToken_UUID, trxName);
    }

    public MRefreshToken(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRefreshToken(MRefreshToken copy) {
        this(Env.getCtx(), copy);
    }

    public MRefreshToken(Properties ctx, MRefreshToken copy) {
        this(ctx, copy, null);
    }

    public MRefreshToken(Properties ctx, MRefreshToken copy, String trxName) {
        this(ctx, "", trxName);
        this.copyPO(copy);
    }

    public static MRefreshToken get(String refreshToken) {
        return (MRefreshToken)new Query(Env.getCtx(), "REST_RefreshToken", "RefreshToken=?", null).setParameters(new Object[]{refreshToken}).first();
    }

    public static MRefreshToken getFromToken(String authToken) {
        Properties ctx = Env.getCtx();
        MRefreshToken retValue = null;
        if (s_refreshtoken_cache_from_authtoken.containsKey((Object)authToken)) {
            retValue = (MRefreshToken)s_refreshtoken_cache_from_authtoken.get(ctx, (Object)authToken.toString(), e -> new MRefreshToken(ctx, (MRefreshToken)e));
            return retValue;
        }
        retValue = (MRefreshToken)new Query(Env.getCtx(), "REST_RefreshToken", "Token=?", null).setParameters(new Object[]{authToken}).first();
        s_refreshtoken_cache_from_authtoken.put((Object)authToken, (PO)retValue, e -> new MRefreshToken(ctx, (MRefreshToken)e));
        return retValue;
    }

    public static MRefreshToken getFromParent(String parentToken) {
        return (MRefreshToken)new Query(Env.getCtx(), "REST_RefreshToken", "ParentToken=?", null).setParameters(new Object[]{parentToken}).first();
    }

    public static MRefreshToken getValidForRefresh(String refreshToken) {
        return (MRefreshToken)new Query(Env.getCtx(), "REST_RefreshToken", "RefreshToken=? AND RevokedAt IS NULL AND (ExpiresAt IS NULL OR ExpiresAt>=getDate()) AND (AbsoluteExpiresAt IS NULL OR AbsoluteExpiresAt>=getDate())", null).setOnlyActiveRecords(true).setParameters(new Object[]{refreshToken}).first();
    }

    @Override
    public void setToken(String Token) {
        try {
            Algorithm algorithm = Algorithm.HMAC512((String)TokenUtils.getTokenSecret());
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(TokenUtils.getTokenIssuer()).acceptExpiresAt(Instant.MAX.getEpochSecond()).build();
            DecodedJWT jwt = verifier.verify(Token);
            int clientId = -1;
            int userId = -1;
            int orgId = -1;
            Claim claim = jwt.getClaim(LoginClaims.AD_Client_ID.name());
            if (claim.isNull() || claim.isMissing()) {
                throw new AdempiereException("Invalid token - no clientId");
            }
            clientId = claim.asInt();
            this.setAD_Client_ID(clientId);
            claim = jwt.getClaim(LoginClaims.AD_User_ID.name());
            if (claim.isNull() || claim.isMissing()) {
                throw new AdempiereException("Invalid token - no userId");
            }
            userId = claim.asInt();
            this.set_ValueNoCheck("CreatedBy", userId);
            claim = jwt.getClaim(LoginClaims.AD_Org_ID.name());
            if (claim.isNull() || claim.isMissing()) {
                throw new AdempiereException("Invalid token - no orgId");
            }
            orgId = claim.asInt();
            this.setAD_Org_ID(orgId);
        }
        catch (Exception e) {
            throw new AdempiereException("Invalid token -> " + e.getMessage(), (Throwable)e);
        }
        super.setToken(Token);
    }

    public static boolean existsAuthToken(String authToken) {
        return new Query(Env.getCtx(), "REST_RefreshToken", "Token=?", null).setParameters(new Object[]{authToken}).match();
    }

    public static boolean isParent(String refreshToken) {
        return new Query(Env.getCtx(), "REST_RefreshToken", "ParentToken=?", null).setParameters(new Object[]{refreshToken}).match();
    }

    public static void logout(String authToken) {
        MRefreshToken rtc = MRefreshToken.getFromToken(authToken);
        MRefreshToken rt = new MRefreshToken(rtc);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        rt.revoke(now, "L");
        rt.saveEx();
        String refreshToken = rt.getRefreshToken();
        MRefreshToken childrt = MRefreshToken.getFromParent(refreshToken);
        while (childrt != null) {
            if (childrt.getRevokedAt() == null) {
                childrt.revoke(now, "L");
                childrt.saveEx();
            }
            childrt = MRefreshToken.getFromParent(childrt.getRefreshToken());
        }
        MRefreshToken parentrt = MRefreshToken.get(rt.getParentToken());
        while (parentrt != null) {
            if (parentrt.getRevokedAt() == null) {
                parentrt.revoke(now, "L");
                parentrt.saveEx();
            }
            parentrt = MRefreshToken.get(parentrt.getParentToken());
        }
    }

    public static void breachDetected(String refreshToken) {
        MRefreshToken rt = MRefreshToken.get(refreshToken);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        rt.revoke(now, "B");
        rt.saveEx();
        MRefreshToken childrt = MRefreshToken.getFromParent(refreshToken);
        while (childrt != null) {
            childrt.revoke(now, "C");
            childrt.saveEx();
            childrt = MRefreshToken.getFromParent(childrt.getRefreshToken());
        }
        MRefreshToken parentrt = MRefreshToken.get(rt.getParentToken());
        while (parentrt != null) {
            parentrt.revoke(now, "C");
            parentrt.saveEx();
            parentrt = MRefreshToken.get(parentrt.getParentToken());
        }
    }

    public static int expireTokens(String where, String revokeCause, ArrayList<Object> params) {
        StringBuilder whereClause = new StringBuilder("(ExpiresAt IS NULL OR ExpiresAt>=?) AND (AbsoluteExpiresAt IS NULL OR AbsoluteExpiresAt>=?) AND RevokedAt IS NULL");
        if (!Util.isEmpty((String)where)) {
            whereClause.append(" AND ").append(where);
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        params.add(0, now);
        params.add(0, now);
        List rts = new Query(Env.getCtx(), "REST_RefreshToken", whereClause.toString(), null).setParameters(params).list();
        int cnt = 0;
        for (MRefreshToken rt : rts) {
            rt.revoke(now, revokeCause);
            rt.saveEx();
            ++cnt;
        }
        return cnt;
    }

    public void revoke(Timestamp revokedAt, String revokeCause) {
        this.setRevokedAt(revokedAt);
        this.setREST_RevokeCause(revokeCause);
        this.setIsActive(false);
    }

    public static boolean isRevoked(String token) {
        MRefreshToken rt = MRefreshToken.getFromToken(token);
        return rt != null && (rt.getRevokedAt() != null || rt.getAbsoluteExpiresAt() != null && rt.getAbsoluteExpiresAt().before(new Timestamp(System.currentTimeMillis())));
    }

    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        super.makeImmutable();
        return this;
    }
}

