/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json.expand;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.ModelHelper;
import com.trekglobal.idempiere.rest.api.json.POParser;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.expand.ExpandUtils;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import com.trekglobal.idempiere.rest.api.model.X_REST_View;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ExpandParser {
    private PO po;
    private String expandParameter = null;
    private String masterTableName = null;
    private Map<String, String> tableNameSQLStatementMap = new HashMap<String, String>();
    private Map<String, JsonElement> tableNameChildArrayMap = new HashMap<String, JsonElement>();
    private MRestView view;

    public ExpandParser(PO po, String expandParameter) {
        this(po, null, expandParameter);
    }

    public ExpandParser(PO po, MRestView view, String expandParameter) {
        this.po = po;
        this.view = view;
        this.expandParameter = expandParameter;
        this.masterTableName = po.get_TableName();
        this.expandRelatedResources();
    }

    private void expandRelatedResources() {
        if (Util.isEmpty((String)this.expandParameter, (boolean)true)) {
            return;
        }
        HashMap<String, List<String>> detailTablesWithOperators = ExpandUtils.getTableNamesOperatorsMap(this.expandParameter);
        for (Map.Entry<String, List<String>> entry : detailTablesWithOperators.entrySet()) {
            this.expandRelatedResource(entry.getKey(), entry.getValue());
        }
    }

    private void expandRelatedResource(String relatedResource, List<String> operators) {
        if (this.isExpandMaster(relatedResource)) {
            this.expandMaster(relatedResource, operators);
        } else {
            this.expandDetail(relatedResource, operators);
        }
    }

    private boolean isExpandMaster(String relatedResource) {
        int columnIndex;
        String columnName = relatedResource;
        if (this.view != null) {
            MRestViewColumn[] columns = this.view.getColumns();
            boolean found = false;
            MRestViewColumn[] mRestViewColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                MRestViewColumn column = mRestViewColumnArray[n2];
                String viewColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)column.getAD_Column_ID());
                if (column.getName().equals(columnName)) {
                    columnName = viewColumn;
                    found = true;
                    break;
                }
                if (columnName.equals(viewColumn)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                return false;
            }
        }
        if ((columnIndex = this.po.get_ColumnIndex(columnName)) < 0) {
            return false;
        }
        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)this.masterTableName, (String)columnName);
        if (column == null || Util.isEmpty((String)column.getReferenceTableName())) {
            throw new IDempiereRestException("Expand error", "Column " + relatedResource + " cannot be expanded", Response.Status.BAD_REQUEST);
        }
        return true;
    }

    private void expandMaster(String columnName, List<String> operators) {
        this.checkMasterExpandOperators(operators);
        X_REST_View referenceView = null;
        MRestViewColumn restViewColumn = null;
        if (this.view != null) {
            MRestViewColumn[] columns;
            MRestViewColumn[] mRestViewColumnArray = columns = this.view.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                MRestViewColumn column = mRestViewColumnArray[n2];
                String viewColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)column.getAD_Column_ID());
                if (column.getName().equals(columnName)) {
                    columnName = viewColumn;
                    if (column.getREST_ReferenceView_ID() > 0) {
                        referenceView = new MRestView(Env.getCtx(), column.getREST_ReferenceView_ID(), null);
                    }
                    restViewColumn = column;
                    break;
                }
                if (columnName.equals(viewColumn)) {
                    if (column.getREST_ReferenceView_ID() > 0) {
                        referenceView = new MRestView(Env.getCtx(), column.getREST_ReferenceView_ID(), null);
                    }
                    restViewColumn = column;
                    break;
                }
                ++n2;
            }
        }
        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)this.masterTableName, (String)columnName);
        String tableName = referenceView != null ? MTable.getTableName((Properties)Env.getCtx(), (int)referenceView.getAD_Table_ID()) : column.getReferenceTableName();
        String foreignTableID = this.po.get_ValueAsString(columnName);
        Query query = RestUtils.getQuery(tableName, foreignTableID, true, false);
        PO po = query.first();
        this.addSQLStatementToMap(tableName, columnName, query.getSQL());
        POParser poParser = new POParser(tableName, foreignTableID, po);
        if (poParser.isValidPO()) {
            IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, po.getClass());
            String select = ExpandUtils.getSelectClause(operators);
            String[] includes = RestUtils.getSelectedColumns(tableName, select);
            JsonObject json = serializer.toJson(po, (MRestView)referenceView, includes, null);
            this.tableNameChildArrayMap.put(restViewColumn != null ? restViewColumn.getName() : column.getColumnName(), (JsonElement)json);
        }
    }

    private void expandDetail(String detailEntity, List<String> operators) {
        List<PO> childPOs;
        String parentKeyColumn;
        MRestViewRelated restViewRelated = null;
        MRestView detailView = null;
        if (this.view != null) {
            MRestViewRelated[] relateds;
            MRestViewRelated[] mRestViewRelatedArray = relateds = this.view.getRelatedViews();
            int n = relateds.length;
            int n2 = 0;
            while (n2 < n) {
                MRestViewRelated related = mRestViewRelatedArray[n2];
                if (related.getName().equals(detailEntity)) {
                    detailView = new MRestView(Env.getCtx(), related.getREST_RelatedRestView_ID(), null);
                    detailEntity = MTable.getTableName((Properties)Env.getCtx(), (int)detailView.getAD_Table_ID());
                    restViewRelated = related;
                    break;
                }
                ++n2;
            }
            if (detailView == null) {
                return;
            }
        }
        String[] tableNameKeyColumnName = this.getTableNameAndKeyColumnName(detailEntity);
        String tableName = tableNameKeyColumnName[0];
        String childKeyColumn = parentKeyColumn = tableNameKeyColumnName[1];
        if (parentKeyColumn.contains(":")) {
            String[] pcKeys = parentKeyColumn.split("[:]");
            parentKeyColumn = pcKeys[0];
            childKeyColumn = pcKeys[1];
        }
        if ((childPOs = this.getChildPOs(operators, tableName, parentKeyColumn, childKeyColumn)) != null && childPOs.size() > 0) {
            JsonArray childArray = new JsonArray();
            IPOSerializer serializer = IPOSerializer.getPOSerializer(tableName, MTable.getClass((String)tableName));
            String select = ExpandUtils.getSelectClause(operators);
            String[] includes = RestUtils.getSelectedColumns(tableName, select);
            if (detailView != null && includes != null && includes.length > 0) {
                includes = detailView.toColumnNames(includes, true);
            }
            for (PO child : childPOs) {
                JsonObject childJsonObject = serializer.toJson(child, detailView, includes, new String[]{childKeyColumn, "model-name"});
                this.expandChildDetails(child, ExpandUtils.getExpandClause(operators), childJsonObject, detailView);
                childArray.add((JsonElement)childJsonObject);
            }
            this.tableNameChildArrayMap.put(restViewRelated != null ? restViewRelated.getName() : detailEntity, (JsonElement)childArray);
        }
    }

    private void checkMasterExpandOperators(List<String> operators) {
        if (!(Util.isEmpty((String)ExpandUtils.getFilterClause(operators)) && Util.isEmpty((String)ExpandUtils.getOrderByClause(operators)) && Util.isEmpty((String)ExpandUtils.getExpandClause(operators)) && ExpandUtils.getTopClause(operators) <= 0 && ExpandUtils.getSkipClause(operators) <= 0)) {
            throw new IDempiereRestException("Expand error", "Expanding a master only support the $select query operator", Response.Status.BAD_REQUEST);
        }
    }

    private String[] getTableNameAndKeyColumnName(String detailEntity) {
        String[] tableNameKeyColumnName = new String[]{this.getTableName(detailEntity), this.getKeyColumnName(detailEntity)};
        String keyColumn = tableNameKeyColumnName[1];
        if (keyColumn.contains(":")) {
            keyColumn = keyColumn.split("[:]")[0];
        }
        if (this.usesDifferentFK(detailEntity) && !this.isValidTableAndKeyColumn(tableNameKeyColumnName[0], keyColumn)) {
            throw new IDempiereRestException("Expand error", "Column: " + tableNameKeyColumnName[1] + " is not a valid FK for table: " + this.masterTableName, Response.Status.BAD_REQUEST);
        }
        return tableNameKeyColumnName;
    }

    private String getKeyColumnName(String detailEntity) {
        return this.usesDifferentFK(detailEntity) ? detailEntity.substring(detailEntity.indexOf(".") + 1) : RestUtils.getLinkKeyColumnName(this.masterTableName, detailEntity);
    }

    private String getTableName(String detailEntity) {
        return this.usesDifferentFK(detailEntity) ? detailEntity.substring(0, detailEntity.indexOf(".")) : detailEntity;
    }

    private boolean usesDifferentFK(String detailEntity) {
        return detailEntity.contains(".");
    }

    private boolean isValidTableAndKeyColumn(String tableName, String keyColumnName) {
        MTable table = RestUtils.getTableAndCheckAccess(tableName);
        MColumn column = table.getColumn(keyColumnName);
        return column != null && (ExpandUtils.isRecordIDTableIDFK(keyColumnName) || this.masterTableName.equalsIgnoreCase(column.getReferenceTableName()) || MColumn.get((Properties)Env.getCtx(), (String)this.masterTableName, (String)keyColumnName) != null);
    }

    private List<PO> getChildPOs(List<String> operators, String tableName, String parentKeyColumn, String childKeyColumn) {
        ModelHelper modelHelper = this.getModelHelper(operators, tableName, parentKeyColumn, childKeyColumn);
        List<PO> poList = modelHelper.getPOsFromRequest();
        this.addSQLStatementToMap(tableName, childKeyColumn, modelHelper.getSQLStatement());
        return poList;
    }

    private ModelHelper getModelHelper(List<String> operators, String tableName, String parentKeyColumn, String childKeyColumn) {
        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)tableName, (String)childKeyColumn);
        if (column == null) {
            throw new IDempiereRestException("Invalid column for expand: " + childKeyColumn, Response.Status.BAD_REQUEST);
        }
        int parentId = this.masterTableName.equalsIgnoreCase(column.getReferenceTableName()) ? this.po.get_ID() : this.po.get_ValueAsInt(parentKeyColumn);
        String filter = this.getFilterClause(operators, childKeyColumn, parentId);
        String orderBy = ExpandUtils.getOrderByClause(operators);
        int top = ExpandUtils.getTopClause(operators);
        int skip = ExpandUtils.getSkipClause(operators);
        return new ModelHelper(tableName, filter, orderBy, top, skip);
    }

    public String getFilterClause(List<String> operators, String keyColumnName, int keyColumnValue) {
        String requestFilterClause;
        StringBuilder filterClause = new StringBuilder(String.valueOf(keyColumnName) + " eq " + keyColumnValue);
        if (ExpandUtils.isRecordIDTableIDFK(keyColumnName)) {
            filterClause.append(" AND ").append("AD_Table_ID").append(" eq ").append(this.po.get_Table_ID());
        }
        if (!Util.isEmpty((String)(requestFilterClause = ExpandUtils.getFilterClause(operators)))) {
            filterClause.append(" AND ").append(requestFilterClause);
        }
        return filterClause.toString();
    }

    private void expandChildDetails(PO childPO, String expandClause, JsonObject childJson, MRestView detailView) {
        if (Util.isEmpty((String)expandClause)) {
            return;
        }
        ExpandParser expandParser = new ExpandParser(childPO, detailView, expandClause);
        ExpandUtils.addDetailDataToJson(expandParser.getTableNameChildArrayMap(), childJson);
        this.addChildDetailSQLToMap(expandParser.getTableNameSQLStatementMap());
    }

    private void addChildDetailSQLToMap(Map<String, String> sqlStatementMap) {
        for (Map.Entry<String, String> entry : sqlStatementMap.entrySet()) {
            String tableName = entry.getKey();
            String sqlStatement = entry.getValue();
            this.addSQLStatementToMap(tableName, null, sqlStatement);
        }
    }

    private void addSQLStatementToMap(String tableName, String columnName, String sqlStatement) {
        String key;
        String string = key = columnName != null ? String.valueOf(tableName) + "[" + columnName + "]" : tableName;
        if (this.tableNameSQLStatementMap.get(key) == null) {
            this.tableNameSQLStatementMap.put(key, sqlStatement);
        }
    }

    public Map<String, String> getTableNameSQLStatementMap() {
        return this.tableNameSQLStatementMap;
    }

    public Map<String, JsonElement> getTableNameChildArrayMap() {
        return this.tableNameChildArrayMap;
    }
}

