/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IGridTabSerializer;
import com.trekglobal.idempiere.rest.api.json.IGridTabSerializerFactory;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MColumn;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(name="com.trekglobal.idempiere.rest.api.json.DefaultGridTabSerializer", service={IGridTabSerializerFactory.class}, property={"service.ranking:Integer=0"}, immediate=true)
public class DefaultGridTabSerializer
implements IGridTabSerializer,
IGridTabSerializerFactory {
    @Override
    public JsonObject toJson(GridTab gridTab, String[] includes, String[] excludes) {
        UUID uid;
        Object value;
        JsonObject json = new JsonObject();
        String keyColumn = gridTab.getKeyColumnName();
        if (!Util.isEmpty((String)keyColumn, (boolean)true) && (value = gridTab.getValue(keyColumn)) != null) {
            if (value instanceof Number) {
                json.addProperty("id", (Number)((Number)value).intValue());
            } else {
                json.addProperty("id", value.toString());
            }
        }
        if ((uid = gridTab.getTableModel().getUUID(gridTab.getCurrentRow())) != null) {
            json.addProperty("uid", uid.toString());
        }
        GridField[] fields = gridTab.getFields();
        int i = 0;
        while (i < fields.length) {
            String columnName;
            Object value2;
            GridField gridField;
            if (i != gridTab.getKeyColumnIndex() && !(gridField = fields[i]).isUUID() && gridField.isDisplayed(true) && (value2 = gridField.getValue()) != null && this.include(columnName = gridField.getColumnName(), includes) && !this.exclude(columnName, excludes)) {
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)gridField.getAD_Column_ID());
                if (!gridField.isEncrypted() && !column.isSecure()) {
                    String propertyName = column.getColumnName();
                    Object jsonValue = TypeConverterUtils.toJsonValue(gridField, value2);
                    if (jsonValue != null) {
                        if (jsonValue instanceof Number) {
                            json.addProperty(propertyName, (Number)jsonValue);
                        } else if (jsonValue instanceof Boolean) {
                            json.addProperty(propertyName, (Boolean)jsonValue);
                        } else if (jsonValue instanceof String) {
                            json.addProperty(propertyName, (String)jsonValue);
                        } else if (jsonValue instanceof JsonElement) {
                            json.add(propertyName, (JsonElement)jsonValue);
                        } else {
                            json.addProperty(propertyName, jsonValue.toString());
                        }
                    }
                }
            }
            ++i;
        }
        return json;
    }

    @Override
    public void fromJson(JsonObject json, GridTab gridTab) {
        Set jsonFields = json.keySet();
        int i = 0;
        while (i < gridTab.getFieldCount()) {
            GridField gridField = gridTab.getField(i);
            String columnName = gridField.getColumnName();
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)gridField.getAD_Column_ID());
            String propertyName = TypeConverterUtils.toPropertyName(columnName);
            if (jsonFields.contains(propertyName) || jsonFields.contains(columnName)) {
                JsonElement jsonField = json.get(propertyName);
                if (jsonField == null) {
                    jsonField = json.get(columnName);
                }
                if (jsonField == null) {
                    if (gridTab.isNew()) {
                        gridField.setValue(gridField.getDefault(), true);
                    }
                } else if (!(jsonField.isJsonArray() || !gridField.isUpdateable() && !gridTab.isNew() || gridField.isVirtualColumn() || gridField.isEncrypted() || column.isSecure() || gridTab.getField("processed") != null && gridTab.getValueAsBoolean("processed") && !gridField.isAlwaysUpdateable() || gridTab.getField("posted") != null && gridTab.getValueAsBoolean("posted") && !gridField.isAlwaysUpdateable())) {
                    Object value = TypeConverterUtils.fromJsonValue(gridField, jsonField);
                    Object oldValue = gridField.getValue();
                    if (!(value == null && oldValue == null || value != null && value.equals(oldValue))) {
                        gridTab.setValue(gridField, value);
                        gridTab.processFieldChange(gridField);
                    }
                }
            }
            ++i;
        }
    }

    private boolean exclude(String columnName, String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return false;
        }
        String[] stringArray = excludes;
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (exclude.equals(columnName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean include(String columnName, String[] includes) {
        if (includes == null || includes.length == 0) {
            return true;
        }
        String[] stringArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            if (include.equals(columnName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IGridTabSerializer getGridTabSerializer(String gridTabUID) {
        if ("*".equals(gridTabUID)) {
            return this;
        }
        return null;
    }
}

