/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InvoiceGen
extends GenForm {
    private static final CLogger log = CLogger.getCLogger(InvoiceGen.class);
    public Object m_AD_Org_ID = null;
    public Object m_C_BPartner_ID = null;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("InvGenerateInfo");
        this.setReportEngineType(2);
        this.setAskPrintMsg("PrintInvoices");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("C_Order_ID");
        miniTable.addColumn("AD_Org_ID");
        miniTable.addColumn("C_DocType_ID");
        miniTable.addColumn("DocumentNo");
        miniTable.addColumn("C_BPartner_ID");
        miniTable.addColumn("DateOrdered");
        miniTable.addColumn("TotalLines");
        miniTable.setMultiSelection(true);
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        miniTable.setColumnClass(3, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        miniTable.setColumnClass(5, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"DateOrdered"));
        miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"TotalLines"));
        miniTable.autoSize();
    }

    private String getOrderSQL() {
        StringBuilder sql = new StringBuilder("SELECT C_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, DateOrdered, TotalLines FROM C_Order ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND ic.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        sql = new StringBuilder(MRole.getDefault().addAccessSQL(sql.toString(), "ic", true, false));
        int idxtable = sql.indexOf(" C_Order ");
        sql.replace(idxtable, idxtable + " C_Order ".length(), " C_Invoice_Candidate_v ");
        return sql.toString();
    }

    private String getRMASql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT rma.M_RMA_ID, org.Name, dt.Name, rma.DocumentNo, bp.Name, rma.Created, rma.Amt ");
        sql.append("FROM M_RMA rma INNER JOIN AD_Org org ON (rma.AD_Org_ID=org.AD_Org_ID) ");
        sql.append("INNER JOIN C_DocType dt ON (rma.C_DocType_ID=dt.C_DocType_ID) ");
        sql.append("INNER JOIN C_BPartner bp ON (rma.C_BPartner_ID=bp.C_BPartner_ID) ");
        sql.append("INNER JOIN M_InOut io ON (rma.InOut_ID=io.M_InOut_ID) ");
        sql.append("WHERE rma.DocStatus='CO' ");
        sql.append("AND dt.DocBaseType = 'SOO' ");
        sql.append("AND NOT EXISTS (SELECT * from C_Invoice i ");
        sql.append("where i.M_RMA_ID=rma.M_RMA_ID AND i.DocStatus IN ('IP', 'CO', 'CL')) ");
        sql.append("AND EXISTS (SELECT * from C_InvoiceLine il inner join M_InOutLine iol ");
        sql.append("on il.M_InOutLine_ID=iol.M_InOutLine_ID inner join C_Invoice i ");
        sql.append("on i.C_Invoice_ID=il.C_Invoice_ID where i.DocStatus IN ('CO', 'CL') ");
        sql.append("AND EXISTS (SELECT 1 FROM m_rmaline rl WHERE rl.m_rma_id = rma.m_rma_id AND iol.m_inoutline_id = rl.m_inoutline_id AND rl.m_inoutline_id IS NOT null)) ");
        sql.append("AND rma.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND rma.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND bp.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        sql.append(" ORDER BY org.Name, bp.Name, rma.Created ");
        sql = new StringBuilder(MRole.getDefault().addAccessSQL(sql.toString(), "rma", true, false));
        return sql.toString();
    }

    public void executeQuery(KeyNamePair docTypeKNPair, IMiniTable miniTable) {
        block6: {
            log.info("");
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            String sql = "";
            sql = docTypeKNPair.getKey() == 259 ? this.getOrderSQL() : this.getRMASql();
            int row = 0;
            miniTable.setRowCount(row);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        miniTable.setRowCount(row + 1);
                        miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                        miniTable.setValueAt(rs.getString(2), row, 1);
                        miniTable.setValueAt(rs.getString(3), row, 2);
                        miniTable.setValueAt(rs.getString(4), row, 3);
                        miniTable.setValueAt(rs.getString(5), row, 4);
                        miniTable.setValueAt(rs.getTimestamp(6), row, 5);
                        miniTable.setValueAt(rs.getBigDecimal(7), row, 6);
                        ++row;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        miniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                results.add(id.getRecord_ID());
            }
            ++i;
        }
        if (results.size() == 0) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Selected #" + results.size());
        }
        this.setSelection(results);
    }

    public String generate(IStatusBar statusBar, KeyNamePair docTypeKNPair, String docActionSelected) {
        String info = "";
        String trxName = Trx.createTrxName((String)"IVG");
        Trx trx = Trx.get((String)trxName, (boolean)true);
        trx.setDisplayName(this.getClass().getName() + "_generate");
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"InvGenerateGen"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int AD_Process_ID = 0;
        AD_Process_ID = docTypeKNPair.getKey() == 661 ? 52002 : 134;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            info = Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance");
            return info;
        }
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.getSelection()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate((String)insert.toString(), (String)trxName) < 0) {
                String msg;
                info = msg = "No Invoices";
                log.config(msg);
                trx.rollback();
                return info;
            }
            insert = new StringBuilder();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate((String)insert.toString(), (String)trxName) < 0) {
            String msg;
            info = msg = "No Invoices";
            log.config(msg);
            trx.rollback();
            return info;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        para.setParameter("Selection", "Y");
        if (!para.save()) {
            String msg;
            info = msg = "No Selection Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        para = new MPInstancePara(instance, 20);
        para.setParameter("DocAction", docActionSelected);
        if (!para.save()) {
            String msg;
            info = msg = "No DocAction Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        this.setTrx(trx);
        this.setProcessInfo(pi);
        return info;
    }
}

