/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAsset;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcessPara;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

@Process
public class A_Depreciation_Exp_Check
extends SvrProcess {
    private boolean p_IsTest = true;
    private int p_A_Asset_ID = -1;
    private String p_WhereClause = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("IsTest")) {
                    this.p_IsTest = para.getParameterAsBoolean();
                } else if (name.equals("A_Asset_ID")) {
                    this.p_A_Asset_ID = para.getParameterAsInt();
                } else if (name.equals("WhereClause")) {
                    this.p_WhereClause = (String)para.getParameter();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int[] nArray = this.getAsset_IDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int A_Asset_ID = nArray[n2];
            this.fixDepreciation(A_Asset_ID);
            if (this.p_IsTest) {
                this.rollback();
            }
            ++n2;
        }
        return "Ok";
    }

    private int[] getAsset_IDs() {
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = null;
        if (this.p_A_Asset_ID > 0) {
            whereClause = "A_Asset_ID=?";
            params.add(this.p_A_Asset_ID);
        } else {
            whereClause = this.p_WhereClause;
        }
        return new Query(this.getCtx(), "A_Asset", whereClause, this.get_TrxName()).setParameters(params).setOrderBy("A_Asset_ID").getIDs();
    }

    private void fixDepreciation(int A_Asset_ID) {
        MAsset asset = MAsset.get(this.getCtx(), A_Asset_ID, this.get_TrxName());
        List<MDepreciationExp> depreciations = this.getDepreciation(asset);
        if (depreciations.get(0).getA_Period() == 0) {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay(asset.getAssetServiceDate()));
            tms = depreciations.get(0).getDateAcct();
            i = 1;
            while (i < depreciations.size()) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay(TimeUtil.addMonths(tms, 1)));
                tms = depreciations.get(i).getDateAcct();
                ++i;
            }
        } else {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay(TimeUtil.addMonths(asset.getAssetServiceDate(), 1)));
            tms = depreciations.get(0).getDateAcct();
            i = 1;
            while (i < depreciations.size()) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay(TimeUtil.addMonths(tms, 1)));
                tms = depreciations.get(i).getDateAcct();
                ++i;
            }
        }
        for (MDepreciationWorkfile wk : MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), A_Asset_ID, this.get_TrxName())) {
            wk.setA_Current_Period();
            wk.saveEx();
            this.addLog(String.valueOf(wk) + ": Period=" + wk.getA_Current_Period() + ", DateAcct=" + String.valueOf(wk.getDateAcct()));
        }
    }

    private void fixDepreciationExp(MDepreciationExp exp, Timestamp dateAcctNew) {
        if (!exp.getDateAcct().equals(dateAcctNew)) {
            this.addLog("OLD1: " + String.valueOf(exp));
            MDepreciationEntry.deleteFacts(exp);
            exp.setDateAcct(dateAcctNew);
            exp.setA_Depreciation_Entry_ID(0);
            exp.saveEx();
            this.addLog("NEW1: " + String.valueOf(exp));
        }
        if (exp.getA_Depreciation_Entry_ID() > 0) {
            int C_Period_ID = DB.getSQLValueEx(exp.get_TrxName(), "SELECT C_Period_ID FROM A_Depreciation_Entry WHERE A_Depreciation_Entry_ID=?", exp.getA_Depreciation_Entry_ID());
            MPeriod period = MPeriod.get(exp.getCtx(), C_Period_ID);
            if (!period.isInPeriod(exp.getDateAcct())) {
                this.addLog("OLD2: " + String.valueOf(exp));
                MDepreciationEntry.deleteFacts(exp);
                exp.setA_Depreciation_Entry_ID(0);
                exp.saveEx();
                this.addLog("NEW2: " + String.valueOf(exp));
            }
        }
    }

    private List<MDepreciationExp> getDepreciation(MAsset asset) {
        String whereClause = "A_Asset_ID=?";
        return new Query(this.getCtx(), "A_Depreciation_Exp", whereClause, this.get_TrxName()).setParameters(asset.get_ID()).setOrderBy("A_Period").list();
    }
}

