/*
 * Decompiled with CFR 0.152.
 */
package org.globalqss.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_T_CashFlow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.MReportTree;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class CashFlow
extends SvrProcess {
    private Timestamp p_dateFrom;
    private Timestamp p_dateTo;
    private int p_C_AcctSchema_ID;
    private int p_C_ElementValue_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("DateTo")) {
                    this.p_dateTo = (Timestamp)para[i2].getParameter();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i2].getParameterAsInt();
                } else if (name.equals("C_ElementValue_ID")) {
                    this.p_C_ElementValue_ID = para[i2].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        CPreparedStatement pstmtOpenOrders22;
        Object pstmtPlan22;
        Throwable throwable;
        Calendar dateFrom = Calendar.getInstance();
        dateFrom.setTimeInMillis(System.currentTimeMillis());
        dateFrom.set(11, 0);
        dateFrom.set(12, 0);
        dateFrom.set(13, 0);
        dateFrom.set(14, 0);
        this.p_dateFrom = new Timestamp(dateFrom.getTimeInMillis());
        this.p_dateFrom.setNanos(0);
        this.log.info("Calculating initial balance");
        StringBuilder sqlIni = new StringBuilder("SELECT SUM(acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)) FROM Fact_Acct WHERE DateAcct<=");
        sqlIni.append(DB.TO_DATE(this.p_dateFrom)).append(" AND PostingType='").append("A").append("' AND ");
        String whereClause = MReportTree.getWhereClause(this.getCtx(), 0, "AC", this.p_C_ElementValue_ID);
        sqlIni.append(whereClause);
        BigDecimal initialBalance = DB.getSQLValueBD(this.get_TrxName(), sqlIni.toString(), new Object[0]);
        X_T_CashFlow cfini = new X_T_CashFlow(this.getCtx(), 0, this.get_TrxName());
        cfini.setAD_Org_ID(0);
        cfini.setAD_PInstance_ID(this.getAD_PInstance_ID());
        cfini.setCashFlowSource("1");
        cfini.setCashFlowType("O");
        cfini.setDateTrx(this.p_dateFrom);
        cfini.setIsActive(true);
        cfini.setIsSOTrx(true);
        cfini.setLineTotalAmt(initialBalance);
        cfini.setProbability(Env.ONEHUNDRED);
        cfini.setDateTo(this.p_dateTo);
        cfini.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
        cfini.setC_ElementValue_ID(this.p_C_ElementValue_ID);
        if (!cfini.save()) {
            throw new AdempiereSystemError("Error saving cash flow ini");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Initial balance calculated = " + String.valueOf(initialBalance));
        }
        String sqlPlan = "SELECT cpl.AD_Org_ID, COALESCE(cpl.C_Activity_ID, cp.C_Activity_ID) AS C_Activity_ID, cp.CashFlowType, COALESCE(cpl.C_BPartner_ID, cp.C_BPartner_ID) AS C_BPartner_ID, COALESCE(cpl.C_Campaign_ID, cp.C_Campaign_ID) AS C_Campaign_ID, cpl.C_Charge_ID, COALESCE(cpl.C_Project_ID, cp.C_Project_ID) AS C_Project_ID, cpl.DateTrx, cpl.Description, cp.IsSOTrx, cpl.LineTotalAmt, cpl.M_Product_ID, cpl.Name, cpl.Probability, cpl.C_CashPlanLine_ID, cp.C_CashPlan_ID FROM C_CashPlanLine cpl JOIN C_CashPlan cp ON (cp.C_CashPlan_ID=cpl.C_CashPlan_ID) WHERE cp.AD_Client_ID=? AND cp.IsActive='Y' AND cpl.IsActive='Y' AND cpl.DateTrx BETWEEN ? AND ?";
        try {
            Throwable throwable2 = null;
            throwable = null;
            try {
                pstmtPlan22 = DB.prepareStatement(sqlPlan, this.get_TrxName());
                try {
                    pstmtPlan22.setInt(1, this.getAD_Client_ID());
                    pstmtPlan22.setTimestamp(2, this.p_dateFrom);
                    pstmtPlan22.setTimestamp(3, this.p_dateTo);
                    ResultSet rsPlan = pstmtPlan22.executeQuery();
                    int noPlan = 0;
                    while (rsPlan.next()) {
                        ++noPlan;
                        boolean issotrx = "Y".equals(rsPlan.getString("IsSOTrx"));
                        BigDecimal total = rsPlan.getBigDecimal("LineTotalAmt");
                        if (!issotrx) {
                            total = total.negate();
                        }
                        X_T_CashFlow cfplan = new X_T_CashFlow(this.getCtx(), 0, this.get_TrxName());
                        cfplan.setAD_Org_ID(rsPlan.getInt("AD_Org_ID"));
                        cfplan.setAD_PInstance_ID(this.getAD_PInstance_ID());
                        cfplan.setC_Activity_ID(rsPlan.getInt("C_Activity_ID"));
                        cfplan.setCashFlowSource("2");
                        cfplan.setCashFlowType(rsPlan.getString("CashFlowType"));
                        cfplan.setC_BPartner_ID(rsPlan.getInt("C_BPartner_ID"));
                        cfplan.setC_Campaign_ID(rsPlan.getInt("C_Campaign_ID"));
                        cfplan.setC_Charge_ID(rsPlan.getInt("C_Charge_ID"));
                        cfplan.setC_Project_ID(rsPlan.getInt("C_Project_ID"));
                        cfplan.setDateTrx(rsPlan.getTimestamp("DateTrx"));
                        cfplan.setDescription(rsPlan.getString("Description"));
                        cfplan.setIsActive(true);
                        cfplan.setIsSOTrx(issotrx);
                        cfplan.setLineTotalAmt(total);
                        cfplan.setM_Product_ID(rsPlan.getInt("M_Product_ID"));
                        cfplan.setName(rsPlan.getString("Name"));
                        cfplan.setProbability(rsPlan.getBigDecimal("Probability"));
                        cfplan.setDateTo(this.p_dateTo);
                        cfplan.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
                        cfplan.setC_ElementValue_ID(this.p_C_ElementValue_ID);
                        cfplan.setC_CashPlanLine_ID(rsPlan.getInt("C_CashPlanLine_ID"));
                        if (cfplan.save()) continue;
                        throw new AdempiereSystemError("Error saving cash flow plan");
                    }
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(noPlan + " plan inserted");
                    }
                }
                finally {
                    if (pstmtPlan22 != null) {
                        pstmtPlan22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlPlan, e);
        }
        String sqlOpenOrders = "SELECT o.C_Order_ID, o.IsPayScheduleValid, SUM((ol.QtyOrdered-ol.QtyInvoiced)*ol.PriceActual)/o.TotalLines as Pending FROM C_Order o JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) WHERE o.AD_Client_ID=? AND o.TotalLines != 0 AND o.DocStatus IN ('CO') AND ol.QtyInvoiced<ol.QtyOrdered GROUP BY o.C_Order_ID, o.IsPayScheduleValid, o.TotalLines";
        try {
            throwable = null;
            pstmtPlan22 = null;
            try {
                pstmtOpenOrders22 = DB.prepareStatement(sqlOpenOrders, this.get_TrxName());
                try {
                    pstmtOpenOrders22.setInt(1, this.getAD_Client_ID());
                    ResultSet rsOpenOrders = pstmtOpenOrders22.executeQuery();
                    int noOrders = 0;
                    int noOrdIns = 0;
                    int noOrdSchIns = 0;
                    while (rsOpenOrders.next()) {
                        if (++noOrders % 100 == 0 && this.log.isLoggable(Level.INFO)) {
                            this.log.info(noOrders + " orders processed");
                        }
                        int order_id = rsOpenOrders.getInt("C_Order_ID");
                        boolean isPaySchedule = "Y".equals(rsOpenOrders.getString("IsPayScheduleValid"));
                        BigDecimal pending = rsOpenOrders.getBigDecimal("Pending");
                        MOrder order = new MOrder(this.getCtx(), order_id, this.get_TrxName());
                        MCurrency curr = MCurrency.get(this.getCtx(), order.getC_Currency_ID());
                        BigDecimal open = order.getGrandTotal().multiply(pending);
                        BigDecimal paid = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(CASE WHEN IsReceipt='Y' THEN PayAmt ELSE -PayAmt END) FROM C_Payment WHERE DocStatus IN ('CO','CL') AND C_Order_ID=? AND C_Invoice_ID IS NULL AND IsAllocated='N'", order_id);
                        if (paid != null) {
                            if (!order.isSOTrx()) {
                                paid = paid.negate();
                            }
                            open = open.subtract(paid);
                        }
                        if (open.scale() > curr.getStdPrecision()) {
                            open = open.setScale(curr.getStdPrecision(), RoundingMode.HALF_UP);
                        }
                        BigDecimal invoiced = order.getGrandTotal().subtract(open);
                        if (isPaySchedule) {
                            MOrderPaySchedule[] schedule = MOrderPaySchedule.getOrderPaySchedule(this.getCtx(), order_id, 0, this.get_TrxName());
                            BigDecimal accum = Env.ZERO;
                            MOrderPaySchedule[] mOrderPayScheduleArray = schedule;
                            int n = schedule.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
                                if (invoiced.compareTo(accum = accum.add(ops.getDueAmt())) <= 0 && ops.getDueDate().compareTo(this.p_dateTo) <= 0) {
                                    BigDecimal opensch = accum.subtract(invoiced).compareTo(ops.getDueAmt()) > 0 ? ops.getDueAmt() : accum.subtract(invoiced);
                                    if (!order.isSOTrx()) {
                                        opensch = opensch.negate();
                                    }
                                    ++noOrdSchIns;
                                    X_T_CashFlow cforderps = new X_T_CashFlow(this.getCtx(), 0, this.get_TrxName());
                                    cforderps.setAD_Org_ID(order.getAD_Org_ID());
                                    cforderps.setAD_PInstance_ID(this.getAD_PInstance_ID());
                                    cforderps.setC_Activity_ID(order.getC_Activity_ID());
                                    cforderps.setCashFlowSource("3");
                                    cforderps.setC_BPartner_ID(order.getC_BPartner_ID());
                                    cforderps.setC_Campaign_ID(order.getC_Campaign_ID());
                                    cforderps.setC_Project_ID(order.getC_Project_ID());
                                    cforderps.setDateTrx(ops.getDueDate());
                                    cforderps.setDescription(order.getDescription());
                                    cforderps.setIsActive(true);
                                    cforderps.setIsSOTrx(order.isSOTrx());
                                    cforderps.setLineTotalAmt(opensch);
                                    cforderps.setProbability(Env.ONEHUNDRED);
                                    cforderps.setDateTo(this.p_dateTo);
                                    cforderps.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
                                    cforderps.setC_ElementValue_ID(this.p_C_ElementValue_ID);
                                    cforderps.setC_CashPlanLine_ID(order.getC_CashPlanLine_ID());
                                    cforderps.setC_Order_ID(order_id);
                                    if (!cforderps.save()) {
                                        throw new AdempiereSystemError("Error saving cash flow order pay schedule");
                                    }
                                }
                                ++n2;
                            }
                            continue;
                        }
                        Timestamp dueDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT paymentTermDueDate(?, ?) FROM Dual", order.getC_PaymentTerm_ID(), order.getDateOrdered());
                        if (dueDate.compareTo(this.p_dateTo) > 0) continue;
                        if (!order.isSOTrx()) {
                            open = open.negate();
                        }
                        ++noOrdIns;
                        X_T_CashFlow cforder = new X_T_CashFlow(this.getCtx(), 0, this.get_TrxName());
                        cforder.setAD_Org_ID(order.getAD_Org_ID());
                        cforder.setAD_PInstance_ID(this.getAD_PInstance_ID());
                        cforder.setC_Activity_ID(order.getC_Activity_ID());
                        cforder.setCashFlowSource("3");
                        cforder.setC_BPartner_ID(order.getC_BPartner_ID());
                        cforder.setC_Campaign_ID(order.getC_Campaign_ID());
                        cforder.setC_Project_ID(order.getC_Project_ID());
                        cforder.setDateTrx(dueDate);
                        cforder.setDescription(order.getDescription());
                        cforder.setIsActive(true);
                        cforder.setIsSOTrx(order.isSOTrx());
                        cforder.setLineTotalAmt(open);
                        cforder.setProbability(Env.ONEHUNDRED);
                        cforder.setDateTo(this.p_dateTo);
                        cforder.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
                        cforder.setC_ElementValue_ID(this.p_C_ElementValue_ID);
                        cforder.setC_CashPlanLine_ID(order.getC_CashPlanLine_ID());
                        cforder.setC_Order_ID(order_id);
                        if (cforder.save()) continue;
                        throw new AdempiereSystemError("Error saving cash flow order");
                    }
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(noOrders + " orders processed, " + noOrdIns + " orders inserted, " + noOrdSchIns + " schedule inserted");
                    }
                }
                finally {
                    if (pstmtOpenOrders22 != null) {
                        pstmtOpenOrders22.close();
                    }
                }
            }
            catch (Throwable pstmtPlan22) {
                if (throwable == null) {
                    throwable = pstmtPlan22;
                } else if (throwable != pstmtPlan22) {
                    throwable.addSuppressed(pstmtPlan22);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlOpenOrders, e);
        }
        String sqlActual = "SELECT oi.AD_Org_ID, oi.C_Invoice_ID, oi.C_BPartner_ID, oi.IsSOTrx, oi.DueDate, oi.OpenAmt, oi.C_Campaign_ID, oi.C_Project_ID, oi.C_Activity_ID FROM RV_OpenItem oi WHERE oi.AD_Client_ID=? AND oi.DueDate <= ?";
        try {
            pstmtPlan22 = null;
            pstmtOpenOrders22 = null;
            try (CPreparedStatement pstmtActual = DB.prepareStatement(sqlActual, this.get_TrxName());){
                pstmtActual.setInt(1, this.getAD_Client_ID());
                pstmtActual.setTimestamp(2, this.p_dateTo);
                ResultSet rsActual = pstmtActual.executeQuery();
                int noInv = 0;
                while (rsActual.next()) {
                    boolean issotrx = "Y".equals(rsActual.getString("IsSOTrx"));
                    BigDecimal openamt = rsActual.getBigDecimal("OpenAmt");
                    if (!issotrx) {
                        openamt = openamt.negate();
                    }
                    MInvoice invoice = new MInvoice(this.getCtx(), rsActual.getInt("C_Invoice_ID"), this.get_TrxName());
                    ++noInv;
                    X_T_CashFlow cfactual = new X_T_CashFlow(this.getCtx(), 0, this.get_TrxName());
                    cfactual.setAD_Org_ID(rsActual.getInt("AD_Org_ID"));
                    cfactual.setAD_PInstance_ID(this.getAD_PInstance_ID());
                    cfactual.setC_Activity_ID(rsActual.getInt("C_Activity_ID"));
                    cfactual.setCashFlowSource("4");
                    cfactual.setC_BPartner_ID(rsActual.getInt("C_BPartner_ID"));
                    cfactual.setC_Campaign_ID(rsActual.getInt("C_Campaign_ID"));
                    cfactual.setC_Project_ID(rsActual.getInt("C_Project_ID"));
                    cfactual.setDateTrx(rsActual.getTimestamp("DueDate"));
                    cfactual.setDescription(invoice.getDescription());
                    cfactual.setIsActive(true);
                    cfactual.setIsSOTrx(issotrx);
                    cfactual.setLineTotalAmt(openamt);
                    cfactual.setProbability(Env.ONEHUNDRED);
                    cfactual.setDateTo(this.p_dateTo);
                    cfactual.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
                    cfactual.setC_ElementValue_ID(this.p_C_ElementValue_ID);
                    cfactual.setC_CashPlanLine_ID(invoice.getC_CashPlanLine_ID());
                    cfactual.setC_Invoice_ID(rsActual.getInt("C_Invoice_ID"));
                    if (cfactual.save()) continue;
                    throw new AdempiereSystemError("Error saving cash flow actual");
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(noInv + " invoices inserted");
                }
            }
            catch (Throwable pstmtOpenOrders22) {
                if (pstmtPlan22 == null) {
                    pstmtPlan22 = pstmtOpenOrders22;
                } else if (pstmtPlan22 != pstmtOpenOrders22) {
                    ((Throwable)pstmtPlan22).addSuppressed(pstmtOpenOrders22);
                }
                throw pstmtPlan22;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlActual, e);
        }
        String sqlupdord = "UPDATE T_CashFlow SET LineTotalAmt = LineTotalAmt - (SELECT COALESCE(SUM(LineTotalAmt),0) FROM T_CashFlow cf WHERE cf.AD_PInstance_ID = T_CashFlow.AD_Pinstance_ID AND cf.C_CashPlanLine_ID=T_CashFlow.C_CashPlanLine_ID AND CashFlowSource = ? /* Orders */) WHERE AD_PInstance_ID = ? AND CashFlowSource = ? /* Plan */ AND EXISTS (SELECT 1 FROM T_CashFlow cf WHERE cf.AD_PInstance_ID = T_CashFlow.AD_PInstance_ID AND cf.C_CashPlanLine_ID=T_CashFlow.C_CashPlanLine_ID AND CashFlowSource = ? /* Orders */)";
        int noupdord = DB.executeUpdate(sqlupdord, new Object[]{"3", this.getAD_PInstance_ID(), "2", "3"}, false, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(noupdord + " plans subtracted from orders");
        }
        String sqlupdinv = "UPDATE T_CashFlow SET LineTotalAmt = LineTotalAmt - (SELECT COALESCE(SUM(LineTotalAmt),0) FROM T_CashFlow cf WHERE cf.AD_PInstance_ID = T_CashFlow.AD_Pinstance_ID AND cf.C_CashPlanLine_ID=T_CashFlow.C_CashPlanLine_ID AND CashFlowSource = ? /* Invoices */) WHERE AD_PInstance_ID = ? AND CashFlowSource = ? /* Plan */ AND EXISTS (SELECT 1 FROM T_CashFlow cf WHERE cf.AD_PInstance_ID = T_CashFlow.AD_PInstance_ID AND cf.C_CashPlanLine_ID=T_CashFlow.C_CashPlanLine_ID AND CashFlowSource = ? /* Invoices */)";
        int noupdinv = DB.executeUpdate(sqlupdinv, new Object[]{"4", this.getAD_PInstance_ID(), "2", "4"}, false, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(noupdinv + " plans subtracted from invoices");
        }
        String sqldeloverplanned = "DELETE FROM T_CashFlow WHERE AD_PInstance_ID = ? AND CashFlowSource = ? /* Plan */ AND ((IsSOTrx='Y' AND LineTotalAmt<=0) OR (IsSOTrx='N' AND LineTotalAmt>=0))";
        int nodelplan = DB.executeUpdate(sqldeloverplanned, new Object[]{this.getAD_PInstance_ID(), "2"}, false, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(nodelplan + " overplanned plans deleted");
        }
        return "OK";
    }
}

