/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBankTransfer;
import org.compiere.model.MPayment;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class BankTransfer
extends SvrProcess {
    private String p_DocumentNo = "";
    private String p_Description = "";
    private int p_C_BPartner_ID = 0;
    private int p_C_Currency_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private int p_C_Charge_ID = 0;
    private BigDecimal p_Amount = Env.ZERO;
    private int p_From_C_BankAccount_ID = 0;
    private int p_To_C_BankAccount_ID = 0;
    private Timestamp p_StatementDate = null;
    private Timestamp p_DateAcct = null;
    private int p_AD_Org_ID = 0;
    private boolean p_IsCreateBankTransferDoc = false;
    private int m_created = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (name.equals("From_C_BankAccount_ID")) {
                this.p_From_C_BankAccount_ID = para[i2].getParameterAsInt();
            } else if (name.equals("To_C_BankAccount_ID")) {
                this.p_To_C_BankAccount_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_ConversionType_ID")) {
                this.p_C_ConversionType_ID = para[i2].getParameterAsInt();
            } else if (name.equals("C_Charge_ID")) {
                this.p_C_Charge_ID = para[i2].getParameterAsInt();
            } else if (name.equals("DocumentNo")) {
                this.p_DocumentNo = (String)para[i2].getParameter();
            } else if (name.equals("Amount")) {
                this.p_Amount = (BigDecimal)para[i2].getParameter();
            } else if (name.equals("Description")) {
                this.p_Description = (String)para[i2].getParameter();
            } else if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i2].getParameter();
            } else if (name.equals("DateAcct")) {
                this.p_DateAcct = (Timestamp)para[i2].getParameter();
            } else if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i2].getParameterAsInt();
            } else if (name.equals("IsCreateBankTransferDoc")) {
                this.p_IsCreateBankTransferDoc = para[i2].getParameterAsBoolean();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From Bank=" + this.p_From_C_BankAccount_ID + " - To Bank=" + this.p_To_C_BankAccount_ID + " - C_BPartner_ID=" + this.p_C_BPartner_ID + "- C_Charge_ID= " + this.p_C_Charge_ID + " - Amount=" + String.valueOf(this.p_Amount) + " - DocumentNo=" + this.p_DocumentNo + " - Description=" + this.p_Description + " - Statement Date=" + String.valueOf(this.p_StatementDate) + " - Date Account=" + String.valueOf(this.p_DateAcct) + " - Create Bank Transfer Doc=" + this.p_IsCreateBankTransferDoc);
        }
        if (this.p_To_C_BankAccount_ID == 0 || this.p_From_C_BankAccount_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@: @To_C_BankAccount_ID@, @From_C_BankAccount_ID@"));
        }
        if (this.p_To_C_BankAccount_ID == this.p_From_C_BankAccount_ID) {
            throw new AdempiereUserError(Msg.getMsg(this.getCtx(), "BankFromToMustDiffer"));
        }
        if (this.p_C_BPartner_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @C_BPartner_ID@"));
        }
        if (this.p_C_Currency_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @C_Currency_ID@"));
        }
        if (this.p_C_Charge_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @C_Charge_ID@"));
        }
        if (this.p_Amount.signum() == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @Amount@"));
        }
        if (this.p_AD_Org_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @AD_Org_ID@"));
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateAcct == null) {
            this.p_DateAcct = this.p_StatementDate;
        }
        if (this.p_IsCreateBankTransferDoc) {
            this.generateBankTransferDoc();
        } else {
            this.generateBankTransfer();
        }
        return "@Created@ = " + this.m_created;
    }

    private void generateBankTransfer() {
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(this.p_From_C_BankAccount_ID);
        paymentBankFrom.setAD_Org_ID(this.p_AD_Org_ID);
        if (!Util.isEmpty(this.p_DocumentNo, true)) {
            paymentBankFrom.setDocumentNo(this.p_DocumentNo);
        }
        paymentBankFrom.setDateAcct(this.p_DateAcct);
        paymentBankFrom.setDateTrx(this.p_StatementDate);
        paymentBankFrom.setTenderType("A");
        paymentBankFrom.setDescription(this.p_Description);
        paymentBankFrom.setC_BPartner_ID(this.p_C_BPartner_ID);
        paymentBankFrom.setC_Currency_ID(this.p_C_Currency_ID);
        if (this.p_C_ConversionType_ID > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.p_C_ConversionType_ID);
        }
        paymentBankFrom.setPayAmt(this.p_Amount);
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.p_C_Charge_ID);
        paymentBankFrom.saveEx();
        if (!paymentBankFrom.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + String.valueOf(paymentBankFrom) + " - " + paymentBankFrom.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + String.valueOf(paymentBankFrom) + " - " + paymentBankFrom.getProcessMsg());
        }
        paymentBankFrom.saveEx();
        this.addBufferLog(paymentBankFrom.getC_Payment_ID(), paymentBankFrom.getDateTrx(), null, paymentBankFrom.getC_DocType().getName() + " " + paymentBankFrom.getDocumentNo(), 335, paymentBankFrom.getC_Payment_ID());
        ++this.m_created;
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(this.p_To_C_BankAccount_ID);
        paymentBankTo.setAD_Org_ID(this.p_AD_Org_ID);
        if (!Util.isEmpty(this.p_DocumentNo, true)) {
            paymentBankTo.setDocumentNo(this.p_DocumentNo);
        }
        paymentBankTo.setDateAcct(this.p_DateAcct);
        paymentBankTo.setDateTrx(this.p_StatementDate);
        paymentBankTo.setTenderType("A");
        paymentBankTo.setDescription(this.p_Description);
        paymentBankTo.setC_BPartner_ID(this.p_C_BPartner_ID);
        paymentBankTo.setC_Currency_ID(this.p_C_Currency_ID);
        if (this.p_C_ConversionType_ID > 0) {
            paymentBankTo.setC_ConversionType_ID(this.p_C_ConversionType_ID);
        }
        paymentBankTo.setPayAmt(this.p_Amount);
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.p_C_Charge_ID);
        paymentBankTo.saveEx();
        if (!paymentBankTo.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + String.valueOf(paymentBankTo) + " - " + paymentBankTo.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + String.valueOf(paymentBankTo) + " - " + paymentBankTo.getProcessMsg());
        }
        paymentBankTo.saveEx();
        this.addBufferLog(paymentBankTo.getC_Payment_ID(), paymentBankTo.getDateTrx(), null, paymentBankTo.getC_DocType().getName() + " " + paymentBankTo.getDocumentNo(), 335, paymentBankTo.getC_Payment_ID());
        ++this.m_created;
    }

    private void generateBankTransferDoc() throws Exception {
        MPayment[] payments;
        MBankTransfer bt = new MBankTransfer(this.getCtx(), 0, this.get_TrxName());
        bt.setAD_Org_ID(this.p_AD_Org_ID);
        bt.setDescription(this.p_Description);
        if (!Util.isEmpty(this.p_DocumentNo, true)) {
            bt.setDocumentNo(this.p_DocumentNo);
        }
        bt.setPayDate(this.p_StatementDate);
        bt.setDateAcct(this.p_DateAcct);
        bt.setFrom_C_BankAccount_ID(this.p_From_C_BankAccount_ID);
        bt.setTo_C_BankAccount_ID(this.p_To_C_BankAccount_ID);
        bt.setFrom_AD_Org_ID(this.p_AD_Org_ID);
        bt.setTo_AD_Org_ID(this.p_AD_Org_ID);
        bt.setFrom_C_Charge_ID(this.p_C_Charge_ID);
        bt.setTo_C_Charge_ID(this.p_C_Charge_ID);
        bt.setFrom_C_Currency_ID(this.p_C_Currency_ID);
        bt.setTo_C_Currency_ID(this.p_C_Currency_ID);
        bt.setFrom_Amt(this.p_Amount);
        bt.setTo_Amt(this.p_Amount);
        bt.setFrom_C_BPartner_ID(this.p_C_BPartner_ID);
        bt.setTo_C_BPartner_ID(this.p_C_BPartner_ID);
        bt.setFrom_TenderType("A");
        bt.setTo_TenderType("A");
        if (this.p_C_ConversionType_ID > 0) {
            bt.setC_ConversionType_ID(this.p_C_ConversionType_ID);
        }
        bt.setIsOverrideCurrencyRate(false);
        bt.saveEx();
        if (!bt.processIt("CO")) {
            this.log.warning("Bank Transfer Process Failed: " + String.valueOf(bt) + " - " + bt.getProcessMsg());
            throw new IllegalStateException("Bank Transfer Process Failed: " + String.valueOf(bt) + " - " + bt.getProcessMsg());
        }
        bt.saveEx();
        this.addBufferLog(bt.getC_BankTransfer_ID(), bt.getPayDate(), null, bt.getDocumentNo(), 200246, bt.getC_BankTransfer_ID());
        ++this.m_created;
        MPayment[] mPaymentArray = payments = MPayment.getOfBankTransfer(this.getCtx(), bt.getC_BankTransfer_ID(), this.get_TrxName());
        int n = payments.length;
        int n2 = 0;
        while (n2 < n) {
            MPayment payment = mPaymentArray[n2];
            this.addBufferLog(payment.getC_Payment_ID(), payment.getDateTrx(), null, payment.getC_DocType().getName() + " " + payment.getDocumentNo(), 335, payment.getC_Payment_ID());
            ++this.m_created;
            ++n2;
        }
    }
}

