/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_IT
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "MILLE", "UNMILIONE", "UNMILIARDO", "UNBILIONE", "UNBILIARDO", "UNTRILIONE"};
    private static final String[] majorNamesPlural = new String[]{"", "MILA", "MILIONI", "MILIARDI", "BILIONI", "BILIARDI", "TRILIONI"};
    private static final String[] tensNames = new String[]{"", "DIECI", "VENTI", "TRENTA", "QUARANTA", "CINQUANTA", "SESSANTA", "SETTANTA", "OTTANTA", "NOVANTA"};
    private static final String[] numNames = new String[]{"", "UNO", "DUE", "TRE", "QUATTRO", "CINQUE", "SEI", "SETTE", "OTTO", "NOVE", "DIECI", "UNDICI", "DODICI", "TREDICI", "QUATTORDICI", "QUINDICI", "SEDICI", "DICIASSETTE", "DICIOTTO", "DICIANNOVE"};

    private String convertLessThanOneThousand(int number) {
        Object soFar;
        int unit = 0;
        int tens = 0;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            unit = number % 10;
            soFar = numNames[unit];
            tens = (number /= 10) % 10;
            soFar = unit == 1 || unit == 8 ? tensNames[tens].substring(0, tensNames[tens].length() - 1) + (String)soFar : tensNames[tens] + (String)soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        if (number > 1) {
            return numNames[number] + "CENTO" + (String)soFar;
        }
        return "CENTO" + (String)soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "ZERO";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "MENO ";
        }
        Object soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = n == 1L && place > 0 ? majorNames[place] + (String)soFar : s + majorNamesPlural[place] + (String)soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + (String)soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuilder sb = new StringBuilder();
        int pos = amount.lastIndexOf(44);
        int pos2 = amount.lastIndexOf(46);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        if (pos >= 0) {
            amount = amount.substring(0, pos);
        }
        amount = amount.replaceAll("\\.", "");
        long amt = (amount = amount.replaceAll(",", "")).length() > 0 ? Long.parseLong(amount) : 0L;
        sb.append(this.convert(amt));
        if (pos >= 0) {
            String cents = oldamt.substring(pos + 1);
            sb.append("/").append(cents);
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        AmtInWords_IT aiw = new AmtInWords_IT();
        aiw.print(",00");
        aiw.print("0,00");
        aiw.print("1000,00");
        aiw.print("1200");
        aiw.print("1.200");
        aiw.print("14000.99");
        aiw.print("28.000.000,99");
        aiw.print("301,000,000.00");
        aiw.print("200000,99");
        aiw.print("-1234567890,99");
        aiw.print("2147483647,99");
        aiw.print("9223372036854775807.99");
    }
}

