/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.LDAP;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.SystemProperties;
import org.compiere.model.X_AD_System;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class MSystem
extends X_AD_System {
    private static final long serialVersionUID = -1917493005917422880L;
    private static CCache<Integer, MSystem> s_system = new CCache("AD_System", 1, -1);
    private static final String SYSTEM_ALLOW_REMEMBER_USER = "U";
    private static final String SYSTEM_ALLOW_REMEMBER_PASSWORD = "P";

    public static synchronized MSystem get(Properties ctx) {
        if (s_system.get(0) != null) {
            return new MSystem(ctx, s_system.get(0));
        }
        MSystem system = (MSystem)new Query(ctx, "AD_System", null, null).setOrderBy("AD_System_ID").firstOnly();
        if (system == null) {
            return null;
        }
        if (!Ini.isClient() && system.setInfo()) {
            system.saveCrossTenantSafeEx();
        }
        s_system.put(0, new MSystem(Env.getCtx(), system));
        return system;
    }

    public MSystem(Properties ctx, String AD_System_UU, String trxName) {
        super(ctx, AD_System_UU, trxName);
    }

    public MSystem(Properties ctx, int ignored, String mtrxName) {
        super(ctx, 0, mtrxName);
        String trxName = null;
        this.load(trxName, new String[0]);
        if (s_system.get(0) == null) {
            s_system.put(0, this);
        }
    }

    public MSystem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (s_system.get(0) == null) {
            s_system.put(0, this);
        }
    }

    public MSystem(MSystem copy) {
        this(Env.getCtx(), copy);
    }

    public MSystem(Properties ctx, MSystem copy) {
        this(ctx, copy, null);
    }

    public MSystem(Properties ctx, MSystem copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public boolean isLDAP() {
        String host = this.getLDAPHost();
        if (host == null || host.length() == 0) {
            return false;
        }
        String domain = this.getLDAPDomain();
        return domain != null && domain.length() > 0;
    }

    public boolean isLDAP(String userName, String password) {
        return LDAP.validate(this.getLDAPHost(), this.getLDAPDomain(), userName, password);
    }

    @Override
    public String getDBAddress() {
        String s = super.getDBAddress();
        if (s == null || s.length() == 0) {
            s = CConnection.get().getConnectionURL();
        }
        return s;
    }

    public String getStatisticsInfo(boolean recalc) {
        String s = super.getStatisticsInfo();
        if (s == null || recalc) {
            String sql = "SELECT 'C'||(SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM AD_Client)||'U'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM AD_User)||'B'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_BPartner)||'P'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM M_Product)||'I'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_Invoice)||'L'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_InvoiceLine)||'M'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM M_Transaction) FROM AD_System";
            s = DB.getSQLValueString(null, sql, new Object[0]);
        }
        return s;
    }

    public String getProfileInfo(boolean recalc) {
        String s = super.getProfileInfo();
        if (s == null || recalc) {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            StringBuilder sb = new StringBuilder();
            try {
                try {
                    pstmt = DB.prepareStatement("SELECT Value FROM AD_Client  WHERE IsActive='Y' ORDER BY AD_Client_ID DESC", null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        sb.append(rs.getString(1)).append('|');
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, "SELECT Value FROM AD_Client  WHERE IsActive='Y' ORDER BY AD_Client_ID DESC");
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            s = sb.toString();
        }
        return s;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean userChange;
        if (this.get_Value("IsAutoErrorReport") == null) {
            this.setIsAutoErrorReport(true);
        }
        boolean bl = userChange = Ini.isClient() && (this.is_ValueChanged("Name") || this.is_ValueChanged("UserName") || this.is_ValueChanged("Password") || this.is_ValueChanged("LDAPHost") || this.is_ValueChanged("LDAPDomain") || this.is_ValueChanged("CustomPrefix"));
        if (userChange) {
            String name = this.getName();
            if (name.equals("?") || name.length() < 2) {
                throw new AdempiereException("Define a unique System name (e.g. Company name) not " + name);
            }
            if (this.getUserName().equals("?") || this.getUserName().length() < 2) {
                throw new AdempiereException("Use the same EMail address as in the Adempiere Web Store");
            }
            if (this.getPassword().equals("?") || this.getPassword().length() < 2) {
                throw new AdempiereException("Use the same Password as in the Adempiere Web Store");
            }
        }
        this.setInfo();
        return true;
    }

    @Override
    public boolean save() {
        if (!this.beforeSave(false)) {
            return false;
        }
        return this.saveUpdate();
    }

    @Override
    public String toString() {
        return "MSystem[" + this.getName() + ",User=" + this.getUserName() + ",ReleaseNo=" + this.getReleaseNo() + "]";
    }

    @Deprecated
    public boolean isValid() {
        if (this.getName() == null || this.getName().length() < 2) {
            this.log.log(Level.WARNING, "Name not valid: " + this.getName());
            return false;
        }
        if (this.getPassword() == null || this.getPassword().length() < 2) {
            this.log.log(Level.WARNING, "Password not valid: " + this.getPassword());
            return false;
        }
        if (this.getInfo() == null || this.getInfo().length() < 2) {
            this.log.log(Level.WARNING, "Need to run Migration once");
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isPDFLicense() {
        String key = this.getSummary();
        return key != null && key.length() > 25;
    }

    public boolean setInfo() {
        if (!TimeUtil.getDay(this.getUpdated()).before(TimeUtil.getDay(null))) {
            return false;
        }
        try {
            this.setDBInfo();
            if (this.isAllowStatistics()) {
                this.setInternalUsers();
                this.setStatisticsInfo(this.getStatisticsInfo(true));
                this.setProfileInfo(this.getProfileInfo(true));
            }
        }
        catch (Exception e) {
            this.setSupportUnits(9999);
            this.setInfo(e.getLocalizedMessage());
            this.log.log(Level.SEVERE, "", e);
        }
        return true;
    }

    private void setInternalUsers() {
        int internalUsers = DB.getSQLValue(null, "SELECT COUNT(DISTINCT (u.AD_User_ID)) AS iu FROM AD_User u INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID) WHERE u.AD_Client_ID<>11 AND u.AD_User_ID NOT IN (?,?,?)", 0, 10, 100);
        this.setSupportUnits(internalUsers);
    }

    private void setDBInfo() {
        String dbAddress = CConnection.get().getConnectionURL();
        this.setDBAddress(dbAddress.toLowerCase());
        if (!Ini.isClient()) {
            int noProcessors = Runtime.getRuntime().availableProcessors();
            this.setNoProcessors(noProcessors);
        }
        String dbName = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            try {
                String dbType = CConnection.get().getDatabase().getName();
                sql = MSystem.getDBInfoSQL(dbType);
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dbName = rs.getString(2);
                    this.setDBInstance(dbName.toLowerCase());
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public static String getDBInfoSQL(String dbType) {
        if (Database.DB_ORACLE.equals(dbType)) {
            return "SELECT SYS_CONTEXT('USERENV','HOST') || '/' || SYS_CONTEXT('USERENV','IP_ADDRESS') AS DBAddress,\tSYS_CONTEXT('USERENV','CURRENT_USER') || '.' || SYS_CONTEXT('USERENV','DB_NAME') || '.' || SYS_CONTEXT('USERENV','DB_DOMAIN') AS DBName FROM DUAL";
        }
        return "SELECT NULL,NULL FROM DUAL WHERE 1=0";
    }

    @Deprecated
    public void info() {
        if (!CLogMgt.isLevelFine()) {
            return;
        }
        ManagementFactory.getRuntimeMXBean();
        if (CLogMgt.isLevelFiner()) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            Iterator<MemoryPoolMXBean> it = list.iterator();
            while (it.hasNext()) {
                it.next();
            }
        } else {
            ManagementFactory.getMemoryMXBean();
        }
        ManagementFactory.getThreadMXBean();
    }

    public static boolean isZKRememberUserAllowed() {
        String ca = MSysConfig.getValue("ZK_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_USER);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_USER) || ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static boolean isZKRememberPasswordAllowed() {
        String ca = MSysConfig.getValue("ZK_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_USER);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD) && !MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
    }

    public static boolean isSwingRememberUserAllowed() {
        String ca = MSysConfig.getValue("SWING_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_PASSWORD);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_USER) || ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static boolean isSwingRememberPasswordAllowed() {
        String ca = MSysConfig.getValue("SWING_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_PASSWORD);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD) && !MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
    }

    public static boolean isSecureProps() {
        if (Env.isWindows() || Ini.isClient()) {
            return false;
        }
        return SystemProperties.isSecureProperties();
    }

    public static boolean isUseLoginPrefix() {
        String loginWithTenantPrefix = MSysConfig.getValue("LOGIN_WITH_TENANT_PREFIX", "N");
        return "F".equals(loginWithTenantPrefix) || "A".equals(loginWithTenantPrefix);
    }

    public static boolean isLoginPrefixMandatory() {
        String loginWithTenantPrefix = MSysConfig.getValue("LOGIN_WITH_TENANT_PREFIX", "N");
        return "F".equals(loginWithTenantPrefix);
    }
}

