/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.Query;
import org.compiere.model.X_I_PriceList;
import org.compiere.model.X_M_PriceList;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPriceList
extends X_M_PriceList
implements ImmutablePOSupport {
    private static final long serialVersionUID = 7128840936482927934L;
    private static ImmutableIntPOCache<Integer, MPriceList> s_cache = new ImmutableIntPOCache("M_PriceList", 5, 5);
    private MPriceListVersion m_plv = null;
    private Integer m_precision = null;

    public static MPriceList get(int M_PriceList_ID) {
        return MPriceList.get(M_PriceList_ID, null);
    }

    public static MPriceList get(int M_PriceList_ID, String trxName) {
        return MPriceList.get(Env.getCtx(), M_PriceList_ID, trxName);
    }

    public static MPriceList get(Properties ctx, int M_PriceList_ID, String trxName) {
        Integer key = M_PriceList_ID;
        MPriceList retValue = s_cache.get(ctx, key, e -> new MPriceList(ctx, (MPriceList)e));
        if (retValue == null) {
            retValue = new MPriceList(ctx, M_PriceList_ID, trxName);
            if (retValue.get_ID() == M_PriceList_ID) {
                s_cache.put(key, retValue, e -> new MPriceList(Env.getCtx(), (MPriceList)e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }

    public static MPriceList getCopy(Properties ctx, int M_PriceList_ID, String trxName) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, trxName);
        if (pl != null) {
            pl = new MPriceList(ctx, pl, trxName);
        }
        return pl;
    }

    public static MPriceList getDefault(Properties ctx, boolean IsSOPriceList) {
        MPriceList retValue;
        MPriceList[] it;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MPriceList[] mPriceListArray = it = s_cache.values().toArray(new MPriceList[0]);
        int n = it.length;
        int n2 = 0;
        while (n2 < n) {
            retValue = mPriceListArray[n2];
            if (retValue.isDefault() && retValue.getAD_Client_ID() == AD_Client_ID && retValue.isSOPriceList() == IsSOPriceList) {
                return retValue;
            }
            ++n2;
        }
        retValue = (MPriceList)new Query(ctx, "M_PriceList", "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=?", null).setParameters(AD_Client_ID, "Y", IsSOPriceList ? "Y" : "N").setOnlyActiveRecords(true).setOrderBy("M_PriceList_ID").first();
        if (retValue != null) {
            s_cache.put(retValue.get_ID(), retValue, e -> new MPriceList(Env.getCtx(), (MPriceList)e));
        }
        return retValue;
    }

    public static MPriceList getDefault(Properties ctx, boolean IsSOPriceList, String ISOCurrency) {
        MPriceList retValue;
        MPriceList[] it;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MCurrency currency = MCurrency.get(ctx, ISOCurrency);
        if (currency == null) {
            return MPriceList.getDefault(ctx, IsSOPriceList);
        }
        int M_Currency_ID = currency.get_ID();
        MPriceList[] mPriceListArray = it = s_cache.values().toArray(new MPriceList[0]);
        int n = it.length;
        int n2 = 0;
        while (n2 < n) {
            retValue = mPriceListArray[n2];
            if (retValue.isDefault() && retValue.getAD_Client_ID() == AD_Client_ID && retValue.isSOPriceList() == IsSOPriceList && retValue.getC_Currency_ID() == M_Currency_ID) {
                return retValue;
            }
            ++n2;
        }
        retValue = (MPriceList)new Query(ctx, "M_PriceList", "AD_Client_ID=? AND IsDefault=? AND IsSOPriceList=? AND C_Currency_ID=?", null).setParameters(AD_Client_ID, "Y", IsSOPriceList ? "Y" : "N", M_Currency_ID).setOnlyActiveRecords(true).setOrderBy("M_PriceList_ID").first();
        if (retValue != null) {
            s_cache.put(retValue.get_ID(), retValue, e -> new MPriceList(Env.getCtx(), (MPriceList)e));
        }
        return retValue;
    }

    public static int getStandardPrecision(Properties ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getStandardPrecision();
    }

    public static int getPricePrecision(Properties ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getPricePrecision();
    }

    public MPriceList(Properties ctx, String M_PriceList_UU, String trxName) {
        super(ctx, M_PriceList_UU, trxName);
        if (Util.isEmpty(M_PriceList_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPriceList(Properties ctx, int M_PriceList_ID, String trxName) {
        super(ctx, M_PriceList_ID, trxName);
        if (M_PriceList_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEnforcePriceLimit(false);
        this.setIsDefault(false);
        this.setIsSOPriceList(false);
        this.setIsTaxIncluded(false);
        this.setPricePrecision(2);
    }

    public MPriceList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPriceList(X_I_PriceList impPL) {
        this(impPL.getCtx(), 0, impPL.get_TrxName());
        this.setClientOrg(impPL);
        this.setUpdatedBy(impPL.getUpdatedBy());
        this.setName(impPL.getName());
        this.setDescription(impPL.getDescription());
        this.setC_Currency_ID(impPL.getC_Currency_ID());
        this.setPricePrecision(impPL.getPricePrecision());
        this.setIsSOPriceList(impPL.isSOPriceList());
        this.setIsTaxIncluded(impPL.isTaxIncluded());
        this.setEnforcePriceLimit(impPL.isEnforcePriceLimit());
    }

    public MPriceList(MPriceList copy) {
        this(Env.getCtx(), copy);
    }

    public MPriceList(Properties ctx, MPriceList copy) {
        this(ctx, copy, null);
    }

    public MPriceList(Properties ctx, MPriceList copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        if (copy.m_plv != null) {
            this.m_plv = new MPriceListVersion(ctx, copy.m_plv, trxName);
            this.m_plv.m_pl = this;
        } else {
            this.m_plv = null;
        }
        this.m_precision = copy.m_precision;
    }

    public MPriceListVersion getPriceListVersion(Timestamp valid) {
        if (valid == null) {
            valid = new Timestamp(System.currentTimeMillis());
        }
        this.m_plv = (MPriceListVersion)new Query(this.getCtx(), "M_PriceList_Version", "M_PriceList_ID=? AND TRUNC(ValidFrom)<=?", this.get_TrxName()).setParameters(this.getM_PriceList_ID(), valid).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (this.m_plv == null) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("None found M_PriceList_ID=" + this.getM_PriceList_ID() + " - " + String.valueOf(valid));
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.m_plv.toString());
            }
        }
        if (this.m_plv != null && this.is_Immutable()) {
            this.m_plv.markImmutable();
        }
        return this.m_plv;
    }

    public int getStandardPrecision() {
        if (this.m_precision == null) {
            MCurrency c = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
            this.m_precision = c.getStdPrecision();
        }
        return this.m_precision;
    }

    @Override
    public MPriceList markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_plv != null) {
            this.m_plv.markImmutable();
        }
        return this;
    }
}

