/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.X_U_POSTerminal;
import org.compiere.util.Env;

public class MPOSTerminal
extends X_U_POSTerminal {
    private static final long serialVersionUID = 6972567212871993024L;

    public MPOSTerminal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPOSTerminal(Properties ctx, String U_POSTerminal_UU, String trxName) {
        super(ctx, U_POSTerminal_UU, trxName);
    }

    public MPOSTerminal(Properties ctx, int U_POSTerminal_ID, String trxName) {
        super(ctx, U_POSTerminal_ID, trxName);
    }

    public MPOSTerminal(MPOSTerminal copy) {
        this(Env.getCtx(), copy);
    }

    public MPOSTerminal(Properties ctx, MPOSTerminal copy) {
        this(ctx, copy, null);
    }

    public MPOSTerminal(Properties ctx, MPOSTerminal copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MPOSTerminal get(int U_POSTerminal_ID) {
        return MPOSTerminal.get(Env.getCtx(), U_POSTerminal_ID);
    }

    public static MPOSTerminal get(Properties ctx, int U_POSTerminal_ID) {
        MPOSTerminal retValue = new MPOSTerminal(ctx, U_POSTerminal_ID, null);
        if (retValue.get_ID() != U_POSTerminal_ID) {
            return null;
        }
        MPOSTerminal.checkLock(retValue);
        return retValue;
    }

    @Override
    protected void loadComplete(boolean success) {
        if (success) {
            MPOSTerminal.checkLock(this);
        }
    }

    public static void checkLock(MPOSTerminal terminal) {
        if (terminal.isLocked()) {
            long timeToUnlock;
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            if (terminal.getUnlockingTime() != null && currentTime.after(terminal.getUnlockingTime())) {
                terminal.setLocked(false);
            }
            if (terminal.getLastLockTime() != null && terminal.getLockTime() > 0 && currentTime.after(new Timestamp(timeToUnlock = terminal.getLastLockTime().getTime() + (long)(terminal.getLockTime() * 60 * 1000)))) {
                terminal.setLocked(false);
            }
            terminal.saveEx();
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("Locked") && this.isLocked()) {
            this.setLastLockTime(new Timestamp(System.currentTimeMillis()));
        }
        return true;
    }
}

