/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset_Class;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.fa.feature.UseLifeImpl;

public class MAssetClass
extends X_A_Asset_Class
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7805056592418891872L;
    private static ImmutableIntPOCache<Integer, MAssetClass> s_cache = new ImmutableIntPOCache("A_Asset_Class", 20);

    public MAssetClass(Properties ctx, String A_Asset_Class_UU, String trxName) {
        super(ctx, A_Asset_Class_UU, trxName);
    }

    public MAssetClass(Properties ctx, int A_Asset_Class_ID, String trxName) {
        super(ctx, A_Asset_Class_ID, trxName);
    }

    public MAssetClass(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAssetClass(MAssetClass copy) {
        this(Env.getCtx(), copy);
    }

    public MAssetClass(Properties ctx, MAssetClass copy) {
        this(ctx, copy, null);
    }

    public MAssetClass(Properties ctx, MAssetClass copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MAssetClass get(int id) {
        return MAssetClass.get(Env.getCtx(), id);
    }

    public static MAssetClass get(Properties ctx, int id) {
        if (id <= 0) {
            return null;
        }
        MAssetClass assetClass = s_cache.get(ctx, id, e -> new MAssetClass(ctx, (MAssetClass)e));
        if (assetClass == null) {
            assetClass = new MAssetClass(ctx, id, null);
            if (assetClass.get_ID() == id) {
                s_cache.put(id, assetClass, e -> new MAssetClass(Env.getCtx(), (MAssetClass)e));
                return assetClass;
            }
            return null;
        }
        return assetClass;
    }

    public static MAssetClass get(Properties ctx, String value) {
        return (MAssetClass)new Query(ctx, "A_Asset_Class", "UPPER(Value)=UPPER(?) AND AD_Client_ID IN (0,?)", null).setParameters(value, Env.getAD_Client_ID(ctx)).setOrderBy("AD_Client_ID DESC").firstOnly();
    }

    public void setDescription() {
        String name;
        StringBuilder description = new StringBuilder();
        String value = this.getValue();
        if (value != null) {
            description.append(value).append(" ");
        }
        if ((name = this.getName()) != null) {
            description.append(name);
        }
        super.setDescription(description.toString());
    }

    public void setLevels() {
        this.setMFX_Grupa(0);
        this.setMFX_SubGrupa(0);
        this.setMFX_Clasa(0);
        this.setMFX_SubClasa(0);
        String value = this.getValue();
        if (value == null || value.length() == 0) {
            return;
        }
        String[] arr = value.split("\\.");
        try {
            if (arr.length >= 1) {
                this.setMFX_Grupa(Integer.valueOf(arr[0]));
            }
            if (arr.length >= 2) {
                this.setMFX_SubGrupa(Integer.valueOf(arr[1]));
            }
            if (arr.length >= 3) {
                this.setMFX_Clasa(Integer.valueOf(arr[2]));
            }
            if (arr.length >= 4) {
                this.setMFX_SubClasa(Integer.valueOf(arr[3]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warning("@Error@ @Value@=" + value);
        }
    }

    public int getA_Life_Period_Min(Timestamp serviceDate) {
        Calendar cal = TimeUtil.getCalendar(serviceDate);
        if (cal.get(1) >= 2004) {
            return this.getA_Life_Period_Min();
        }
        return this.getA_Life_Period_2004();
    }

    public String validate(boolean saveError, int A_Life_Period, Timestamp serviceDate) {
        this.log.fine("Entering");
        int A_Life_Period_Min = 0;
        int A_Life_Period_Max = 1000000;
        Calendar cal = TimeUtil.getCalendar(serviceDate);
        if (cal.get(1) >= 2004) {
            A_Life_Period_Min = this.getA_Life_Period_Min();
            A_Life_Period_Max = this.getA_Life_Period_Max();
        } else {
            A_Life_Period_Min = this.getA_Life_Period_2004();
            A_Life_Period_Max = this.getA_Life_Period_2004();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("serviceDate=" + String.valueOf(serviceDate) + ", A_Life_Period_Min=" + A_Life_Period_Min + ", A_Life_Period_Max=" + A_Life_Period_Max + ", A_Life_Period=" + A_Life_Period);
        }
        if (A_Life_Period < A_Life_Period_Min || A_Life_Period > A_Life_Period_Max) {
            String errmsg = "@UseLifeMonths@=" + A_Life_Period + " @NotBetween@ " + A_Life_Period_Min + " - " + A_Life_Period_Max;
            if (saveError) {
                this.log.saveError("Error", errmsg);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Leaving: " + errmsg);
                Thread.dumpStack();
            }
            return errmsg;
        }
        return "";
    }

    public boolean validate(UseLifeImpl asset) {
        Timestamp serviceDate;
        int A_Life_Period;
        String errmsg;
        boolean ok;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: UseLifeImpl=" + String.valueOf(asset));
        }
        if (!asset.isFiscal()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Leaving: fiscal=false [RETURN TRUE]");
            }
            return true;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset is fiscal");
        }
        boolean bl = ok = (errmsg = this.validate(true, A_Life_Period = asset.getUseLifeMonths(), serviceDate = asset.getAssetServiceDate())) == null || errmsg.length() == 0;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: ok=" + ok);
        }
        return ok;
    }

    public boolean isDepreciated() {
        return this.getA_Life_Period_Min() != 0 || this.getA_Life_Period_Max() != 0;
    }

    @Override
    public boolean beforeSave(boolean newRecord) {
        this.setDescription();
        if (this.is_ValueChanged("Value")) {
            this.setValue(this.getValue().trim());
            this.setLevels();
        }
        return true;
    }

    @Override
    public MAssetClass markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

