/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Zip;
import org.compiere.model.IArchiveStore;
import org.compiere.model.MClientInfo;
import org.compiere.model.MStorageProvider;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Archive;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MArchive
extends X_AD_Archive {
    private static final long serialVersionUID = 1195510484179775189L;
    private static CLogger s_log = CLogger.getCLogger(MArchive.class);
    protected MStorageProvider provider;

    public static MArchive[] get(Properties ctx, String whereClause) {
        return MArchive.get(ctx, whereClause, null);
    }

    public static MArchive[] get(Properties ctx, String whereClause, String trxName) {
        List<MArchive> list;
        StringBuilder sql = new StringBuilder("AD_Client_ID=?");
        if (!Util.isEmpty(whereClause)) {
            sql.append(whereClause);
        }
        if ((list = new Query(ctx, "AD_Archive", sql.toString(), trxName).setParameters(Env.getAD_Client_ID(ctx)).setOrderBy("Created").list()).size() == 0) {
            s_log.fine(sql.toString());
        } else if (s_log.isLoggable(Level.FINER)) {
            s_log.finer(sql.toString());
        }
        MArchive[] retValue = new MArchive[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MArchive(Properties ctx, String AD_Archive_UU, String trxName) {
        super(ctx, AD_Archive_UU, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, int AD_Archive_ID, String trxName) {
        super(ctx, AD_Archive_ID, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initArchiveStoreDetails(ctx, trxName);
    }

    public MArchive(Properties ctx, PrintInfo info, String trxName) {
        this(ctx, 0, trxName);
        this.setName(info.getName());
        this.setIsReport(info.isReport());
        this.setAD_Process_ID(info.getAD_Process_ID());
        this.setAD_Table_ID(info.getAD_Table_ID());
        this.setRecord_ID(info.getRecord_ID());
        this.setRecord_UU(info.getRecord_UU());
        this.setC_BPartner_ID(info.getC_BPartner_ID());
    }

    private void initArchiveStoreDetails(Properties ctx, String trxName) {
        if (this.is_new()) {
            MClientInfo clientInfo = MClientInfo.get(ctx, this.getAD_Client_ID());
            this.setStorageProvider(MStorageProvider.get(ctx, clientInfo.getStorageArchive_ID()));
        } else {
            this.setStorageProvider(MStorageProvider.get(ctx, this.getAD_StorageProvider_ID()));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MArchive[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public byte[] getBinaryData() {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            return prov.loadLOBData(this, this.provider);
        }
        return null;
    }

    public InputStream getInputStream() {
        byte[] inflatedData = this.getBinaryData();
        if (inflatedData == null) {
            return null;
        }
        return new ByteArrayInputStream(inflatedData);
    }

    @Override
    public void setBinaryData(byte[] inflatedData) {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            prov.save(this, this.provider, inflatedData);
        }
    }

    public String getCreatedByName() {
        String name;
        block6: {
            name = "?";
            String sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getCreatedBy());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        name = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return name;
    }

    public String getArchivePathSnippet() {
        StringBuilder path = new StringBuilder().append(this.getAD_Client_ID()).append(File.separator).append(this.getAD_Org_ID()).append(File.separator);
        if (this.getAD_Process_ID() > 0) {
            path.append(this.getAD_Process_ID()).append(File.separator);
        }
        if (this.getAD_Table_ID() > 0) {
            path.append(this.getAD_Table_ID()).append(File.separator);
        }
        if (this.getRecord_ID() > 0) {
            path.append(this.getRecord_ID()).append(File.separator);
        } else if (!Util.isEmpty(this.getRecord_UU())) {
            path.append(this.getRecord_UU()).append(File.separator);
        }
        return path.toString();
    }

    public byte[] getByteData() {
        return super.getBinaryData();
    }

    public void setByteData(byte[] BinaryData) {
        super.setBinaryData(BinaryData);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MTable table2;
        PO po;
        byte[] data = super.getBinaryData();
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.getRecord_ID() > 0 && this.getAD_Table_ID() > 0 && Util.isEmpty(this.getRecord_UU()) && (po = (table2 = MTable.get(this.getAD_Table_ID())).getPO(this.getRecord_ID(), this.get_TrxName())) != null) {
            this.setRecord_UU(po.get_UUID());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    @Override
    protected boolean postDelete() {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null) {
            return prov.deleteArchive(this, this.provider);
        }
        return true;
    }

    @Override
    protected void saveNew_afterSetID() {
        IArchiveStore prov = this.provider.getArchiveStore();
        if (prov != null && prov.isPendingFlush()) {
            prov.flush(this, this.provider);
        }
    }

    public void setStorageProvider(MStorageProvider p2) {
        this.provider = p2;
        this.setAD_StorageProvider_ID(p2.getAD_StorageProvider_ID());
    }

    public File saveAsZip() {
        StringBuilder name = new StringBuilder(MTable.get(Env.getCtx(), this.getAD_Table_ID()).getTableName()).append("_");
        if (this.getRecord_ID() > 0) {
            name.append(this.getRecord_ID()).append("_");
        } else if (!Util.isEmpty(this.getRecord_UU())) {
            name.append(this.getRecord_UU()).append("_");
        }
        File tempfolder = null;
        try {
            Path tempPath = Files.createTempDirectory(name.toString(), new FileAttribute[0]);
            tempfolder = tempPath.toFile();
        }
        catch (IOException e1) {
            throw new AdempiereException("Unable to create temp folder", e1);
        }
        File destZipFile = null;
        try {
            destZipFile = File.createTempFile("IdempiereArchive", ".zip");
        }
        catch (Throwable e) {
            throw new AdempiereException("Unable to create temp file", e);
        }
        destZipFile.delete();
        File destArchiveFile = null;
        try {
            destArchiveFile = File.createTempFile("IdempiereArchive", ".pdf", tempfolder);
        }
        catch (Throwable e) {
            throw new AdempiereException("Unable to create temp file", e);
        }
        destArchiveFile.delete();
        Path path = destArchiveFile.toPath();
        try {
            Files.write(path, this.getBinaryData(), new OpenOption[0]);
        }
        catch (IOException e1) {
            throw new AdempiereException(e1);
        }
        Zip zipper = new Zip();
        zipper.setDestFile(destZipFile);
        zipper.setBasedir(tempfolder);
        zipper.setUpdate(true);
        zipper.setCompress(true);
        zipper.setCaseSensitive(false);
        zipper.setFilesonly(true);
        zipper.setTaskName("zip");
        zipper.setTaskType("zip");
        zipper.setProject(new Project());
        zipper.setOwningTarget(new Target());
        zipper.execute();
        try {
            FileUtil.deleteDirectory(tempfolder);
        }
        catch (IOException iOException) {}
        return destZipFile;
    }

    public static int[] getReportAndDocumentCountByRecordId(int AD_Table_ID, int Record_ID, String trxName) {
        return MArchive.getReportAndDocumentCountByRecordId(AD_Table_ID, Record_ID, null, trxName);
    }

    public static int[] getReportAndDocumentCountByRecordId(int AD_Table_ID, int Record_ID, String Record_UU, String trxName) {
        int reportCount = 0;
        int documentCount = 0;
        StringBuilder sql = new StringBuilder("SELECT IsReport, COUNT(*) FROM AD_Archive ");
        if (Util.isEmpty(Record_UU)) {
            sql.append("WHERE (AD_Table_ID=? AND Record_ID=?) ");
        } else {
            sql.append("WHERE (AD_Table_ID=? AND Record_UU=?) ");
        }
        if (AD_Table_ID == 291) {
            sql.append(" OR C_BPartner_ID=?");
        }
        sql.append(" GROUP BY IsReport");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                pstmt.setInt(1, AD_Table_ID);
                if (Util.isEmpty(Record_UU)) {
                    pstmt.setInt(2, Record_ID);
                } else {
                    pstmt.setString(2, Record_UU);
                }
                if (AD_Table_ID == 291) {
                    pstmt.setInt(3, Record_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if ("Y".equals(rs.getString(1))) {
                        reportCount += rs.getInt(2);
                        continue;
                    }
                    documentCount += rs.getInt(2);
                }
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return new int[]{reportCount, documentCount};
    }

    public static int getReportCountByTableId(int AD_Table_ID, String trxName) {
        return DB.getSQLValueEx(trxName, "SELECT COUNT(*) FROM AD_Archive WHERE AD_Table_ID=? AND IsReport='Y'", AD_Table_ID);
    }
}

