/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MMeasure;
import org.compiere.model.Query;
import org.compiere.model.X_PA_Achievement;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MAchievement
extends X_PA_Achievement {
    private static final long serialVersionUID = -1438593600498523664L;
    private static CLogger s_log = CLogger.getCLogger(MAchievement.class);

    public static MAchievement[] get(MMeasure measure) {
        return MAchievement.getOfMeasure(measure.getCtx(), measure.getPA_Measure_ID());
    }

    public static MAchievement[] getOfMeasure(Properties ctx, int PA_Measure_ID) {
        List<MAchievement> list = new Query(ctx, "PA_Achievement", "PA_Measure_ID=? AND IsAchieved='Y'", null).setParameters(PA_Measure_ID).setOrderBy("SeqNo, DateDoc").list();
        MAchievement[] retValue = new MAchievement[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public MAchievement(Properties ctx, String PA_Achievement_UU, String trxName) {
        super(ctx, PA_Achievement_UU, trxName);
    }

    public MAchievement(Properties ctx, int PA_Achievement_ID, String trxName) {
        super(ctx, PA_Achievement_ID, trxName);
    }

    public MAchievement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAchievement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isAchieved()) {
            if (this.getManualActual().signum() == 0) {
                this.setManualActual(Env.ONE);
            }
            if (this.getDateDoc() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            this.updateAchievementGoals();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateAchievementGoals();
        }
        return success;
    }

    private void updateAchievementGoals() {
        MMeasure measure = MMeasure.get(this.getCtx(), this.getPA_Measure_ID());
        measure.updateGoals();
    }
}

