/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.install.TranslationHandler;
import org.compiere.model.MLanguage;
import org.compiere.model.MPInstance;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class Translation
implements IApplication {
    public static final String DTD = "<!DOCTYPE idempiereTrl PUBLIC \"-//ComPiere, Inc.//DTD iDempiere Translation 1.0//EN\" \"http://www.idempiere.com/dtd/idempiereTrl.dtd\">";
    public static final String XML_TAG = "idempiereTrl";
    public static final String XML_TAG2 = "adempiereTrl";
    public static final String XML_TAG3 = "compiereTrl";
    public static final String XML_ATTRIBUTE_TABLE = "table";
    public static final String XML_ATTRIBUTE_LANGUAGE = "language";
    public static final String XML_ROW_TAG = "row";
    public static final String XML_ROW_ATTRIBUTE_ID = "id";
    public static final String XML_ROW_ATTRIBUTE_UUID = "uuid";
    public static final String XML_ROW_ATTRIBUTE_TRANSLATED = "trl";
    public static final String XML_VALUE_TAG = "value";
    public static final String XML_VALUE_ATTRIBUTE_COLUMN = "column";
    public static final String XML_VALUE_ATTRIBUTE_ORIGINAL = "original";
    private boolean m_IsCentrallyMaintained = false;
    private static final CLogger log = CLogger.getCLogger(Translation.class);
    private Properties m_ctx = null;

    public Translation(Properties ctx) {
        this.m_ctx = ctx;
    }

    public Translation() {
        this.m_ctx = Env.getCtx();
    }

    public String importTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
        return this.importTrl(directory, AD_Client_ID, AD_Language, Trl_Table, null);
    }

    public String importTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table, String trxName) {
        File in;
        String fileName = directory + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        if (log.isLoggable(Level.INFO)) {
            log.info(fileName);
        }
        if (!(in = new File(fileName)).exists()) {
            String msg = "File does not exist: " + fileName;
            log.log(Level.SEVERE, msg);
            return msg;
        }
        try {
            MLanguage langCached;
            MLanguage lang;
            TranslationHandler handler = new TranslationHandler(AD_Client_ID, trxName);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
            if (log.isLoggable(Level.INFO)) {
                log.info("Updated=" + handler.getUpdateCount());
            }
            if (!(lang = new MLanguage(this.m_ctx, (langCached = MLanguage.get(this.m_ctx, AD_Language)).getAD_Language_ID(), null)).isLoginLocale()) {
                lang.setIsLoginLocale(true);
                lang.saveEx();
            }
            return Msg.getMsg(this.m_ctx, "Updated") + "=" + handler.getUpdateCount();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public String exportTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table, boolean onlyCentralized) {
        String fileName = directory + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        if (log.isLoggable(Level.INFO)) {
            log.info(fileName);
        }
        File out = new File(fileName);
        boolean isBaseLanguage = Language.isBaseLanguage(AD_Language);
        String tableName = Trl_Table;
        int pos = tableName.indexOf("_Trl");
        String Base_Table = Trl_Table.substring(0, pos);
        if (isBaseLanguage) {
            tableName = Base_Table;
        }
        if (onlyCentralized && MTable.get(this.m_ctx, tableName).getAD_Table_ID() > 999999) {
            return "";
        }
        MTable baseTable = MTable.get(Env.getCtx(), Base_Table);
        String keyColumn = baseTable.getKeyColumns()[0];
        String uuidColumn = PO.getUUIDColumnName(Base_Table);
        String[] trlColumns = this.getTrlColumns(Base_Table);
        StringBuilder sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
                document.appendChild(document.createComment(DTD));
                Element root = document.createElement(XML_TAG);
                root.setAttribute(XML_ATTRIBUTE_LANGUAGE, AD_Language);
                root.setAttribute(XML_ATTRIBUTE_TABLE, Base_Table);
                document.appendChild(root);
                sql = new StringBuilder("SELECT ");
                if (isBaseLanguage) {
                    sql.append("'Y',");
                } else {
                    sql.append("t.IsTranslated,");
                }
                sql.append("t.").append(keyColumn);
                sql.append(", o.").append(uuidColumn);
                int i2 = 0;
                while (i2 < trlColumns.length) {
                    sql.append(", t.").append(trlColumns[i2]).append(",o.").append(trlColumns[i2]).append(" AS ").append(trlColumns[i2]).append("O");
                    ++i2;
                }
                sql.append(" FROM ").append(tableName).append(" t").append(" INNER JOIN ").append(Base_Table).append(" o ON (t.").append(keyColumn).append("=o.").append(keyColumn).append(")");
                boolean haveWhere = false;
                if (!isBaseLanguage) {
                    sql.append(" WHERE t.AD_Language=?");
                    haveWhere = true;
                }
                if (this.m_IsCentrallyMaintained) {
                    sql.append(haveWhere ? " AND " : " WHERE ").append("o.IsCentrallyMaintained='N'");
                    haveWhere = true;
                }
                if (AD_Client_ID >= 0) {
                    sql.append(haveWhere ? " AND " : " WHERE ").append("o.AD_Client_ID=").append(AD_Client_ID);
                    haveWhere = true;
                }
                if (onlyCentralized && keyColumn.endsWith("_ID")) {
                    sql.append(haveWhere ? " AND " : " WHERE ").append(" o.").append(keyColumn).append("<=").append(999999).append(" AND o.IsActive = 'Y'");
                }
                sql.append(" ORDER BY t.").append(keyColumn);
                pstmt = DB.prepareStatement(sql.toString(), null);
                if (!isBaseLanguage) {
                    pstmt.setString(1, AD_Language);
                }
                rs = pstmt.executeQuery();
                int rows = 0;
                while (rs.next()) {
                    Element row = document.createElement(XML_ROW_TAG);
                    int keyid = -1;
                    if (!baseTable.isUUIDKeyTable()) {
                        keyid = rs.getInt(2);
                    }
                    String uuid = rs.getString(3);
                    if (keyid >= 0 && keyid <= 999999 || Util.isEmpty(uuid)) {
                        row.setAttribute(XML_ROW_ATTRIBUTE_ID, String.valueOf(keyid));
                    } else {
                        row.setAttribute(XML_ROW_ATTRIBUTE_UUID, String.valueOf(uuid));
                    }
                    row.setAttribute(XML_ROW_ATTRIBUTE_TRANSLATED, rs.getString(1));
                    int i3 = 0;
                    while (i3 < trlColumns.length) {
                        String valueString;
                        Element value = document.createElement(XML_VALUE_TAG);
                        value.setAttribute(XML_VALUE_ATTRIBUTE_COLUMN, trlColumns[i3]);
                        String origString = rs.getString(trlColumns[i3] + "O");
                        if (origString == null) {
                            origString = "";
                        }
                        if ((valueString = rs.getString(trlColumns[i3])) == null) {
                            valueString = "";
                        }
                        value.setAttribute(XML_VALUE_ATTRIBUTE_ORIGINAL, origString);
                        if (valueString.indexOf("<") != -1 || valueString.indexOf(">") != -1 || valueString.indexOf("&") != -1) {
                            value.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                            value.appendChild(document.createCDATASection(valueString));
                        } else {
                            value.appendChild(document.createTextNode(valueString));
                        }
                        row.appendChild(value);
                        ++i3;
                    }
                    root.appendChild(row);
                    ++rows;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Records=" + rows + ", DTD=" + String.valueOf(document.getDoctype()) + " - " + Trl_Table);
                }
                DOMSource source = new DOMSource(document);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                tFactory.setAttribute("indent-number", 1);
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                out.createNewFile();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "utf-8");
                StreamResult result = new StreamResult(writer);
                transformer.transform(source, result);
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new AdempiereException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    private String[] getTrlColumns(String Base_Table) {
        ArrayList<String> list;
        block13: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block11: {
                this.m_IsCentrallyMaintained = false;
                sql = "SELECT TableName FROM AD_Table t INNER JOIN AD_Column c ON (c.AD_Table_ID=t.AD_Table_ID AND c.ColumnName='IsCentrallyMaintained') WHERE t.TableName=? AND c.IsActive='Y'";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setString(1, Base_Table);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_IsCentrallyMaintained = true;
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.ColumnName NOT LIKE ?  AND c.AD_Reference_ID IN (10,14,36) ORDER BY IsMandatory DESC, ColumnName";
            list = new ArrayList<String>();
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, Base_Table + "_Trl");
                    pstmt.setString(2, PO.getUUIDColumnName(Base_Table + "_Trl"));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String s = rs.getString(1);
                        list.add(s);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String validateLanguage(String p_AD_Language) {
        return this.validateLanguage(p_AD_Language, null);
    }

    public String validateLanguage(String AD_Language, String trxName) {
        MLanguage language = (MLanguage)new Query(this.m_ctx, "AD_Language", "AD_Language=?", trxName).setParameters(AD_Language).first();
        if (language == null) {
            log.log(Level.SEVERE, "Language does not exist: " + AD_Language);
            return "Language does not exist: " + AD_Language;
        }
        if (language.isActive()) {
            if (language.isBaseLanguage()) {
                return "";
            }
        } else {
            log.log(Level.SEVERE, "Language not active or not system language: " + AD_Language);
            return "Language not active or not system language: " + AD_Language;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Start Validating ... " + String.valueOf(language));
        }
        language.maintain(true);
        return "";
    }

    public void process(String directory, String AD_Language, String mode) {
        ArrayList<String> trlTables;
        block14: {
            String sql = "SELECT Name, TableName FROM AD_Table WHERE TableName LIKE '%_Trl' ORDER BY Name";
            trlTables = new ArrayList<String>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        trlTables.add(rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        int i2 = 0;
        while (i2 < trlTables.size()) {
            String table2 = (String)trlTables.get(i2);
            File dir = new File(directory);
            if (mode.equals("import")) {
                if (!dir.exists() || !dir.isDirectory()) {
                    System.out.println("The language cannot be imported from " + directory + " as this directory does not exist.");
                    System.exit(1);
                }
                this.importTrl(directory, -1, AD_Language, table2);
            } else if (mode.equals("export")) {
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (!(dir = new File(directory)).exists()) {
                    System.out.println("Cannot create directory " + directory + " to export the language to it.");
                    System.exit(1);
                }
                this.exportTrl(directory, -1, AD_Language, table2, true);
            } else {
                System.out.println("Just import and export are supported as modes.");
            }
            ++i2;
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        Adempiere.startup(false);
        Map args = context.getArguments();
        String[] commandlineArgs = (String[])args.get("application.args");
        if (commandlineArgs.length == 3 && ("import".equals(commandlineArgs[0]) || "export".equals(commandlineArgs[0]))) {
            String command = commandlineArgs[0];
            String directory = commandlineArgs[1];
            String countrycode = commandlineArgs[2];
            Properties ctx = Env.getCtx();
            Translation translation = new Translation(ctx);
            String msg = translation.validateLanguage(countrycode);
            if (msg.length() > 0) {
                System.err.println(msg);
            }
            translation.process(directory, countrycode, command);
        } else if (commandlineArgs.length == 1 && "sync".equals(commandlineArgs[0])) {
            ProcessInfo pi = new ProcessInfo("Synchronize Terminology", 172);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            MPInstance instance = new MPInstance(Env.getCtx(), 172, -1, 0, null);
            instance.saveEx();
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            ProcessCall process = Core.getProcess("org.compiere.process.SynchronizeTerminology");
            process.startProcess(Env.getCtx(), pi, null);
            StringBuilder msgout = new StringBuilder("Process=").append(pi.getTitle()).append(" Error=").append(pi.isError()).append(" Summary=").append(pi.getSummary());
            System.out.println(msgout.toString());
        } else {
            System.out.println("translation OSGi plugin commandline usage:");
            System.out.println("Translation.sh import translation/data de_DE");
            System.out.println("Translation.sh export translation/data de_DE");
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }
}

